#include "WhiteNoise.hh"
#include "rndm.hh"

namespace generator {

  WhiteNoise::WhiteNoise(double Amp)
    : DataSource(kContinuous)
  {
      setParameter("A", Amp);
  }

  WhiteNoise::~WhiteNoise(void) {
  }

  WhiteNoise*
  WhiteNoise::clone(void) const {
      return new WhiteNoise(*this);
  }

  void
  WhiteNoise::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {
      double Ampl  = getNumeric("A");
      for (int i=0 ; i<N ; ++i) {
	  d[i] += Ampl * Rannor();
      }
  }

} // namespace generator
