#include "SineData.hh"
#include <iostream>
#include <cmath>

using namespace std;

namespace generator {

  //====================================  Default constructor
  SineData::SineData(void) 
    : DataSource(kContinuous), mT0(0)
  {
      setParameter("A",   1.0);
      setParameter("F",   1.0);
      setParameter("Phi", 0.0);
  }

  //====================================  Data constructor
  SineData::SineData(double Amp, double Freq, double Phi)
    : DataSource(kContinuous), mT0(0)
  {
      setParameter("A",   Amp);
      setParameter("F",   Freq);
      setParameter("Phi", Phi);
  }

  //====================================  Destructor
  SineData::~SineData(void) {
  }

  //====================================  Clone method
  SineData*
  SineData::clone(void) const {
      return new SineData(*this);
  }

  //====================================  Generate sine time-series
  void
  SineData::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {
      if (!mT0) mT0 = t0;

      //--------------------------------  Get the parameters
      double twopi = 2*M_PI;
      double Ampl  = getNumeric("A");   // Amplitude in user units
      double f0    = getNumeric("F");   // Frequency in Hz
      double Phi   = getNumeric("Phi"); // Phi at t=0 (in degrees)

      //-------------------------------  Set up to loop
      double delt  = double(t0 - mT0);
      double x0    = fmod(f0, 1.0)*long(delt) + f0*fmod(delt, 1.0) + Phi/360;
      double xInc  = twopi * f0 * dT;

      double x = twopi * fmod(x0, 1.0);
      for (int i=0; i<N; ++i) {
	d[i] += Ampl * sin(x + double(i)*xInc);
	  //x    += xInc;
      }
  }

} // namespace generator
