/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "Metastable.hh"
#include <iostream>
#include <cmath>

using namespace std;

namespace generator {

    //====================================  Default constructor
    Metastable::Metastable(void) 
	: DataSource(kRetrigger), mT0(0)
    {
	setParameter("t0",   1.0);
	setParameter("t1",   1.0);
	setParameter("Off",  0.0);
	setParameter("On",   1.0);
    }

    //====================================  Destructor
    Metastable::~Metastable(void) {
    }

    //====================================  Clone method
    Metastable*
    Metastable::clone(void) const {
	return new Metastable(*this);
    }

    //====================================  Generate sine-gaussian time-series
    Interval
    Metastable::getDuration(void) const {
	return getNumeric("t0") + getNumeric("t1");
    }

    //====================================  Generate sine-gaussian time-series
    void
    Metastable::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {

	//--------------------------------  Get the parameters for this event
	mT0   = getTrigTime();
	mDt0  = Interval(getNumeric("t0"));   // Duration of off state
	mDt1  = Interval(getNumeric("t1"));   // Duration of on state
	mVoff = getNumeric("Off");            // Phi at t=0 (in degrees)
	mVon  = getNumeric("On");             // Phi at t=0 (in degrees)

	Interval delta0 = mT0 + mDt0 - t0; 
	Interval delta1 = mT0 + mDt0 + mDt1 - t0;
	int i0 = 0;
	if (mT0 > t0) i0 = int(double(mT0 - t0) / dT);

	//-------------------------------  Set up to loop
	for (int i=i0; i<N; ++i) {
	    Interval delta = dT * double(i);
	    if (delta >= delta0 && delta < delta1) d[i] = mVon;
	    else                                   d[i] = mVoff;
	}
    }

} // namespace generator
