//
//  Class FDEasyCalibrate: High-level methods for calibrating ASQ power spectra
//  into units of physical displacement (nanometers or strain).
//    version:  0.3
//       date:  2004.09.24   
//     author:  Patrick J. Sutton (psutton@ligo.caltech.edu)
//
///////////////////////////////////////////////////////////////////////////


#include "FDEasyCalibrate.hh"


#ifndef __CINT__
#include <fstream>
//#include "PSD.hh"
//#include "Hanning.hh" 
#endif  //------ !def(__CINT__)


//----- Just call constructor for base class.

FDEasyCalibrate::FDEasyCalibrate(DaccAPI *access, const char *refcal_file, 
bool GenerateCalParam, double Fmin, double Fstep, int npoint) 
:  
    FDCalibrate(access, refcal_file, GenerateCalParam, Fmin, Fstep, npoint)
{

    //----- Exactly the same constructor as for FDCalibrate.
    //      Nothing else to be done.
    //cout << "FDEasyCalibrate::FDEasyCalibrate() called.\n";
    return;

}


FDEasyCalibrate::~FDEasyCalibrate()
{

    //----- Destructors from FDCalibrate, FDFilter are automatically 
    //      called.  Since FDEasyCalibrate contains no new data 
    //      members, there's nothing to do here.
    //cout << "~FDEasyCalibrate() called.\n";
    return;

}


int FDEasyCalibrate::UpdateResponseFunction()
{

    int return_status = 1;
    //std::cout << "FDEasyCalibrate::UpdateResponseFunction() called.\n";

    //----- Update response function "on-the-fly" using data 
    //      from the EXC and DARM channels.  
    //      Note: UpdateAlpha() and ComputeResponseFunction() 
    //      check that the calibration is physical.  If not, then 
    //      the response function is set to its reference value
    //      (its value for alpha=1=beta).
    //
    //      Call in this order!
    UpdateBeta(); 
    UpdateAlpha(); 
    ComputeResponseFunction();

    //----- Return "all clear" code only if updated alpha*beta is physical.
    if (IsCalibrationGood()) {
        return_status = 0;
    } 

    return return_status;

}


int FDEasyCalibrate::UpdateResponseFunction(Time t)
{

    int return_status = 1;
    //cout << "FDEasyCalibrate::UpdateResponseFunction(Time) called.\n";

    // KLUDGE FIX
    //----- Return error if no stored calibrations!
    // if (???) {
    //  cout << "Error: No stored calibrations available.\n";
    //  return;
    // }

    //----- Trigger look-up of stored alpha, beta.
    UpdateAlphaBeta(t); 
    ComputeResponseFunction();

    //----- Return "all clear" code only if updated alpha*beta is physical.
    if (IsCalibrationGood()) {
        return_status = 0;
    }
 
    return return_status;

}


