#include <stdio.h>
#include <string.h>
#include <ctype.h>  /* isalnum() */

#include "debug.h"
#include "parse_fortran.h"


    /* the correct way wouldbe " -> \" but that's complicated */
void remove_double_quotes(char *temp_string) {
   int i;
   
   for(i=0;i<strlen(temp_string);i++) {
      if (temp_string[i]=='\"')temp_string[i]='\'';      
      
   }
}
   

int find_end_of_parenthesis(char *temp_string) {
    
    int i=0, open_paren=0;
   
       /* First navigate to the end of the parenthesis */
    while( (temp_string[i]!='(') && (i<strlen(temp_string) ) ) i++;
   
    do {
       if (temp_string[i]=='(') open_paren++;
       if (temp_string[i]==')') open_paren--;
       i++;
    }   while( (open_paren!=0) && (i<strlen(temp_string)) ) ;
  
    return i;
}


void get_token(char *long_string,char *destination,int length) {
 
   int count=0;
   char *temp=long_string;
   
   while( (*temp!=0) && (isalnum(*temp)) && (count<length)) {
      *(destination+count)=toupper(*(temp));
      temp++;
      count++;
   }
   *(destination+count)='\0';
   
}

char *point_to_non_whitespace(char *string) {
 
   char *temp_string=string;
   
   while ((*temp_string==' ') || (*temp_string=='\t')) temp_string++;
      
   return temp_string;
   
}

    
int get_fortran_line(FILE *fff,char *string,int *line_number,int length) {
 
    fpos_t file_position;
    char temp_string[BUFSIZ];
   
    fgets(string,length,fff);
    if (feof(fff)) return -1;
    (*line_number)++;

    if (strlen(string)>73) fprintf(stderr,"Warning!  Line %i > 73 chars\n",
				   *line_number);
   
    if (string[strlen(string)-1]=='\n') {
       string[strlen(string)-1]='\0';
    }
   
    if ((string[0]=='C') || (string[0]=='*')) return 0;
   
    fgetpos(fff,&file_position);
   
    fgets(temp_string,BUFSIZ,fff);
   
    while ( (strlen(temp_string)>4) && 
	    (temp_string[0]!='C') && (temp_string[0]!='*') &&
	    (temp_string[5]!=' ') && (temp_string[5]!='0') &&
	    !feof(fff)) {
       (*line_number)++;
       DEBUG(stderr,"Continued line %i!\n",*line_number);
       if (temp_string[strlen(temp_string)-1]=='\n') {
          temp_string[strlen(temp_string)-1]='\0';
       }
       strncat(string,temp_string+6,length);
       fgetpos(fff,&file_position);
       fgets(temp_string,BUFSIZ,fff);
    }
   
   
    fsetpos(fff,&file_position);
    if (feof(fff)) return -1;

    return 0;

}

int parse_fortran_line(char *string,int *label,char *token,char **gunk) {

   char *temp_pointer;
   int temp_label;
   
   if (string[0]=='C') {
      DEBUG(stderr,"IGNORING COMMENT: %s\n",string);
      strncpy(token,"\n",1);
      *label=-1;
      return -1;
   }
       
   if (sscanf(string,"%i",&temp_label)==1) {
       *label=temp_label;
   } else {
     *label=-1;
   }
      
   if (strlen(string)<7) {
      strncpy(token,"\n",1);
      return -1;
   }
   
   temp_pointer=string;
   temp_pointer+=6;  /* skip label area */
   temp_pointer=point_to_non_whitespace(temp_pointer);
   
   *gunk=temp_pointer;
   get_token(temp_pointer,token,BUFSIZ);    
   
   return 0;
}

