#include <stdio.h>
#include <stdlib.h> /* realloc() */
#include <string.h> /* strdup() */
#include "debug.h"
#include "block.h"

int add_block_line(struct block_type *block,int line,char *label) {
    block->lines=realloc(block->lines,
			 (block->num_lines+1)*sizeof(struct block_line_type));
    block->lines[block->num_lines].line=line;
    block->lines[block->num_lines].label=strdup(label);
    block->num_lines++;
     
    return 0;
}

int start_block(struct block_type *block,int line_number) {
    
    block->label=line_number;
    block->num_lines=0;
    block->lines=NULL;
    return 0;
}

int end_block(struct block_type *block,FILE *fout) {

    int i,prev_block;
   
    prev_block=block->label;
   
    fprintf(fout,"\t%i [shape=record,label=\"{",block->label);
    for(i=0;i<block->num_lines;i++) {
       if (i!=0) fprintf(fout,"|");
       fprintf(fout,"<%i> \\\"%s\\\" ",block->lines[i].line,
	                           block->lines[i].label);
       free(block->lines[i].label);
    
    }
    fprintf(fout,"}\"];\n");    
    fprintf(fout,"\n");
   
   
    if (block->lines!=NULL) free(block->lines);
   
    return prev_block;
}

