#ifndef _TDFCONFIG_METHOD_H
#define _TDFCONFIG_METHOD_H 1
/*
 *                  t d F c o n f i g M e t h o d. h
 *
 *  Function:
 *     Include file for the configuration allocation package, CONFIG - for 
 *     method implementation algorithm libraries.
 *
 * Sccs Id:     tdFconfigMethod.h, Release 1.7, 01/24/02
 *
 *  History:
 *     28th Sep 1994.  Original version. KS/AAO.
 *     10th Oct 1994.  Added definitions of ConfigButtonClear() etc. KS/AAO.
 *     17th Oct 1994.  Parameter routines now provided in both algorithm-
 *                     specific and non-specific code. KS/AAO.
 *     22nd Jan 1999.  Merge in GBD's changes - Add ObjName to 
 *                     CONFIG_TargetInfo structure.  Add function prototypes
 *                     ConfigSetImportFile() nad ConfigSetImportOnlyMode().
 *                     Also add ConfigMethodSetImportFile() prototype and
 *                     SCCS Id.  TJF/AAO.
 *     07th Mar 2000.  Major changes to support new style where the
 *                     algorithm routines are called via function pointer. 
 *                     TJF/AAO.
 *     08th Mar 2000.  Extract tdFconfigMethod.h from tdFconfig.h.
 *     20th Mar 2000.  Add AllowAllocChange flag to PivotInfo. TJF/AAO.
 *     28th Mar 2000.  Add AllocRptFunction.
 *     31st Mar 2000.  Support tentative allocations.
 *     06th Apr 2000.  Add park information to pivot info structure.
 *     18th Apr 2000.  Add ParkMayCollide routine.
 *     08th Aug 2000.  Changed 'spect' field in the CONFIG_PivotInfo structure
 *                     to the more general 'FibreType' - type changed from
 *                     char to int at same time. Added FibreIsBroken() and
 *                     FibreIsGuide() and FibreTargetCompatible() routine
 *                     pointers to the method info. KS. 
 *     21st Aug 2000.  Now undefines Status if defined so it can be used as
 *                     a variable name. KS.
 *     05th Sep 2000.  Added SetFibrePos() routine pointer to the method
 *                     info. KS/TJF.
 *     31st Jan 2001.  Added AdjPark() routine pointer to the method info. KS.
 *     02nd Feb 2001.  Added FibreReallyExists() routine pointer to the method
 *                     info. KS.
 *     21st Feb 2001.  Added fibre length to PivotInfo structure. KS.
 *     13th Nov 2001.  Added TargetIsGuide() and TargetIsSky() support. KS.
 *     14th Nov 2001.  Added FibreText() and FibreTypeMatch() support. KS.
 *     17th Nov 2001.  Added SetSky() support to method layer. KS.
 *      3rd Jan 2001.  Added PositionerTolerances argument to definition of
 *                     ConfigFieldChkRoutine calling sequence. KS/AAO.
*      21st Dec 2002.  ConfigColInvPosRoutine: fibreType arg. added. RSC.
 *
 */

/*  Some environments define Status as a type - this conflicts with a common
 *  variable name in this code, so we undefine it if necessary.
 */

#ifdef Status
#undef Status
#endif

/*  Fixed values  */

/*  CONFIG_TRUE and CONFIG_FALSE are just convenient defintions - if you use
 *  TRUE and FALSE you often end in conflicting with some other definition of
 *  these.
 */

#define CONFIG_TRUE 1
#define CONFIG_FALSE 0

/*
 *  These definitions must be the same as the equivalent FPIL macros,
 *  but we can't include fpil.h here (to avoid dependencies) so we
 *  must define them outselves
 */
#define CONFIG_COL_BUTBUT 2
#define CONFIG_COL_BUTFIB 2
#define CONFIG_COL_FIBBUT 3
#define CONFIG_NOCOL 0

/*  PI is just Pi, of course.  */

#define PI 3.14159265359

/*  Types used by CONFIG. */

typedef long int CONFIG_Boolean;     /* Used for logical values */

typedef struct CONFIG_AllocInfo {    /* Details about pivot allocation */
   int TargetIndex;                  /* Allocated target, if any (index into the
                                      * TargetInfo global array) */
   long X;                           /* X-coordinate of position, in microns */
   long Y;                           /* Y-coordinate of position, in microns */
   double Theta;                     /* Theta value for fibre */
   char State;                       /* 'U' or 'A' or zero, for 'unallocated',
                                      * 'allocated' or broken. */
   int Tentative;                    /* Indicates the allocation is tentative
                                      */
} CONFIG_AllocInfo;


typedef struct CONFIG_PivotInfo {    /* Details about each pivot */
   long X;                           /* X-coordinate of pivot, in microns */
   long Y;                           /* Y-coordinate of pivot, in microns */
   long ParkX;                       /* X-coordinate of park position */
   long ParkY;                       /* Y-coordinate of park position */
   int FibreType;                    /* A code indicating the fibre type - this
                                      * is instrument-dependent. */
   unsigned int FibreLength;         /* Fibre length in microns */
   double Theta;                     /* Theta value of park position */
   int AllowAllocChange;             /* Indicates if the allocation algorithm
                                      * is allowed to change the allocation
                                      * of this pivot.  If this is false, then
                                      * NoteDeallocation and NoAllocation will
                                      * return errors for this pivot. (This
                                      * field may be true even though FibreType
                                      * indicates a broken fibre, so both fields
                                      * need to be checked.) */
} CONFIG_PivotInfo;

typedef struct CONFIG_TargetInfo {   /* Details about each target */
   long X;                           /* X-coordinate of target, in microns */
   long Y;                           /* Y-coordinate of target, in microns */
   int OriginalIndex;                /* Index in original target list */
   CONFIG_Boolean PreAllocated;      /* True if explicitly allocated */
   char Type;                        /* Type of object. This is instrument
                                      * dependent. */
   char Priority;                    /* Priority value, 0..9, 9 = highest. */
   char Spect;                       /* Combines with 'Type' to provide extra
                                      * information about the target - 
                                      * usually the spectrograph to which it
                                      * should be allocated, hence the name. */
   char *ObjName;                    /* Pointer to string giving the name of
                                      * the Object */
} CONFIG_TargetInfo;

/*  This defines a standard feedback function used to report progress,
 *  fibre allocations, deallocations, etc.
 */

typedef int (*CONFIG_ReportFunction) (
   void *FunctionArg,             /* (>) Caller-supplied argument */
   char Type,                     /* (>) Indicates the type of report */
   char *Description,             /* (>) What the program is doing */
   int PivotIndex,                /* (>) The index number of a pivot */
   int IsGuide,                   /* (>) Whether target is a guide star */
   int TargetIndex,               /* (>) The index number of a target */
   long int TargetX,              /* (>) The X-coordinate of a target */
   long int TargetY,              /* (>) The Y-coordinate of a target */
   double Theta,                  /* (>) Theta value for button */
   double PercentDone);           /* (>) The percentage of work done */

typedef void (*CONFIG_AllocRptFunction) (
   void *FunctionArg,             /* (>) Caller-supplied argument */
   int Alloc,                     /* (>) True for allocation, False for 
                                   *     Deallocation */
   int PivotIndex,                /* (>) The index number of a pivot */
   int IsGuide,                   /* (>) Whether target is a guide star */
   int TargetIndex,               /* (>) The index number of a target */
   long int TargetX,              /* (>) The X-coordinate of a target */
   long int TargetY,              /* (>) The Y-coordinate of a target */
   double Theta,                  /* (>) Theta value for button */
   StatusType *Status);           /* (!) Inherited status */

/*
 * This defines a feedback function used to output informational
 * messages to stdout.
 */
typedef void (*ConfigInfoRoutine) (
   void *FunctionArg,             /* (>) Caller-supplied argument */
   const char *String);

/*
 *  Predeclaration of CONFIG_MethodDetails for ConfigRegisterMethod.
 */
typedef struct CONFIG_MethodDetails CONFIG_MethodDetails;

/* ------------------------------------------------------------------------- */

/*  These routines form the defined interface between the 'housekeeping and
 *  external interface' section of the allocation algorithms and the
 *  method-specific routines. These define the external view of the
 *  method-specific routines. If these are changed, not only must the
 *  documentation be updated accordingly, but also equivalent changes
 *  must be made to all existing instances of method-specific code.
 */

/*
 *  Predeclaration of CONFIG_MethodInfo for use in these typedefs.
 */
typedef struct CONFIG_MethodInfo CONFIG_MethodInfo;

typedef void (*ConfigMethodGlobalInitRoutine) (
    const CONFIG_MethodInfo *MethodInfo);
                                  /*     Initialises method-specific globals */

typedef void (*ConfigMethodReleaseRoutine) (
    const CONFIG_MethodInfo *MethodInfo); 
                                  /*     Releases any method specific dynamic 
                                   *     memory */

typedef void (*ConfigMethodInitRoutine) (
                                  /*     Method specific initialisation for new
                                   *     target field. */
   const CONFIG_MethodInfo *MethodInfo,
                                  /* (>) Supplies house keeping details */
   CONFIG_ReportFunction ReportFunction,
                                  /* (>) Feedback routine to call */
   void *FunctionArg,             /* (>) Caller-supplied argument */
   StatusType *Status);           /* (!) Inherited status */

typedef void (*ConfigMethodSetSkyRoutine) (
                                  /*     Sets sky target counts  */
   const CONFIG_MethodInfo *MethodInfo,
                                  /* (>) Supplies housekeeping details */
   int FibreType,                 /* (>) Fibre type code */
   int NumberSkyAllocations,      /* (>) Number of fibres for sky targets */
   StatusType *Status);           /* (!) Inherited status */

typedef void (*ConfigMethodAllocateRoutine) (
                                  /*     Performs the actual allocation */
   const CONFIG_MethodInfo *MethodInfo,
                                  /* (>) Supplies housekeeping details */
   CONFIG_ReportFunction ReportFunction,
                                  /* (>) Feedback routine to call */
   void *FunctionArg,             /* (>) Caller-supplied argument */
   StatusType *Status);           /* (!) Inherited status */

typedef int (*ConfigMethodNumParamsRoutine)(
                                  /*     Returns number of parameters */
    const CONFIG_MethodInfo *MethodInfo);
                                  /* (>) Supplies housekeeping details */

typedef void (*ConfigMethodParamDetailsRoutine) ( 
                                  /*     Gets details of a given parameter */
   const CONFIG_MethodInfo *MethodInfo,
                                  /* (>) Supplies housekeeping details */
   int ParameterNumber,           /* (>) Number of parameter */
   char **Name,                   /* (<) Parameter name */
   char *Type,                    /* (<) Type code for parameter */
   double Limits[2],              /* (<) Numerical range */
   int *NValues,                  /* (<) # of possible values */
   char ***Values,                /* (<) List of possible values */
   StatusType *Status);           /* (!) Inherited status */

typedef void (*ConfigMethodSetParamRoutine) (
                                  /*     Sets the value of a named parameter */
   const CONFIG_MethodInfo *MethodInfo,
                                  /* (>) Supplies house keeping details */
   char *Name,                    /* (>) Name of parameter */
   char *Value,                   /* (>) Value for parameter */
   StatusType *Status);           /* (!) Inherited status */

typedef void (*ConfigMethodGetParamRoutine) (
                                  /*     Get value of a named parameter */
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   char *Name,                    /* (>) Name of parameter */
   char *Value,                   /* (>) Value for parameter */
   int VSize,                     /* (>) Maximum number of characters */
   StatusType *Status);           /* (!) Inherited status */

typedef void (*ConfigMethodSetImportRoutine) (
   const CONFIG_MethodInfo *MethodInfo,
                                  /* (>) Supplies house keeping details */
   char name[80]);

/*
 *  Structure describing a method
 */

#define CONFIG_MTH_NAME_LEN 40  /* Length of method name including null */
#define CONFIG_MTH_N_ROUTINES 9 /* Value for RoutineCount */
#define CONFIG_NUM_METHODS   5  /* Maximum number of methods */

struct CONFIG_MethodDetails { 
   int                             Version;
   int                             RoutineCount;
   void *                          clientData;
   char                            Name[CONFIG_MTH_NAME_LEN];
   ConfigMethodGlobalInitRoutine   GlobalInit;
   ConfigMethodInitRoutine         Init;
   ConfigMethodReleaseRoutine      ReleaseMem;
   ConfigMethodSetSkyRoutine       SetSky;
   ConfigMethodAllocateRoutine     Allocate;
   ConfigMethodNumParamsRoutine    NumParams;
   ConfigMethodParamDetailsRoutine ParamDetails;
   ConfigMethodSetParamRoutine     SetParam;
   ConfigMethodGetParamRoutine     GetParam;
   ConfigMethodSetImportRoutine    SetImportFile;
};

/* -------------------------------------------------------------------------- */

/*  These routines are those provided in the 'housekeeping and interface'
 *  section for use by the method-specific routines.
 *
 *  Note that in this routines, the MethodInfo structure is const only
 *  because these routines are called from the allocation algorithm layer,
 *  which is not allowed to touch MethodInfo.  It is acceptable for
 *  the implementation of this layer to case MethodInfo to be non-const and
 *  to case the const elements of MethodInfo to be non-const.
 */
typedef long   (* ConfigIntValRoutine)  (const CONFIG_MethodInfo * MethodInfo);
typedef double (* ConfigRealValRoutine) (const CONFIG_MethodInfo * MethodInfo);

typedef void (* ConfigGetVirtPivRoutine) ( 
                                /*      Get coords of button's virtual pivot */
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   double OriginX,              /* (>) The x-coordinate of the button origin */
   double OriginY,              /* (>) The y-coordinate of the button origin */
   double Theta,                /* (>) The theta angle for the button        */
   double *VirtPivX,            /* (<) The x-coordinate of the virtual pivot */
   double *VirtPivY);           /* (<) The y-coordinate of the virtual pivot */


typedef double (* ConfigThetaFibRoutine) ( 
                                 /*     Calculates radial theta fibre angle  */
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   const CONFIG_TargetInfo *TargetInfo,/* (>) Target info structure */
   const CONFIG_PivotInfo *PivotInfo); /* (>) Pivot info structure */


typedef CONFIG_Boolean (* ConfigCheckAlphaRoutine) ( 
                                 /*     Gets & checks fibre alpha value      */
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   const CONFIG_TargetInfo *TargetInfo,/* (>) Target info structure          */
   const CONFIG_PivotInfo *PivotInfo,  /* (>) Pivot info structure           */
   double *Alpha);               /* (<) Returns calculated alpha value       */

typedef CONFIG_Boolean (* ConfigChkAllocationRoutine) (
                                 /* (<) Returns true if allocation is OK */
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   int Pivot,                    /* (>) The number of the pivot in question  */
   int Target,                   /* (>) The number of the target in question */
   double Theta,                 /* (>) The proposed twist angle, theta      */
   int *CollidingPivot);         /* (<) Any one colliding pivot. */


typedef void (* ConfigFieldChkRoutine) ( 
                                 /*     Performs a full field validation     */
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   CONFIG_ReportFunction ReportFunction,
                                 /* (>) Feedback routine to call */
   void *FunctionArg,            /* (>) Caller-supplied argument */
   int PositionerTolerances,     /* (>) If true, use positioner tolerances */
   StatusType  *status);         /* (!) Inherited status variable */


typedef void (*ConfigNoteAllocationRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   int Pivot,                    /* (>) Pivot being allocated                */
   int Target,                   /* (>) Target allocated to pivot            */
   double Theta,                 /* (>) Theta (twist) angle for fibre        */
   int Tentative,                /* (>) If true, allocation is tentative     */
   StatusType *Status);          /* (!) Inherited status variable            */

typedef void (*ConfigNoteDeallocationRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   int Pivot,                    /* (>) Pivot being allocated */
   StatusType *Status);          /* (!) Inherited status variable */

typedef void (*ConfigTentativeFixRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   int Pivot,                          /* (>) Pivot being allocated          */
   int Flag,                           /* (>) True to set allocated, false
                                          to deallocate */
   StatusType *Status);                /* (!) Inherited status               */
    

typedef int  (*ConfigColFibFibRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   double  pivAX,                /* (>) Fibre A X ordinate */
   double  pivAY,                /* (>) Fibre A Y ordinate */
   double  fvpAX,                /* (>) Fibre A virtual pivot X ordinate   */
   double  fvpAY,                /* (>) Fibre A virtual pivot Y ordinate */
   double  pivBX,                /* (>) Fibre B X ordinate */
   double  pivBY,                /* (>) Fibre B Y ordinate */
   double  fvpBX,                /* (>) Fibre B virtual pivot X ordinate   */
   double  fvpBY);               /* (>) Fibre B virtual pivot Y ordinate */

typedef int  (*ConfigColButFibRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   double butX,                  /* (>) Button X ordinate */
   double butY,                  /* (>) Button Y ordinate */
   double theta,                 /* (>) Button theta      */
   double fvpX,                  /* (>) Fibre virtual pivot X ordinate */
   double fvpY,                  /* (>) Fibre virtual pivot Y ordinate */
   double pivX,                  /* (>) Fibre pivot X ordinate */
   double pivY);                 /* (>) Fibre pivot Y ordinate*/

typedef int  (*ConfigColButButRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   double butXa,                 /* (>) Button A X ordinate */
   double butYa,                 /* (>) Button A Y ordinate */
   double thetaa,                /* (>) Button A theta      */
   double butXb,                 /* (>) Button B X ordinate */
   double butYb,                 /* (>) Button B Y ordinate */
   double thetab);               /* (>) Button B theta      */

typedef int  (*ConfigColInvPosRoutine) (
   const CONFIG_MethodInfo *MethodInfo,/* (>) Supplies house keeping details */
   int       fibreType,          /* (>) Fibre type        */
   long int  butx,               /* (>) Button X ordinate */
   long int  buty,               /* (>) Button Y ordinate */
   double    theta);             /* (>) Button theta      */

typedef int  (*ConfigAdjParkRoutine) (
    const CONFIG_MethodInfo *MethodInfo,/* (>) house keeping details*/
    int IPiv,                           /* (>) The pivot number */
    long int targetX,                   /* (>) The target X position */
    long int targetY,                   /* (>) The target Y position */
    double theta);                      /* (>) Pivot theta angle */
    
typedef int  (*ConfigFibreReallyExistsRoutine) (
    const CONFIG_MethodInfo *MethodInfo,/* (>) house keeping details*/
    int IPiv);                          /* (>) The pivot number */
    
typedef int  (*ConfigCollisionRoutine) (
    const CONFIG_MethodInfo *MethodInfo,/* (>) house keeping details*/
    long int butXa,                     /* (>) Button A fibre X position */
    long int butYa,                     /* (>) Button A fibre Y position */
    double thetaa,                      /* (>) Button A theta angle      */
    long int pivXa,                     /* (>) Button A pivot X position */
    long int pivYa,                     /* (>) Button A pivot Y position */
    long int butXb,                     /* (>) Button B fibre X position */
    long int butYb,                     /* (>) Button B fibre Y position */
    double thetab,                      /* (>) Button B theta angle      */
    long int pivXb,                     /* (>) Button B pivot X position */
    long int pivYb);                    /* (>) Button B pivot Y position */

typedef int  (*ConfigParkMayCollideRoutine) (
    const CONFIG_MethodInfo *MethodInfo);/* (>) house keeping details*/

typedef void (*ConfigSetFibrePosRoutine) (
    const CONFIG_MethodInfo *MethodInfo,/* (>) house keeping details*/
    int pivot,                          /* (>) Pivot to change      */
    int X,                              /* (>) New X position       */
    int Y,                              /* (>) New Y position       */
    double theta,                       /* (>) New Theta position   */
    int Target,                         /* (>) New target index     */
    CONFIG_Boolean allocated);          /* (>) Is it to be allocated */

typedef int  (*ConfigFibreIsGuideRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    int fibreType);                      /* (>) Fibre type code */

typedef int  (*ConfigTargetIsGuideRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    char TargetType);                    /* (>) Target type code */

typedef int  (*ConfigTargetIsSkyRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    char TargetType);                    /* (>) Target type code */

typedef char* (*ConfigFibreTextRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    int FibreType);                      /* (>) Fibre type code */

typedef int (*ConfigFibreTypeMatchRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    int FibreType,                       /* (>) First fibre type code */
    int SecondType);                     /* (>) Second fibre type code */

typedef int (*ConfigFibreSharesSkyRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    int FibreType);                      /* (>) Fibre type code */

typedef int  (*ConfigFibreIsBrokenRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    int fibreType);                      /* (>) Fibre type code */

typedef int  (*ConfigFibreTargetCompatibleRoutine) (
    const CONFIG_MethodInfo *MethodInfo, /* (>) house keeping details*/
    char targetType,                     /* (>) target type code */
    char spectType,                      /* (>) target spectrograph code */
    int fibreType);                      /* (>) Fibre type code */

/*
 * CONFIG_MethodInfo -> The structure used to supply information to the
 * allocation algorithm routines.
 */

struct CONFIG_MethodInfo {
   void *                             clientData; 
   ConfigIntValRoutine                MaxExtension; 
   ConfigGetVirtPivRoutine            GetVirtPiv; 
   ConfigThetaFibRoutine              ThetaFib; 
   ConfigCheckAlphaRoutine            CheckAlpha;
   ConfigChkAllocationRoutine         CheckAllocation;
   ConfigFieldChkRoutine              FieldCheck;
   ConfigNoteAllocationRoutine        NoteAllocation;
   ConfigTentativeFixRoutine          TentativeFix;
   ConfigNoteDeallocationRoutine      NoteDeallocation;
   ConfigNoteDeallocationRoutine      NoteDeallocationBroken;
   ConfigIntValRoutine                ButtonClear;
   ConfigIntValRoutine                FibreClear;
   ConfigRealValRoutine               MaxButAngle;
   ConfigRealValRoutine               MaxPivAngle;
   ConfigIntValRoutine                SafeClearance;
   ConfigColFibFibRoutine             ColFibFib;
   ConfigColButFibRoutine             ColButFib;
   ConfigColButButRoutine             ColButBut;
   ConfigColInvPosRoutine             ColInvPos;
   ConfigCollisionRoutine             Collision;
   ConfigAdjParkRoutine               AdjPark;
   ConfigFibreReallyExistsRoutine     FibreReallyExists;
   ConfigSetFibrePosRoutine           SetFibrePos;
   ConfigParkMayCollideRoutine        ParkMayCollide;
   ConfigFibreIsGuideRoutine          FibreIsGuide;
   ConfigFibreIsBrokenRoutine         FibreIsBroken;
   ConfigTargetIsGuideRoutine         TargetIsGuide;
   ConfigTargetIsSkyRoutine           TargetIsSky;
   ConfigFibreTextRoutine             FibreText;
   ConfigFibreTypeMatchRoutine        FibreTypeMatch;
   ConfigFibreSharesSkyRoutine        FibreSharesSky;
   ConfigFibreTargetCompatibleRoutine FibreTargetCompatible;
   ConfigInfoRoutine                  InfoRoutine;
   void                             * InfoArgument;
   ConfigInfoRoutine                  ErrRepRoutine;
   int                                Field;
   int                                NumberPivots;
   int                                NumberTargets;
   const CONFIG_TargetInfo         *  TargetInfo;
   const CONFIG_PivotInfo          *  PivotInfo;
   const CONFIG_AllocInfo          *  AllocInfo;
   void *                            _Instrument; /* Hidden item, used by
                                                  callback routines only,
                                                  Use for an FpilType 
                                                  variable */
   CONFIG_AllocRptFunction         _AllocRpt;   /* Hidden item, allocation
                                                   report function used
                                                   by NoteAllocation and
                                                   NoteDeallocation */
   void *                          _AllocRptArg; /* Hidden item, arg to
                                                    _AllocRpt function */
};


/*
 * Define a version specification.
 */
#define CONFIG_VERSION 2

/*
 * This value is set in the priority field if an item is outside the
 * field area and should not be configured.  
 */
#define CONFIG_PRIO_INVALID 100

#endif
