/*
*+                                s d s l i s t

 * Function name:
      sdslist

 * Function:
      List  sds files on stdout.

 *  Synopsis:
	sdslist [file...]

 * Description:
	A listing of the contents of Sds objects contained in the specified
	files is generated on standard output.  The listing consists of
	the name, type, dimensions andvalue of each object in the structure.
	The hierarchical structure is indicated by indenting the listing for
	components at each level.

	For array objects, only the values for the first vew components
	are listed so that each listing fits on a single line.	
      

 * Language:
      C


 * Support: Jeremy Bailey, AAO

 *-

 * History:
      24-Feb-95 - TJF - Header added for wflman support.
      30-Aug-99 - KS  - Added conditional code to get arguments on Mac.


 */
#include "status.h"
#include "sds.h"

#if defined (__MWERKS__) && defined(macintosh)
#include <console.h>
#endif

main(int argc, char* argv[])

{
  StatusType status;
  SdsIdType id;
  
#if defined (__MWERKS__) && defined(macintosh)
  argc = ccommand(&argv);
#endif

  if (argc > 1)
    {
      status = SDS__OK;
      SdsRead(argv[1],&id,&status);
      SdsList(id,&status);
    }
  if (status == 0)
      return 0;
  else
      return -1;
 
}
