/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: convertPAF.h 77237 2003-01-31 05:42:32Z flamemgr $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* rschmutz  29/01/03  PPRS 8670: load INS.OSS.CHECKHA in PAF file.
* rschmutz  29/01/03  this header created - previous history see below.
*/

/*
 *                       c o n v e r t  P A F . h
 *
 *  Include file for the FPOSS PAF input routines.
 *
 *  History:
 *     20th Apr 2001.  KS.  Original version
 *     31st Oct 2001.  KS.  Instrument now passed to PAF_CreateSds().
 *     28th Aug 2002.  KS.  ModeCode now returned by PAF_CreateSds().
 */

#include "sds.h"
#include "status.h"
#include "fpil.h"

#ifdef Status
#undef Status
#endif

/*  Structure used to return information about any VLT guide object that
 *  has been selected.
 */
 
typedef struct PAF_VLTGuideInfo {
   int SelGuideIndex;         /* Selected guide object - index into the 
                               * unallocGuide structure, starting from 1. Zero
                               * if no guide object selected. */
   char Posneg[4];            /* Orientation for guide pivot, if a guide
                               * object has been selected. One of "POS" or 
                               * "NEG" */
} PAF_VLTGuideInfoType;

/*  The main external PAF_ routine - this reads a PAF file and creates an
 *  SDS structure as required by FP OSS. It also returns details about
 *  any VLT guide star that has been selected, and a code giving the 
 *  mode (the fibre combination) in use.
 */
 
void PAF_CreateSds (
   FpilType *Instrument,
   char* FileName,
   SdsIdType PivId,
   SdsIdType* FileId,
   PAF_VLTGuideInfoType* GuideInfoPtr,
   int *ModeCode,
   double *checkHA,
   StatusType* Status);
   
/*  The only other external routine returns the address of a string describing
 *  the last PAF_ routine error. Since Ers is also used to report errors,
 *  this will probably not be made use of.
 */
 
char* PAF_GetErrorText (void);
