%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4
%% Purpose: Encoding and decoding of the types in PKIX1Explicit-2009.

-module('PKIX1Explicit-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIX1Explicit-2009.hrl").
-asn1_info([{vsn,'5.4'},
            {module,'PKIX1Explicit-2009'},
            {options,[{i,"/buildroot/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/buildroot/otp/lib/public_key/asn1"},
 {outdir,"/buildroot/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/buildroot/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_AttributeType/2,
enc_X520name/2,
enc_X520CommonName/2,
enc_X520LocalityName/2,
enc_X520StateOrProvinceName/2,
enc_X520OrganizationName/2,
enc_X520OrganizationalUnitName/2,
enc_Name/2,
enc_RDNSequence/2,
enc_DistinguishedName/2,
enc_RelativeDistinguishedName/2,
enc_Certificate/2,
enc_TBSCertificate/2,
enc_Version/2,
enc_CertificateSerialNumber/2,
enc_Validity/2,
enc_Time/2,
enc_UniqueIdentifier/2,
enc_SubjectPublicKeyInfo/2,
enc_CertificateList/2,
enc_TBSCertList/2,
'enc_at-x520StateOrProvinceName_DirectoryString'/2,
enc_RelativeDistinguishedName_DirectoryString/2,
'enc_at-x520Title_DirectoryString'/2,
'enc_at-x520Pseudonym_DirectoryString'/2,
'enc_at-x520OrganizationalUnitName_DirectoryString'/2,
'enc_at-x520OrganizationName_DirectoryString'/2
]).

-export([
dec_AttributeType/2,
dec_X520name/2,
dec_X520CommonName/2,
dec_X520LocalityName/2,
dec_X520StateOrProvinceName/2,
dec_X520OrganizationName/2,
dec_X520OrganizationalUnitName/2,
dec_Name/2,
dec_RDNSequence/2,
dec_DistinguishedName/2,
dec_RelativeDistinguishedName/2,
dec_Certificate/2,
dec_TBSCertificate/2,
dec_Version/2,
dec_CertificateSerialNumber/2,
dec_Validity/2,
dec_Time/2,
dec_UniqueIdentifier/2,
dec_SubjectPublicKeyInfo/2,
dec_CertificateList/2,
dec_TBSCertList/2,
'dec_at-x520StateOrProvinceName_DirectoryString'/2,
dec_RelativeDistinguishedName_DirectoryString/2,
'dec_at-x520Title_DirectoryString'/2,
'dec_at-x520Pseudonym_DirectoryString'/2,
'dec_at-x520OrganizationalUnitName_DirectoryString'/2,
'dec_at-x520OrganizationName_DirectoryString'/2
]).

-export([
'enc_at-name'/3,
'enc_at-surname'/3,
'enc_at-givenName'/3,
'enc_at-initials'/3,
'enc_at-generationQualifier'/3,
'enc_at-x520CommonName'/3,
'enc_at-x520LocalityName'/3,
'enc_at-x520StateOrProvinceName'/3,
'enc_at-x520OrganizationName'/3,
'enc_at-x520OrganizationalUnitName'/3,
'enc_at-x520Title'/3,
'enc_at-x520dnQualifier'/3,
'enc_at-x520countryName'/3,
'enc_at-x520SerialNumber'/3,
'enc_at-x520Pseudonym'/3,
'enc_at-domainComponent'/3,
'enc_at-emailAddress'/3
]).

-export([
'dec_at-name'/3,
'dec_at-surname'/3,
'dec_at-givenName'/3,
'dec_at-initials'/3,
'dec_at-generationQualifier'/3,
'dec_at-x520CommonName'/3,
'dec_at-x520LocalityName'/3,
'dec_at-x520StateOrProvinceName'/3,
'dec_at-x520OrganizationName'/3,
'dec_at-x520OrganizationalUnitName'/3,
'dec_at-x520Title'/3,
'dec_at-x520dnQualifier'/3,
'dec_at-x520countryName'/3,
'dec_at-x520SerialNumber'/3,
'dec_at-x520Pseudonym'/3,
'dec_at-domainComponent'/3,
'dec_at-emailAddress'/3
]).

-export([
getenc_SupportedAttributes/1,
getenc_SignatureAlgorithms/1,
getenc_PublicKeyAlgorithms/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_1/1,
getenc_internal_object_set_argument_15/1,
getenc_internal_object_set_argument_14/1,
getenc_internal_object_set_argument_13/1,
getenc_internal_object_set_argument_12/1,
getenc_internal_object_set_argument_11/1
]).

-export([
getdec_SupportedAttributes/1,
getdec_SignatureAlgorithms/1,
getdec_PublicKeyAlgorithms/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_1/1,
getdec_internal_object_set_argument_15/1,
getdec_internal_object_set_argument_14/1,
getdec_internal_object_set_argument_13/1,
getdec_internal_object_set_argument_12/1,
getdec_internal_object_set_argument_11/1
]).

-export([
'id-pkix'/0,
'id-pe'/0,
'id-qt'/0,
'id-kp'/0,
'id-ad'/0,
'id-qt-cps'/0,
'id-qt-unotice'/0,
'id-ad-ocsp'/0,
'id-ad-caIssuers'/0,
'id-ad-timeStamping'/0,
'id-ad-caRepository'/0,
'id-at'/0,
'id-at-name'/0,
'id-at-surname'/0,
'id-at-givenName'/0,
'id-at-initials'/0,
'id-at-generationQualifier'/0,
'id-at-commonName'/0,
'id-at-localityName'/0,
'id-at-stateOrProvinceName'/0,
'id-at-organizationName'/0,
'id-at-organizationalUnitName'/0,
'id-at-title'/0,
'id-at-dnQualifier'/0,
'id-at-countryName'/0,
'id-at-serialNumber'/0,
'id-at-pseudonym'/0,
'id-domainComponent'/0,
'pkcs-9'/0,
'id-emailAddress'/0,
'ub-state-name'/0,
'ub-organization-name'/0,
'ub-organizational-unit-name'/0,
'ub-title'/0,
'ub-serial-number'/0,
'ub-pseudonym'/0,
'ub-emailaddress-length'/0,
'ub-locality-name'/0,
'ub-common-name'/0,
'ub-name'/0
]).

-export([info/0]).

-export([
decode_TBSCertList_exclusive/1
]).

-export([decode_part/2]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_partial_incomplete(Type, Data0, Pattern) ->
  {Data,RestBin} =
    decode_primitive_incomplete(Pattern, Data0),
  try {ok,decode_partial_inc_disp(Type, Data)}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_part(Type, Data0) when is_binary(Data0) ->
  try {ok,decode_inc_disp(Type, element(1, ber_decode_nif(Data0)))}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end;
decode_part(Type, Data0) ->
  try {ok,decode_inc_disp(Type, Data0)}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_partial_inc_disp('CertificateList',Data) ->
  'dec-inc-CertificateList'(Data).
encode_disp('AttributeType', Data) -> enc_AttributeType(Data);
encode_disp('X520name', Data) -> enc_X520name(Data);
encode_disp('X520CommonName', Data) -> enc_X520CommonName(Data);
encode_disp('X520LocalityName', Data) -> enc_X520LocalityName(Data);
encode_disp('X520StateOrProvinceName', Data) -> enc_X520StateOrProvinceName(Data);
encode_disp('X520OrganizationName', Data) -> enc_X520OrganizationName(Data);
encode_disp('X520OrganizationalUnitName', Data) -> enc_X520OrganizationalUnitName(Data);
encode_disp('Name', Data) -> enc_Name(Data);
encode_disp('RDNSequence', Data) -> enc_RDNSequence(Data);
encode_disp('DistinguishedName', Data) -> enc_DistinguishedName(Data);
encode_disp('RelativeDistinguishedName', Data) -> enc_RelativeDistinguishedName(Data);
encode_disp('Certificate', Data) -> enc_Certificate(Data);
encode_disp('TBSCertificate', Data) -> enc_TBSCertificate(Data);
encode_disp('Version', Data) -> enc_Version(Data);
encode_disp('CertificateSerialNumber', Data) -> enc_CertificateSerialNumber(Data);
encode_disp('Validity', Data) -> enc_Validity(Data);
encode_disp('Time', Data) -> enc_Time(Data);
encode_disp('UniqueIdentifier', Data) -> enc_UniqueIdentifier(Data);
encode_disp('SubjectPublicKeyInfo', Data) -> enc_SubjectPublicKeyInfo(Data);
encode_disp('CertificateList', Data) -> enc_CertificateList(Data);
encode_disp('TBSCertList', Data) -> enc_TBSCertList(Data);
encode_disp('at-x520StateOrProvinceName_DirectoryString', Data) -> 'enc_at-x520StateOrProvinceName_DirectoryString'(Data);
encode_disp('RelativeDistinguishedName_DirectoryString', Data) -> enc_RelativeDistinguishedName_DirectoryString(Data);
encode_disp('at-x520Title_DirectoryString', Data) -> 'enc_at-x520Title_DirectoryString'(Data);
encode_disp('at-x520Pseudonym_DirectoryString', Data) -> 'enc_at-x520Pseudonym_DirectoryString'(Data);
encode_disp('at-x520OrganizationalUnitName_DirectoryString', Data) -> 'enc_at-x520OrganizationalUnitName_DirectoryString'(Data);
encode_disp('at-x520OrganizationName_DirectoryString', Data) -> 'enc_at-x520OrganizationName_DirectoryString'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('AttributeType', Data) -> dec_AttributeType(Data);
decode_disp('X520name', Data) -> dec_X520name(Data);
decode_disp('X520CommonName', Data) -> dec_X520CommonName(Data);
decode_disp('X520LocalityName', Data) -> dec_X520LocalityName(Data);
decode_disp('X520StateOrProvinceName', Data) -> dec_X520StateOrProvinceName(Data);
decode_disp('X520OrganizationName', Data) -> dec_X520OrganizationName(Data);
decode_disp('X520OrganizationalUnitName', Data) -> dec_X520OrganizationalUnitName(Data);
decode_disp('Name', Data) -> dec_Name(Data);
decode_disp('RDNSequence', Data) -> dec_RDNSequence(Data);
decode_disp('DistinguishedName', Data) -> dec_DistinguishedName(Data);
decode_disp('RelativeDistinguishedName', Data) -> dec_RelativeDistinguishedName(Data);
decode_disp('Certificate', Data) -> dec_Certificate(Data);
decode_disp('TBSCertificate', Data) -> dec_TBSCertificate(Data);
decode_disp('Version', Data) -> dec_Version(Data);
decode_disp('CertificateSerialNumber', Data) -> dec_CertificateSerialNumber(Data);
decode_disp('Validity', Data) -> dec_Validity(Data);
decode_disp('Time', Data) -> dec_Time(Data);
decode_disp('UniqueIdentifier', Data) -> dec_UniqueIdentifier(Data);
decode_disp('SubjectPublicKeyInfo', Data) -> dec_SubjectPublicKeyInfo(Data);
decode_disp('CertificateList', Data) -> dec_CertificateList(Data);
decode_disp('TBSCertList', Data) -> dec_TBSCertList(Data);
decode_disp('at-x520StateOrProvinceName_DirectoryString', Data) -> 'dec_at-x520StateOrProvinceName_DirectoryString'(Data);
decode_disp('RelativeDistinguishedName_DirectoryString', Data) -> dec_RelativeDistinguishedName_DirectoryString(Data);
decode_disp('at-x520Title_DirectoryString', Data) -> 'dec_at-x520Title_DirectoryString'(Data);
decode_disp('at-x520Pseudonym_DirectoryString', Data) -> 'dec_at-x520Pseudonym_DirectoryString'(Data);
decode_disp('at-x520OrganizationalUnitName_DirectoryString', Data) -> 'dec_at-x520OrganizationalUnitName_DirectoryString'(Data);
decode_disp('at-x520OrganizationName_DirectoryString', Data) -> 'dec_at-x520OrganizationName_DirectoryString'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  AttributeType
%%================================
enc_AttributeType(Val) ->
    enc_AttributeType(Val, [<<6>>]).

enc_AttributeType(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_AttributeType(Tlv) ->
   dec_AttributeType(Tlv, [6]).

dec_AttributeType(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  X520name
%%================================
enc_X520name(Val) ->
    enc_X520name(Val, []).

enc_X520name(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520name(Tlv) ->
   dec_X520name(Tlv, []).

dec_X520name(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32768 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 32768 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 32768 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 32768 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520CommonName
%%================================
enc_X520CommonName(Val) ->
    enc_X520CommonName(Val, []).

enc_X520CommonName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520CommonName(Tlv) ->
   dec_X520CommonName(Tlv, []).

dec_X520CommonName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 64 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 64 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520LocalityName
%%================================
enc_X520LocalityName(Val) ->
    enc_X520LocalityName(Val, []).

enc_X520LocalityName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520LocalityName(Tlv) ->
   dec_X520LocalityName(Tlv, []).

dec_X520LocalityName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 128 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 128 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520StateOrProvinceName
%%================================
enc_X520StateOrProvinceName(Val) ->
    enc_X520StateOrProvinceName(Val, []).

enc_X520StateOrProvinceName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520StateOrProvinceName(Tlv) ->
   dec_X520StateOrProvinceName(Tlv, []).

dec_X520StateOrProvinceName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 128 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 128 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520OrganizationName
%%================================
enc_X520OrganizationName(Val) ->
    enc_X520OrganizationName(Val, []).

enc_X520OrganizationName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520OrganizationName(Tlv) ->
   dec_X520OrganizationName(Tlv, []).

dec_X520OrganizationName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 64 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 64 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520OrganizationalUnitName
%%================================
enc_X520OrganizationalUnitName(Val) ->
    enc_X520OrganizationalUnitName(Val, []).

enc_X520OrganizationalUnitName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_X520OrganizationalUnitName(Tlv) ->
   dec_X520OrganizationalUnitName(Tlv, []).

dec_X520OrganizationalUnitName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 64 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 64 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Name
%%================================
enc_Name(Val) ->
    enc_Name(Val, []).

enc_Name(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      rdnSequence ->
         'enc_RDNSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Name(Tlv) ->
   dec_Name(Tlv, []).

dec_Name(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'rdnSequence'
    {16, V1} -> 
        {rdnSequence, 'dec_RDNSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RDNSequence
%%================================
enc_RDNSequence(Val) ->
    enc_RDNSequence(Val, [<<48>>]).

enc_RDNSequence(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RDNSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RDNSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RDNSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName'(H, [<<49>>]),
   'enc_RDNSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RDNSequence(Tlv) ->
   dec_RDNSequence(Tlv, [16]).

dec_RDNSequence(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RelativeDistinguishedName'(V1, [17]) || V1 <- Tlv1].




%%================================
%%  DistinguishedName
%%================================
enc_DistinguishedName(Val) ->
    enc_DistinguishedName(Val, [<<48>>]).

enc_DistinguishedName(Val, TagIn) ->
   enc_RDNSequence(Val, TagIn).


dec_DistinguishedName(Tlv) ->
   dec_DistinguishedName(Tlv, [16]).

dec_DistinguishedName(Tlv, TagIn) ->
'dec_RDNSequence'(Tlv, TagIn).



%%================================
%%  RelativeDistinguishedName
%%================================
enc_RelativeDistinguishedName(Val) ->
    enc_RelativeDistinguishedName(Val, [<<49>>]).

enc_RelativeDistinguishedName(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RelativeDistinguishedName_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_RelativeDistinguishedName_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName_SingleAttribute'(H, [<<48>>]),
   'enc_RelativeDistinguishedName_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  RelativeDistinguishedName_SingleAttribute
%%================================
enc_RelativeDistinguishedName_SingleAttribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIX1Explicit-2009':'getenc_internal_object_set_argument_1'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RelativeDistinguishedName(Tlv) ->
   dec_RelativeDistinguishedName(Tlv, [17]).

dec_RelativeDistinguishedName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RelativeDistinguishedName_SingleAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_RelativeDistinguishedName_SingleAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjtypeTerm1 =
   'PKIX1Explicit-2009':'getdec_internal_object_set_argument_1'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SingleAttribute',Term1,Term2},
Res1.


%%================================
%%  Certificate
%%================================
enc_Certificate(Val) ->
    enc_Certificate(Val, [<<48>>]).

enc_Certificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIX1Explicit-2009:TBSCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Certificate_algorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Certificate_algorithmIdentifier
%%================================
enc_Certificate_algorithmIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_SignatureAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Certificate(Tlv) ->
   dec_Certificate(Tlv, [16]).

dec_Certificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIX1Explicit-2009:TBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Certificate_algorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Certificate',Term1,Term2,Term3},
Res1.
'dec_Certificate_algorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_SignatureAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Certificate_algorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  TBSCertificate
%%================================
enc_TBSCertificate(Val) ->
    enc_TBSCertificate(Val, [<<48>>]).

enc_TBSCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute signature(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_TBSCertificate_signature'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Name'(Cindex4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit-2009:Validity
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_Validity'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_Name'(Cindex6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External PKIX1Explicit-2009:SubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_SubjectPublicKeyInfo'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex9, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSCertificate_extensions'(Cindex10, [<<48>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertificate_signature
%%================================
enc_TBSCertificate_signature(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertificate_extensions
%%================================
enc_TBSCertificate_extensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSCertificate_extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSCertificate_extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSCertificate_extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSCertificate_extensions_Extension'(H, [<<48>>]),
   'enc_TBSCertificate_extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSCertificate_extensions_Extension
%%================================
enc_TBSCertificate_extensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TBSCertificate(Tlv) ->
   dec_TBSCertificate(Tlv, [16]).

dec_TBSCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute signature(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_TBSCertificate_signature'(V3, [16]),

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Name'(V4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit-2009:Validity
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_Validity'(V5, [16]),

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_Name'(V6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External PKIX1Explicit-2009:SubjectPublicKeyInfo
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_SubjectPublicKeyInfo'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131073,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131074,V9}|TempTlv10] ->
    {decode_native_bit_string(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131075,V10}|TempTlv11] ->
    {'dec_TBSCertificate_extensions'(V10, [16]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,
Tlv12 = skip_ExtensionAdditions(Tlv11, []),

case Tlv12 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv12}}}) % extra fields not allowed
end,
Res1 = {'TBSCertificate',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.
'dec_TBSCertificate_signature'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'TBSCertificate_signature',Term1,Term2},
Res1.
'dec_TBSCertificate_extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TBSCertificate_extensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_TBSCertificate_extensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  Version
%%================================
enc_Version(Val) ->
    enc_Version(Val, [<<2>>]).

enc_Version(Val, TagIn) ->
encode_integer(Val, [{v1,0},{v2,1},{v3,2}], TagIn).


dec_Version(Tlv) ->
   dec_Version(Tlv, [2]).

dec_Version(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
.



%%================================
%%  CertificateSerialNumber
%%================================
enc_CertificateSerialNumber(Val) ->
    enc_CertificateSerialNumber(Val, [<<2>>]).

enc_CertificateSerialNumber(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_CertificateSerialNumber(Tlv) ->
   dec_CertificateSerialNumber(Tlv, [2]).

dec_CertificateSerialNumber(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  Validity
%%================================
enc_Validity(Val) ->
    enc_Validity(Val, [<<48>>]).

enc_Validity(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Time'(Cindex1, []),

%%-------------------------------------------------
%% attribute notAfter(2)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Time'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Validity(Tlv) ->
   dec_Validity(Tlv, [16]).

dec_Validity(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBefore(1)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Time'(V1, []),

%%-------------------------------------------------
%% attribute notAfter(2)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Time'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Validity',Term1,Term2},
Res1.


%%================================
%%  Time
%%================================
enc_Time(Val) ->
    enc_Time(Val, []).

enc_Time(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      utcTime ->
         encode_restricted_string(element(2,Val), [<<23>>]);
      generalTime ->
         encode_restricted_string(element(2,Val), [<<24>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Time(Tlv) ->
   dec_Time(Tlv, []).

dec_Time(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'utcTime'
    {23, V1} -> 
        {utcTime, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'generalTime'
    {24, V1} -> 
        {generalTime, begin
binary_to_list(decode_restricted_string(V1, []))
end
};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  UniqueIdentifier
%%================================
enc_UniqueIdentifier(Val) ->
    enc_UniqueIdentifier(Val, [<<3>>]).

enc_UniqueIdentifier(Val, TagIn) ->
encode_unnamed_bit_string(Val, TagIn).


dec_UniqueIdentifier(Tlv) ->
   dec_UniqueIdentifier(Tlv, [3]).

dec_UniqueIdentifier(Tlv, TagIn) ->
decode_native_bit_string(Tlv, TagIn).



%%================================
%%  SubjectPublicKeyInfo
%%================================
enc_SubjectPublicKeyInfo(Val) ->
    enc_SubjectPublicKeyInfo(Val, [<<48>>]).

enc_SubjectPublicKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_SubjectPublicKeyInfo_algorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SubjectPublicKeyInfo_algorithm
%%================================
enc_SubjectPublicKeyInfo_algorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SubjectPublicKeyInfo(Tlv) ->
   dec_SubjectPublicKeyInfo(Tlv, [16]).

dec_SubjectPublicKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_SubjectPublicKeyInfo_algorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SubjectPublicKeyInfo',Term1,Term2},
Res1.
'dec_SubjectPublicKeyInfo_algorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_internal_object_set_argument_6'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SubjectPublicKeyInfo_algorithm',Term1,Term2},
Res1.


%%================================
%%  CertificateList
%%================================
enc_CertificateList(Val) ->
    enc_CertificateList(Val, [<<48>>]).

enc_CertificateList(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIX1Explicit-2009:TBSCertList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertList'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertificateList_algorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificateList_algorithmIdentifier
%%================================
enc_CertificateList_algorithmIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_SignatureAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertificateList(Tlv) ->
   dec_CertificateList(Tlv, [16]).

dec_CertificateList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIX1Explicit-2009:TBSCertList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertList'(V1, [16]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificateList_algorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertificateList',Term1,Term2,Term3},
Res1.
'dec_CertificateList_algorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_SignatureAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificateList_algorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  TBSCertList
%%================================
enc_TBSCertList(Val) ->
    enc_TBSCertList(Val, [<<48>>]).

enc_TBSCertList(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>])
       end,

%%-------------------------------------------------
%% attribute signature(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_TBSCertList_signature'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_Name'(Cindex3, []),

%%-------------------------------------------------
%% attribute thisUpdate(4)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Time'(Cindex4, []),

%%-------------------------------------------------
%% attribute nextUpdate(5)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Time'(Cindex5, [])
       end,

%%-------------------------------------------------
%% attribute revokedCertificates(6) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSCertList_revokedCertificates'(Cindex6, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute crlExtensions(7) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSCertList_crlExtensions'(Cindex7, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertList_signature
%%================================
enc_TBSCertList_signature(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_internal_object_set_argument_11'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertList_revokedCertificates
%%================================
enc_TBSCertList_revokedCertificates(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSCertList_revokedCertificates_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSCertList_revokedCertificates_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_SEQOF'(H, [<<48>>]),
   'enc_TBSCertList_revokedCertificates_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSCertList_revokedCertificates_SEQOF
%%================================
enc_TBSCertList_revokedCertificates_SEQOF(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute userCertificate(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute revocationDate(2)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Time'(Cindex2, []),

%%-------------------------------------------------
%% attribute crlEntryExtensions(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions
%%================================
enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_Extension'(H, [<<48>>]),
   'enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_Extension
%%================================
enc_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertList_crlExtensions
%%================================
enc_TBSCertList_crlExtensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSCertList_crlExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSCertList_crlExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSCertList_crlExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSCertList_crlExtensions_Extension'(H, [<<48>>]),
   'enc_TBSCertList_crlExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSCertList_crlExtensions_Extension
%%================================
enc_TBSCertList_crlExtensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TBSCertList(Tlv) ->
   dec_TBSCertList(Tlv, [16]).

dec_TBSCertList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute signature(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_TBSCertList_signature'(V2, [16]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_Name'(V3, []),

%%-------------------------------------------------
%% attribute thisUpdate(4)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Time'(V4, []),

%%-------------------------------------------------
%% attribute nextUpdate(5)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[V5 = {23,_}|TempTlv6] ->
    {'dec_Time'(V5, []), TempTlv6};
[V5 = {24,_}|TempTlv6] ->
    {'dec_Time'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute revokedCertificates(6) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{16,V6}|TempTlv7] ->
    {'dec_TBSCertList_revokedCertificates'(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute crlExtensions(7) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131072,V7}|TempTlv8] ->
    {'dec_TBSCertList_crlExtensions'(V7, [16]), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,
Tlv9 = skip_ExtensionAdditions(Tlv8, []),

case Tlv9 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv9}}}) % extra fields not allowed
end,
Res1 = {'TBSCertList',Term1,Term2,Term3,Term4,Term5,Term6,Term7},
Res1.
'dec_TBSCertList_signature'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_internal_object_set_argument_11'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'TBSCertList_signature',Term1,Term2},
Res1.
'dec_TBSCertList_revokedCertificates'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TBSCertList_revokedCertificates_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_TBSCertList_revokedCertificates_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute userCertificate(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute revocationDate(2)   External PKIX1Explicit-2009:Time
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Time'(V2, []),

%%-------------------------------------------------
%% attribute crlEntryExtensions(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,
Tlv5 = skip_ExtensionAdditions(Tlv4, []),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'TBSCertList_revokedCertificates_SEQOF',Term1,Term2,Term3},
Res1.
'dec_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_TBSCertList_revokedCertificates_SEQOF_crlEntryExtensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.
'dec_TBSCertList_crlExtensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TBSCertList_crlExtensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_TBSCertList_crlExtensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  at-x520StateOrProvinceName_DirectoryString
%%================================
'enc_at-x520StateOrProvinceName_DirectoryString'(Val) ->
    'enc_at-x520StateOrProvinceName_DirectoryString'(Val, []).

'enc_at-x520StateOrProvinceName_DirectoryString'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_at-x520StateOrProvinceName_DirectoryString'(Tlv) ->
   'dec_at-x520StateOrProvinceName_DirectoryString'(Tlv, []).

'dec_at-x520StateOrProvinceName_DirectoryString'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 128 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 128 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RelativeDistinguishedName_DirectoryString
%%================================
enc_RelativeDistinguishedName_DirectoryString(Val) ->
    enc_RelativeDistinguishedName_DirectoryString(Val, []).

enc_RelativeDistinguishedName_DirectoryString(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_RelativeDistinguishedName_DirectoryString(Tlv) ->
   dec_RelativeDistinguishedName_DirectoryString(Tlv, []).

dec_RelativeDistinguishedName_DirectoryString(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 128 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 128 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  at-x520Title_DirectoryString
%%================================
'enc_at-x520Title_DirectoryString'(Val) ->
    'enc_at-x520Title_DirectoryString'(Val, []).

'enc_at-x520Title_DirectoryString'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_at-x520Title_DirectoryString'(Tlv) ->
   'dec_at-x520Title_DirectoryString'(Tlv, []).

'dec_at-x520Title_DirectoryString'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 64 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 64 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  at-x520Pseudonym_DirectoryString
%%================================
'enc_at-x520Pseudonym_DirectoryString'(Val) ->
    'enc_at-x520Pseudonym_DirectoryString'(Val, []).

'enc_at-x520Pseudonym_DirectoryString'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_at-x520Pseudonym_DirectoryString'(Tlv) ->
   'dec_at-x520Pseudonym_DirectoryString'(Tlv, []).

'dec_at-x520Pseudonym_DirectoryString'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 128 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 128 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 128 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  at-x520OrganizationalUnitName_DirectoryString
%%================================
'enc_at-x520OrganizationalUnitName_DirectoryString'(Val) ->
    'enc_at-x520OrganizationalUnitName_DirectoryString'(Val, []).

'enc_at-x520OrganizationalUnitName_DirectoryString'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_at-x520OrganizationalUnitName_DirectoryString'(Tlv) ->
   'dec_at-x520OrganizationalUnitName_DirectoryString'(Tlv, []).

'dec_at-x520OrganizationalUnitName_DirectoryString'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 64 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 64 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  at-x520OrganizationName_DirectoryString
%%================================
'enc_at-x520OrganizationName_DirectoryString'(Val) ->
    'enc_at-x520OrganizationName_DirectoryString'(Val, []).

'enc_at-x520OrganizationName_DirectoryString'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_at-x520OrganizationName_DirectoryString'(Tlv) ->
   'dec_at-x520OrganizationName_DirectoryString'(Tlv, []).

'dec_at-x520OrganizationName_DirectoryString'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 64 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 64 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'id-pkix'() ->
{1,3,6,1,5,5,7}.

'id-pe'() ->
{1,3,6,1,5,5,7,1}.

'id-qt'() ->
{1,3,6,1,5,5,7,2}.

'id-kp'() ->
{1,3,6,1,5,5,7,3}.

'id-ad'() ->
{1,3,6,1,5,5,7,48}.

'id-qt-cps'() ->
{1,3,6,1,5,5,7,2,1}.

'id-qt-unotice'() ->
{1,3,6,1,5,5,7,2,2}.

'id-ad-ocsp'() ->
{1,3,6,1,5,5,7,48,1}.

'id-ad-caIssuers'() ->
{1,3,6,1,5,5,7,48,2}.

'id-ad-timeStamping'() ->
{1,3,6,1,5,5,7,48,3}.

'id-ad-caRepository'() ->
{1,3,6,1,5,5,7,48,5}.

'id-at'() ->
{2,5,4}.

'id-at-name'() ->
{2,5,4,41}.

'id-at-surname'() ->
{2,5,4,4}.

'id-at-givenName'() ->
{2,5,4,42}.

'id-at-initials'() ->
{2,5,4,43}.

'id-at-generationQualifier'() ->
{2,5,4,44}.

'id-at-commonName'() ->
{2,5,4,3}.

'id-at-localityName'() ->
{2,5,4,7}.

'id-at-stateOrProvinceName'() ->
{2,5,4,8}.

'id-at-organizationName'() ->
{2,5,4,10}.

'id-at-organizationalUnitName'() ->
{2,5,4,11}.

'id-at-title'() ->
{2,5,4,12}.

'id-at-dnQualifier'() ->
{2,5,4,46}.

'id-at-countryName'() ->
{2,5,4,6}.

'id-at-serialNumber'() ->
{2,5,4,5}.

'id-at-pseudonym'() ->
{2,5,4,65}.

'id-domainComponent'() ->
{0,9,2342,19200300,100,1,25}.

'pkcs-9'() ->
{1,2,840,113549,1,9}.

'id-emailAddress'() ->
{1,2,840,113549,1,9,1}.

'ub-state-name'() ->
128.

'ub-organization-name'() ->
64.

'ub-organizational-unit-name'() ->
64.

'ub-title'() ->
64.

'ub-serial-number'() ->
64.

'ub-pseudonym'() ->
128.

'ub-emailaddress-length'() ->
255.

'ub-locality-name'() ->
128.

'ub-common-name'() ->
64.

'ub-name'() ->
32768.




%%================================
%%  at-name
%%================================
'enc_at-name'('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []);
'enc_at-name'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []);
'dec_at-name'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  at-surname
%%================================
'enc_at-surname'('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []);
'enc_at-surname'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-surname'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []);
'dec_at-surname'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-givenName
%%================================
'enc_at-givenName'('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []);
'enc_at-givenName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-givenName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []);
'dec_at-givenName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-initials
%%================================
'enc_at-initials'('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []);
'enc_at-initials'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-initials'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []);
'dec_at-initials'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-generationQualifier
%%================================
'enc_at-generationQualifier'('Type', Val, _RestPrimFieldName) ->
   enc_X520name(Val, []);
'enc_at-generationQualifier'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-generationQualifier'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520name(Tlv, []);
'dec_at-generationQualifier'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520CommonName
%%================================
'enc_at-x520CommonName'('Type', Val, _RestPrimFieldName) ->
   enc_X520CommonName(Val, []);
'enc_at-x520CommonName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520CommonName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520CommonName(Tlv, []);
'dec_at-x520CommonName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520LocalityName
%%================================
'enc_at-x520LocalityName'('Type', Val, _RestPrimFieldName) ->
   enc_X520LocalityName(Val, []);
'enc_at-x520LocalityName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520LocalityName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_X520LocalityName(Tlv, []);
'dec_at-x520LocalityName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520StateOrProvinceName
%%================================
'enc_at-x520StateOrProvinceName'('Type', Val, _RestPrimFieldName) ->
   'enc_at-x520StateOrProvinceName_DirectoryString'(Val,[]);
'enc_at-x520StateOrProvinceName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520StateOrProvinceName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_at-x520StateOrProvinceName_DirectoryString'(Tlv,[]);
'dec_at-x520StateOrProvinceName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520OrganizationName
%%================================
'enc_at-x520OrganizationName'('Type', Val, _RestPrimFieldName) ->
   'enc_at-x520OrganizationName_DirectoryString'(Val,[]);
'enc_at-x520OrganizationName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520OrganizationName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_at-x520OrganizationName_DirectoryString'(Tlv,[]);
'dec_at-x520OrganizationName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520OrganizationalUnitName
%%================================
'enc_at-x520OrganizationalUnitName'('Type', Val, _RestPrimFieldName) ->
   'enc_at-x520OrganizationalUnitName_DirectoryString'(Val,[]);
'enc_at-x520OrganizationalUnitName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520OrganizationalUnitName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_at-x520OrganizationalUnitName_DirectoryString'(Tlv,[]);
'dec_at-x520OrganizationalUnitName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520Title
%%================================
'enc_at-x520Title'('Type', Val, _RestPrimFieldName) ->
   'enc_at-x520Title_DirectoryString'(Val,[]);
'enc_at-x520Title'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520Title'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_at-x520Title_DirectoryString'(Tlv,[]);
'dec_at-x520Title'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520dnQualifier
%%================================
'enc_at-x520dnQualifier'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
'enc_at-x520dnQualifier'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520dnQualifier'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [19]))
end
;
'dec_at-x520dnQualifier'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520countryName
%%================================
'enc_at-x520countryName'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
'enc_at-x520countryName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520countryName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [19]),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end;
'dec_at-x520countryName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520SerialNumber
%%================================
'enc_at-x520SerialNumber'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<19>>]);
'enc_at-x520SerialNumber'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520SerialNumber'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [19]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end;
'dec_at-x520SerialNumber'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-x520Pseudonym
%%================================
'enc_at-x520Pseudonym'('Type', Val, _RestPrimFieldName) ->
   'enc_at-x520Pseudonym_DirectoryString'(Val,[]);
'enc_at-x520Pseudonym'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-x520Pseudonym'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_at-x520Pseudonym_DirectoryString'(Tlv,[]);
'dec_at-x520Pseudonym'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-domainComponent
%%================================
'enc_at-domainComponent'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<22>>]);
'enc_at-domainComponent'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-domainComponent'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [22]))
end
;
'dec_at-domainComponent'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  at-emailAddress
%%================================
'enc_at-emailAddress'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<22>>]);
'enc_at-emailAddress'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-emailAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_restricted_string(Tlv, [22]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 255 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end;
'dec_at-emailAddress'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  SupportedAttributes
%%================================
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,3} ->
    fun 'enc_at-x520CommonName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,4} ->
    fun 'enc_at-surname'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,5} ->
    fun 'enc_at-x520SerialNumber'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,6} ->
    fun 'enc_at-x520countryName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,7} ->
    fun 'enc_at-x520LocalityName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,8} ->
    fun 'enc_at-x520StateOrProvinceName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,10} ->
    fun 'enc_at-x520OrganizationName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,11} ->
    fun 'enc_at-x520OrganizationalUnitName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,12} ->
    fun 'enc_at-x520Title'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,41} ->
    fun 'enc_at-name'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,42} ->
    fun 'enc_at-givenName'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,43} ->
    fun 'enc_at-initials'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,44} ->
    fun 'enc_at-generationQualifier'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,46} ->
    fun 'enc_at-x520dnQualifier'/3;
getenc_SupportedAttributes(Id) when Id =:= {2,5,4,65} ->
    fun 'enc_at-x520Pseudonym'/3;
getenc_SupportedAttributes(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
    fun 'enc_at-domainComponent'/3;
getenc_SupportedAttributes(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'enc_at-emailAddress'/3;
getenc_SupportedAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedAttributes(Id) when Id =:= {2,5,4,3} ->
    fun 'dec_at-x520CommonName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,4} ->
    fun 'dec_at-surname'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,5} ->
    fun 'dec_at-x520SerialNumber'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,6} ->
    fun 'dec_at-x520countryName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,7} ->
    fun 'dec_at-x520LocalityName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,8} ->
    fun 'dec_at-x520StateOrProvinceName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,10} ->
    fun 'dec_at-x520OrganizationName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,11} ->
    fun 'dec_at-x520OrganizationalUnitName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,12} ->
    fun 'dec_at-x520Title'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,41} ->
    fun 'dec_at-name'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,42} ->
    fun 'dec_at-givenName'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,43} ->
    fun 'dec_at-initials'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,44} ->
    fun 'dec_at-generationQualifier'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,46} ->
    fun 'dec_at-x520dnQualifier'/3;
getdec_SupportedAttributes(Id) when Id =:= {2,5,4,65} ->
    fun 'dec_at-x520Pseudonym'/3;
getdec_SupportedAttributes(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
    fun 'dec_at-domainComponent'/3;
getdec_SupportedAttributes(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'dec_at-emailAddress'/3;
getdec_SupportedAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgorithms
%%================================
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_SignatureAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_SignatureAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PublicKeyAlgorithms
%%================================
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,3,132,1,12} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ecDH'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,3,132,1,13} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ecMQV'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,10040,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dsa'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,10045,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ec'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dh'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-rsa'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,7} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_pk-rsaES-OAEP'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_pk-rsaSSA-PSS'(T,V,O) end;
getenc_PublicKeyAlgorithms(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-kea'(T,V,O) end;
getenc_PublicKeyAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PublicKeyAlgorithms(Id) when Id =:= {1,3,132,1,12} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ecDH'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,3,132,1,13} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ecMQV'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,10040,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dsa'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,10045,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ec'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dh'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-rsa'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,7} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_pk-rsaES-OAEP'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_pk-rsaSSA-PSS'(T,V,O) end;
getdec_PublicKeyAlgorithms(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-kea'(T,V,O) end;
getdec_PublicKeyAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,132,1,12} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ecDH'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,132,1,13} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ecMQV'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,2,840,10040,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dsa'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,2,840,10045,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ec'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dh'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-rsa'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,2,840,113549,1,1,7} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_pk-rsaES-OAEP'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_pk-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-kea'(T,V,O) end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,132,1,12} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ecDH'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,132,1,13} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ecMQV'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,2,840,10040,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dsa'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,2,840,10045,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ec'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dh'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-rsa'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,2,840,113549,1,1,7} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_pk-rsaES-OAEP'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_pk-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-kea'(T,V,O) end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_1
%%================================
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,3} ->
    fun 'enc_at-x520CommonName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,4} ->
    fun 'enc_at-surname'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,5} ->
    fun 'enc_at-x520SerialNumber'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,6} ->
    fun 'enc_at-x520countryName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,7} ->
    fun 'enc_at-x520LocalityName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,8} ->
    fun 'enc_at-x520StateOrProvinceName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,10} ->
    fun 'enc_at-x520OrganizationName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,11} ->
    fun 'enc_at-x520OrganizationalUnitName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,12} ->
    fun 'enc_at-x520Title'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,41} ->
    fun 'enc_at-name'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,42} ->
    fun 'enc_at-givenName'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,43} ->
    fun 'enc_at-initials'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,44} ->
    fun 'enc_at-generationQualifier'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,46} ->
    fun 'enc_at-x520dnQualifier'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {2,5,4,65} ->
    fun 'enc_at-x520Pseudonym'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
    fun 'enc_at-domainComponent'/3;
getenc_internal_object_set_argument_1(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'enc_at-emailAddress'/3;
getenc_internal_object_set_argument_1(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,3} ->
    fun 'dec_at-x520CommonName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,4} ->
    fun 'dec_at-surname'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,5} ->
    fun 'dec_at-x520SerialNumber'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,6} ->
    fun 'dec_at-x520countryName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,7} ->
    fun 'dec_at-x520LocalityName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,8} ->
    fun 'dec_at-x520StateOrProvinceName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,10} ->
    fun 'dec_at-x520OrganizationName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,11} ->
    fun 'dec_at-x520OrganizationalUnitName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,12} ->
    fun 'dec_at-x520Title'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,41} ->
    fun 'dec_at-name'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,42} ->
    fun 'dec_at-givenName'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,43} ->
    fun 'dec_at-initials'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,44} ->
    fun 'dec_at-generationQualifier'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,46} ->
    fun 'dec_at-x520dnQualifier'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {2,5,4,65} ->
    fun 'dec_at-x520Pseudonym'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
    fun 'dec_at-domainComponent'/3;
getdec_internal_object_set_argument_1(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'dec_at-emailAddress'/3;
getdec_internal_object_set_argument_1(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_15
%%================================
getenc_internal_object_set_argument_15(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_15(Id) when Id =:= {2,5,29,20} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLNumber'(T,V,O) end;
getenc_internal_object_set_argument_15(Id) when Id =:= {2,5,29,27} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-DeltaCRLIndicator'(T,V,O) end;
getenc_internal_object_set_argument_15(Id) when Id =:= {2,5,29,28} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuingDistributionPoint'(T,V,O) end;
getenc_internal_object_set_argument_15(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_15(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_15(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_15(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_15(Id) when Id =:= {2,5,29,20} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLNumber'(T,V,O) end;
getdec_internal_object_set_argument_15(Id) when Id =:= {2,5,29,27} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-DeltaCRLIndicator'(T,V,O) end;
getdec_internal_object_set_argument_15(Id) when Id =:= {2,5,29,28} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuingDistributionPoint'(T,V,O) end;
getdec_internal_object_set_argument_15(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_15(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_15(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_14
%%================================
getenc_internal_object_set_argument_14(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_14(Id) when Id =:= {2,5,29,20} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLNumber'(T,V,O) end;
getenc_internal_object_set_argument_14(Id) when Id =:= {2,5,29,27} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-DeltaCRLIndicator'(T,V,O) end;
getenc_internal_object_set_argument_14(Id) when Id =:= {2,5,29,28} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuingDistributionPoint'(T,V,O) end;
getenc_internal_object_set_argument_14(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_14(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_14(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_14(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_14(Id) when Id =:= {2,5,29,20} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLNumber'(T,V,O) end;
getdec_internal_object_set_argument_14(Id) when Id =:= {2,5,29,27} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-DeltaCRLIndicator'(T,V,O) end;
getdec_internal_object_set_argument_14(Id) when Id =:= {2,5,29,28} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuingDistributionPoint'(T,V,O) end;
getdec_internal_object_set_argument_14(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_14(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_14(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_13
%%================================
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLReason'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-HoldInstructionCode'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InvalidityDate'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificateIssuer'(T,V,O) end;
getenc_internal_object_set_argument_13(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLReason'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-HoldInstructionCode'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InvalidityDate'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificateIssuer'(T,V,O) end;
getdec_internal_object_set_argument_13(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_12
%%================================
getenc_internal_object_set_argument_12(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLReason'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-HoldInstructionCode'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InvalidityDate'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificateIssuer'(T,V,O) end;
getenc_internal_object_set_argument_12(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_12(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLReason'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-HoldInstructionCode'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InvalidityDate'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificateIssuer'(T,V,O) end;
getdec_internal_object_set_argument_12(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_11
%%================================
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_11(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_11(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_11(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.




'dec-inc-CertificateList'(Tlv) ->
   'dec-inc-CertificateList'(Tlv, [16]).

'dec-inc-CertificateList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute toBeSigned(1)   External PKIX1Explicit-2009:TBSCertList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = {'CertificateList_toBeSigned',V1},

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificateList_algorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertificateList',Term1,Term2,Term3},
Res1.
decode_TBSCertList_exclusive(Bytes) ->
  decode_partial_incomplete('CertificateList', Bytes, [mandatory,{undecoded,[16]}]).
decode_inc_disp('CertificateList_toBeSigned',Data) ->
  'dec_TBSCertList'(Data,[16]).

%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    _ = decode_primitive_incomplete([{undecoded,0},{alt_parts,0}], element(6, Arg)),
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try check_int(Value, 0, [{v1,0},{v2,1},{v3,2}]) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= false ->
true;
is_default_2(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_int(Value, Value, _) when is_integer(Value) ->
    true;
check_int(Value, DefValue, NNL) when is_atom(Value) ->
    case lists:keyfind(Value, 1, NNL) of
        {_, DefValue} ->
            true;
        _ ->
            throw(false)
    end;
check_int(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_BMP_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_BMP_string(binary_to_list(Bin)).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_constr_indef_incomplete(_TagMatch, <<0,0,Rest/binary>>, Acc) ->
    {lists:reverse(Acc), Rest};
decode_constr_indef_incomplete([Tag | RestTags], Bin, Acc) ->
    case decode_primitive_incomplete([Tag], Bin) of
        {Tlv, Rest} ->
            decode_constr_indef_incomplete(RestTags, Rest, [Tlv | Acc]);
        asn1_NOVALUE ->
            decode_constr_indef_incomplete(RestTags, Bin, Acc)
    end.

decode_constructed(Bin) when byte_size(Bin) =:= 0 ->
    [];
decode_constructed(Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed(Rest)].

decode_constructed_incomplete([Tags = [Ts]], Bin) when is_list(Ts) ->
    decode_constructed_incomplete(Tags, Bin);
decode_constructed_incomplete(_TagMatch, <<>>) ->
    [];
decode_constructed_incomplete([mandatory | RestTag], Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed_incomplete(RestTag, Rest)];
decode_constructed_incomplete([{Alt, _} | _] = Directives, Bin)
    when Alt =:= alt_undecoded; Alt =:= alt; Alt =:= alt_parts ->
    {_Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    case incomplete_choice_alt(TagNo, Directives) of
        {alt_undecoded, _} ->
            LenA = byte_size(Bin) - byte_size(Rest),
            <<A:LenA/binary,Rest/binary>> = Bin,
            A;
        {alt, InnerDirectives} ->
            {Tlv, Rest} =
                decode_primitive_incomplete(InnerDirectives, V),
            {TagNo, Tlv};
        {alt_parts, _} ->
            [{TagNo, decode_parts_incomplete(V)}];
        no_match ->
            {Tlv, _} = decode_primitive(Bin),
            Tlv
    end;
decode_constructed_incomplete([TagNo | RestTag], Bin) ->
    case decode_primitive_incomplete([TagNo], Bin) of
        {Tlv, Rest} ->
            [Tlv | decode_constructed_incomplete(RestTag, Rest)];
        asn1_NOVALUE ->
            decode_constructed_incomplete(RestTag, Bin)
    end;
decode_constructed_incomplete([], Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed_incomplete([], Rest)].

decode_constructed_indefinite(<<0,0,Rest/binary>>, Acc) ->
    {lists:reverse(Acc), Rest};
decode_constructed_indefinite(Bin, Acc) ->
    {Tlv, Rest} = decode_primitive(Bin),
    decode_constructed_indefinite(Rest, [Tlv | Acc]).

decode_incomplete2(_Form = 2, TagNo, V, TagMatch, _) ->
    {Vlist, Rest2} = decode_constr_indef_incomplete(TagMatch, V, []),
    {{TagNo, Vlist}, Rest2};
decode_incomplete2(1, TagNo, V, [TagMatch], Rest) when is_list(TagMatch) ->
    {{TagNo, decode_constructed_incomplete(TagMatch, V)}, Rest};
decode_incomplete2(1, TagNo, V, TagMatch, Rest) ->
    {{TagNo, decode_constructed_incomplete(TagMatch, V)}, Rest};
decode_incomplete2(0, TagNo, V, _TagMatch, Rest) ->
    {{TagNo, V}, Rest}.

decode_incomplete_bin(Bin) ->
    {ok, Rest} = skip_tag(Bin),
    {ok, Rest2} = skip_length_and_value(Rest),
    IncLen = byte_size(Bin) - byte_size(Rest2),
    <<IncBin:IncLen/binary,Ret/binary>> = Bin,
    {IncBin, Ret}.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_length(<<1:1,0:7,T/binary>>) ->
    {indefinite, T};
decode_length(<<0:1,Length:7,T/binary>>) ->
    {Length, T};
decode_length(<<1:1,LL:7,Length:LL/unit:8,T/binary>>) ->
    {Length, T}.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_parts_incomplete(<<>>) ->
    [];
decode_parts_incomplete(Bin) ->
    {ok, Rest} = skip_tag(Bin),
    {ok, Rest2} = skip_length_and_value(Rest),
    LenPart = byte_size(Bin) - byte_size(Rest2),
    <<Part:LenPart/binary,RestBin/binary>> = Bin,
    [Part | decode_parts_incomplete(RestBin)].

decode_primitive(Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    case Form of
        1 ->
            {{TagNo, decode_constructed(V)}, Rest};
        0 ->
            {{TagNo, V}, Rest};
        2 ->
            {Vlist, Rest2} = decode_constructed_indefinite(V, []),
            {{TagNo, Vlist}, Rest2}
    end.

decode_primitive_incomplete([{default, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, [], Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{default, TagNo, Directives}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{default_undecoded, [Tag | _]}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, Tag, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, [], Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt, TagNo, Directives}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt_undecoded, [Tag | _]}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, Tag, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{alt_undecoded, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, TagNo, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, V}, Rest};
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt, TagNo, Directives} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt_parts, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, V}, Rest};
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{alt_parts, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, decode_parts_incomplete(V)}, Rest};
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{undecoded, _TagNo} | _RestTag], Bin) ->
    decode_incomplete_bin(Bin);
decode_primitive_incomplete([{parts, [TagNo | MoreTags]} | _RestTag],
                            Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            case MoreTags of
                [] ->
                    {{TagNo, decode_parts_incomplete(V)}, Rest};
                [TagNo2] ->
                    {_, TagNo2, V2, <<>>} = decode_tag_and_length(V),
                    {{TagNo, {TagNo2, decode_parts_incomplete(V2)}},
                     Rest}
            end;
        Err ->
            {error, {asn1, "tag failure", TagNo, Err}}
    end;
decode_primitive_incomplete([mandatory | RestTag], Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    decode_incomplete2(Form, TagNo, V, RestTag, Rest);
decode_primitive_incomplete([{mandatory, Directives}], Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    decode_incomplete2(Form, TagNo, V, Directives, Rest);
decode_primitive_incomplete([], Bin) ->
    decode_primitive(Bin).

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

decode_tag(<<0:1,PartialTag:7,Buffer/binary>>, TagAck) ->
    TagNo = TagAck bsl 7 bor PartialTag,
    {TagNo, Buffer};
decode_tag(<<_:1,PartialTag:7,Buffer/binary>>, TagAck) ->
    TagAck1 = TagAck bsl 7 bor PartialTag,
    decode_tag(Buffer, TagAck1).

decode_tag_and_length(<<Class:2,
                        Form:1,
                        TagNo:5,
                        0:1,
                        Length:7,
                        V:Length/binary,
                        RestBuffer/binary>>)
    when TagNo < 31 ->
    {Form, Class bsl 16 bor TagNo, V, RestBuffer};
decode_tag_and_length(<<Class:2,1:1,TagNo:5,1:1,0:7,T/binary>>)
    when TagNo < 31 ->
    {2, Class bsl 16 + TagNo, T, <<>>};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        TagNo:5,
                        1:1,
                        LL:7,
                        Length:LL/unit:8,
                        V:Length/binary,
                        T/binary>>)
    when TagNo < 31 ->
    {Form, Class bsl 16 bor TagNo, V, T};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        0:1,
                        TagNo:7,
                        0:1,
                        Length:7,
                        V:Length/binary,
                        RestBuffer/binary>>) ->
    {Form, Class bsl 16 bor TagNo, V, RestBuffer};
decode_tag_and_length(<<Class:2,1:1,31:5,0:1,TagNo:7,1:1,0:7,T/binary>>) ->
    {2, Class bsl 16 bor TagNo, T, <<>>};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        0:1,
                        TagNo:7,
                        1:1,
                        LL:7,
                        Length:LL/unit:8,
                        V:Length/binary,
                        T/binary>>) ->
    {Form, Class bsl 16 bor TagNo, V, T};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        1:1,
                        TagPart1:7,
                        0:1,
                        TagPartLast,
                        Buffer/binary>>) ->
    TagNo = TagPart1 bsl 7 bor TagPartLast,
    {Length, RestBuffer} = decode_length(Buffer),
    <<V:Length/binary,RestBuffer2/binary>> = RestBuffer,
    {Form, Class bsl 16 bor TagNo, V, RestBuffer2};
decode_tag_and_length(<<Class:2,Form:1,31:5,Buffer/binary>>) ->
    {TagNo, Buffer1} = decode_tag(Buffer, 0),
    {Length, RestBuffer} = decode_length(Buffer1),
    <<V:Length/binary,RestBuffer2/binary>> = RestBuffer,
    {Form, Class bsl 16 bor TagNo, V, RestBuffer2}.

decode_universal_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_universal_string(binary_to_list(Bin)).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_BMP_string(BMPString, TagIn) ->
    OctetList = mk_BMP_list(BMPString),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_universal_string(Universal, TagIn) ->
    OctetList = mk_uni_list(Universal),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

incomplete_choice_alt(TagNo, [{Alt, TagNo} | Directives]) ->
    {Alt, Directives};
incomplete_choice_alt(TagNo, [D]) when is_list(D) ->
    incomplete_choice_alt(TagNo, D);
incomplete_choice_alt(TagNo, [_H | Directives]) ->
    incomplete_choice_alt(TagNo, Directives);
incomplete_choice_alt(_, []) ->
    no_match.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_BMP_list(In) ->
    mk_BMP_list(In, []).

mk_BMP_list([], List) ->
    lists:reverse(List);
mk_BMP_list([{0, 0, C, D} | T], List) ->
    mk_BMP_list(T, [D, C | List]);
mk_BMP_list([H | T], List) ->
    mk_BMP_list(T, [H, 0 | List]).

mk_BMP_string(In) ->
    mk_BMP_string(In, []).

mk_BMP_string([], US) ->
    lists:reverse(US);
mk_BMP_string([0, B | T], US) ->
    mk_BMP_string(T, [B | US]);
mk_BMP_string([C, D | T], US) ->
    mk_BMP_string(T, [{0, 0, C, D} | US]).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

mk_uni_list(In) ->
    mk_uni_list(In, []).

mk_uni_list([], List) ->
    lists:reverse(List);
mk_uni_list([{A, B, C, D} | T], List) ->
    mk_uni_list(T, [D, C, B, A | List]);
mk_uni_list([H | T], List) ->
    mk_uni_list(T, [H, 0, 0, 0 | List]).

mk_universal_string(In) ->
    mk_universal_string(In, []).

mk_universal_string([], Acc) ->
    lists:reverse(Acc);
mk_universal_string([0, 0, 0, D | T], Acc) ->
    mk_universal_string(T, [D | Acc]);
mk_universal_string([A, B, C, D | T], Acc) ->
    mk_universal_string(T, [{A, B, C, D} | Acc]).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.

skip_ExtensionAdditions([], _Tags) ->
    [];
skip_ExtensionAdditions([{Tag, _} | Rest] = TLV, Tags) ->
    case
        [ 
         X ||
             X = T <- Tags,
             T =:= Tag
        ]
    of
        [] ->
            skip_ExtensionAdditions(Rest, Tags);
        _ ->
            TLV
    end.

skip_indefinite_value(<<0,0,Rest/binary>>) ->
    {ok, Rest};
skip_indefinite_value(Binary) ->
    {ok, RestBinary} = skip_tag(Binary),
    {ok, RestBinary2} = skip_length_and_value(RestBinary),
    skip_indefinite_value(RestBinary2).

skip_length_and_value(Binary) ->
    case decode_length(Binary) of
        {indefinite, RestBinary} ->
            skip_indefinite_value(RestBinary);
        {Length, RestBinary} ->
            <<_:Length/unit:8,Rest/binary>> = RestBinary,
            {ok, Rest}
    end.

skip_long_tag(<<1:1,_:7,Rest/binary>>) ->
    skip_long_tag(Rest);
skip_long_tag(<<0:1,_:7,Rest/binary>>) ->
    {ok, Rest}.

skip_tag(<<_:3,31:5,Rest/binary>>) ->
    skip_long_tag(Rest);
skip_tag(<<_:3,_Tag:5,Rest/binary>>) ->
    {ok, Rest}.
