/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.Arrays;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.linked.ChildEnumeration;
import net.sf.saxon.tree.linked.CommentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ProcInstImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.Navigator;

public abstract class ParentNodeImpl
extends NodeImpl {
    private Object _children = null;
    private int sequence;

    @Override
    protected final long getSequenceNumber() {
        return this.getRawSequenceNumber() == -1 ? -1L : (long)this.getRawSequenceNumber() << 32;
    }

    protected final int getRawSequenceNumber() {
        return this.sequence;
    }

    protected final void setRawSequenceNumber(int seq) {
        this.sequence = seq;
    }

    protected final void setChildren(Object children) {
        this._children = children;
    }

    @Override
    public final boolean hasChildNodes() {
        return this._children != null;
    }

    public final int getNumberOfChildren() {
        if (this._children == null) {
            return 0;
        }
        if (this._children instanceof NodeImpl) {
            return 1;
        }
        return ((NodeInfo[])this._children).length;
    }

    protected final AxisIterator iterateChildren(NodeTest test) {
        if (this._children == null) {
            return EmptyIterator.ofNodes();
        }
        if (this._children instanceof NodeImpl) {
            NodeImpl child = (NodeImpl)this._children;
            if (test == null || test == AnyNodeTest.getInstance()) {
                return SingleNodeIterator.makeIterator(child);
            }
            return Navigator.filteredSingleton(child, test);
        }
        if (test == null || test == AnyNodeTest.getInstance()) {
            return new ArrayIterator.OfNodes((NodeInfo[])((NodeImpl[])this._children));
        }
        return new ChildEnumeration((NodeImpl)this, test);
    }

    @Override
    public final NodeImpl getFirstChild() {
        if (this._children == null) {
            return null;
        }
        if (this._children instanceof NodeImpl) {
            return (NodeImpl)this._children;
        }
        return ((NodeImpl[])this._children)[0];
    }

    @Override
    public final NodeImpl getLastChild() {
        if (this._children == null) {
            return null;
        }
        if (this._children instanceof NodeImpl) {
            return (NodeImpl)this._children;
        }
        NodeImpl[] n = (NodeImpl[])this._children;
        return n[n.length - 1];
    }

    protected final NodeImpl getNthChild(int n) {
        if (this._children == null) {
            return null;
        }
        if (this._children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this._children : null;
        }
        NodeImpl[] nodes = (NodeImpl[])this._children;
        if (n < 0 || n >= nodes.length) {
            return null;
        }
        return nodes[n];
    }

    protected void removeChild(NodeImpl child) {
        if (this._children == null) {
            return;
        }
        if (this._children == child) {
            this._children = null;
            return;
        }
        NodeImpl[] nodes = (NodeImpl[])this._children;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] != child) continue;
            if (nodes.length == 2) {
                this._children = nodes[1 - i];
                break;
            }
            NodeImpl[] n2 = new NodeImpl[nodes.length - 1];
            if (i > 0) {
                System.arraycopy(nodes, 0, n2, 0, i);
            }
            if (i < nodes.length - 1) {
                System.arraycopy(nodes, i + 1, n2, i, nodes.length - i - 1);
            }
            this._children = this.cleanUpChildren(n2);
            break;
        }
    }

    private NodeImpl[] cleanUpChildren(NodeImpl[] children) {
        boolean prevText = false;
        int j = 0;
        NodeImpl[] c2 = new NodeImpl[children.length];
        for (NodeImpl node : children) {
            if (node instanceof TextImpl) {
                if (prevText) {
                    TextImpl prev = (TextImpl)c2[j - 1];
                    prev.replaceStringValue(prev.getUnicodeStringValue().concat(node.getUnicodeStringValue()));
                    continue;
                }
                if (node.getUnicodeStringValue().isEmpty()) continue;
                prevText = true;
                node.setSiblingPosition(j);
                c2[j++] = node;
                continue;
            }
            node.setSiblingPosition(j);
            c2[j++] = node;
            prevText = false;
        }
        if (j == c2.length) {
            return c2;
        }
        return Arrays.copyOf(c2, j);
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        UnicodeBuilder sb = null;
        for (NodeImpl next = this.getFirstChild(); next != null; next = next.getNextInDocument(this)) {
            if (!(next instanceof TextImpl)) continue;
            if (sb == null) {
                sb = new UnicodeBuilder();
            }
            sb.accept(next.getUnicodeStringValue());
        }
        if (sb == null) {
            return EmptyUnicodeString.getInstance();
        }
        return sb.toUnicodeString();
    }

    protected synchronized void addChild(NodeImpl node, int index) {
        NodeImpl[] c;
        if (this._children == null) {
            c = new NodeImpl[10];
        } else if (this._children instanceof NodeImpl) {
            c = new NodeImpl[10];
            c[0] = (NodeImpl)this._children;
        } else {
            c = (NodeImpl[])this._children;
        }
        if (index >= c.length) {
            c = Arrays.copyOf(c, c.length * 2);
        }
        c[index] = node;
        node.setRawParent(this);
        node.setSiblingPosition(index);
        this._children = c;
    }

    @Override
    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
        if (atStart) {
            this.insertChildrenAt(source, 0, inherit);
        } else {
            this.insertChildrenAt(source, this.getNumberOfChildren(), inherit);
        }
    }

    protected synchronized void insertChildrenAt(NodeInfo[] source, int index, boolean inherit) {
        if (source.length == 0) {
            return;
        }
        NodeImpl[] source2 = this.adjustSuppliedNodeArray(source, inherit);
        if (this._children == null) {
            if (source2.length == 1) {
                this._children = source2[0];
                ((NodeImpl)this._children).setSiblingPosition(0);
            } else {
                this._children = this.cleanUpChildren(source2);
            }
        } else if (this._children instanceof NodeImpl) {
            int adjacent;
            int n = adjacent = index == 0 ? source2.length - 1 : 0;
            if (this._children instanceof TextImpl && source2[adjacent] instanceof TextImpl) {
                if (index == 0) {
                    source2[adjacent].replaceStringValue(source2[adjacent].getUnicodeStringValue().concat(((TextImpl)this._children).getUnicodeStringValue()));
                } else {
                    source2[adjacent].replaceStringValue(((TextImpl)this._children).getUnicodeStringValue().concat(source2[adjacent].getUnicodeStringValue()));
                }
                this._children = this.cleanUpChildren(source2);
            } else {
                NodeImpl[] n2 = new NodeImpl[source2.length + 1];
                if (index == 0) {
                    System.arraycopy(source2, 0, n2, 0, source2.length);
                    n2[source2.length] = (NodeImpl)this._children;
                } else {
                    n2[0] = (NodeImpl)this._children;
                    System.arraycopy(source2, 0, n2, 1, source2.length);
                }
                this._children = this.cleanUpChildren(n2);
            }
        } else {
            NodeImpl[] n0 = (NodeImpl[])this._children;
            NodeImpl[] n2 = new NodeImpl[n0.length + source2.length];
            System.arraycopy(n0, 0, n2, 0, index);
            System.arraycopy(source2, 0, n2, index, source2.length);
            System.arraycopy(n0, index, n2, index + source2.length, n0.length - index);
            this._children = this.cleanUpChildren(n2);
        }
    }

    private NodeImpl convertForeignNode(NodeInfo source) {
        if (!(source instanceof NodeImpl)) {
            int kind = source.getNodeKind();
            switch (kind) {
                case 3: {
                    return new TextImpl(source.getUnicodeStringValue());
                }
                case 8: {
                    return new CommentImpl(source.getUnicodeStringValue());
                }
                case 7: {
                    return new ProcInstImpl(source.getLocalPart(), source.getUnicodeStringValue());
                }
                case 1: {
                    LinkedTreeBuilder builder = null;
                    try {
                        builder = new LinkedTreeBuilder(this.getConfiguration().makePipelineConfiguration());
                        ((Builder)builder).open();
                        source.copy(builder, 2, Loc.NONE);
                        ((Builder)builder).close();
                    }
                    catch (XPathException e) {
                        throw new IllegalArgumentException("Failed to convert inserted element node to an instance of net.sf.saxon.om.tree.ElementImpl");
                    }
                    return (NodeImpl)((Builder)builder).getCurrentRoot();
                }
            }
            throw new IllegalArgumentException("Cannot insert a node unless it is an element, comment, text node, or processing instruction");
        }
        return (NodeImpl)source;
    }

    protected synchronized void replaceChildrenAt(NodeInfo[] source, int index, boolean inherit) {
        if (this._children == null) {
            return;
        }
        NodeImpl[] source2 = this.adjustSuppliedNodeArray(source, inherit);
        if (this._children instanceof NodeImpl) {
            if (source2.length == 0) {
                this._children = null;
            } else if (source2.length == 1) {
                this._children = source2[0];
            } else {
                NodeImpl[] n2 = new NodeImpl[source2.length];
                System.arraycopy(source2, 0, n2, 0, source.length);
                this._children = this.cleanUpChildren(n2);
            }
        } else {
            NodeImpl[] n0 = (NodeImpl[])this._children;
            NodeImpl[] n2 = new NodeImpl[n0.length + source2.length - 1];
            System.arraycopy(n0, 0, n2, 0, index);
            System.arraycopy(source2, 0, n2, index, source2.length);
            System.arraycopy(n0, index + 1, n2, index + source2.length, n0.length - index - 1);
            this._children = this.cleanUpChildren(n2);
        }
    }

    private NodeImpl[] adjustSuppliedNodeArray(NodeInfo[] source, boolean inherit) {
        NodeImpl[] source2 = new NodeImpl[source.length];
        for (int i = 0; i < source.length; ++i) {
            source2[i] = this.convertForeignNode(source[i]);
            NodeImpl child = source2[i];
            child.setRawParent(this);
            if (!(child instanceof ElementImpl)) continue;
            ((ElementImpl)child).fixupInsertedNamespaces(inherit);
        }
        return source2;
    }

    public synchronized void compact(int size) {
        if (size == 0) {
            this._children = null;
        } else if (size == 1) {
            if (this._children instanceof NodeImpl[]) {
                this._children = ((NodeImpl[])this._children)[0];
            }
        } else {
            this._children = Arrays.copyOf((NodeImpl[])this._children, size);
        }
    }
}

