/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr152.h"
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "eif_process.h"
#include <fcntl.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F168_3356
static void inline_F168_3356 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F168_3356
#endif
#ifndef INLINE_F168_3357
static void inline_F168_3357 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F168_3357
#endif
#ifndef INLINE_F168_3360
static void inline_F168_3360 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F168_3360
#endif
#ifndef INLINE_F168_3374
static void inline_F168_3374 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F168_3374
#endif
#ifndef INLINE_F168_3372
static void inline_F168_3372 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  _exit(127);
				}
	;
}
#define INLINE_F168_3372
#endif
#ifndef INLINE_F168_3371
static void inline_F168_3371 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F168_3371
#endif
#ifndef INLINE_F168_3367
static void inline_F168_3367 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F168_3367
#endif
#ifndef INLINE_F168_3373
static void inline_F168_3373 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F168_3373
#endif
#ifndef INLINE_F168_3368
static void inline_F168_3368 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F168_3368
#endif
#ifndef INLINE_F168_3370
static void inline_F168_3370 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F168_3370
#endif
#ifndef INLINE_F168_3375
static void inline_F168_3375 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F168_3375
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F168_3356 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 167, Current, 0, 2, 3440);
	inline_F168_3356 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F168_3357 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 167, Current, 0, 1, 3441);
	inline_F168_3357 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F168_3359 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 167, Current, 0, 0, 3443);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) F168_3364(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F168_3360 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("new_process_group", 167, Current, 0, 0, 3444);
	inline_F168_3360 ();
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.exec_process */
void F168_3361 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc5);
	RTLR(3,tr1);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTEAA("exec_process", 167, Current, 5, 4, 3445);
	RTGC;
	RTHOOK(1);
	loc2 = F620_5634(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	RTHOOK(3);
	loc4 = F168_3366(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(4);
	loc5 = RTLNS(eif_new_type(689, 0x00).id, 689, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F690_5860(RTCW(loc5), ((EIF_INTEGER_32) 0L));
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F620_5627(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F690_5874(RTCW(loc5), tr1);
		RTHOOK(8);
		tp1 = F690_5866(RTCW(loc5));
		tp1 = F168_3365(Current, tp1);
		inline_F168_3374(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), tp1);
		RTHOOK(9);
		loc1++;
	}
	RTHOOK(10);
	{
		/* INLINED CODE (ANY.default_pointer) */
		tp1 = (EIF_POINTER)  0;
		/* END INLINED CODE */
	}
	tp2 = tp1;
	inline_F168_3374(loc4, loc2, tp2);
	RTHOOK(11);
	loc5 = RTLNS(eif_new_type(689, 0x00).id, 689, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F690_5859(RTCW(loc5), arg1);
	RTHOOK(12);
	tp1 = F690_5866(RTCW(loc5));
	inline_F168_3372(tp1, loc4, arg4, arg3);
	RTHOOK(13);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F168_3364 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTEAA("unix_fork_process", 167, Current, 0, 0, 3448);
	RTHOOK(1);
	inline_F168_3371((EIF_INTEGER_32 *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F168_3365 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("str_dup", 167, Current, 0, 1, 3449);
	RTHOOK(1);
	inline_F168_3367(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F168_3366 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("unix_allocate_arg_memory", 167, Current, 0, 1, 3450);
	RTHOOK(1);
	inline_F168_3373(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F168_3367 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_str_dup", 167, Current, 0, 2, 3451);
	inline_F168_3367 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F168_3368 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 167, Current, 0, 2, 3452);
	inline_F168_3368 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F168_3370 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 167, Current, 0, 5, 3454);
	EIF_ENTER_C;
	inline_F168_3370 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F168_3371 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_fork_process", 167, Current, 0, 1, 3455);
	inline_F168_3371 ((EIF_INTEGER_32*) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F168_3372 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 167, Current, 0, 4, 3456);
	inline_F168_3372 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F168_3373 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_allocate_arg_memory", 167, Current, 0, 2, 3457);
	inline_F168_3373 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F168_3374 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 167, Current, 0, 3, 3458);
	inline_F168_3374 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F168_3375 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("attach_terminals", 167, Current, 0, 1, 3459);
	inline_F168_3375 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit152 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
