/*
 * Code for class I18N_UNIX_C_FUNCTIONS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i1129.h"
#include <eif_langinfo.h>
#include <iconv.h>
#include <locale.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F145_3005
static EIF_INTEGER_32 inline_F145_3005 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F145_3005
#endif
#ifndef INLINE_F145_3004
static EIF_POINTER inline_F145_3004 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F145_3004
#endif
#ifndef INLINE_F145_2999
static EIF_POINTER inline_F145_2999 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F145_2999
#endif
#ifndef INLINE_F145_3001
static EIF_POINTER inline_F145_3001 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F145_3001
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_UNIX_C_FUNCTIONS}.unix_set_locale */
void F145_2997 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTEAA("unix_set_locale", 144, Current, 3, 1, 3091);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(317, 0x00).id, 317, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F318_4799(RTCW(loc1), arg1);
	RTHOOK(2);
	ti4_1 = inline_F145_3005();
	tp1 = F318_4821(RTCW(loc1));
	loc2 = inline_F145_3004(ti4_1, tp1);
	RTHOOK(3);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(4);
		loc1 = RTLNS(eif_new_type(317, 0x00).id, 317, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F318_4803(RTCW(loc1), loc2);
		RTHOOK(5);
		tr1 = RTOSCF(3003,F145_3003, (Current));
		tr2 = F318_4813(RTCW(loc1));
		F224_3957(RTCW(tr1), tr2);
	} else {
		RTHOOK(6);
		tr1 = RTOSCF(3003,F145_3003, (Current));
		tr2 = RTMS_EX_H("POSIX",5,1331472728);
		F224_3957(RTCW(tr1), tr2);
	}
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info_managed */
EIF_REFERENCE F145_2998 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Result);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("unix_get_locale_info_managed", 144, Current, 0, 1, 3092);
	RTGC;
	RTHOOK(1);
	Result = RTLNS(eif_new_type(948, 0x00).id, 948, _OBJSIZ_0_1_0_1_0_1_1_0_);
	tp1 = inline_F145_2999(arg1);
	F949_7012(RTCW(Result), tp1, ((EIF_INTEGER_32) 0L));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info */
EIF_POINTER F145_2999 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_get_locale_info", 144, Current, 0, 1, 3093);
	Result = inline_F145_2999 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_is_available */
EIF_BOOLEAN F145_3000 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTEAA("unix_is_available", 144, Current, 2, 1, 3094);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(317, 0x00).id, 317, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F318_4799(RTCW(loc1), arg1);
	RTHOOK(2);
	ti4_1 = inline_F145_3005();
	tp1 = F318_4821(RTCW(loc1));
	tp1 = inline_F145_3004(ti4_1, tp1);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tp1 != loc2);
	RTHOOK(3);
	tr1 = F145_3002(Current);
	F145_2997(Current, tr1);
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_current_codeset */
EIF_POINTER F145_3001 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_current_codeset", 144, Current, 0, 0, 3095);
	Result = inline_F145_3001 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name */
EIF_REFERENCE F145_3002 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTEAA("unix_locale_name", 144, Current, 0, 0, 3096);
	RTGC;
	RTHOOK(1);
	Result = *(EIF_REFERENCE *)(RTCV(RTOSCF(3003,F145_3003, (Current))));
	RTHOOK(3);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name_cell */
static EIF_REFERENCE F145_3003_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	

	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTEAA("unix_locale_name_cell", 144, Current, 0, 0, 3097);
	RTGC;
	RTOSP (3003);
#define Result RTOSR(3003)
	RTOC_NEW(Result);
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {223,1084,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		tr1 = RTLNS(typres0.id, 223, _OBJSIZ_1_0_0_0_0_0_0_0_);
	}
	tr2 = RTMS_EX_H("POSIX",5,1331472728);
	F224_3957(RTCW(tr1), tr2);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (3003);
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F145_3003 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(3003,F145_3003_body,(Current));
}

/* {I18N_UNIX_C_FUNCTIONS}.c_setlocale */
EIF_POINTER F145_3004 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_setlocale", 144, Current, 0, 2, 3098);
	Result = inline_F145_3004 ((EIF_INTEGER_32) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_lc_all */
EIF_INTEGER_32 F145_3005 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_lc_all", 144, Current, 0, 0, 3099);
	Result = inline_F145_3005 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit129 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
