note

	description: "General manager implementation"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

deferred class

	MANAGER_I 

inherit

	COMPOSITE_I;

	STACKABLE_I;

feature -- Access

	foreground_color: COLOR
			-- Foreground color of manager widget
		deferred
		end;

feature -- Status setting

	update_foreground_color
		deferred
		end;
        
	set_initial_input_focus (a_widget: WIDGET)
			-- Set child which will initially have input focus
		require
			a_widget_not_void: not (a_widget = Void)
		deferred
		end

feature -- Element change

	set_foreground_color (new_color: COLOR)
			-- Set foreground color to `new_color'.
		require
			color_not_void: new_color /= Void
		deferred
		ensure
			foreground_color_set: foreground_color = new_color
		end;

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class MANAGER_I

