note
	description: "Defines the interval, in days, between invocations of a task. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	X_DAILY_RECORD

inherit
	ECOM_STRUCTURE
		redefine
			make
		end

create
	make,
	make_from_pointer

feature {NONE}  -- Initialization

	make
			-- Make.
		do
			Precursor {ECOM_STRUCTURE}
		end

	make_from_pointer (a_pointer: POINTER)
			-- Make from pointer.
		do
			make_by_pointer (a_pointer)
		end

feature -- Access

	days_interval: INTEGER
			-- 
		do
			Result := ccom_x_daily_days_interval (item)
		end

feature -- Measurement

	structure_size: INTEGER
			-- Size of structure
		do
			Result := c_size_of_x_daily
		end

feature -- Basic Operations

	set_days_interval (a_days_interval: INTEGER)
			-- Set `days_interval' with `a_days_interval'.
		do
			ccom_x_daily_set_days_interval (item, a_days_interval)
		end

feature {NONE}  -- Externals

	c_size_of_x_daily: INTEGER
			-- Size of structure
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__DAILY.h%"]"
		alias 
			"sizeof (ecom_MS_TaskSched_lib::_DAILY)"
		end

	ccom_x_daily_days_interval (a_pointer: POINTER): INTEGER
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__DAILY_impl.h%"](ecom_MS_TaskSched_lib::_DAILY *):EIF_INTEGER"
		end

	ccom_x_daily_set_days_interval (a_pointer: POINTER; arg2: INTEGER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__DAILY_impl.h%"](ecom_MS_TaskSched_lib::_DAILY *, USHORT)"
		end

end -- X_DAILY_RECORD


