note

	description:

		"Constant attributes implemented in .NET"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2006-2017, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2019-02-07 22:54:15 +0000 (Thu, 07 Feb 2019) $"
	revision: "$Revision: 102807 $"

class ET_DOTNET_CONSTANT_ATTRIBUTE

inherit

	ET_CONSTANT_ATTRIBUTE
		undefine
			is_frozen, is_dotnet,
			has_static_mark,
			overloaded_extended_name
		redefine
			process, make,
			new_synonym, renamed_feature
		end

	ET_DOTNET_QUERY
		undefine
			is_constant_attribute,
			is_static,
			is_prefixable
		end

create

	make

feature {NONE} -- Initialization

	make (a_name: like extended_name; a_type: like declared_type; a_constant: like constant; a_class: like implementation_class)
			-- Create a new .NET constant attribute.
		do
			dotnet_name := a_name.feature_name.name
			overloaded_extended_name := a_name
			precursor (a_name, a_type, a_constant, a_class)
		ensure then
			dotnet_name_set: dotnet_name.same_string (name.name)
			overloaded_extended_name_set: overloaded_extended_name = a_name
		end

feature -- Duplication

	new_synonym (a_name: like extended_name): like Current
			-- Synonym feature
		do
			Result := precursor (a_name)
			Result.set_overloaded_extended_name (overloaded_extended_name)
			Result.set_dotnet_name (dotnet_name)
		end

feature -- Conversion

	renamed_feature (a_name: like extended_name): like Current
			-- Renamed version of current feature
		do
			Result := precursor (a_name)
			Result.set_overloaded_extended_name (overloaded_extended_name)
			Result.set_dotnet_name (dotnet_name)
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR)
			-- Process current node.
		do
			a_processor.process_dotnet_constant_attribute (Current)
		end

end
