% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{class}
\name{duckdb_register}
\alias{duckdb_register}
\alias{duckdb_unregister}
\alias{duckdb_connection-class}
\alias{show,duckdb_connection-method}
\alias{dbIsValid,duckdb_connection-method}
\alias{dbDisconnect,duckdb_connection-method}
\alias{dbSendQuery,duckdb_connection,character-method}
\alias{dbDataType,duckdb_connection-method}
\alias{dbWriteTable,duckdb_connection,character,data.frame-method}
\alias{dbListTables,duckdb_connection-method}
\alias{dbExistsTable,duckdb_connection,character-method}
\alias{dbListFields,duckdb_connection,character-method}
\alias{dbRemoveTable,duckdb_connection,character-method}
\alias{dbGetInfo,duckdb_connection-method}
\alias{dbBegin,duckdb_connection-method}
\alias{dbCommit,duckdb_connection-method}
\alias{dbRollback,duckdb_connection-method}
\alias{read_csv_duckdb}
\title{Register a R data.frame as a virtual table (view) in DuckDB without copying the data}
\usage{
duckdb_register(conn, name, df)

duckdb_unregister(conn, name)

\S4method{show}{duckdb_connection}(object)

\S4method{dbIsValid}{duckdb_connection}(dbObj, ...)

\S4method{dbDisconnect}{duckdb_connection}(conn, ..., shutdown = FALSE)

\S4method{dbSendQuery}{duckdb_connection,character}(conn, statement, ...)

\S4method{dbDataType}{duckdb_connection}(dbObj, obj, ...)

\S4method{dbWriteTable}{duckdb_connection,character,data.frame}(
  conn,
  name,
  value,
  row.names = FALSE,
  overwrite = FALSE,
  append = FALSE,
  field.types = NULL,
  temporary = FALSE,
  ...
)

\S4method{dbListTables}{duckdb_connection}(conn, ...)

\S4method{dbExistsTable}{duckdb_connection,character}(conn, name, ...)

\S4method{dbListFields}{duckdb_connection,character}(conn, name, ...)

\S4method{dbRemoveTable}{duckdb_connection,character}(conn, name, ...)

\S4method{dbGetInfo}{duckdb_connection}(dbObj, ...)

\S4method{dbBegin}{duckdb_connection}(conn, ...)

\S4method{dbCommit}{duckdb_connection}(conn, ...)

\S4method{dbRollback}{duckdb_connection}(conn, ...)

read_csv_duckdb(
  conn,
  files,
  tablename,
  header = TRUE,
  na.strings = "",
  nrow.check = 500,
  delim = ",",
  quote = "\\"",
  col.names = NULL,
  lower.case.names = FALSE,
  sep = delim,
  transaction = TRUE,
  ...
)
}
\arguments{
\item{conn}{A DuckDB connection, created by `dbConnect()`.}

\item{name}{The name for the virtual table previously registered using `duckdb_register()`.}

\item{df}{A `data.frame` with the data for the virtual table}

\item{object}{Any R object}

\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}

\item{shutdown}{Shut down the DuckDB database instance that this connection refers to.}

\item{statement}{a character string containing SQL.}

\item{obj}{An R object whose SQL type we want to determine.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{row.names}{Whether the row.names of the data.frame should be preserved}

\item{overwrite}{If a table with the given name already exists, should it be overwritten?}

\item{append}{If a table with the given name already exists, just try to append the passed data to it}

\item{field.types}{Override the auto-generated SQL types}

\item{temporary}{Should the created table be temporary?}

\item{files}{One or more CSV file names, should all have the same structure though}

\item{tablename}{The database table the files should be read into}

\item{header}{Whether or not the CSV files have a separate header in the first line}

\item{na.strings}{Which strings in the CSV files should be considered to be NULL}

\item{nrow.check}{How many rows should be read from the CSV file to figure out data types}

\item{delim}{Which field separator should be used}

\item{quote}{Which quote character is used for columns in the CSV file}

\item{col.names}{Override the detected or generated column names}

\item{lower.case.names}{Transform column names to lower case}

\item{sep}{Alias for delim for compatibility}

\item{transaction}{Should a transaction be used for the entire operation}
}
\description{
Register a R data.frame as a virtual table (view) in DuckDB without copying the data

Unregister a virtual table referring to a data.frame

DuckDB connection class

Directly reads a CSV file into DuckDB, tries to detect and create the correct schema for it.
}
