; master library - VGA - trapezoid
;
; Function:
;	void vgc_trapezoid( int y1, int x11, int x12, int y2, int x21, int x22 ) ;
;
; Description:
;	`hԂ(v[̂)
;
; Parameters:
;	int y1			Pڂ̐̂W
;	int x11, x12		Pڂ̗̐[̂W
;	int y2			Qڂ̐̂W
;	int x21, x22		Qڂ̗̐[̂W
;
; Binding Target:
;	Microsoft-C / Turbo-C / Turbo Pascal
;
; Running Target:
;	VGA/SVGA 16color
;
; Requiring Resources:
;	CPU: 186
;
; Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Notes:
;	E炩ߐF≉Z[h vgc_setcolor()Ŏw肵ĂB
;	ENbsOsĂ܂B
;	@ÉAgrc_setclip()ɂNbsOɑΉĂ܂A
;	@㉺́AʘgŃNbv܂BĂяoőΉ(˰)
;	@W㋫EɂĂƒxȂ܂B
;	@i㋫EƂ̌_vZɁAォ珇ɒׂĂ邽߁j
;	Eʒu֌W͏㉺AEƂRłA˂Ăꍇ
;	@˂ꂽ`iQ̎Op`_ŐڂĂԁj`悵܂B
;
; Author:
;	ˏF
;
; Revision History:
;	92/3/21 Initial
;	92/3/29 bug fix, `ɑӂ̌F߂悤ɂ
;	92/4/2 X
;	92/4/18 Op`ٰ݂番BدݸޕtB
;	92/4/19 X
;	92/5/7 ȏɂ
;	92/5/20 CӸدݸނ̉ɂΉB:-)
;	92/5/22 ȏ`
;	92/6/6	bug fix
;	92/6/13 bug fix
;	92/6/16 TASMΉ
;	94/ 4/ 9 Initial: vgc_zoid.asm/master.lib 0.23

	.186
	.MODEL SMALL

	.DATA?
		EXTRN ClipYT:WORD, ClipYB:WORD
		EXTRN trapez_a:WORD, trapez_b:WORD	; ``pϐ
		EXTRN graph_VramSeg:WORD		; VRAM[ZOg
		EXTRN graph_VramWidth:WORD

	.CODE
		include func.inc
		EXTRN make_linework:NEAR, vgc_draw_trapezoid:NEAR

func VGC_TRAPEZOID	; vgc_trapezoid() {
	push	BP
	mov	BP,SP
	push	DI
	push	SI
	mov	ES,graph_VramSeg
	mov	CX,ClipYB

	; 
	y1  = (RETSIZE+6)*2
	x11 = (RETSIZE+5)*2
	x12 = (RETSIZE+4)*2
	y2  = (RETSIZE+3)*2
	x21 = (RETSIZE+2)*2
	x22 = (RETSIZE+1)*2

	mov	SI,[BP+y1]
	mov	DI,[BP+y2]

	cmp	SI,DI
	jg	short Lgyaku

	cmp	DI,ClipYT
	jl	short Lno_draw
	cmp	SI,CX
	jg	short Lno_draw
	sub	DI,CX			; if ( y2 >= Ymax )
	sbb	AX,AX			;	y2 = Ymax ;
	and	DI,AX
	add	DI,CX
	sub	DI,SI			; DI = y2 - y1
	jl	short Lno_draw

	mov	AX,[BP+x21]
	mov	CX,DI			; y2-y1
	mov	BX,offset trapez_a	;a
	mov	DX,[BP+x11]
	call	make_linework

	mov	AX,[BP+x22]
	mov	CX,DI			; y2-y1
	mov	BX,offset trapez_b	;b
	mov	DX,[BP+x12]
	push	offset Ldraw
	jmp	make_linework

Lgyaku:
	xchg	SI,DI			; y2<->y1

	cmp	DI,ClipYT
	jl	short Lno_draw
	cmp	SI,CX
	jg	short Lno_draw
	sub	DI,CX			; if ( y2 >= Ymax )
	sbb	AX,AX			;	y2 = Ymax ;
	and	DI,AX
	add	DI,CX

	sub	DI,SI			; DI = y2 - y1
	jl	short Lno_draw

	mov	AX,[BP+x11]
	mov	CX,DI			; y2-y1
	mov	BX,offset trapez_a	;a
	mov	DX,[BP+x21]
	call	make_linework

	mov	AX,[BP+x12]
	mov	CX,DI			; y2-y1
	mov	BX,offset trapez_b	;b
	mov	DX,[BP+x22]
	call	make_linework
Ldraw:
	mov	AX,SI
	imul	graph_VramWidth
	mov	SI,AX
	mov	DX,DI
	call	vgc_draw_trapezoid
Lno_draw:
	pop	SI
	pop	DI
	leave
	ret	12
endfunc			; }

END
