#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 535
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 105
#define ALIAS_COUNT 0
#define TOKEN_COUNT 59
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 41

enum {
  sym_keyword = 1,
  sym_identifier = 2,
  sym_integer_expression = 3,
  sym_float_expression = 4,
  sym__hpath_start = 5,
  sym_spath_expression = 6,
  sym_uri_expression = 7,
  anon_sym_COLON = 8,
  anon_sym_AT = 9,
  anon_sym_LBRACE = 10,
  anon_sym_RBRACE = 11,
  anon_sym_COMMA = 12,
  anon_sym_QMARK = 13,
  sym_ellipses = 14,
  anon_sym_assert = 15,
  anon_sym_SEMI = 16,
  anon_sym_with = 17,
  anon_sym_let = 18,
  anon_sym_in = 19,
  anon_sym_if = 20,
  anon_sym_then = 21,
  anon_sym_else = 22,
  anon_sym_BANG = 23,
  anon_sym_DASH = 24,
  anon_sym_EQ_EQ = 25,
  anon_sym_BANG_EQ = 26,
  anon_sym_LT = 27,
  anon_sym_LT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_GT_EQ = 30,
  anon_sym_AMP_AMP = 31,
  anon_sym_PIPE_PIPE = 32,
  anon_sym_PLUS = 33,
  anon_sym_STAR = 34,
  anon_sym_SLASH = 35,
  anon_sym_DASH_GT = 36,
  anon_sym_SLASH_SLASH = 37,
  anon_sym_PLUS_PLUS = 38,
  anon_sym_DOT = 39,
  anon_sym_or = 40,
  anon_sym_LPAREN = 41,
  anon_sym_RPAREN = 42,
  anon_sym_rec = 43,
  anon_sym_DQUOTE = 44,
  sym_escape_sequence = 45,
  anon_sym_SQUOTE_SQUOTE = 46,
  sym__indented_escape_sequence = 47,
  anon_sym_EQ = 48,
  anon_sym_inherit = 49,
  anon_sym_DOLLAR_LBRACE = 50,
  anon_sym_DOLLAR_LBRACE2 = 51,
  anon_sym_LBRACK = 52,
  anon_sym_RBRACK = 53,
  sym_comment = 54,
  sym_string_fragment = 55,
  sym__indented_string_fragment = 56,
  sym__path_start = 57,
  sym_path_fragment = 58,
  sym_source_code = 59,
  sym__expression = 60,
  sym_variable_expression = 61,
  sym_path_expression = 62,
  sym_hpath_expression = 63,
  sym__expr_function_expression = 64,
  sym_function_expression = 65,
  sym_formals = 66,
  sym_formal = 67,
  sym_assert_expression = 68,
  sym_with_expression = 69,
  sym_let_expression = 70,
  sym__expr_if = 71,
  sym_if_expression = 72,
  sym__expr_op = 73,
  sym_has_attr_expression = 74,
  sym_unary_expression = 75,
  sym_binary_expression = 76,
  sym__expr_apply_expression = 77,
  sym_apply_expression = 78,
  sym__expr_select_expression = 79,
  sym_select_expression = 80,
  sym__expr_simple = 81,
  sym_parenthesized_expression = 82,
  sym_attrset_expression = 83,
  sym_let_attrset_expression = 84,
  sym_rec_attrset_expression = 85,
  sym_string_expression = 86,
  sym_indented_string_expression = 87,
  sym_binding_set = 88,
  sym_binding = 89,
  sym_inherit = 90,
  sym_inherit_from = 91,
  sym_attrpath = 92,
  sym_inherited_attrs = 93,
  sym__immediate_interpolation = 94,
  sym_interpolation = 95,
  sym_list_expression = 96,
  aux_sym_path_expression_repeat1 = 97,
  aux_sym_formals_repeat1 = 98,
  aux_sym_string_expression_repeat1 = 99,
  aux_sym_indented_string_expression_repeat1 = 100,
  aux_sym_binding_set_repeat1 = 101,
  aux_sym_attrpath_repeat1 = 102,
  aux_sym_inherited_attrs_repeat1 = 103,
  aux_sym_list_expression_repeat1 = 104,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [sym_identifier] = "identifier",
  [sym_integer_expression] = "integer_expression",
  [sym_float_expression] = "float_expression",
  [sym__hpath_start] = "path_fragment",
  [sym_spath_expression] = "spath_expression",
  [sym_uri_expression] = "uri_expression",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [sym_ellipses] = "ellipses",
  [anon_sym_assert] = "assert",
  [anon_sym_SEMI] = ";",
  [anon_sym_with] = "with",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DOT] = ".",
  [anon_sym_or] = "or",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_rec] = "rec",
  [anon_sym_DQUOTE] = "\"",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_SQUOTE_SQUOTE] = "''",
  [sym__indented_escape_sequence] = "escape_sequence",
  [anon_sym_EQ] = "=",
  [anon_sym_inherit] = "inherit",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_DOLLAR_LBRACE2] = "${",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_comment] = "comment",
  [sym_string_fragment] = "string_fragment",
  [sym__indented_string_fragment] = "string_fragment",
  [sym__path_start] = "path_fragment",
  [sym_path_fragment] = "path_fragment",
  [sym_source_code] = "source_code",
  [sym__expression] = "_expression",
  [sym_variable_expression] = "variable_expression",
  [sym_path_expression] = "path_expression",
  [sym_hpath_expression] = "hpath_expression",
  [sym__expr_function_expression] = "_expr_function_expression",
  [sym_function_expression] = "function_expression",
  [sym_formals] = "formals",
  [sym_formal] = "formal",
  [sym_assert_expression] = "assert_expression",
  [sym_with_expression] = "with_expression",
  [sym_let_expression] = "let_expression",
  [sym__expr_if] = "_expr_if",
  [sym_if_expression] = "if_expression",
  [sym__expr_op] = "_expr_op",
  [sym_has_attr_expression] = "has_attr_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expr_apply_expression] = "_expr_apply_expression",
  [sym_apply_expression] = "apply_expression",
  [sym__expr_select_expression] = "_expr_select_expression",
  [sym_select_expression] = "select_expression",
  [sym__expr_simple] = "_expr_simple",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_attrset_expression] = "attrset_expression",
  [sym_let_attrset_expression] = "let_attrset_expression",
  [sym_rec_attrset_expression] = "rec_attrset_expression",
  [sym_string_expression] = "string_expression",
  [sym_indented_string_expression] = "indented_string_expression",
  [sym_binding_set] = "binding_set",
  [sym_binding] = "binding",
  [sym_inherit] = "inherit",
  [sym_inherit_from] = "inherit_from",
  [sym_attrpath] = "attrpath",
  [sym_inherited_attrs] = "inherited_attrs",
  [sym__immediate_interpolation] = "interpolation",
  [sym_interpolation] = "interpolation",
  [sym_list_expression] = "list_expression",
  [aux_sym_path_expression_repeat1] = "path_expression_repeat1",
  [aux_sym_formals_repeat1] = "formals_repeat1",
  [aux_sym_string_expression_repeat1] = "string_expression_repeat1",
  [aux_sym_indented_string_expression_repeat1] = "indented_string_expression_repeat1",
  [aux_sym_binding_set_repeat1] = "binding_set_repeat1",
  [aux_sym_attrpath_repeat1] = "attrpath_repeat1",
  [aux_sym_inherited_attrs_repeat1] = "inherited_attrs_repeat1",
  [aux_sym_list_expression_repeat1] = "list_expression_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [sym_identifier] = sym_identifier,
  [sym_integer_expression] = sym_integer_expression,
  [sym_float_expression] = sym_float_expression,
  [sym__hpath_start] = sym_path_fragment,
  [sym_spath_expression] = sym_spath_expression,
  [sym_uri_expression] = sym_uri_expression,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_ellipses] = sym_ellipses,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE,
  [sym__indented_escape_sequence] = sym_escape_sequence,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_inherit] = anon_sym_inherit,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_DOLLAR_LBRACE2] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_comment] = sym_comment,
  [sym_string_fragment] = sym_string_fragment,
  [sym__indented_string_fragment] = sym_string_fragment,
  [sym__path_start] = sym_path_fragment,
  [sym_path_fragment] = sym_path_fragment,
  [sym_source_code] = sym_source_code,
  [sym__expression] = sym__expression,
  [sym_variable_expression] = sym_variable_expression,
  [sym_path_expression] = sym_path_expression,
  [sym_hpath_expression] = sym_hpath_expression,
  [sym__expr_function_expression] = sym__expr_function_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_formals] = sym_formals,
  [sym_formal] = sym_formal,
  [sym_assert_expression] = sym_assert_expression,
  [sym_with_expression] = sym_with_expression,
  [sym_let_expression] = sym_let_expression,
  [sym__expr_if] = sym__expr_if,
  [sym_if_expression] = sym_if_expression,
  [sym__expr_op] = sym__expr_op,
  [sym_has_attr_expression] = sym_has_attr_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expr_apply_expression] = sym__expr_apply_expression,
  [sym_apply_expression] = sym_apply_expression,
  [sym__expr_select_expression] = sym__expr_select_expression,
  [sym_select_expression] = sym_select_expression,
  [sym__expr_simple] = sym__expr_simple,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_attrset_expression] = sym_attrset_expression,
  [sym_let_attrset_expression] = sym_let_attrset_expression,
  [sym_rec_attrset_expression] = sym_rec_attrset_expression,
  [sym_string_expression] = sym_string_expression,
  [sym_indented_string_expression] = sym_indented_string_expression,
  [sym_binding_set] = sym_binding_set,
  [sym_binding] = sym_binding,
  [sym_inherit] = sym_inherit,
  [sym_inherit_from] = sym_inherit_from,
  [sym_attrpath] = sym_attrpath,
  [sym_inherited_attrs] = sym_inherited_attrs,
  [sym__immediate_interpolation] = sym_interpolation,
  [sym_interpolation] = sym_interpolation,
  [sym_list_expression] = sym_list_expression,
  [aux_sym_path_expression_repeat1] = aux_sym_path_expression_repeat1,
  [aux_sym_formals_repeat1] = aux_sym_formals_repeat1,
  [aux_sym_string_expression_repeat1] = aux_sym_string_expression_repeat1,
  [aux_sym_indented_string_expression_repeat1] = aux_sym_indented_string_expression_repeat1,
  [aux_sym_binding_set_repeat1] = aux_sym_binding_set_repeat1,
  [aux_sym_attrpath_repeat1] = aux_sym_attrpath_repeat1,
  [aux_sym_inherited_attrs_repeat1] = aux_sym_inherited_attrs_repeat1,
  [aux_sym_list_expression_repeat1] = aux_sym_list_expression_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_float_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__hpath_start] = {
    .visible = true,
    .named = true,
  },
  [sym_spath_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_uri_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipses] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__indented_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__path_start] = {
    .visible = true,
    .named = true,
  },
  [sym_path_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_code] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_variable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_hpath_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_formals] = {
    .visible = true,
    .named = true,
  },
  [sym_formal] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_with_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_if] = {
    .visible = false,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_op] = {
    .visible = false,
    .named = true,
  },
  [sym_has_attr_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_apply_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_apply_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_select_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_select_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_simple] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_rec_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_indented_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_set] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit_from] = {
    .visible = true,
    .named = true,
  },
  [sym_attrpath] = {
    .visible = true,
    .named = true,
  },
  [sym_inherited_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_list_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formals_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_indented_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binding_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attrpath_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inherited_attrs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_attr = 3,
  field_attrpath = 4,
  field_attrs = 5,
  field_binding = 6,
  field_body = 7,
  field_condition = 8,
  field_consequence = 9,
  field_default = 10,
  field_element = 11,
  field_ellipses = 12,
  field_environment = 13,
  field_expression = 14,
  field_formal = 15,
  field_formals = 16,
  field_function = 17,
  field_left = 18,
  field_name = 19,
  field_operator = 20,
  field_right = 21,
  field_universal = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_attr] = "attr",
  [field_attrpath] = "attrpath",
  [field_attrs] = "attrs",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_default] = "default",
  [field_element] = "element",
  [field_ellipses] = "ellipses",
  [field_environment] = "environment",
  [field_expression] = "expression",
  [field_formal] = "formal",
  [field_formals] = "formals",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_universal] = "universal",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 2},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 1},
  [13] = {.index = 16, .length = 1},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 1},
  [17] = {.index = 21, .length = 1},
  [18] = {.index = 22, .length = 1},
  [19] = {.index = 23, .length = 2},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 27, .length = 3},
  [22] = {.index = 30, .length = 3},
  [23] = {.index = 33, .length = 2},
  [24] = {.index = 35, .length = 2},
  [25] = {.index = 37, .length = 1},
  [26] = {.index = 38, .length = 2},
  [27] = {.index = 40, .length = 1},
  [28] = {.index = 41, .length = 2},
  [29] = {.index = 43, .length = 2},
  [30] = {.index = 45, .length = 2},
  [31] = {.index = 47, .length = 2},
  [32] = {.index = 49, .length = 1},
  [33] = {.index = 50, .length = 3},
  [34] = {.index = 53, .length = 2},
  [35] = {.index = 55, .length = 2},
  [36] = {.index = 57, .length = 3},
  [37] = {.index = 60, .length = 3},
  [38] = {.index = 63, .length = 3},
  [39] = {.index = 66, .length = 3},
  [40] = {.index = 69, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_expression, 0},
  [2] =
    {field_expression, 0, .inherited = true},
  [3] =
    {field_attr, 0},
  [4] =
    {field_binding, 0},
  [5] =
    {field_binding, 0, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_element, 0},
  [9] =
    {field_argument, 1},
    {field_function, 0},
  [11] =
    {field_body, 2},
    {field_universal, 0},
  [13] =
    {field_attr, 0},
    {field_attr, 1, .inherited = true},
  [15] =
    {field_ellipses, 1},
  [16] =
    {field_attr, 0, .inherited = true},
  [17] =
    {field_formal, 1},
  [18] =
    {field_binding, 0, .inherited = true},
    {field_binding, 1, .inherited = true},
  [20] =
    {field_body, 2},
  [21] =
    {field_expression, 1},
  [22] =
    {field_element, 1, .inherited = true},
  [23] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [25] =
    {field_body, 2},
    {field_formals, 0},
  [27] =
    {field_attrpath, 2},
    {field_expression, 0},
    {field_operator, 1},
  [30] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [33] =
    {field_attrpath, 2},
    {field_expression, 0},
  [35] =
    {field_default, 2},
    {field_name, 0},
  [37] =
    {field_attr, 1},
  [38] =
    {field_attr, 0, .inherited = true},
    {field_attr, 1, .inherited = true},
  [40] =
    {field_attrs, 1},
  [41] =
    {field_formal, 1},
    {field_formal, 2, .inherited = true},
  [43] =
    {field_formal, 0, .inherited = true},
    {field_formal, 1, .inherited = true},
  [45] =
    {field_body, 3},
    {field_condition, 1},
  [47] =
    {field_body, 3},
    {field_environment, 1},
  [49] =
    {field_body, 3},
  [50] =
    {field_body, 4},
    {field_formals, 2},
    {field_universal, 0},
  [53] =
    {field_ellipses, 3},
    {field_formal, 1},
  [55] =
    {field_attrpath, 0},
    {field_expression, 2},
  [57] =
    {field_body, 4},
    {field_formals, 0},
    {field_universal, 2},
  [60] =
    {field_attrpath, 2},
    {field_default, 4},
    {field_expression, 0},
  [63] =
    {field_ellipses, 4},
    {field_formal, 1},
    {field_formal, 2, .inherited = true},
  [66] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [69] =
    {field_attrs, 4},
    {field_expression, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(138);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(156);
      END_STATE();
    case 7:
      if (lookahead == '\'') ADVANCE(155);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(125);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == '/') ADVANCE(45);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 27:
      if (lookahead == 'h') ADVANCE(22);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 36:
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(26);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(160);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(161);
      END_STATE();
    case 41:
      if (lookahead == '|') ADVANCE(139);
      END_STATE();
    case 42:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 45:
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 46:
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 47:
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '~') ADVANCE(118);
      END_STATE();
    case 48:
      if (lookahead != 0) ADVANCE(154);
      END_STATE();
    case 49:
      if (lookahead != 0) ADVANCE(157);
      END_STATE();
    case 50:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 51:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 52:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 53:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 54:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 55:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '\'') ADVANCE(7);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(162);
      if (lookahead == ']') ADVANCE(163);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(80);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 56:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'r') ADVANCE(21);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(29);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(56)
      END_STATE();
    case 57:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(17);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'r') ADVANCE(21);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(29);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      END_STATE();
    case 58:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(71);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(94);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(24);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'c') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(65);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(79);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'i') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'i') ADVANCE(86);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'l') ADVANCE(84);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(149);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(75);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 't') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == 't') ADVANCE(73);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(102);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(64);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(92);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(150);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(93);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(89);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(96);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_integer_expression);
      if (lookahead == '.') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_integer_expression);
      if (lookahead == '.') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_integer_expression);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_float_expression);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_float_expression);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym__hpath_start);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_spath_expression);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_uri_expression);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '~') ADVANCE(118);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_ellipses);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(143);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(145);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(15);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      if (lookahead == '$' ||
          lookahead == '\'') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(49);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym__indented_escape_sequence);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE2);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(165);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(2);
      if (lookahead == 'i') ADVANCE(3);
      if (lookahead == 'l') ADVANCE(4);
      if (lookahead == 'r') ADVANCE(5);
      if (lookahead == 't') ADVANCE(6);
      if (lookahead == 'w') ADVANCE(7);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(8);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(9);
      END_STATE();
    case 3:
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(12);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 6:
      if (lookahead == 'h') ADVANCE(14);
      END_STATE();
    case 7:
      if (lookahead == 'i') ADVANCE(15);
      END_STATE();
    case 8:
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'h') ADVANCE(18);
      END_STATE();
    case 12:
      if (lookahead == 't') ADVANCE(19);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(20);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 15:
      if (lookahead == 't') ADVANCE(22);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_rec);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 22:
      if (lookahead == 'h') ADVANCE(27);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 25:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_inherit);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 51, .external_lex_state = 2},
  [2] = {.lex_state = 51, .external_lex_state = 2},
  [3] = {.lex_state = 51, .external_lex_state = 2},
  [4] = {.lex_state = 51, .external_lex_state = 2},
  [5] = {.lex_state = 53, .external_lex_state = 2},
  [6] = {.lex_state = 51, .external_lex_state = 2},
  [7] = {.lex_state = 51, .external_lex_state = 2},
  [8] = {.lex_state = 51, .external_lex_state = 2},
  [9] = {.lex_state = 51, .external_lex_state = 2},
  [10] = {.lex_state = 51, .external_lex_state = 2},
  [11] = {.lex_state = 51, .external_lex_state = 2},
  [12] = {.lex_state = 51, .external_lex_state = 2},
  [13] = {.lex_state = 51, .external_lex_state = 2},
  [14] = {.lex_state = 51, .external_lex_state = 2},
  [15] = {.lex_state = 51, .external_lex_state = 2},
  [16] = {.lex_state = 51, .external_lex_state = 2},
  [17] = {.lex_state = 51, .external_lex_state = 2},
  [18] = {.lex_state = 51, .external_lex_state = 2},
  [19] = {.lex_state = 51, .external_lex_state = 2},
  [20] = {.lex_state = 51, .external_lex_state = 2},
  [21] = {.lex_state = 51, .external_lex_state = 2},
  [22] = {.lex_state = 51, .external_lex_state = 2},
  [23] = {.lex_state = 51, .external_lex_state = 2},
  [24] = {.lex_state = 51, .external_lex_state = 2},
  [25] = {.lex_state = 51, .external_lex_state = 2},
  [26] = {.lex_state = 51, .external_lex_state = 2},
  [27] = {.lex_state = 51, .external_lex_state = 2},
  [28] = {.lex_state = 51, .external_lex_state = 2},
  [29] = {.lex_state = 51, .external_lex_state = 2},
  [30] = {.lex_state = 51, .external_lex_state = 2},
  [31] = {.lex_state = 51, .external_lex_state = 2},
  [32] = {.lex_state = 51, .external_lex_state = 2},
  [33] = {.lex_state = 51, .external_lex_state = 2},
  [34] = {.lex_state = 51, .external_lex_state = 2},
  [35] = {.lex_state = 51, .external_lex_state = 2},
  [36] = {.lex_state = 51, .external_lex_state = 2},
  [37] = {.lex_state = 51, .external_lex_state = 2},
  [38] = {.lex_state = 51, .external_lex_state = 2},
  [39] = {.lex_state = 51, .external_lex_state = 2},
  [40] = {.lex_state = 51, .external_lex_state = 2},
  [41] = {.lex_state = 51, .external_lex_state = 2},
  [42] = {.lex_state = 51, .external_lex_state = 2},
  [43] = {.lex_state = 51, .external_lex_state = 2},
  [44] = {.lex_state = 51, .external_lex_state = 2},
  [45] = {.lex_state = 51, .external_lex_state = 2},
  [46] = {.lex_state = 51, .external_lex_state = 2},
  [47] = {.lex_state = 51, .external_lex_state = 2},
  [48] = {.lex_state = 51, .external_lex_state = 2},
  [49] = {.lex_state = 51, .external_lex_state = 2},
  [50] = {.lex_state = 51, .external_lex_state = 2},
  [51] = {.lex_state = 51, .external_lex_state = 2},
  [52] = {.lex_state = 51, .external_lex_state = 2},
  [53] = {.lex_state = 51, .external_lex_state = 2},
  [54] = {.lex_state = 51, .external_lex_state = 2},
  [55] = {.lex_state = 51, .external_lex_state = 2},
  [56] = {.lex_state = 51, .external_lex_state = 2},
  [57] = {.lex_state = 51, .external_lex_state = 2},
  [58] = {.lex_state = 51, .external_lex_state = 2},
  [59] = {.lex_state = 51, .external_lex_state = 2},
  [60] = {.lex_state = 51, .external_lex_state = 2},
  [61] = {.lex_state = 51, .external_lex_state = 2},
  [62] = {.lex_state = 51, .external_lex_state = 2},
  [63] = {.lex_state = 51, .external_lex_state = 2},
  [64] = {.lex_state = 51, .external_lex_state = 2},
  [65] = {.lex_state = 51, .external_lex_state = 2},
  [66] = {.lex_state = 51, .external_lex_state = 2},
  [67] = {.lex_state = 51, .external_lex_state = 2},
  [68] = {.lex_state = 51, .external_lex_state = 2},
  [69] = {.lex_state = 51, .external_lex_state = 2},
  [70] = {.lex_state = 51, .external_lex_state = 2},
  [71] = {.lex_state = 51, .external_lex_state = 2},
  [72] = {.lex_state = 51, .external_lex_state = 2},
  [73] = {.lex_state = 51, .external_lex_state = 2},
  [74] = {.lex_state = 51, .external_lex_state = 2},
  [75] = {.lex_state = 51, .external_lex_state = 2},
  [76] = {.lex_state = 53, .external_lex_state = 2},
  [77] = {.lex_state = 53, .external_lex_state = 2},
  [78] = {.lex_state = 53, .external_lex_state = 2},
  [79] = {.lex_state = 53, .external_lex_state = 3},
  [80] = {.lex_state = 53, .external_lex_state = 3},
  [81] = {.lex_state = 53, .external_lex_state = 3},
  [82] = {.lex_state = 53, .external_lex_state = 3},
  [83] = {.lex_state = 53, .external_lex_state = 3},
  [84] = {.lex_state = 53, .external_lex_state = 3},
  [85] = {.lex_state = 55, .external_lex_state = 2},
  [86] = {.lex_state = 55, .external_lex_state = 2},
  [87] = {.lex_state = 55, .external_lex_state = 2},
  [88] = {.lex_state = 53, .external_lex_state = 3},
  [89] = {.lex_state = 53, .external_lex_state = 2},
  [90] = {.lex_state = 55, .external_lex_state = 2},
  [91] = {.lex_state = 55, .external_lex_state = 2},
  [92] = {.lex_state = 55, .external_lex_state = 2},
  [93] = {.lex_state = 55, .external_lex_state = 2},
  [94] = {.lex_state = 53, .external_lex_state = 2},
  [95] = {.lex_state = 53, .external_lex_state = 2},
  [96] = {.lex_state = 53, .external_lex_state = 3},
  [97] = {.lex_state = 53, .external_lex_state = 3},
  [98] = {.lex_state = 53, .external_lex_state = 3},
  [99] = {.lex_state = 53, .external_lex_state = 3},
  [100] = {.lex_state = 53, .external_lex_state = 3},
  [101] = {.lex_state = 53, .external_lex_state = 2},
  [102] = {.lex_state = 53, .external_lex_state = 2},
  [103] = {.lex_state = 53, .external_lex_state = 3},
  [104] = {.lex_state = 53, .external_lex_state = 3},
  [105] = {.lex_state = 53, .external_lex_state = 3},
  [106] = {.lex_state = 53, .external_lex_state = 2},
  [107] = {.lex_state = 53, .external_lex_state = 2},
  [108] = {.lex_state = 53, .external_lex_state = 3},
  [109] = {.lex_state = 53, .external_lex_state = 2},
  [110] = {.lex_state = 53, .external_lex_state = 3},
  [111] = {.lex_state = 53, .external_lex_state = 3},
  [112] = {.lex_state = 53, .external_lex_state = 3},
  [113] = {.lex_state = 53, .external_lex_state = 2},
  [114] = {.lex_state = 53, .external_lex_state = 2},
  [115] = {.lex_state = 53, .external_lex_state = 2},
  [116] = {.lex_state = 53, .external_lex_state = 2},
  [117] = {.lex_state = 53, .external_lex_state = 2},
  [118] = {.lex_state = 53, .external_lex_state = 2},
  [119] = {.lex_state = 53, .external_lex_state = 2},
  [120] = {.lex_state = 53, .external_lex_state = 2},
  [121] = {.lex_state = 53, .external_lex_state = 3},
  [122] = {.lex_state = 53, .external_lex_state = 3},
  [123] = {.lex_state = 53, .external_lex_state = 2},
  [124] = {.lex_state = 53, .external_lex_state = 3},
  [125] = {.lex_state = 55, .external_lex_state = 2},
  [126] = {.lex_state = 51, .external_lex_state = 2},
  [127] = {.lex_state = 51, .external_lex_state = 2},
  [128] = {.lex_state = 51, .external_lex_state = 2},
  [129] = {.lex_state = 51, .external_lex_state = 2},
  [130] = {.lex_state = 51, .external_lex_state = 2},
  [131] = {.lex_state = 51, .external_lex_state = 2},
  [132] = {.lex_state = 51, .external_lex_state = 2},
  [133] = {.lex_state = 51, .external_lex_state = 2},
  [134] = {.lex_state = 51, .external_lex_state = 2},
  [135] = {.lex_state = 51, .external_lex_state = 2},
  [136] = {.lex_state = 51, .external_lex_state = 2},
  [137] = {.lex_state = 51, .external_lex_state = 2},
  [138] = {.lex_state = 51, .external_lex_state = 2},
  [139] = {.lex_state = 51, .external_lex_state = 2},
  [140] = {.lex_state = 51, .external_lex_state = 2},
  [141] = {.lex_state = 51, .external_lex_state = 2},
  [142] = {.lex_state = 51, .external_lex_state = 2},
  [143] = {.lex_state = 51, .external_lex_state = 2},
  [144] = {.lex_state = 51, .external_lex_state = 2},
  [145] = {.lex_state = 53, .external_lex_state = 2},
  [146] = {.lex_state = 51, .external_lex_state = 2},
  [147] = {.lex_state = 51, .external_lex_state = 2},
  [148] = {.lex_state = 51, .external_lex_state = 2},
  [149] = {.lex_state = 51, .external_lex_state = 2},
  [150] = {.lex_state = 51, .external_lex_state = 2},
  [151] = {.lex_state = 51, .external_lex_state = 2},
  [152] = {.lex_state = 51, .external_lex_state = 2},
  [153] = {.lex_state = 51, .external_lex_state = 2},
  [154] = {.lex_state = 51, .external_lex_state = 2},
  [155] = {.lex_state = 51, .external_lex_state = 2},
  [156] = {.lex_state = 51, .external_lex_state = 2},
  [157] = {.lex_state = 51, .external_lex_state = 2},
  [158] = {.lex_state = 51, .external_lex_state = 2},
  [159] = {.lex_state = 51, .external_lex_state = 2},
  [160] = {.lex_state = 51, .external_lex_state = 2},
  [161] = {.lex_state = 51, .external_lex_state = 2},
  [162] = {.lex_state = 51, .external_lex_state = 2},
  [163] = {.lex_state = 51, .external_lex_state = 2},
  [164] = {.lex_state = 51, .external_lex_state = 2},
  [165] = {.lex_state = 51, .external_lex_state = 2},
  [166] = {.lex_state = 51, .external_lex_state = 2},
  [167] = {.lex_state = 51, .external_lex_state = 2},
  [168] = {.lex_state = 51, .external_lex_state = 2},
  [169] = {.lex_state = 51, .external_lex_state = 2},
  [170] = {.lex_state = 51, .external_lex_state = 2},
  [171] = {.lex_state = 53, .external_lex_state = 2},
  [172] = {.lex_state = 55, .external_lex_state = 2},
  [173] = {.lex_state = 53, .external_lex_state = 2},
  [174] = {.lex_state = 53, .external_lex_state = 3},
  [175] = {.lex_state = 55, .external_lex_state = 2},
  [176] = {.lex_state = 53, .external_lex_state = 3},
  [177] = {.lex_state = 55, .external_lex_state = 2},
  [178] = {.lex_state = 55, .external_lex_state = 2},
  [179] = {.lex_state = 55, .external_lex_state = 2},
  [180] = {.lex_state = 55, .external_lex_state = 2},
  [181] = {.lex_state = 53, .external_lex_state = 2},
  [182] = {.lex_state = 53, .external_lex_state = 2},
  [183] = {.lex_state = 53, .external_lex_state = 3},
  [184] = {.lex_state = 55, .external_lex_state = 2},
  [185] = {.lex_state = 53, .external_lex_state = 2},
  [186] = {.lex_state = 53, .external_lex_state = 3},
  [187] = {.lex_state = 53, .external_lex_state = 2},
  [188] = {.lex_state = 55, .external_lex_state = 2},
  [189] = {.lex_state = 53, .external_lex_state = 2},
  [190] = {.lex_state = 53, .external_lex_state = 3},
  [191] = {.lex_state = 55, .external_lex_state = 2},
  [192] = {.lex_state = 53, .external_lex_state = 3},
  [193] = {.lex_state = 55, .external_lex_state = 2},
  [194] = {.lex_state = 55, .external_lex_state = 2},
  [195] = {.lex_state = 55, .external_lex_state = 2},
  [196] = {.lex_state = 55, .external_lex_state = 2},
  [197] = {.lex_state = 55, .external_lex_state = 2},
  [198] = {.lex_state = 55, .external_lex_state = 2},
  [199] = {.lex_state = 55, .external_lex_state = 2},
  [200] = {.lex_state = 55, .external_lex_state = 2},
  [201] = {.lex_state = 55, .external_lex_state = 2},
  [202] = {.lex_state = 55, .external_lex_state = 2},
  [203] = {.lex_state = 55, .external_lex_state = 2},
  [204] = {.lex_state = 55, .external_lex_state = 2},
  [205] = {.lex_state = 53, .external_lex_state = 2},
  [206] = {.lex_state = 53, .external_lex_state = 2},
  [207] = {.lex_state = 53, .external_lex_state = 2},
  [208] = {.lex_state = 53, .external_lex_state = 2},
  [209] = {.lex_state = 53, .external_lex_state = 2},
  [210] = {.lex_state = 53, .external_lex_state = 2},
  [211] = {.lex_state = 53, .external_lex_state = 2},
  [212] = {.lex_state = 53, .external_lex_state = 2},
  [213] = {.lex_state = 55, .external_lex_state = 2},
  [214] = {.lex_state = 53, .external_lex_state = 2},
  [215] = {.lex_state = 53, .external_lex_state = 2},
  [216] = {.lex_state = 53, .external_lex_state = 2},
  [217] = {.lex_state = 53, .external_lex_state = 2},
  [218] = {.lex_state = 53, .external_lex_state = 2},
  [219] = {.lex_state = 53, .external_lex_state = 2},
  [220] = {.lex_state = 53, .external_lex_state = 2},
  [221] = {.lex_state = 53, .external_lex_state = 2},
  [222] = {.lex_state = 53, .external_lex_state = 2},
  [223] = {.lex_state = 53, .external_lex_state = 2},
  [224] = {.lex_state = 53, .external_lex_state = 2},
  [225] = {.lex_state = 53, .external_lex_state = 2},
  [226] = {.lex_state = 55, .external_lex_state = 2},
  [227] = {.lex_state = 53, .external_lex_state = 2},
  [228] = {.lex_state = 53, .external_lex_state = 2},
  [229] = {.lex_state = 53, .external_lex_state = 2},
  [230] = {.lex_state = 53, .external_lex_state = 2},
  [231] = {.lex_state = 53, .external_lex_state = 2},
  [232] = {.lex_state = 53, .external_lex_state = 2},
  [233] = {.lex_state = 53, .external_lex_state = 2},
  [234] = {.lex_state = 53, .external_lex_state = 2},
  [235] = {.lex_state = 53, .external_lex_state = 2},
  [236] = {.lex_state = 53, .external_lex_state = 2},
  [237] = {.lex_state = 53, .external_lex_state = 2},
  [238] = {.lex_state = 53, .external_lex_state = 2},
  [239] = {.lex_state = 53, .external_lex_state = 2},
  [240] = {.lex_state = 53, .external_lex_state = 2},
  [241] = {.lex_state = 53, .external_lex_state = 2},
  [242] = {.lex_state = 53, .external_lex_state = 2},
  [243] = {.lex_state = 53, .external_lex_state = 2},
  [244] = {.lex_state = 53, .external_lex_state = 2},
  [245] = {.lex_state = 53, .external_lex_state = 2},
  [246] = {.lex_state = 55, .external_lex_state = 2},
  [247] = {.lex_state = 53, .external_lex_state = 2},
  [248] = {.lex_state = 53, .external_lex_state = 2},
  [249] = {.lex_state = 53, .external_lex_state = 2},
  [250] = {.lex_state = 53, .external_lex_state = 2},
  [251] = {.lex_state = 53, .external_lex_state = 2},
  [252] = {.lex_state = 53, .external_lex_state = 2},
  [253] = {.lex_state = 53, .external_lex_state = 2},
  [254] = {.lex_state = 53, .external_lex_state = 2},
  [255] = {.lex_state = 53, .external_lex_state = 2},
  [256] = {.lex_state = 53, .external_lex_state = 2},
  [257] = {.lex_state = 53, .external_lex_state = 2},
  [258] = {.lex_state = 53, .external_lex_state = 2},
  [259] = {.lex_state = 51, .external_lex_state = 2},
  [260] = {.lex_state = 51, .external_lex_state = 2},
  [261] = {.lex_state = 51, .external_lex_state = 2},
  [262] = {.lex_state = 51, .external_lex_state = 2},
  [263] = {.lex_state = 51, .external_lex_state = 2},
  [264] = {.lex_state = 51, .external_lex_state = 2},
  [265] = {.lex_state = 51, .external_lex_state = 2},
  [266] = {.lex_state = 51, .external_lex_state = 2},
  [267] = {.lex_state = 51, .external_lex_state = 2},
  [268] = {.lex_state = 51, .external_lex_state = 2},
  [269] = {.lex_state = 51, .external_lex_state = 2},
  [270] = {.lex_state = 51, .external_lex_state = 2},
  [271] = {.lex_state = 51, .external_lex_state = 2},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 56},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 57},
  [277] = {.lex_state = 57},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 57},
  [281] = {.lex_state = 57},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 57},
  [284] = {.lex_state = 57},
  [285] = {.lex_state = 57},
  [286] = {.lex_state = 57},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 57},
  [289] = {.lex_state = 57},
  [290] = {.lex_state = 57},
  [291] = {.lex_state = 57},
  [292] = {.lex_state = 57},
  [293] = {.lex_state = 57},
  [294] = {.lex_state = 57},
  [295] = {.lex_state = 57},
  [296] = {.lex_state = 57},
  [297] = {.lex_state = 57},
  [298] = {.lex_state = 57},
  [299] = {.lex_state = 57},
  [300] = {.lex_state = 57},
  [301] = {.lex_state = 57},
  [302] = {.lex_state = 57},
  [303] = {.lex_state = 57},
  [304] = {.lex_state = 57},
  [305] = {.lex_state = 57},
  [306] = {.lex_state = 57},
  [307] = {.lex_state = 57},
  [308] = {.lex_state = 57},
  [309] = {.lex_state = 57},
  [310] = {.lex_state = 57},
  [311] = {.lex_state = 57},
  [312] = {.lex_state = 57},
  [313] = {.lex_state = 57},
  [314] = {.lex_state = 57},
  [315] = {.lex_state = 57},
  [316] = {.lex_state = 57},
  [317] = {.lex_state = 57},
  [318] = {.lex_state = 57},
  [319] = {.lex_state = 57},
  [320] = {.lex_state = 57},
  [321] = {.lex_state = 57},
  [322] = {.lex_state = 57},
  [323] = {.lex_state = 57},
  [324] = {.lex_state = 57},
  [325] = {.lex_state = 57},
  [326] = {.lex_state = 57},
  [327] = {.lex_state = 57},
  [328] = {.lex_state = 57},
  [329] = {.lex_state = 57},
  [330] = {.lex_state = 57},
  [331] = {.lex_state = 51, .external_lex_state = 2},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 3},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 56},
  [359] = {.lex_state = 56},
  [360] = {.lex_state = 56},
  [361] = {.lex_state = 56},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 56},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 56},
  [367] = {.lex_state = 56},
  [368] = {.lex_state = 56},
  [369] = {.lex_state = 56},
  [370] = {.lex_state = 56},
  [371] = {.lex_state = 1},
  [372] = {.lex_state = 1, .external_lex_state = 4},
  [373] = {.lex_state = 1, .external_lex_state = 4},
  [374] = {.lex_state = 51, .external_lex_state = 5},
  [375] = {.lex_state = 1, .external_lex_state = 4},
  [376] = {.lex_state = 1},
  [377] = {.lex_state = 1, .external_lex_state = 4},
  [378] = {.lex_state = 51, .external_lex_state = 5},
  [379] = {.lex_state = 51, .external_lex_state = 5},
  [380] = {.lex_state = 51, .external_lex_state = 5},
  [381] = {.lex_state = 51, .external_lex_state = 5},
  [382] = {.lex_state = 1, .external_lex_state = 4},
  [383] = {.lex_state = 51, .external_lex_state = 5},
  [384] = {.lex_state = 1, .external_lex_state = 4},
  [385] = {.lex_state = 51},
  [386] = {.lex_state = 1, .external_lex_state = 4},
  [387] = {.lex_state = 1, .external_lex_state = 4},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 51, .external_lex_state = 5},
  [390] = {.lex_state = 51, .external_lex_state = 5},
  [391] = {.lex_state = 51, .external_lex_state = 5},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 51, .external_lex_state = 5},
  [395] = {.lex_state = 1, .external_lex_state = 4},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 51, .external_lex_state = 5},
  [398] = {.lex_state = 51, .external_lex_state = 5},
  [399] = {.lex_state = 51, .external_lex_state = 5},
  [400] = {.lex_state = 1},
  [401] = {.lex_state = 51, .external_lex_state = 5},
  [402] = {.lex_state = 51, .external_lex_state = 5},
  [403] = {.lex_state = 51, .external_lex_state = 5},
  [404] = {.lex_state = 51, .external_lex_state = 5},
  [405] = {.lex_state = 51, .external_lex_state = 5},
  [406] = {.lex_state = 51, .external_lex_state = 5},
  [407] = {.lex_state = 51, .external_lex_state = 5},
  [408] = {.lex_state = 51, .external_lex_state = 5},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 1},
  [412] = {.lex_state = 3},
  [413] = {.lex_state = 3},
  [414] = {.lex_state = 3},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 3},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 3},
  [421] = {.lex_state = 3},
  [422] = {.lex_state = 3},
  [423] = {.lex_state = 4},
  [424] = {.lex_state = 51, .external_lex_state = 5},
  [425] = {.lex_state = 1, .external_lex_state = 4},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 4},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 51},
  [432] = {.lex_state = 51},
  [433] = {.lex_state = 4},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 1},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 56},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 56},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 56},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 56},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 56},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 56},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 1},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 56},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 56},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 56},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 51},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 51},
  [527] = {.lex_state = 56},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 56},
  [530] = {.lex_state = 56},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
};

enum {
  ts_external_token_string_fragment = 0,
  ts_external_token__indented_string_fragment = 1,
  ts_external_token__path_start = 2,
  ts_external_token_path_fragment = 3,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_string_fragment] = sym_string_fragment,
  [ts_external_token__indented_string_fragment] = sym__indented_string_fragment,
  [ts_external_token__path_start] = sym__path_start,
  [ts_external_token_path_fragment] = sym_path_fragment,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_string_fragment] = true,
    [ts_external_token__indented_string_fragment] = true,
    [ts_external_token__path_start] = true,
    [ts_external_token_path_fragment] = true,
  },
  [2] = {
    [ts_external_token__path_start] = true,
  },
  [3] = {
    [ts_external_token__path_start] = true,
    [ts_external_token_path_fragment] = true,
  },
  [4] = {
    [ts_external_token__indented_string_fragment] = true,
  },
  [5] = {
    [ts_external_token_string_fragment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_integer_expression] = ACTIONS(1),
    [sym_float_expression] = ACTIONS(1),
    [sym__hpath_start] = ACTIONS(1),
    [sym_spath_expression] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_ellipses] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_rec] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(1),
    [sym__indented_escape_sequence] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_inherit] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE2] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_string_fragment] = ACTIONS(1),
    [sym__indented_string_fragment] = ACTIONS(1),
    [sym__path_start] = ACTIONS(1),
    [sym_path_fragment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_code] = STATE(532),
    [sym__expression] = STATE(531),
    [sym_variable_expression] = STATE(214),
    [sym_path_expression] = STATE(214),
    [sym_hpath_expression] = STATE(214),
    [sym__expr_function_expression] = STATE(367),
    [sym_function_expression] = STATE(367),
    [sym_formals] = STATE(438),
    [sym_assert_expression] = STATE(367),
    [sym_with_expression] = STATE(367),
    [sym_let_expression] = STATE(367),
    [sym__expr_if] = STATE(367),
    [sym_if_expression] = STATE(367),
    [sym__expr_op] = STATE(304),
    [sym_has_attr_expression] = STATE(304),
    [sym_unary_expression] = STATE(304),
    [sym_binary_expression] = STATE(304),
    [sym__expr_apply_expression] = STATE(78),
    [sym_apply_expression] = STATE(78),
    [sym__expr_select_expression] = STATE(78),
    [sym_select_expression] = STATE(78),
    [sym__expr_simple] = STATE(214),
    [sym_parenthesized_expression] = STATE(214),
    [sym_attrset_expression] = STATE(214),
    [sym_let_attrset_expression] = STATE(214),
    [sym_rec_attrset_expression] = STATE(214),
    [sym_string_expression] = STATE(214),
    [sym_indented_string_expression] = STATE(214),
    [sym_list_expression] = STATE(214),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_integer_expression] = ACTIONS(9),
    [sym_float_expression] = ACTIONS(11),
    [sym__hpath_start] = ACTIONS(13),
    [sym_spath_expression] = ACTIONS(11),
    [sym_uri_expression] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_let] = ACTIONS(21),
    [anon_sym_if] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(29),
    [anon_sym_rec] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [sym__path_start] = ACTIONS(39),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(439), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [97] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(505), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [194] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(359), 1,
      sym__expression,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [291] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    STATE(173), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(83), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
    ACTIONS(79), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [374] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(513), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [471] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(512), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [568] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(499), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [665] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(519), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [762] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    STATE(497), 1,
      sym__expression,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [859] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(496), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [956] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(481), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1053] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    STATE(530), 1,
      sym__expression,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1150] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    STATE(529), 1,
      sym__expression,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1247] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(528), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1344] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(521), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1441] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    STATE(527), 1,
      sym__expression,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1538] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(482), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1635] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(518), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1732] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(479), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1829] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(525), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1926] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    STATE(508), 1,
      sym__expression,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2023] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(359), 1,
      sym__expression,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2120] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(359), 1,
      sym__expression,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2217] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(464), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2314] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(493), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2411] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(359), 1,
      sym__expression,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2508] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(476), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2605] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(467), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2702] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(475), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2799] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(491), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2896] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    STATE(472), 1,
      sym__expression,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2993] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(498), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3090] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(487), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3187] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(468), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3284] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(465), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3381] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(463), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3478] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(459), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3575] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(458), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3672] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    STATE(480), 1,
      sym__expression,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3769] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    STATE(454), 1,
      sym__expression,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3866] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(509), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3963] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    STATE(486), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(367), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4060] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(369), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4154] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(369), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4248] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4342] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(368), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4436] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(368), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4530] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(360), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4624] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(370), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4718] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(364), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4812] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(369), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4906] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(368), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5000] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(369), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5094] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5188] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(370), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5282] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5376] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(360), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5470] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(361), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5564] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(360), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5658] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(361), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5752] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5846] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5940] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(370), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6034] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(368), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6128] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6222] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(364), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6316] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(370), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6410] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6504] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(360), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6598] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    ACTIONS(129), 1,
      anon_sym_assert,
    ACTIONS(131), 1,
      anon_sym_with,
    ACTIONS(133), 1,
      anon_sym_let,
    ACTIONS(135), 1,
      anon_sym_if,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    STATE(447), 1,
      sym_formals,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(364), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6692] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(366), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6786] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(437), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(289), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(361), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6880] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      sym_identifier,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_assert,
    ACTIONS(97), 1,
      anon_sym_with,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    STATE(450), 1,
      sym_formals,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(364), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6974] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(361), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7068] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    STATE(257), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(83), 6,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(79), 11,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7148] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    STATE(254), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(83), 6,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(79), 11,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7228] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    STATE(253), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(83), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
    ACTIONS(79), 12,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [7308] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(177), 1,
      sym_path_fragment,
    STATE(81), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7364] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(177), 1,
      sym_path_fragment,
    STATE(81), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7420] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(190), 1,
      sym_path_fragment,
    STATE(81), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7476] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(197), 1,
      sym_path_fragment,
    STATE(79), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7532] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(203), 1,
      sym_path_fragment,
    STATE(80), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 28,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7634] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_DOT,
    STATE(87), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7684] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_DOT,
    STATE(86), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7734] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_DOT,
    STATE(86), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(222), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(224), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(228), 28,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7830] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      anon_sym_COLON,
    ACTIONS(236), 1,
      anon_sym_AT,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [7879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(240), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(244), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(248), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(252), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8059] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(254), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(262), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8150] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(266), 1,
      sym_path_fragment,
    STATE(104), 1,
      aux_sym_path_expression_repeat1,
    STATE(186), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8202] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(270), 1,
      sym_path_fragment,
    STATE(122), 1,
      aux_sym_path_expression_repeat1,
    STATE(192), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8254] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(272), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(275), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(192), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8306] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(281), 1,
      sym_path_fragment,
    STATE(99), 1,
      aux_sym_path_expression_repeat1,
    STATE(186), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8358] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(286), 1,
      sym_path_fragment,
    STATE(110), 1,
      aux_sym_path_expression_repeat1,
    STATE(174), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8410] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 1,
      anon_sym_DOT,
    ACTIONS(288), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(290), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(296), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8500] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(298), 1,
      sym_path_fragment,
    STATE(111), 1,
      aux_sym_path_expression_repeat1,
    STATE(174), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8552] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(300), 1,
      sym_path_fragment,
    STATE(99), 1,
      aux_sym_path_expression_repeat1,
    STATE(186), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8604] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(300), 1,
      sym_path_fragment,
    STATE(99), 1,
      aux_sym_path_expression_repeat1,
    STATE(186), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(304), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8744] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(306), 1,
      sym_path_fragment,
    STATE(121), 1,
      aux_sym_path_expression_repeat1,
    STATE(192), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(310), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8840] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(312), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(174), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8892] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(312), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(174), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8944] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(314), 1,
      sym_path_fragment,
    STATE(105), 1,
      aux_sym_path_expression_repeat1,
    STATE(186), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8996] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(318), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(322), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(330), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(240), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(252), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9348] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(336), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(192), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9400] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(336), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(192), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9452] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(340), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9496] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(345), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(174), 1,
      sym__immediate_interpolation,
    ACTIONS(183), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(185), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9548] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(352), 1,
      anon_sym_or,
    ACTIONS(348), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(350), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9594] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(324), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9667] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(316), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9740] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(311), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9813] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(296), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9886] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(312), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9959] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10032] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(299), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10105] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(321), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10178] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(323), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10251] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(325), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10324] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(295), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10397] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(309), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10470] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(294), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10543] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(307), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10616] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(293), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10689] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(292), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10762] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(291), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10835] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10908] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(317), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [11024] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(276), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11097] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(288), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11170] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(287), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11243] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(276), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11316] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(303), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11389] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11462] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(276), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11535] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(298), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11608] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(305), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11681] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(306), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11754] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(302), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11827] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(301), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11900] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11973] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12046] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(327), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12119] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(328), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12192] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12265] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(319), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12338] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(314), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12411] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(137), 1,
      anon_sym_BANG,
    ACTIONS(139), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(310), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12484] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(320), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12557] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(297), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12630] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(5), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(276), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12703] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(330), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12776] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(103), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(322), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12849] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(254), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [12893] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_DOT,
    STATE(188), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [12939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(362), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [12981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13023] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(364), 1,
      anon_sym_DOT,
    STATE(175), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(228), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13111] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 1,
      anon_sym_DOT,
    STATE(177), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13157] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_DOT,
    STATE(177), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(222), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(224), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13203] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 1,
      anon_sym_DOT,
    STATE(184), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(222), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(224), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13249] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 1,
      anon_sym_DOT,
    STATE(179), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13295] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(254), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13339] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(376), 1,
      anon_sym_AT,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(228), 24,
      sym__path_start,
      sym_path_fragment,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13427] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_DOT,
    STATE(184), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(217), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13473] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 1,
      anon_sym_COLON,
    ACTIONS(383), 1,
      anon_sym_AT,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13561] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_COLON,
    ACTIONS(387), 1,
      anon_sym_AT,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13607] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_DOT,
    STATE(175), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(222), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(224), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13653] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(254), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(228), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13739] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_DOT,
    STATE(178), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 24,
      sym__path_start,
      sym_path_fragment,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(244), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(244), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(244), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(252), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(240), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(240), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(240), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(248), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(252), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(248), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14237] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(252), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(248), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(322), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(310), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(252), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(330), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(240), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(262), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(304), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14639] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_or,
    ACTIONS(348), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(350), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14681] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      anon_sym_DOT,
    ACTIONS(288), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(290), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(304), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(330), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(252), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(296), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14963] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(340), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(340), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(240), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(304), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(330), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15163] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      anon_sym_or,
    ACTIONS(348), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(350), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(318), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(240), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(318), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(296), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15525] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(262), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(310), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(296), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(340), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(256), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15765] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(252), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15845] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 1,
      anon_sym_DOT,
    ACTIONS(288), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(290), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(322), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15967] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 1,
      anon_sym_or,
    ACTIONS(348), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(350), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(262), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(318), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(322), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16169] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DOT,
    ACTIONS(288), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(290), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(310), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(362), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(362), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16368] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(362), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16485] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(401), 1,
      anon_sym_RBRACK,
    STATE(267), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16550] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(403), 1,
      anon_sym_RBRACK,
    STATE(264), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16615] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(405), 1,
      anon_sym_RBRACK,
    STATE(263), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16680] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(407), 1,
      anon_sym_RBRACK,
    STATE(265), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16745] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(409), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16810] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(411), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16875] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(413), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16940] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 1,
      sym_identifier,
    ACTIONS(418), 1,
      sym_integer_expression,
    ACTIONS(424), 1,
      sym__hpath_start,
    ACTIONS(427), 1,
      anon_sym_LBRACE,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(433), 1,
      anon_sym_LPAREN,
    ACTIONS(436), 1,
      anon_sym_rec,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(445), 1,
      anon_sym_LBRACK,
    ACTIONS(448), 1,
      anon_sym_RBRACK,
    ACTIONS(450), 1,
      sym__path_start,
    STATE(266), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(421), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17005] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    ACTIONS(453), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_expression_repeat1,
    STATE(331), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17070] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_integer_expression,
    ACTIONS(125), 1,
      sym__hpath_start,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_rec,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    STATE(258), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(123), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17129] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 1,
      sym_integer_expression,
    ACTIONS(91), 1,
      sym__hpath_start,
    ACTIONS(107), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_rec,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    STATE(256), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(89), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(251), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17188] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    STATE(255), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(214), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17247] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_let,
    STATE(145), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(101), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(240), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(248), 19,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
  [17372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(252), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(244), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(455), 18,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(459), 18,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17500] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(222), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(224), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17535] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(217), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17570] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 1,
      anon_sym_DOT,
    STATE(278), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(211), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17604] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(283), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(222), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(224), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17637] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(281), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(211), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17670] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_DOT,
    STATE(283), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(215), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(217), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(240), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(252), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(244), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17787] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [17823] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(487), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(489), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 9,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [17865] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(499), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 1,
      anon_sym_DASH_GT,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(487), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(489), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(493), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [17915] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [17955] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(487), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(489), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [17999] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(487), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(489), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 6,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18045] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18077] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(499), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 1,
      anon_sym_DASH_GT,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(487), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(489), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [18127] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18167] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18199] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(479), 1,
      anon_sym_STAR,
    ACTIONS(481), 1,
      anon_sym_SLASH,
    ACTIONS(483), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(457), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(485), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(455), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18237] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(509), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18276] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(521), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      anon_sym_then,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18317] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18354] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18393] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18426] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18459] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      ts_builtin_sym_end,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(555), 1,
      anon_sym_DASH_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(509), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(549), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18506] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18543] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(509), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(549), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18584] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(457), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(455), 9,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18619] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(559), 1,
      anon_sym_AMP_AMP,
    ACTIONS(561), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(563), 1,
      anon_sym_DASH_GT,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(557), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18666] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18695] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18732] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_then,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(567), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(569), 1,
      anon_sym_DASH_GT,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(521), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18779] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18808] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(521), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 3,
      anon_sym_then,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18851] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(559), 1,
      anon_sym_AMP_AMP,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(557), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 3,
      anon_sym_else,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18894] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_then,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(567), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(569), 1,
      anon_sym_DASH_GT,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(521), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18941] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18970] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(457), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(455), 9,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19005] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(457), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(455), 9,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19040] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(557), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 4,
      anon_sym_else,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19081] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(559), 1,
      anon_sym_AMP_AMP,
    ACTIONS(561), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(563), 1,
      anon_sym_DASH_GT,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(557), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19128] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19165] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19194] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(519), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(523), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(525), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19233] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(537), 1,
      anon_sym_STAR,
    ACTIONS(539), 1,
      anon_sym_SLASH,
    ACTIONS(541), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(543), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(535), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19270] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(527), 1,
      anon_sym_STAR,
    ACTIONS(529), 1,
      anon_sym_SLASH,
    ACTIONS(533), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19303] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(509), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(549), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 3,
      ts_builtin_sym_end,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19346] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19375] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      ts_builtin_sym_end,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(555), 1,
      anon_sym_DASH_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(509), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(549), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19422] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(505), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19459] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(517), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 4,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_rec,
    ACTIONS(573), 11,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [19511] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
    ACTIONS(579), 1,
      sym_ellipses,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(427), 1,
      sym_formal,
    STATE(473), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19554] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_ellipses,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(587), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(427), 1,
      sym_formal,
    STATE(514), 1,
      sym_attrpath,
    STATE(517), 1,
      sym_binding_set,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19597] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_ellipses,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(427), 1,
      sym_formal,
    STATE(514), 1,
      sym_attrpath,
    STATE(523), 1,
      sym_binding_set,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19640] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_ellipses,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(427), 1,
      sym_formal,
    STATE(457), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19683] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(595), 1,
      anon_sym_LBRACE,
    ACTIONS(597), 1,
      anon_sym_in,
    ACTIONS(599), 1,
      anon_sym_inherit,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(484), 1,
      sym_binding_set,
    STATE(526), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19723] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
    ACTIONS(603), 1,
      anon_sym_in,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(504), 1,
      sym_binding_set,
    STATE(526), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19763] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    ACTIONS(607), 1,
      anon_sym_in,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(510), 1,
      sym_binding_set,
    STATE(526), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19803] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(609), 1,
      anon_sym_LBRACE,
    ACTIONS(611), 1,
      anon_sym_in,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(461), 1,
      sym_binding_set,
    STATE(526), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19843] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(613), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(457), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19880] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(615), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(469), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19917] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(617), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(451), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19954] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(619), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(473), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19991] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(621), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(492), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20028] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(623), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(460), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20065] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(625), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(514), 1,
      sym_attrpath,
    STATE(523), 1,
      sym_binding_set,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20102] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(627), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(514), 1,
      sym_attrpath,
    STATE(517), 1,
      sym_binding_set,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20139] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(629), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(470), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20176] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(631), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(485), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20213] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(500), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20250] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(635), 1,
      anon_sym_RBRACE,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(456), 1,
      sym_binding_set,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20287] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(637), 1,
      anon_sym_in,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(526), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20321] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(642), 1,
      anon_sym_in,
    ACTIONS(644), 1,
      anon_sym_DQUOTE,
    ACTIONS(647), 1,
      anon_sym_inherit,
    ACTIONS(650), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(526), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20355] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(644), 1,
      anon_sym_DQUOTE,
    ACTIONS(650), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(653), 1,
      anon_sym_RBRACE,
    ACTIONS(655), 1,
      anon_sym_inherit,
    STATE(354), 1,
      aux_sym_binding_set_repeat1,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20389] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_inherit,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(658), 1,
      anon_sym_RBRACE,
    STATE(354), 1,
      aux_sym_binding_set_repeat1,
    STATE(514), 1,
      sym_attrpath,
    STATE(431), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(420), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20423] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    STATE(363), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(489), 1,
      sym_inherited_attrs,
    STATE(426), 2,
      sym_string_expression,
      sym_interpolation,
  [20449] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(664), 1,
      anon_sym_LPAREN,
    STATE(363), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(488), 1,
      sym_inherited_attrs,
    STATE(426), 2,
      sym_string_expression,
      sym_interpolation,
  [20475] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20488] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20514] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20527] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    STATE(363), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(478), 1,
      sym_inherited_attrs,
    STATE(426), 2,
      sym_string_expression,
      sym_interpolation,
  [20550] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(674), 1,
      anon_sym_SEMI,
    STATE(371), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(426), 2,
      sym_string_expression,
      sym_interpolation,
  [20573] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20586] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    STATE(363), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(533), 1,
      sym_inherited_attrs,
    STATE(426), 2,
      sym_string_expression,
      sym_interpolation,
  [20609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20622] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20648] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20661] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20674] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      sym_identifier,
    ACTIONS(691), 1,
      anon_sym_SEMI,
    ACTIONS(693), 1,
      anon_sym_DQUOTE,
    ACTIONS(696), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(371), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(426), 2,
      sym_string_expression,
      sym_interpolation,
  [20697] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(701), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(375), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20715] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(705), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(701), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(375), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20733] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(709), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(379), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20751] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(713), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(718), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(715), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(375), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20769] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      sym_identifier,
    ACTIONS(723), 1,
      anon_sym_DQUOTE,
    ACTIONS(725), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(226), 1,
      sym_attrpath,
    STATE(180), 2,
      sym_string_expression,
      sym_interpolation,
  [20789] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(727), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(701), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(375), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20807] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(729), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20825] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20843] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_DQUOTE,
    ACTIONS(740), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(737), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20861] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(743), 1,
      anon_sym_DQUOTE,
    ACTIONS(745), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(397), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20879] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(747), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(749), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(372), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20897] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(751), 1,
      anon_sym_DQUOTE,
    ACTIONS(753), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(390), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20915] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(755), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(757), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(373), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20933] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(463), 1,
      anon_sym_DOT,
    ACTIONS(761), 1,
      anon_sym_QMARK,
    STATE(278), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(759), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [20953] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(763), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(765), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(387), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20971] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(767), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(701), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(375), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20989] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym_identifier,
    ACTIONS(771), 1,
      anon_sym_DQUOTE,
    ACTIONS(773), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(246), 1,
      sym_attrpath,
    STATE(191), 2,
      sym_string_expression,
      sym_interpolation,
  [21009] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(775), 1,
      anon_sym_DQUOTE,
    ACTIONS(777), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(394), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21027] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(779), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21045] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(781), 1,
      anon_sym_DQUOTE,
    ACTIONS(783), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(408), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21063] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_identifier,
    ACTIONS(787), 1,
      anon_sym_DQUOTE,
    ACTIONS(789), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(277), 1,
      sym_attrpath,
    STATE(282), 2,
      sym_string_expression,
      sym_interpolation,
  [21083] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 1,
      sym_identifier,
    ACTIONS(793), 1,
      anon_sym_DQUOTE,
    ACTIONS(795), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(213), 1,
      sym_attrpath,
    STATE(172), 2,
      sym_string_expression,
      sym_interpolation,
  [21103] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(797), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21121] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(799), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(801), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(377), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21139] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(803), 1,
      sym_identifier,
    STATE(277), 1,
      sym_attrpath,
    STATE(280), 2,
      sym_string_expression,
      sym_interpolation,
  [21159] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(805), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21177] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(378), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21195] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(811), 1,
      anon_sym_DQUOTE,
    ACTIONS(813), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(401), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21213] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 1,
      sym_identifier,
    ACTIONS(817), 1,
      anon_sym_DQUOTE,
    ACTIONS(819), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(125), 1,
      sym_attrpath,
    STATE(85), 2,
      sym_string_expression,
      sym_interpolation,
  [21233] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(821), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21251] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(823), 1,
      anon_sym_DQUOTE,
    ACTIONS(825), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(403), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21269] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(827), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21287] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(829), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21305] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(831), 1,
      anon_sym_DQUOTE,
    ACTIONS(833), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(404), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21323] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(835), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21341] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(837), 1,
      anon_sym_DQUOTE,
    ACTIONS(839), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(406), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21359] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(841), 1,
      anon_sym_DQUOTE,
    ACTIONS(731), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21377] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 1,
      anon_sym_DQUOTE,
    ACTIONS(795), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(843), 1,
      sym_identifier,
    STATE(204), 2,
      sym_string_expression,
      sym_interpolation,
  [21394] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(847), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21407] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 1,
      anon_sym_DQUOTE,
    ACTIONS(819), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(849), 1,
      sym_identifier,
    STATE(92), 2,
      sym_string_expression,
      sym_interpolation,
  [21424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(851), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21437] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(855), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(845), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21463] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(859), 1,
      sym_identifier,
    STATE(273), 2,
      sym_string_expression,
      sym_interpolation,
  [21480] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(771), 1,
      anon_sym_DQUOTE,
    ACTIONS(773), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(202), 2,
      sym_string_expression,
      sym_interpolation,
  [21497] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 1,
      anon_sym_DQUOTE,
    ACTIONS(789), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(859), 1,
      sym_identifier,
    STATE(273), 2,
      sym_string_expression,
      sym_interpolation,
  [21514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(865), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(863), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21527] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 1,
      anon_sym_DQUOTE,
    ACTIONS(725), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(867), 1,
      sym_identifier,
    STATE(200), 2,
      sym_string_expression,
      sym_interpolation,
  [21544] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(865), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(853), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(857), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21583] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 1,
      sym_ellipses,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(871), 1,
      anon_sym_RBRACE,
    STATE(427), 1,
      sym_formal,
  [21599] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 4,
      sym_string_fragment,
      anon_sym_DQUOTE,
      sym_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(244), 3,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21621] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 4,
      sym_identifier,
      anon_sym_SEMI,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21631] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_RBRACE,
    ACTIONS(877), 1,
      anon_sym_COMMA,
    STATE(430), 1,
      aux_sym_formals_repeat1,
  [21644] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 1,
      anon_sym_RBRACE,
    ACTIONS(881), 1,
      anon_sym_COMMA,
    STATE(428), 1,
      aux_sym_formals_repeat1,
  [21657] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(884), 1,
      sym_ellipses,
    STATE(446), 1,
      sym_formal,
  [21670] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 1,
      anon_sym_RBRACE,
    ACTIONS(888), 1,
      anon_sym_COMMA,
    STATE(428), 1,
      aux_sym_formals_repeat1,
  [21683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(463), 1,
      anon_sym_DOT,
    STATE(432), 1,
      aux_sym_attrpath_repeat1,
  [21696] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(224), 1,
      anon_sym_EQ,
    ACTIONS(463), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_attrpath_repeat1,
  [21709] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(890), 1,
      sym_ellipses,
    STATE(446), 1,
      sym_formal,
  [21722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_QMARK,
    ACTIONS(759), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21733] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 1,
      anon_sym_LBRACE,
    STATE(452), 1,
      sym_formals,
  [21743] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21751] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 1,
      anon_sym_COLON,
    ACTIONS(898), 1,
      anon_sym_AT,
  [21761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 1,
      anon_sym_COLON,
    ACTIONS(902), 1,
      anon_sym_AT,
  [21771] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 1,
      anon_sym_LBRACE,
    STATE(494), 1,
      sym_formals,
  [21789] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 1,
      anon_sym_LBRACE,
    STATE(466), 1,
      sym_formals,
  [21799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 1,
      sym_identifier,
    STATE(446), 1,
      sym_formal,
  [21809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 1,
      anon_sym_LBRACE,
    STATE(515), 1,
      sym_formals,
  [21819] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21827] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 1,
      anon_sym_COLON,
    ACTIONS(914), 1,
      anon_sym_AT,
  [21853] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 1,
      anon_sym_COLON,
    ACTIONS(922), 1,
      anon_sym_AT,
  [21879] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_RBRACE,
  [21886] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 1,
      anon_sym_COLON,
  [21893] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_COLON,
  [21900] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 1,
      anon_sym_else,
  [21907] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_COLON,
  [21914] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
  [21921] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_RBRACE,
  [21928] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 1,
      anon_sym_SEMI,
  [21935] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 1,
      anon_sym_SEMI,
  [21942] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 1,
      anon_sym_RBRACE,
  [21949] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_in,
  [21956] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      anon_sym_LBRACE,
  [21963] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 1,
      anon_sym_RPAREN,
  [21970] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 1,
      anon_sym_SEMI,
  [21977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 1,
      anon_sym_RBRACE,
  [21984] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_COLON,
  [21991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_SEMI,
  [21998] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_RBRACE,
  [22005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_RBRACE,
  [22012] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 1,
      anon_sym_RBRACE,
  [22019] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      anon_sym_COLON,
  [22026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 1,
      anon_sym_else,
  [22033] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_RBRACE,
  [22040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 1,
      anon_sym_RBRACE,
  [22047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_RBRACE,
  [22054] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_RBRACE,
  [22061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LBRACE,
  [22068] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 1,
      anon_sym_SEMI,
  [22075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_RBRACE,
  [22082] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      anon_sym_else,
  [22089] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_SEMI,
  [22096] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      anon_sym_RBRACE,
  [22103] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 1,
      anon_sym_COLON,
  [22110] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_in,
  [22117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_RBRACE,
  [22124] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_RBRACE,
  [22131] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_RBRACE,
  [22138] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      anon_sym_SEMI,
  [22145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_SEMI,
  [22152] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_LBRACE,
  [22159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
  [22166] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      anon_sym_RBRACE,
  [22173] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_RBRACE,
  [22180] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      anon_sym_COLON,
  [22187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      sym_identifier,
  [22194] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_SEMI,
  [22201] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_else,
  [22208] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      anon_sym_RPAREN,
  [22215] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 1,
      anon_sym_RBRACE,
  [22222] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      anon_sym_RBRACE,
  [22229] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
  [22236] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      sym_identifier,
  [22243] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_RBRACE,
  [22250] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_in,
  [22257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_RPAREN,
  [22264] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
  [22271] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
  [22278] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      anon_sym_then,
  [22285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_RBRACE,
  [22292] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      anon_sym_in,
  [22299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 1,
      sym_identifier,
  [22306] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
  [22313] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      anon_sym_SEMI,
  [22320] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      anon_sym_EQ,
  [22327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 1,
      anon_sym_COLON,
  [22334] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
  [22341] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_RBRACE,
  [22348] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      anon_sym_RBRACE,
  [22355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 1,
      anon_sym_SEMI,
  [22362] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      sym_identifier,
  [22369] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 1,
      anon_sym_SEMI,
  [22376] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      anon_sym_RBRACE,
  [22383] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 1,
      anon_sym_RBRACE,
  [22390] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 1,
      anon_sym_COLON,
  [22397] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      anon_sym_RPAREN,
  [22404] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      anon_sym_EQ,
  [22411] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      anon_sym_then,
  [22418] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      anon_sym_RPAREN,
  [22425] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 1,
      anon_sym_then,
  [22432] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_then,
  [22439] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      ts_builtin_sym_end,
  [22446] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 1,
      ts_builtin_sym_end,
  [22453] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      anon_sym_SEMI,
  [22460] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      anon_sym_LBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 97,
  [SMALL_STATE(4)] = 194,
  [SMALL_STATE(5)] = 291,
  [SMALL_STATE(6)] = 374,
  [SMALL_STATE(7)] = 471,
  [SMALL_STATE(8)] = 568,
  [SMALL_STATE(9)] = 665,
  [SMALL_STATE(10)] = 762,
  [SMALL_STATE(11)] = 859,
  [SMALL_STATE(12)] = 956,
  [SMALL_STATE(13)] = 1053,
  [SMALL_STATE(14)] = 1150,
  [SMALL_STATE(15)] = 1247,
  [SMALL_STATE(16)] = 1344,
  [SMALL_STATE(17)] = 1441,
  [SMALL_STATE(18)] = 1538,
  [SMALL_STATE(19)] = 1635,
  [SMALL_STATE(20)] = 1732,
  [SMALL_STATE(21)] = 1829,
  [SMALL_STATE(22)] = 1926,
  [SMALL_STATE(23)] = 2023,
  [SMALL_STATE(24)] = 2120,
  [SMALL_STATE(25)] = 2217,
  [SMALL_STATE(26)] = 2314,
  [SMALL_STATE(27)] = 2411,
  [SMALL_STATE(28)] = 2508,
  [SMALL_STATE(29)] = 2605,
  [SMALL_STATE(30)] = 2702,
  [SMALL_STATE(31)] = 2799,
  [SMALL_STATE(32)] = 2896,
  [SMALL_STATE(33)] = 2993,
  [SMALL_STATE(34)] = 3090,
  [SMALL_STATE(35)] = 3187,
  [SMALL_STATE(36)] = 3284,
  [SMALL_STATE(37)] = 3381,
  [SMALL_STATE(38)] = 3478,
  [SMALL_STATE(39)] = 3575,
  [SMALL_STATE(40)] = 3672,
  [SMALL_STATE(41)] = 3769,
  [SMALL_STATE(42)] = 3866,
  [SMALL_STATE(43)] = 3963,
  [SMALL_STATE(44)] = 4060,
  [SMALL_STATE(45)] = 4154,
  [SMALL_STATE(46)] = 4248,
  [SMALL_STATE(47)] = 4342,
  [SMALL_STATE(48)] = 4436,
  [SMALL_STATE(49)] = 4530,
  [SMALL_STATE(50)] = 4624,
  [SMALL_STATE(51)] = 4718,
  [SMALL_STATE(52)] = 4812,
  [SMALL_STATE(53)] = 4906,
  [SMALL_STATE(54)] = 5000,
  [SMALL_STATE(55)] = 5094,
  [SMALL_STATE(56)] = 5188,
  [SMALL_STATE(57)] = 5282,
  [SMALL_STATE(58)] = 5376,
  [SMALL_STATE(59)] = 5470,
  [SMALL_STATE(60)] = 5564,
  [SMALL_STATE(61)] = 5658,
  [SMALL_STATE(62)] = 5752,
  [SMALL_STATE(63)] = 5846,
  [SMALL_STATE(64)] = 5940,
  [SMALL_STATE(65)] = 6034,
  [SMALL_STATE(66)] = 6128,
  [SMALL_STATE(67)] = 6222,
  [SMALL_STATE(68)] = 6316,
  [SMALL_STATE(69)] = 6410,
  [SMALL_STATE(70)] = 6504,
  [SMALL_STATE(71)] = 6598,
  [SMALL_STATE(72)] = 6692,
  [SMALL_STATE(73)] = 6786,
  [SMALL_STATE(74)] = 6880,
  [SMALL_STATE(75)] = 6974,
  [SMALL_STATE(76)] = 7068,
  [SMALL_STATE(77)] = 7148,
  [SMALL_STATE(78)] = 7228,
  [SMALL_STATE(79)] = 7308,
  [SMALL_STATE(80)] = 7364,
  [SMALL_STATE(81)] = 7420,
  [SMALL_STATE(82)] = 7476,
  [SMALL_STATE(83)] = 7532,
  [SMALL_STATE(84)] = 7588,
  [SMALL_STATE(85)] = 7634,
  [SMALL_STATE(86)] = 7684,
  [SMALL_STATE(87)] = 7734,
  [SMALL_STATE(88)] = 7784,
  [SMALL_STATE(89)] = 7830,
  [SMALL_STATE(90)] = 7879,
  [SMALL_STATE(91)] = 7924,
  [SMALL_STATE(92)] = 7969,
  [SMALL_STATE(93)] = 8014,
  [SMALL_STATE(94)] = 8059,
  [SMALL_STATE(95)] = 8106,
  [SMALL_STATE(96)] = 8150,
  [SMALL_STATE(97)] = 8202,
  [SMALL_STATE(98)] = 8254,
  [SMALL_STATE(99)] = 8306,
  [SMALL_STATE(100)] = 8358,
  [SMALL_STATE(101)] = 8410,
  [SMALL_STATE(102)] = 8456,
  [SMALL_STATE(103)] = 8500,
  [SMALL_STATE(104)] = 8552,
  [SMALL_STATE(105)] = 8604,
  [SMALL_STATE(106)] = 8656,
  [SMALL_STATE(107)] = 8700,
  [SMALL_STATE(108)] = 8744,
  [SMALL_STATE(109)] = 8796,
  [SMALL_STATE(110)] = 8840,
  [SMALL_STATE(111)] = 8892,
  [SMALL_STATE(112)] = 8944,
  [SMALL_STATE(113)] = 8996,
  [SMALL_STATE(114)] = 9040,
  [SMALL_STATE(115)] = 9084,
  [SMALL_STATE(116)] = 9128,
  [SMALL_STATE(117)] = 9172,
  [SMALL_STATE(118)] = 9216,
  [SMALL_STATE(119)] = 9260,
  [SMALL_STATE(120)] = 9304,
  [SMALL_STATE(121)] = 9348,
  [SMALL_STATE(122)] = 9400,
  [SMALL_STATE(123)] = 9452,
  [SMALL_STATE(124)] = 9496,
  [SMALL_STATE(125)] = 9548,
  [SMALL_STATE(126)] = 9594,
  [SMALL_STATE(127)] = 9667,
  [SMALL_STATE(128)] = 9740,
  [SMALL_STATE(129)] = 9813,
  [SMALL_STATE(130)] = 9886,
  [SMALL_STATE(131)] = 9959,
  [SMALL_STATE(132)] = 10032,
  [SMALL_STATE(133)] = 10105,
  [SMALL_STATE(134)] = 10178,
  [SMALL_STATE(135)] = 10251,
  [SMALL_STATE(136)] = 10324,
  [SMALL_STATE(137)] = 10397,
  [SMALL_STATE(138)] = 10470,
  [SMALL_STATE(139)] = 10543,
  [SMALL_STATE(140)] = 10616,
  [SMALL_STATE(141)] = 10689,
  [SMALL_STATE(142)] = 10762,
  [SMALL_STATE(143)] = 10835,
  [SMALL_STATE(144)] = 10908,
  [SMALL_STATE(145)] = 10981,
  [SMALL_STATE(146)] = 11024,
  [SMALL_STATE(147)] = 11097,
  [SMALL_STATE(148)] = 11170,
  [SMALL_STATE(149)] = 11243,
  [SMALL_STATE(150)] = 11316,
  [SMALL_STATE(151)] = 11389,
  [SMALL_STATE(152)] = 11462,
  [SMALL_STATE(153)] = 11535,
  [SMALL_STATE(154)] = 11608,
  [SMALL_STATE(155)] = 11681,
  [SMALL_STATE(156)] = 11754,
  [SMALL_STATE(157)] = 11827,
  [SMALL_STATE(158)] = 11900,
  [SMALL_STATE(159)] = 11973,
  [SMALL_STATE(160)] = 12046,
  [SMALL_STATE(161)] = 12119,
  [SMALL_STATE(162)] = 12192,
  [SMALL_STATE(163)] = 12265,
  [SMALL_STATE(164)] = 12338,
  [SMALL_STATE(165)] = 12411,
  [SMALL_STATE(166)] = 12484,
  [SMALL_STATE(167)] = 12557,
  [SMALL_STATE(168)] = 12630,
  [SMALL_STATE(169)] = 12703,
  [SMALL_STATE(170)] = 12776,
  [SMALL_STATE(171)] = 12849,
  [SMALL_STATE(172)] = 12893,
  [SMALL_STATE(173)] = 12939,
  [SMALL_STATE(174)] = 12981,
  [SMALL_STATE(175)] = 13023,
  [SMALL_STATE(176)] = 13069,
  [SMALL_STATE(177)] = 13111,
  [SMALL_STATE(178)] = 13157,
  [SMALL_STATE(179)] = 13203,
  [SMALL_STATE(180)] = 13249,
  [SMALL_STATE(181)] = 13295,
  [SMALL_STATE(182)] = 13339,
  [SMALL_STATE(183)] = 13385,
  [SMALL_STATE(184)] = 13427,
  [SMALL_STATE(185)] = 13473,
  [SMALL_STATE(186)] = 13519,
  [SMALL_STATE(187)] = 13561,
  [SMALL_STATE(188)] = 13607,
  [SMALL_STATE(189)] = 13653,
  [SMALL_STATE(190)] = 13697,
  [SMALL_STATE(191)] = 13739,
  [SMALL_STATE(192)] = 13785,
  [SMALL_STATE(193)] = 13827,
  [SMALL_STATE(194)] = 13868,
  [SMALL_STATE(195)] = 13909,
  [SMALL_STATE(196)] = 13950,
  [SMALL_STATE(197)] = 13991,
  [SMALL_STATE(198)] = 14032,
  [SMALL_STATE(199)] = 14073,
  [SMALL_STATE(200)] = 14114,
  [SMALL_STATE(201)] = 14155,
  [SMALL_STATE(202)] = 14196,
  [SMALL_STATE(203)] = 14237,
  [SMALL_STATE(204)] = 14278,
  [SMALL_STATE(205)] = 14319,
  [SMALL_STATE(206)] = 14359,
  [SMALL_STATE(207)] = 14399,
  [SMALL_STATE(208)] = 14439,
  [SMALL_STATE(209)] = 14479,
  [SMALL_STATE(210)] = 14519,
  [SMALL_STATE(211)] = 14559,
  [SMALL_STATE(212)] = 14599,
  [SMALL_STATE(213)] = 14639,
  [SMALL_STATE(214)] = 14681,
  [SMALL_STATE(215)] = 14723,
  [SMALL_STATE(216)] = 14763,
  [SMALL_STATE(217)] = 14803,
  [SMALL_STATE(218)] = 14843,
  [SMALL_STATE(219)] = 14883,
  [SMALL_STATE(220)] = 14923,
  [SMALL_STATE(221)] = 14963,
  [SMALL_STATE(222)] = 15003,
  [SMALL_STATE(223)] = 15043,
  [SMALL_STATE(224)] = 15083,
  [SMALL_STATE(225)] = 15123,
  [SMALL_STATE(226)] = 15163,
  [SMALL_STATE(227)] = 15205,
  [SMALL_STATE(228)] = 15245,
  [SMALL_STATE(229)] = 15285,
  [SMALL_STATE(230)] = 15325,
  [SMALL_STATE(231)] = 15365,
  [SMALL_STATE(232)] = 15405,
  [SMALL_STATE(233)] = 15445,
  [SMALL_STATE(234)] = 15485,
  [SMALL_STATE(235)] = 15525,
  [SMALL_STATE(236)] = 15565,
  [SMALL_STATE(237)] = 15605,
  [SMALL_STATE(238)] = 15645,
  [SMALL_STATE(239)] = 15685,
  [SMALL_STATE(240)] = 15725,
  [SMALL_STATE(241)] = 15765,
  [SMALL_STATE(242)] = 15805,
  [SMALL_STATE(243)] = 15845,
  [SMALL_STATE(244)] = 15887,
  [SMALL_STATE(245)] = 15927,
  [SMALL_STATE(246)] = 15967,
  [SMALL_STATE(247)] = 16009,
  [SMALL_STATE(248)] = 16049,
  [SMALL_STATE(249)] = 16089,
  [SMALL_STATE(250)] = 16129,
  [SMALL_STATE(251)] = 16169,
  [SMALL_STATE(252)] = 16211,
  [SMALL_STATE(253)] = 16251,
  [SMALL_STATE(254)] = 16290,
  [SMALL_STATE(255)] = 16329,
  [SMALL_STATE(256)] = 16368,
  [SMALL_STATE(257)] = 16407,
  [SMALL_STATE(258)] = 16446,
  [SMALL_STATE(259)] = 16485,
  [SMALL_STATE(260)] = 16550,
  [SMALL_STATE(261)] = 16615,
  [SMALL_STATE(262)] = 16680,
  [SMALL_STATE(263)] = 16745,
  [SMALL_STATE(264)] = 16810,
  [SMALL_STATE(265)] = 16875,
  [SMALL_STATE(266)] = 16940,
  [SMALL_STATE(267)] = 17005,
  [SMALL_STATE(268)] = 17070,
  [SMALL_STATE(269)] = 17129,
  [SMALL_STATE(270)] = 17188,
  [SMALL_STATE(271)] = 17247,
  [SMALL_STATE(272)] = 17306,
  [SMALL_STATE(273)] = 17339,
  [SMALL_STATE(274)] = 17372,
  [SMALL_STATE(275)] = 17405,
  [SMALL_STATE(276)] = 17438,
  [SMALL_STATE(277)] = 17469,
  [SMALL_STATE(278)] = 17500,
  [SMALL_STATE(279)] = 17535,
  [SMALL_STATE(280)] = 17570,
  [SMALL_STATE(281)] = 17604,
  [SMALL_STATE(282)] = 17637,
  [SMALL_STATE(283)] = 17670,
  [SMALL_STATE(284)] = 17703,
  [SMALL_STATE(285)] = 17731,
  [SMALL_STATE(286)] = 17759,
  [SMALL_STATE(287)] = 17787,
  [SMALL_STATE(288)] = 17823,
  [SMALL_STATE(289)] = 17865,
  [SMALL_STATE(290)] = 17915,
  [SMALL_STATE(291)] = 17955,
  [SMALL_STATE(292)] = 17999,
  [SMALL_STATE(293)] = 18045,
  [SMALL_STATE(294)] = 18077,
  [SMALL_STATE(295)] = 18127,
  [SMALL_STATE(296)] = 18167,
  [SMALL_STATE(297)] = 18199,
  [SMALL_STATE(298)] = 18237,
  [SMALL_STATE(299)] = 18276,
  [SMALL_STATE(300)] = 18317,
  [SMALL_STATE(301)] = 18354,
  [SMALL_STATE(302)] = 18393,
  [SMALL_STATE(303)] = 18426,
  [SMALL_STATE(304)] = 18459,
  [SMALL_STATE(305)] = 18506,
  [SMALL_STATE(306)] = 18543,
  [SMALL_STATE(307)] = 18584,
  [SMALL_STATE(308)] = 18619,
  [SMALL_STATE(309)] = 18666,
  [SMALL_STATE(310)] = 18695,
  [SMALL_STATE(311)] = 18732,
  [SMALL_STATE(312)] = 18779,
  [SMALL_STATE(313)] = 18808,
  [SMALL_STATE(314)] = 18851,
  [SMALL_STATE(315)] = 18894,
  [SMALL_STATE(316)] = 18941,
  [SMALL_STATE(317)] = 18970,
  [SMALL_STATE(318)] = 19005,
  [SMALL_STATE(319)] = 19040,
  [SMALL_STATE(320)] = 19081,
  [SMALL_STATE(321)] = 19128,
  [SMALL_STATE(322)] = 19165,
  [SMALL_STATE(323)] = 19194,
  [SMALL_STATE(324)] = 19233,
  [SMALL_STATE(325)] = 19270,
  [SMALL_STATE(326)] = 19303,
  [SMALL_STATE(327)] = 19346,
  [SMALL_STATE(328)] = 19375,
  [SMALL_STATE(329)] = 19422,
  [SMALL_STATE(330)] = 19459,
  [SMALL_STATE(331)] = 19488,
  [SMALL_STATE(332)] = 19511,
  [SMALL_STATE(333)] = 19554,
  [SMALL_STATE(334)] = 19597,
  [SMALL_STATE(335)] = 19640,
  [SMALL_STATE(336)] = 19683,
  [SMALL_STATE(337)] = 19723,
  [SMALL_STATE(338)] = 19763,
  [SMALL_STATE(339)] = 19803,
  [SMALL_STATE(340)] = 19843,
  [SMALL_STATE(341)] = 19880,
  [SMALL_STATE(342)] = 19917,
  [SMALL_STATE(343)] = 19954,
  [SMALL_STATE(344)] = 19991,
  [SMALL_STATE(345)] = 20028,
  [SMALL_STATE(346)] = 20065,
  [SMALL_STATE(347)] = 20102,
  [SMALL_STATE(348)] = 20139,
  [SMALL_STATE(349)] = 20176,
  [SMALL_STATE(350)] = 20213,
  [SMALL_STATE(351)] = 20250,
  [SMALL_STATE(352)] = 20287,
  [SMALL_STATE(353)] = 20321,
  [SMALL_STATE(354)] = 20355,
  [SMALL_STATE(355)] = 20389,
  [SMALL_STATE(356)] = 20423,
  [SMALL_STATE(357)] = 20449,
  [SMALL_STATE(358)] = 20475,
  [SMALL_STATE(359)] = 20488,
  [SMALL_STATE(360)] = 20501,
  [SMALL_STATE(361)] = 20514,
  [SMALL_STATE(362)] = 20527,
  [SMALL_STATE(363)] = 20550,
  [SMALL_STATE(364)] = 20573,
  [SMALL_STATE(365)] = 20586,
  [SMALL_STATE(366)] = 20609,
  [SMALL_STATE(367)] = 20622,
  [SMALL_STATE(368)] = 20635,
  [SMALL_STATE(369)] = 20648,
  [SMALL_STATE(370)] = 20661,
  [SMALL_STATE(371)] = 20674,
  [SMALL_STATE(372)] = 20697,
  [SMALL_STATE(373)] = 20715,
  [SMALL_STATE(374)] = 20733,
  [SMALL_STATE(375)] = 20751,
  [SMALL_STATE(376)] = 20769,
  [SMALL_STATE(377)] = 20789,
  [SMALL_STATE(378)] = 20807,
  [SMALL_STATE(379)] = 20825,
  [SMALL_STATE(380)] = 20843,
  [SMALL_STATE(381)] = 20861,
  [SMALL_STATE(382)] = 20879,
  [SMALL_STATE(383)] = 20897,
  [SMALL_STATE(384)] = 20915,
  [SMALL_STATE(385)] = 20933,
  [SMALL_STATE(386)] = 20953,
  [SMALL_STATE(387)] = 20971,
  [SMALL_STATE(388)] = 20989,
  [SMALL_STATE(389)] = 21009,
  [SMALL_STATE(390)] = 21027,
  [SMALL_STATE(391)] = 21045,
  [SMALL_STATE(392)] = 21063,
  [SMALL_STATE(393)] = 21083,
  [SMALL_STATE(394)] = 21103,
  [SMALL_STATE(395)] = 21121,
  [SMALL_STATE(396)] = 21139,
  [SMALL_STATE(397)] = 21159,
  [SMALL_STATE(398)] = 21177,
  [SMALL_STATE(399)] = 21195,
  [SMALL_STATE(400)] = 21213,
  [SMALL_STATE(401)] = 21233,
  [SMALL_STATE(402)] = 21251,
  [SMALL_STATE(403)] = 21269,
  [SMALL_STATE(404)] = 21287,
  [SMALL_STATE(405)] = 21305,
  [SMALL_STATE(406)] = 21323,
  [SMALL_STATE(407)] = 21341,
  [SMALL_STATE(408)] = 21359,
  [SMALL_STATE(409)] = 21377,
  [SMALL_STATE(410)] = 21394,
  [SMALL_STATE(411)] = 21407,
  [SMALL_STATE(412)] = 21424,
  [SMALL_STATE(413)] = 21437,
  [SMALL_STATE(414)] = 21450,
  [SMALL_STATE(415)] = 21463,
  [SMALL_STATE(416)] = 21480,
  [SMALL_STATE(417)] = 21497,
  [SMALL_STATE(418)] = 21514,
  [SMALL_STATE(419)] = 21527,
  [SMALL_STATE(420)] = 21544,
  [SMALL_STATE(421)] = 21557,
  [SMALL_STATE(422)] = 21570,
  [SMALL_STATE(423)] = 21583,
  [SMALL_STATE(424)] = 21599,
  [SMALL_STATE(425)] = 21609,
  [SMALL_STATE(426)] = 21621,
  [SMALL_STATE(427)] = 21631,
  [SMALL_STATE(428)] = 21644,
  [SMALL_STATE(429)] = 21657,
  [SMALL_STATE(430)] = 21670,
  [SMALL_STATE(431)] = 21683,
  [SMALL_STATE(432)] = 21696,
  [SMALL_STATE(433)] = 21709,
  [SMALL_STATE(434)] = 21722,
  [SMALL_STATE(435)] = 21733,
  [SMALL_STATE(436)] = 21743,
  [SMALL_STATE(437)] = 21751,
  [SMALL_STATE(438)] = 21761,
  [SMALL_STATE(439)] = 21771,
  [SMALL_STATE(440)] = 21779,
  [SMALL_STATE(441)] = 21789,
  [SMALL_STATE(442)] = 21799,
  [SMALL_STATE(443)] = 21809,
  [SMALL_STATE(444)] = 21819,
  [SMALL_STATE(445)] = 21827,
  [SMALL_STATE(446)] = 21835,
  [SMALL_STATE(447)] = 21843,
  [SMALL_STATE(448)] = 21853,
  [SMALL_STATE(449)] = 21861,
  [SMALL_STATE(450)] = 21869,
  [SMALL_STATE(451)] = 21879,
  [SMALL_STATE(452)] = 21886,
  [SMALL_STATE(453)] = 21893,
  [SMALL_STATE(454)] = 21900,
  [SMALL_STATE(455)] = 21907,
  [SMALL_STATE(456)] = 21914,
  [SMALL_STATE(457)] = 21921,
  [SMALL_STATE(458)] = 21928,
  [SMALL_STATE(459)] = 21935,
  [SMALL_STATE(460)] = 21942,
  [SMALL_STATE(461)] = 21949,
  [SMALL_STATE(462)] = 21956,
  [SMALL_STATE(463)] = 21963,
  [SMALL_STATE(464)] = 21970,
  [SMALL_STATE(465)] = 21977,
  [SMALL_STATE(466)] = 21984,
  [SMALL_STATE(467)] = 21991,
  [SMALL_STATE(468)] = 21998,
  [SMALL_STATE(469)] = 22005,
  [SMALL_STATE(470)] = 22012,
  [SMALL_STATE(471)] = 22019,
  [SMALL_STATE(472)] = 22026,
  [SMALL_STATE(473)] = 22033,
  [SMALL_STATE(474)] = 22040,
  [SMALL_STATE(475)] = 22047,
  [SMALL_STATE(476)] = 22054,
  [SMALL_STATE(477)] = 22061,
  [SMALL_STATE(478)] = 22068,
  [SMALL_STATE(479)] = 22075,
  [SMALL_STATE(480)] = 22082,
  [SMALL_STATE(481)] = 22089,
  [SMALL_STATE(482)] = 22096,
  [SMALL_STATE(483)] = 22103,
  [SMALL_STATE(484)] = 22110,
  [SMALL_STATE(485)] = 22117,
  [SMALL_STATE(486)] = 22124,
  [SMALL_STATE(487)] = 22131,
  [SMALL_STATE(488)] = 22138,
  [SMALL_STATE(489)] = 22145,
  [SMALL_STATE(490)] = 22152,
  [SMALL_STATE(491)] = 22159,
  [SMALL_STATE(492)] = 22166,
  [SMALL_STATE(493)] = 22173,
  [SMALL_STATE(494)] = 22180,
  [SMALL_STATE(495)] = 22187,
  [SMALL_STATE(496)] = 22194,
  [SMALL_STATE(497)] = 22201,
  [SMALL_STATE(498)] = 22208,
  [SMALL_STATE(499)] = 22215,
  [SMALL_STATE(500)] = 22222,
  [SMALL_STATE(501)] = 22229,
  [SMALL_STATE(502)] = 22236,
  [SMALL_STATE(503)] = 22243,
  [SMALL_STATE(504)] = 22250,
  [SMALL_STATE(505)] = 22257,
  [SMALL_STATE(506)] = 22264,
  [SMALL_STATE(507)] = 22271,
  [SMALL_STATE(508)] = 22278,
  [SMALL_STATE(509)] = 22285,
  [SMALL_STATE(510)] = 22292,
  [SMALL_STATE(511)] = 22299,
  [SMALL_STATE(512)] = 22306,
  [SMALL_STATE(513)] = 22313,
  [SMALL_STATE(514)] = 22320,
  [SMALL_STATE(515)] = 22327,
  [SMALL_STATE(516)] = 22334,
  [SMALL_STATE(517)] = 22341,
  [SMALL_STATE(518)] = 22348,
  [SMALL_STATE(519)] = 22355,
  [SMALL_STATE(520)] = 22362,
  [SMALL_STATE(521)] = 22369,
  [SMALL_STATE(522)] = 22376,
  [SMALL_STATE(523)] = 22383,
  [SMALL_STATE(524)] = 22390,
  [SMALL_STATE(525)] = 22397,
  [SMALL_STATE(526)] = 22404,
  [SMALL_STATE(527)] = 22411,
  [SMALL_STATE(528)] = 22418,
  [SMALL_STATE(529)] = 22425,
  [SMALL_STATE(530)] = 22432,
  [SMALL_STATE(531)] = 22439,
  [SMALL_STATE(532)] = 22446,
  [SMALL_STATE(533)] = 22453,
  [SMALL_STATE(534)] = 22460,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_code, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(490),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_op, 1),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(501),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr_op, 1),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(462),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hpath_expression, 2),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hpath_expression, 2),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 2),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 2),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(26),
  [190] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(81),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hpath_expression, 1),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hpath_expression, 1),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 1),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 1),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 1, .production_id = 3),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 1, .production_id = 3),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrpath, 1, .production_id = 4),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrpath, 1, .production_id = 4),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(411),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrpath, 2, .production_id = 11),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrpath, 2, .production_id = 11),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__immediate_interpolation, 3, .production_id = 17),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__immediate_interpolation, 3, .production_id = 17),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expression, 1, .production_id = 1),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expression, 1, .production_id = 1),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expression, 2),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expression, 2),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3, .production_id = 17),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3, .production_id = 17),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 25),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 25),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expression, 3),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expression, 3),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrset_expression, 2),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrset_expression, 2),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 2),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expression, 3, .production_id = 18),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expression, 3, .production_id = 18),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(8),
  [275] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(98),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(36),
  [281] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(99),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr_select_expression, 1),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_select_expression, 1),
  [292] = {.entry = {.count = 1, .reusable = false}}, SHIFT(400),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rec_attrset_expression, 3),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rec_attrset_expression, 3),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rec_attrset_expression, 4),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rec_attrset_expression, 4),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indented_string_expression, 3),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indented_string_expression, 3),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indented_string_expression, 2),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indented_string_expression, 2),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expression, 2),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expression, 2),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrset_expression, 3),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrset_expression, 3),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_attrset_expression, 4),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_attrset_expression, 4),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_attrset_expression, 3),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_attrset_expression, 3),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, .production_id = 17),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, .production_id = 17),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(19),
  [345] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(124),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_select_expression, 3, .production_id = 23),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_select_expression, 3, .production_id = 23),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_select_expression, 5, .production_id = 37),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_select_expression, 5, .production_id = 37),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_apply_expression, 2, .production_id = 9),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_expression, 2, .production_id = 9),
  [364] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(409),
  [367] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(416),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [378] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(419),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [415] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(107),
  [418] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(101),
  [421] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(101),
  [424] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(82),
  [427] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(346),
  [430] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(501),
  [433] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(33),
  [436] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(490),
  [439] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(398),
  [442] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(382),
  [445] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(260),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19),
  [450] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(83),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 7),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 7),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_has_attr_expression, 3, .production_id = 21),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_has_attr_expression, 3, .production_id = 21),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [465] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(415),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [470] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(417),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [477] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [481] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [485] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_if, 1),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 1, .production_id = 8),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 1, .production_id = 8),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binding_set, 1, .production_id = 6),
  [639] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(431),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15),
  [644] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(381),
  [647] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(356),
  [650] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(34),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15),
  [655] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(357),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding_set, 1, .production_id = 6),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 20),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_expression, 6, .production_id = 39),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_expression, 4, .production_id = 30),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 5, .production_id = 36),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherited_attrs, 1, .production_id = 13),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 10),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 16),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 5, .production_id = 33),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 4, .production_id = 32),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_with_expression, 4, .production_id = 31),
  [688] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(426),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26),
  [693] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(381),
  [696] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(34),
  [699] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [705] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2),
  [715] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(375),
  [718] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(42),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2),
  [737] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(380),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(43),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [755] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal, 1, .production_id = 1),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [767] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [799] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inherit, 3, .production_id = 27),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherit, 3, .production_id = 27),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [851] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inherit_from, 6, .production_id = 40),
  [853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherit_from, 6, .production_id = 40),
  [855] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binding, 4, .production_id = 35),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding, 4, .production_id = 35),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [863] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 1, .production_id = 5),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 1, .production_id = 5),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [873] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 1, .production_id = 4),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 29),
  [881] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 29), SHIFT_REPEAT(442),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 4, .production_id = 28),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal, 3, .production_id = 24),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 5, .production_id = 34),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 3, .production_id = 12),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 14),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 6, .production_id = 38),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 3, .production_id = 14),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_code, 1, .production_id = 2),
  [1078] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_nix_external_scanner_create(void);
void tree_sitter_nix_external_scanner_destroy(void *);
bool tree_sitter_nix_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_nix_external_scanner_serialize(void *, char *);
void tree_sitter_nix_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_nix(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_keyword,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_nix_external_scanner_create,
      tree_sitter_nix_external_scanner_destroy,
      tree_sitter_nix_external_scanner_scan,
      tree_sitter_nix_external_scanner_serialize,
      tree_sitter_nix_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
