/*
    This file is part of darktable,
    copyright (c) 2012 johannes hanika.

    darktable is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    darktable is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with darktable.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DT_GUI_LEGACY_PRESETS_H
#define DT_GUI_LEGACY_PRESETS_H

#include "common/database.h"

static const char *sql_lines[] = {
"PRAGMA foreign_keys=OFF;"
, "BEGIN TRANSACTION;"
, "drop table if exists legacy_presets" // fails first time, but doesn't hurt.
, "CREATE TABLE legacy_presets (name varchar, description varchar, operation varchar, op_version integer, op_params blob, enabled integer, blendop_params blob, blendop_version integer, model varchar, maker varchar, lens varchar, iso_min real, iso_max real, exposure_min real, exposure_max real, aperture_min real, aperture_max real, focal_length_min real, focal_length_max real, writeprotect integer, autoapply integer, filter integer, def integer, isldr integer);"
, "INSERT INTO legacy_presets VALUES('red filter','','monochrome',2,X'000000420000804233331340A97F0000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('red black white','','colorzones',1,X'0200000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F000000000000403E0000003F5C8F023F0000703F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003F6666263F000000000000000000000000000000006666263F0000003F0000003F0000003F0000003F0000003F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('black white and skin tones','','colorzones',1,X'0200000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3E0000803E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003F0000003F9A99993E0000000000000000000000000000003F0000003F0000003F0000003F0000003F0000003F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('polarizing filter','','colorzones',1,X'0100000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F2222E23E6666A63E5555553E0000003F0000003F0000083F0000183F0000283F0000383F0000003F0000003F0000003F0000003F0000003F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('natural skin tones','','colorzones',1,X'0200000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000D313F63DF7037E3E0000003FFE803F3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003FDB17F03ED656E43EDB17F03E5AD4FF3E0000003FDB17F03E0000003F0000003F0000003F0000003F0000003F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('black & white film','','colorzones',1,X'0200000000000000772B7B3EAB08FF3EEF39243F3316613F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F30F01C3F465BE53EB779073F473B2A3FBDFC463F30F01C3F0000000000000000000000000000000000000000000000000000003F0000003F0000003F0000003F0000003F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('fill-light 0.25EV with 4 zones','','relight',1,X'0000803E0000803E00008040',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('fill-shadow -0.25EV with 4 zones','','relight',1,X'000080BE0000803E00008040',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('daylight','','lowlight',1,X'0000000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000803F0000803F0000803F0000803F0000803F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('indoor bright','','lowlight',1,X'0000F04100000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F9A99193FCDCC4C3F3333733F48E17A3F0000803F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('indoor dim','','lowlight',1,X'0000F04100000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F9A99993E0000003F3333333F9A99593FEC51783F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('indoor dark','','lowlight',1,X'0000204200000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803FCDCC4C3DCDCC4C3ECDCCCC3E3333333F1F856B3F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('twilight','','lowlight',1,X'0000484200000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F295C8F3DCDCCCC3DEC51383E3333B33E0000403F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('night street lit','','lowlight',1,X'0000F04100000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F000000006666E63E0000403F7B146E3FA4707D3F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('night street','','lowlight',1,X'0000F04100000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F000000009A99193E3333B33ECDCC4C3FEC51783F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('night street dark','','lowlight',1,X'00002042000000009A99193ECDCCCC3E9A99193FCDCC4C3F0000803F000000000AD7A33CCDCC4C3DCDCC4C3ECDCC0C3F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('night','','lowlight',1,X'0000484200000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('low contrast','','tonecurve',3,X'00000000000000009C197D3B2600FF3B47E79C3D2DEE1F3E666B2D3E04A9943E9431463F2A1B463F0000803F0000803F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600000007000000070000000000000000000000000000000100000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('linear','','tonecurve',3,X'00000000000000000AD7A33D0AD7A33DCDCCCC3ECDCCCC3E9A99193F9A99193F1F856B3F1F856B3F0000803F0000803F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600000007000000070000000000000000000000000000000100000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('med contrast','','tonecurve',3,X'000000000000000077177D3BF5FCB33AD067083E03D0E53D3F6BA63EA846B93E5018553F94AE643F0000803F0000803F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600000007000000070000000000000000000000000000000100000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('high contrast','','tonecurve',3,X'000000000000000077177D3BBCCE3F39D067083E48E0903D3F6BA63E5F9BE93E5018553FFADE743F0000803F0000803F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000AD7A33D0AD7A33D9A99993E9A99993E0000003F0000003F3333333F3333333F1F856B3F1F856B3F0000803F0000803F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600000007000000070000000000000000000000000000000100000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('neutral grey ND2 (soft)','','graduatednd',1,X'0000803F0000000000000000000048420000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('neutral grey ND4 (soft)','','graduatednd',1,X'000000400000000000000000000048420000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('neutral grey ND8 (soft)','','graduatednd',1,X'000040400000000000000000000048420000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('neutral grey ND2 (hard)','','graduatednd',1,X'0000803F0000964200000000000048420000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('neutral grey ND4 (hard)','','graduatednd',1,X'000000400000964200000000000048420000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('neutral grey ND8 (hard)','','graduatednd',1,X'000040400000964200000000000048420000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('orange ND2 (soft)','','graduatednd',1,X'0000803F0000000000000000000048428ACBD13DCDCC4C3F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('yellow ND2 (soft)','','graduatednd',1,X'0000803F0000000000000000000048426AD91A3E0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('purple ND2 (soft)','','graduatednd',1,X'0000803F000000000000000000004842390B533F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('green ND2 (soft)','','graduatednd',1,X'0000803F00000000000000000000484249D99A3E0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('red ND2 (soft)','','graduatednd',1,X'0000803F000000000000000000004842000000000000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('blue ND2 (soft)','','graduatednd',1,X'0000803F00000000000000000000484291D5293F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('brown ND4 (soft)','','graduatednd',1,X'00000040000000000000000000004842A2D5A93D0000803E',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('authentic sepia','','splittoning',1,X'3FE9933D1F856B3F398EE33D1F856B3FAE47213F00000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('authentic cyanotype','','splittoning',1,X'C7711C3F0AD7233FC7711C3F0AD7233F000000003D0AA740',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('authentic platinotype','','splittoning',1,X'3FE9133D3D0AD73E3FE9133D3D0AD73E0000C84200000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('chocolate brown','','splittoning',1,X'F5499F3D14AEC73EF5499F3D0AD7A33D9A99193F00000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('swap R and B','','channelmixer',1,X'00000000000000000000000000000000000000000000803F00000000000000000000000000000000000000000000803F00000000000000000000000000000000000000000000803F000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('swap G and B','','channelmixer',1,X'0000000000000000000000000000803F00000000000000000000000000000000000000000000000000000000000000000000803F00000000000000000000000000000000000000000000803F0000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('color contrast boost','','channelmixer',1,X'0000000000000000CDCC4C3F0000803F0000000000000000000000000000000000000000CDCCCC3D000000000000803F00000000000000000000000000000000CDCCCC3D00000000000000000000803F00000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('color details boost','','channelmixer',1,X'0000000000000000CDCCCC3D0000803F0000000000000000000000000000000000000000CDCC4C3F000000000000803F00000000000000000000000000000000CDCCCC3D00000000000000000000803F00000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('color artifacts boost','','channelmixer',1,X'0000000000000000CDCCCC3D0000803F0000000000000000000000000000000000000000CDCCCC3D000000000000803F00000000000000000000000000000000CDCC4C3F00000000000000000000803F00000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('b/w','','channelmixer',1,X'0000000000000000000000000000803F00000000000000003D0A573E000000000000000000000000000000000000803F00000000EC51383F00000000000000000000000000000000000000000000803F295C8F3D',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('b/w artifacts boost','','channelmixer',1,X'0000000000000000000000000000803F0000000000000000CDCC8CBE000000000000000000000000000000000000803F00000000CDCC8CBE00000000000000000000000000000000000000000000803F3333A33F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('b/w smooth skin','','channelmixer',1,X'0000000000000000000000000000803F00000000000000000000803F00000000000000000000000000000000000000000000803F6666A63E000000000000000000000000000000000000000000000000CDCCCCBE',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('b/w blue artifacts reduce','','channelmixer',1,X'000000000000000000000000000000000000000000000000CDCCCC3E0000000000000000000000000000000000000000000000000000403F0000000000000000000000000000000000000000000000009A9919BE',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('flip horizontally','','flip',1,X'01000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('flip vertically','','flip',1,X'02000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('rotate by -90','','flip',1,X'06000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('rotate by  90','','flip',1,X'05000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('rotate by 180','','flip',1,X'03000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('warming filter','','colorcorrection',1,X'333373BF0000904033336340000000000000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('cooling filter','','colorcorrection',1,X'3333733F000090C0333363C0000000800000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('local contrast mask','','lowpass',1,X'0000000000004842000080BF00000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('dark contrast','','basecurve',2,X'000000000000000059A5943D0AD7233D3E08213EFF090E3EE8DEFB3EE8DEFB3E8C10423F8C10423F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,2);"
, "INSERT INTO legacy_presets VALUES('canon eos like','','basecurve',2,X'0000000000000000363AE73C2E1DF33C12BEF73D0BD56D3EC95AEB3E78613F3FF8DE5B3FF1BD773F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%Canon%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('canon eos like alternate','','basecurve',2,X'00000000000000005BB6D63C2E1DF33CC2F7DE3D0BD56D3ED89CB33E78613F3FD95A2B3FF1BD773F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%DISABLED%','%Canon%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('nikon like','','basecurve',2,X'0000000000000000D3A4143D94A2153D12BEF73D14B4693EC95AEB3E427A423FF8DE5B3F8FC47B3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%NIKON%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('nikon like alternate','','basecurve',2,X'00000000000000006F12833AACC52737363A673DF855993DF1BDB73E0C93253FF1BD373FBD8A743F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%DISABLED%','%NIKON%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('sony alpha like','','basecurve',2,X'0000000000000000F4DC023D94A2153D35ECD73D14B4693E7077DE3E427A423FA5115B3F8FC47B3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%SONY%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('pentax like','','basecurve',2,X'0000000000000000F720043D8D7DC93C12BEF73DBE692A3E9A94523EB134A83EBBD61A3FA6484A3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%PENTAX%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('ricoh like','','basecurve',2,X'00000000000000000322043D8D7DC93C12BEF73DBE692A3E9A94523EB134A83EBBD61A3FA6484A3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%RICOH%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('olympus like','','basecurve',2,X'00000000000000007F32463C9B1D293C9E7BEF3D8FC42B3EA3730E3F2B17363F9431663F73F4743F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%OLYMPUS%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('olympus like alternate','','basecurve',2,X'00000000000000007F32463C9B1D293C59A5943D8FC42B3EC2F79E3E2B17363F4529253F73F4743F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%DISABLED%','%OLYMPUS%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('panasonic like','','basecurve',2,X'0000000000000000D3A4143D8D7DC93C12BEF73DBE692A3E9A94523EB134A83EBBD61A3FA6484A3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%Panasonic%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('leica like','','basecurve',2,X'0000000000000000DFA5143D8D7DC93C12BEF73DBE692A3E9A94523EB134A83EBBD61A3FA6484A3F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%Leica Camera AG%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('kodak easyshare like','','basecurve',2,X'000000000000000097AD353DFCC2AB3C3142083E96061E3E91B5563E0DC1993EAB94123FDEE3403F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%EASTMAN KODAK COMPANY%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('konica minolta like','','basecurve',2,X'0000000000000000AE28A53C9B1D293CB039E73D8FC42B3E0000003F2B17363F9431663F73F4743F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%MINOLTA%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('samsung like','','basecurve',2,X'0000000000000000BB29253D2E1DF33C3142083E0BD56D3E5629E53E78613F3FF1BD573FF1BD773F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%SAMSUNG%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('fujifilm like','','basecurve',2,X'0000000000000000363AE73C2E1DF33CD4B5D63D0BD56D3E9431C63E78613F3F3E08413FF1BD773F0000803F0000803F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%FUJIFILM%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "INSERT INTO legacy_presets VALUES('fotogenetic (point & shoot)','','basecurve',2,X'0000000000000000E8F9B33D0F42003EE8F9333E3142803E8A02B53E3142003F28D71C3FE8DE3F3F0000803F1767603F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,2);"
, "INSERT INTO legacy_presets VALUES('fotogenetic (EV3)','','basecurve',2,X'000000000000000034BBCE3D0F42003E34BB4E3E3142803EFC1D9A3E1E6CC13E55DECE3E93C6003F0000803FDE73603F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000020000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%%','%%','%%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,2);"
, "INSERT INTO legacy_presets VALUES('15:10 postcard white','','borders',2,X'0000803F0000803F0000803F0000C03F333A32000000000000000000000000000000000000000000CDCCCC3D0000003F312F3200000000000000000000000000000000000000003F312F320000000000000000000000000000000000000000000000003F000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('15:10 postcard black','','borders',2,X'0000000000000000000000000000C03F333A32000000000000000000000000000000000000000000CDCCCC3D0000003F312F3200000000000000000000000000000000000000003F312F320000000000000000000000000000000000000000000000003F0000803F0000803F0000803F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('enhance coarse','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000403F6666263FCDCC0C3F0000003F0000003F0000003FCDCC0C3F0000003F0000003F0000003F0000003F0000003FCDCC4C3E713D8A3E7B14AE3E85EBD13E8FC2F53E0000003F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('sharpen and denoise (strong)','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F5555153FABAA2A3F0000403F5655553FABAA6A3F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F000000008988883D8988083ECECC4C3E8988883EABAAAA3E00000000CECCCC3DCECC4C3E9A99993ECECCCC3E0100003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('sharpen and denoise','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003FABAA0A3F5555153F0000203FABAA2A3F5655353F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F000000008988083D8988883DCECCCC3D8988083EABAA2A3E00000000CECC4C3DCECCCC3D9A99193ECECC4C3E0100803E',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('sharpen (strong)','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F5555153FABAA2A3F0000403F5655553FABAA6A3F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('sharpen','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003FABAA0A3F5555153F0000203FABAA2A3F5655353F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('chroma denoise','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000CECC4C3DCECCCC3D9A99193ECECC4C3E0100803E',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('denoise (subtle)','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F00000000000000000000000000000000000000000000000000000000000000000000000000000000D0CC4C3DD0CCCC3D00000000CECC4C3DCECCCC3D9A99193ECECC4C3E0100803E',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('denoise','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F000000008988083D8988883DCECCCC3D8988083EABAA2A3E00000000CECC4C3DCECCCC3D9A99193ECECC4C3E0100803E',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('denoise (strong)','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F3D0AD73E00000000000000008988883D8988083ECECC4C3E8988883EABAAAA3E000000008988083E8988883ECECCCC3E0000003F0000003F',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('bloom','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F0000003FA470BD3EAE47E13E0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F0000003F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('clarity (subtle)','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803FCDCC0C3FCDCC0C3FCDCC0C3FCDCC0C3FCDCC0C3FCDCC0C3F0000003F0000003F0000003F0000003F0000003F0000003F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('clarity','','atrous',1,X'0700000000000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F00000000CDCC4C3ECDCCCC3E9A99193FCDCC4C3F0000803F9A99193F9A99193F9A99193F9A99193F9A99193F9A99193FCDCC0C3FCDCC0C3FCDCC0C3FCDCC0C3FCDCC0C3FCDCC0C3F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',1,X'000000000000C842000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',3,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('CC-by','','metadata',1,X'0000437265617469766520436F6D6D6F6E73204174747269627574696F6E202843432D425929000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('CC-by-sa','','metadata',1,X'0000437265617469766520436F6D6D6F6E73204174747269627574696F6E2D5368617265416C696B65202843432D42592D534129000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('CC-by-nd','','metadata',1,X'0000437265617469766520436F6D6D6F6E73204174747269627574696F6E2D4E6F446572697673202843432D42592D4E4429000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('CC-by-nc','','metadata',1,X'0000437265617469766520436F6D6D6F6E73204174747269627574696F6E2D4E6F6E436F6D6D65726369616C202843432D42592D4E4329000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('CC-by-nc-sa','','metadata',1,X'0000437265617469766520436F6D6D6F6E73204174747269627574696F6E2D4E6F6E436F6D6D65726369616C2D5368617265416C696B65202843432D42592D4E432D534129000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('CC-by-nc-nd','','metadata',1,X'0000437265617469766520436F6D6D6F6E73204174747269627574696F6E2D4E6F6E436F6D6D65726369616C2D4E6F446572697673202843432D42592D4E432D4E4429000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('all rights reserved','','metadata',1,X'0000416C6C207269676874732072657365727665642E000000',1,NULL,0,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,0,0,0,0);"
, "INSERT INTO legacy_presets VALUES('sharpen','','sharpen',1,X'000000400000003F0000003F',1,X'000000000000C84200000000000000000000000000000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F00000000000000000000803F0000803F',4,'%','%','%',0.0,51200.0,0.0,10000000.0,0.0,100000000.0,0.0,1000.0,1,1,0,0,2);"
, "COMMIT;"
};
static const int num_sql_lines = 100;

void dt_legacy_presets_create()
{
  // a bit stupid, deletes and re-inserts every time :(
  for(int i=0;i<num_sql_lines;i++)
    DT_DEBUG_SQLITE3_EXEC(dt_database_get(darktable.db), sql_lines[i], NULL, NULL, NULL);
}

#endif
