# Copyright (C) 2004 Scott W. Dunlop <swdunlop at users.sourceforge.net>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import os.path, sys
from glob import glob
from urllib import quote_plus as uriquote
from urllib import unquote_plus as uriunquote
from weakref import WeakValueDictionary
from sets import Set
from difflib import SequenceMatcher
from cStringIO import StringIO

from errors import *
from html import parse_hazeml, normalize, htmlquote
from node import Node

from types import StringType
import time

def ago( t ):
    secs = time.time() - t

    days = int( secs / 86400 )
    if days:
        if days == 1:
            return "a day ago"
        elif days == 2:
            return "two days ago"
        else:
            return "%s days ago" % (days,)
    
    hours = int( secs / 3600 )
    if hours:
        if hours == 1:
            return "an hour ago"
        elif hours == 2:
            return "two hours ago"
        else:
            return "%s hours ago" % (hours,)
    
    minutes = int( secs / 60 )
    if minutes:
        if minutes == 1:
            return "a minute ago"
        elif minutes == 2:
            return "two minutes ago"
        else:
            return "%s minutes ago" % (minutes,)

    secs = int( secs )
    if secs == 1:
        return "a second ago"
    else:
        return "%s seconds ago" % (secs,)

def collate_interfaces( wiki ):
    from fragment import Lexicon

    sv = wiki.getServer()
    db = wiki.getDatabase()
    
    fragsdir = os.path.join( os.path.dirname( __file__ ) or '.', 'fragments' )

    lexicon = Lexicon()
    gateways = {}
    methods = {}
    
    base_url = htmlquote( wiki.getBaseUrl( ) )
    site_name = htmlquote( wiki.getSitename( ) )

    lexicon.setGlobal( 'htmlquote', htmlquote )
    lexicon.setGlobal( 'IHateFavicons', IHateFavicons )
    lexicon.setGlobal( 'UnauthorizedAccess', UnauthorizedAccess )
    lexicon.setGlobal( 'InvalidRequestError', InvalidRequestError )
    lexicon.setGlobal( 'Node', Node )
    lexicon.setGlobal( 'time', time.time )
    
    lexicon.setGlobal( 'ago', ago )
    lexicon.setGlobal( 'wiki', wiki )
    lexicon.setGlobal( 'sv', sv )
    lexicon.setGlobal( 'db', db )
    lexicon.setGlobal( 'site_name', site_name )
    lexicon.setGlobal( 'base_url', base_url )
    lexicon.setGlobal( 'style_url', base_url + '/style.css' )
    lexicon.setGlobal( 'front_url', base_url + '/' + site_name )
    lexicon.setGlobal( 'node_additions_url', base_url + '/@additions' )
    lexicon.setGlobal( 'node_changes_url', base_url + '/@changes' )
    
    for path in glob( os.path.join( fragsdir, '*' ) ):
        lexicon.makeFragment( file = path )
    
    for entry in ( 
        ('edit', 'mt-edit'),
        ('refs', 'mt-refs'),
        ('diffs', 'mt-diffs'),
        ('', 'Login', 'login', 'mt-display'),
        ('Save', 'save', 'mt-save')
    ):
        keys = entry[:-1]
        fragname = entry[-1]
        fragment = lexicon.findFragment( fragname )
        
        for key in keys:
            methods[key] = fragment

    for entry in (
        ('', 'goto-front'),
        ('favicon.ico', 'gw-favicon'),
        ('style.css', 'gw-stylesheet'),
        ('@changes', 'gw-changes'),
        ('@additions', 'gw-additions')
    ):
        keys = entry[:-1]
        fragname = entry[-1]
        fragment = lexicon.findFragment( fragname )
        
        for key in keys:
            gateways[key] = fragment

    return lexicon, gateways, methods

