# t20040 - Test case for recursive variadic template function call
## Config
```yaml
diagrams:
  t20040_sequence:
    type: sequence
    glob:
      - t20040.cc
    include:
      namespaces:
        - clanguml::t20040
    using_namespace: clanguml::t20040
    from:
      - function: "clanguml::t20040::tmain()"
```
## Source code
File `tests/t20040/t20040.cc`
```cpp
#include <iostream>
#include <string>

namespace clanguml {
namespace t20040 {
void print() { }

template <typename T, typename... Ts> void print(T head, Ts... tail)
{
    std::cout << head << std::endl;
    print(tail...);
}

template <typename... Ts> void doublePrint(Ts... args)
{
    print(args + args...);
}

void tmain()
{
    using namespace std::literals::string_literals;

    print(1, 3.14, "test"s);

    doublePrint("test"s, 2024 / 2);
}
}
}
```
## Generated PlantUML diagrams
![t20040_sequence](./t20040_sequence.svg "Test case for recursive variadic template function call")
## Generated Mermaid diagrams
![t20040_sequence](./t20040_sequence_mermaid.svg "Test case for recursive variadic template function call")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20040_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20040::tmain()",
      "id": "7988980481179677306",
      "name": "tmain",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 6,
        "file": "t20040.cc",
        "line": 19,
        "translation_unit": "t20040.cc"
      },
      "type": "function"
    },
    {
      "display_name": "print<int,double,std::string>(int,double,std::string)",
      "full_name": "clanguml::t20040::print<int,double,std::string>(int,double,std::string)",
      "id": "15319823812730202792",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<double,std::string>(double,std::string)",
      "full_name": "clanguml::t20040::print<double,std::string>(double,std::string)",
      "id": "15866132119849058914",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<std::string>(std::string)",
      "full_name": "clanguml::t20040::print<std::string>(std::string)",
      "id": "7631446682124985359",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print()",
      "full_name": "clanguml::t20040::print()",
      "id": "1963347511152581998",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 6,
        "file": "t20040.cc",
        "line": 6,
        "translation_unit": "t20040.cc"
      },
      "type": "function"
    },
    {
      "display_name": "doublePrint<std::string,int>(std::string,int)",
      "full_name": "clanguml::t20040::doublePrint<std::string,int>(std::string,int)",
      "id": "14169635637322842038",
      "name": "doublePrint",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 32,
        "file": "t20040.cc",
        "line": 14,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<std::string,int>(std::string,int)",
      "full_name": "clanguml::t20040::print<std::string,int>(std::string,int)",
      "id": "15071931466831638243",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<int>(int)",
      "full_name": "clanguml::t20040::print<int>(int)",
      "id": "9515419718316191441",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "7988980481179677306",
        "location": "clanguml::t20040::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "7988980481179677306",
            "participant_id": "7988980481179677306"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 23,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "15319823812730202792",
            "participant_id": "15319823812730202792"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15319823812730202792",
            "participant_id": "15319823812730202792"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "15866132119849058914",
            "participant_id": "15866132119849058914"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15866132119849058914",
            "participant_id": "15866132119849058914"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "7631446682124985359",
            "participant_id": "7631446682124985359"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7631446682124985359",
            "participant_id": "7631446682124985359"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "1963347511152581998",
            "participant_id": "1963347511152581998"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7988980481179677306",
            "participant_id": "7988980481179677306"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 25,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "14169635637322842038",
            "participant_id": "14169635637322842038"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14169635637322842038",
            "participant_id": "14169635637322842038"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 16,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "15071931466831638243",
            "participant_id": "15071931466831638243"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15071931466831638243",
            "participant_id": "15071931466831638243"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "9515419718316191441",
            "participant_id": "9515419718316191441"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9515419718316191441",
            "participant_id": "9515419718316191441"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "1963347511152581998",
            "participant_id": "1963347511152581998"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20040"
}
```
## Generated GraphML models
