# t20038 - Sequence diagram comment decorator test case
## Config
```yaml
add_compile_flags:
  - -fparse-all-comments
diagrams:
  t20038_sequence:
    type: sequence
    glob:
      - t20038.cc
    include:
      namespaces:
        - clanguml::t20038
    from:
      - function: clanguml::t20038::tmain()
    generate_message_comments: true
    message_comment_width: 35
    using_namespace: clanguml::t20038
```
## Source code
File `tests/t20038/t20038.cc`
```cpp
#include <future>

#include "include/t20038.h"

namespace clanguml {
namespace t20038 {

struct A {
    int a() { return 1; }

    int aa()
    {
        int i;
        // Repeat 10 times
        for (i = 0; i < 10;) {
            i += a();
        }
        return i;
    }

    int aaa() { return 3; }

    int aaaa() { return add(4, 4); }

    int aaaaa() { return 5; }
};

struct B {
    int b() { return a.a(); }

    int bb() { return a.aa(); }

    int bbb() { return a.aaa(); }

    int bbbb() { return a.aaaa(); }

    int bbbbb() { return a.aaaa(); }

    int wrap(int b) { return b; }

    A a;
};

int tmain()
{
    B b;

    // Nisl purus in mollis nunc sed id semper. Varius vel pharetra vel
    // turpis. Arcu cursus vitae congue mauris rhoncus. Risus feugiat in
    // ante metus dictum at tempor. Lacus vel facilisis volutpat est. Auctor
    // urna nunc id cursus metus aliquam. Diam sit amet nisl suscipit
    // adipiscing. Potenti nullam ac tortor vitae purus faucibus ornare
    // suspendisse sed. Lobortis feugiat vivamus at augue eget arcu dictum
    // varius. Non tellus orci ac auctor.
    if (true) {
        auto r = 0;
        // Repeat 5 times...
        while (r < 5) {
            r += b.b();
        }
        return r;
    }
    else {
        // ... or just once
        return 2 * b.b();
    }

    // \uml{skip}
    b.bb();

    // \uml{call clanguml::t20038::B::bbb()}
    auto bbb_future = std::async(std::launch::deferred, &B::bbb, b);

    bbb_future.wait();

    // This comment should be rendered only once
    b.wrap(b.bbbb());

    add_impl<double>(2, 2); // What is 2 + 2?

    // This is a generic comment about calling bbbbb()
    //
    // \uml{note:some_other_diagram[] This is specific for some_other_diagram}
    // \uml{note:t20038_sequence[] Calling B::bbbbb()}
    b.bbbbb();

    // This is a conditional operator
    return b.bbb() > 5 ? 0 : 1;
}
}
}
```
File `tests/t20038/include/t20038.h`
```cpp
#pragma once

namespace clanguml {
namespace t20038 {

template <typename T> T add_impl(T a, T b) { return a + b; };

template <typename T> T add(T a, T b)
{
    // Invoke 'add' implementation
    return add_impl(a, b);
};
}
}
```
## Generated PlantUML diagrams
![t20038_sequence](./t20038_sequence.svg "Sequence diagram comment decorator test case")
## Generated Mermaid diagrams
![t20038_sequence](./t20038_sequence_mermaid.svg "Sequence diagram comment decorator test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20038_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20038::tmain()",
      "id": "8108885002633823792",
      "name": "tmain",
      "namespace": "clanguml::t20038",
      "source_location": {
        "column": 5,
        "file": "t20038.cc",
        "line": 44,
        "translation_unit": "t20038.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "b()",
          "full_name": "clanguml::t20038::B::b()",
          "id": "5522516829806183901",
          "name": "b",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 29,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bbb()",
          "full_name": "clanguml::t20038::B::bbb()",
          "id": "15218655993561963475",
          "name": "bbb",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 33,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bbbb()",
          "full_name": "clanguml::t20038::B::bbbb()",
          "id": "457518923793673502",
          "name": "bbbb",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 35,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        },
        {
          "display_name": "wrap(int)",
          "full_name": "clanguml::t20038::B::wrap(int)",
          "id": "5862199529645096278",
          "name": "wrap",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 39,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bbbbb()",
          "full_name": "clanguml::t20038::B::bbbbb()",
          "id": "5810360542293206912",
          "name": "bbbbb",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 37,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20038::B",
      "id": "8326302221771171317",
      "name": "B",
      "namespace": "clanguml::t20038",
      "source_location": {
        "column": 8,
        "file": "t20038.cc",
        "line": 28,
        "translation_unit": "t20038.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a()",
          "full_name": "clanguml::t20038::A::a()",
          "id": "10490389983354674971",
          "name": "a",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 9,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aaa()",
          "full_name": "clanguml::t20038::A::aaa()",
          "id": "17257666034544329159",
          "name": "aaa",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 21,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aaaa()",
          "full_name": "clanguml::t20038::A::aaaa()",
          "id": "10966838598160369228",
          "name": "aaaa",
          "namespace": "clanguml::t20038",
          "source_location": {
            "column": 9,
            "file": "t20038.cc",
            "line": 23,
            "translation_unit": "t20038.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20038::A",
      "id": "16181798519051847963",
      "name": "A",
      "namespace": "clanguml::t20038",
      "source_location": {
        "column": 8,
        "file": "t20038.cc",
        "line": 8,
        "translation_unit": "t20038.cc"
      },
      "type": "class"
    },
    {
      "display_name": "add<int>(int,int)",
      "full_name": "clanguml::t20038::add<int>(int,int)",
      "id": "16066467566327460914",
      "name": "add",
      "namespace": "clanguml::t20038",
      "source_location": {
        "column": 25,
        "file": "include/t20038.h",
        "line": 8,
        "translation_unit": "t20038.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "add_impl<int>(int,int)",
      "full_name": "clanguml::t20038::add_impl<int>(int,int)",
      "id": "14904059563015848795",
      "name": "add_impl",
      "namespace": "clanguml::t20038",
      "source_location": {
        "column": 25,
        "file": "include/t20038.h",
        "line": 6,
        "translation_unit": "t20038.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "add_impl<double>(double,double)",
      "full_name": "clanguml::t20038::add_impl<double>(double,double)",
      "id": "13780172073331423003",
      "name": "add_impl",
      "namespace": "clanguml::t20038",
      "source_location": {
        "column": 25,
        "file": "include/t20038.h",
        "line": 6,
        "translation_unit": "t20038.cc"
      },
      "type": "function_template"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "8108885002633823792",
        "location": "clanguml::t20038::tmain()"
      },
      "messages": [
        {
          "activity_id": "8108885002633823792",
          "branches": [
            {
              "messages": [
                {
                  "activity_id": "8108885002633823792",
                  "messages": [
                    {
                      "from": {
                        "activity_id": "8108885002633823792",
                        "participant_id": "8108885002633823792"
                      },
                      "name": "b()",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 18,
                        "file": "t20038.cc",
                        "line": 59,
                        "translation_unit": "t20038.cc"
                      },
                      "to": {
                        "activity_id": "5522516829806183901",
                        "participant_id": "8326302221771171317"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "5522516829806183901",
                        "participant_id": "8326302221771171317"
                      },
                      "name": "a()",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 22,
                        "file": "t20038.cc",
                        "line": 29,
                        "translation_unit": "t20038.cc"
                      },
                      "to": {
                        "activity_id": "10490389983354674971",
                        "participant_id": "16181798519051847963"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "10490389983354674971",
                        "participant_id": "16181798519051847963"
                      },
                      "name": "",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 15,
                        "file": "t20038.cc",
                        "line": 9,
                        "translation_unit": "t20038.cc"
                      },
                      "to": {
                        "activity_id": "5522516829806183901",
                        "participant_id": "8326302221771171317"
                      },
                      "type": "return"
                    },
                    {
                      "from": {
                        "activity_id": "5522516829806183901",
                        "participant_id": "8326302221771171317"
                      },
                      "name": "",
                      "return_type": "int",
                      "scope": "normal",
                      "source_location": {
                        "column": 15,
                        "file": "t20038.cc",
                        "line": 29,
                        "translation_unit": "t20038.cc"
                      },
                      "to": {
                        "activity_id": "8108885002633823792",
                        "participant_id": "8108885002633823792"
                      },
                      "type": "return"
                    }
                  ],
                  "name": "while",
                  "type": "loop"
                }
              ],
              "type": "consequent"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "8108885002633823792",
                    "participant_id": "8108885002633823792"
                  },
                  "name": "b()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 20,
                    "file": "t20038.cc",
                    "line": 65,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "5522516829806183901",
                    "participant_id": "8326302221771171317"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "5522516829806183901",
                    "participant_id": "8326302221771171317"
                  },
                  "name": "a()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 22,
                    "file": "t20038.cc",
                    "line": 29,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "10490389983354674971",
                    "participant_id": "16181798519051847963"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "10490389983354674971",
                    "participant_id": "16181798519051847963"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 15,
                    "file": "t20038.cc",
                    "line": 9,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "5522516829806183901",
                    "participant_id": "8326302221771171317"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "5522516829806183901",
                    "participant_id": "8326302221771171317"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 15,
                    "file": "t20038.cc",
                    "line": 29,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "8108885002633823792",
                    "participant_id": "8108885002633823792"
                  },
                  "type": "return"
                }
              ],
              "type": "alternative"
            }
          ],
          "name": "if",
          "type": "alt"
        },
        {
          "from": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "name": "bbb()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 23,
            "file": "t20038.cc",
            "line": 72,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "15218655993561963475",
            "participant_id": "8326302221771171317"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15218655993561963475",
            "participant_id": "8326302221771171317"
          },
          "name": "aaa()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 24,
            "file": "t20038.cc",
            "line": 33,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "17257666034544329159",
            "participant_id": "16181798519051847963"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17257666034544329159",
            "participant_id": "16181798519051847963"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20038.cc",
            "line": 21,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "15218655993561963475",
            "participant_id": "8326302221771171317"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "15218655993561963475",
            "participant_id": "8326302221771171317"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20038.cc",
            "line": 33,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "name": "bbbb()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20038.cc",
            "line": 77,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "457518923793673502",
            "participant_id": "8326302221771171317"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "457518923793673502",
            "participant_id": "8326302221771171317"
          },
          "name": "aaaa()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20038.cc",
            "line": 35,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20038.cc",
            "line": 23,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "include/t20038.h",
            "line": 11,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "14904059563015848795",
            "participant_id": "14904059563015848795"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14904059563015848795",
            "participant_id": "14904059563015848795"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 46,
            "file": "include/t20038.h",
            "line": 6,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "include/t20038.h",
            "line": 11,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20038.cc",
            "line": 23,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "457518923793673502",
            "participant_id": "8326302221771171317"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "457518923793673502",
            "participant_id": "8326302221771171317"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20038.cc",
            "line": 35,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "type": "return"
        },
        {
          "comment": "This comment should be rendered only once",
          "from": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "name": "wrap(int)",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20038.cc",
            "line": 77,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "5862199529645096278",
            "participant_id": "8326302221771171317"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5862199529645096278",
            "participant_id": "8326302221771171317"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 23,
            "file": "t20038.cc",
            "line": 39,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "type": "return"
        },
        {
          "comment": "What is 2 + 2?",
          "from": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20038.cc",
            "line": 79,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "13780172073331423003",
            "participant_id": "13780172073331423003"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13780172073331423003",
            "participant_id": "13780172073331423003"
          },
          "name": "",
          "return_type": "double",
          "scope": "normal",
          "source_location": {
            "column": 46,
            "file": "include/t20038.h",
            "line": 6,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "type": "return"
        },
        {
          "comment": "This is a generic comment about calling bbbbb()",
          "from": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "name": "bbbbb()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20038.cc",
            "line": 85,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "5810360542293206912",
            "participant_id": "8326302221771171317"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5810360542293206912",
            "participant_id": "8326302221771171317"
          },
          "name": "aaaa()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20038.cc",
            "line": 37,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20038.cc",
            "line": 23,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "include/t20038.h",
            "line": 11,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "14904059563015848795",
            "participant_id": "14904059563015848795"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14904059563015848795",
            "participant_id": "14904059563015848795"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 46,
            "file": "include/t20038.h",
            "line": 6,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "16066467566327460914",
            "participant_id": "16066467566327460914"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "include/t20038.h",
            "line": 11,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "10966838598160369228",
            "participant_id": "16181798519051847963"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20038.cc",
            "line": 23,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "5810360542293206912",
            "participant_id": "8326302221771171317"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "5810360542293206912",
            "participant_id": "8326302221771171317"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 19,
            "file": "t20038.cc",
            "line": 37,
            "translation_unit": "t20038.cc"
          },
          "to": {
            "activity_id": "8108885002633823792",
            "participant_id": "8108885002633823792"
          },
          "type": "return"
        },
        {
          "activity_id": "8108885002633823792",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "8108885002633823792",
                    "participant_id": "8108885002633823792"
                  },
                  "name": "bbb()",
                  "return_type": "int",
                  "scope": "condition",
                  "source_location": {
                    "column": 12,
                    "file": "t20038.cc",
                    "line": 88,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "15218655993561963475",
                    "participant_id": "8326302221771171317"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "15218655993561963475",
                    "participant_id": "8326302221771171317"
                  },
                  "name": "aaa()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 24,
                    "file": "t20038.cc",
                    "line": 33,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "17257666034544329159",
                    "participant_id": "16181798519051847963"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "17257666034544329159",
                    "participant_id": "16181798519051847963"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 17,
                    "file": "t20038.cc",
                    "line": 21,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "15218655993561963475",
                    "participant_id": "8326302221771171317"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "15218655993561963475",
                    "participant_id": "8326302221771171317"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 17,
                    "file": "t20038.cc",
                    "line": 33,
                    "translation_unit": "t20038.cc"
                  },
                  "to": {
                    "activity_id": "8108885002633823792",
                    "participant_id": "8108885002633823792"
                  },
                  "type": "return"
                }
              ],
              "type": "consequent"
            },
            {
              "type": "alternative"
            }
          ],
          "name": "conditional",
          "type": "alt"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20038"
}
```
## Generated GraphML models
