# t20013 - Function and method arguments in sequence diagrams test case
## Config
```yaml
diagrams:
  t20013_sequence:
    type: sequence
    glob:
      - t20013.cc
    include:
      namespaces:
        - clanguml::t20013
    using_namespace: clanguml::t20013
    from:
      - function: "clanguml::t20013::tmain(int,char **)"
```
## Source code
File `tests/t20013/t20013.cc`
```cpp
namespace clanguml {
namespace t20013 {

struct A {
    int a1(int i) { return i; }
    double a2(double d) { return d; }
    const char *a3(const char *s) { return s; }
};

struct B {
    int b(int i) { return a.a1(i); }
    double b(double d) { return a.a2(d); }
    const char *b(const char *s) { return a.a3(s); }

    A a;
};

void tmain(int argc, char **argv)
{
    B b;

    b.b(1);
    b.b(2.0);
    b.b("three");
}
}
}
```
## Generated PlantUML diagrams
![t20013_sequence](./t20013_sequence.svg "Function and method arguments in sequence diagrams test case")
## Generated Mermaid diagrams
![t20013_sequence](./t20013_sequence_mermaid.svg "Function and method arguments in sequence diagrams test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20013_sequence",
  "participants": [
    {
      "display_name": "tmain(int,char **)",
      "full_name": "clanguml::t20013::tmain(int,char **)",
      "id": "9998149056622750574",
      "name": "tmain",
      "namespace": "clanguml::t20013",
      "source_location": {
        "column": 6,
        "file": "t20013.cc",
        "line": 18,
        "translation_unit": "t20013.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "b(int)",
          "full_name": "clanguml::t20013::B::b(int)",
          "id": "17158432866189463946",
          "name": "b",
          "namespace": "clanguml::t20013",
          "source_location": {
            "column": 9,
            "file": "t20013.cc",
            "line": 11,
            "translation_unit": "t20013.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b(double)",
          "full_name": "clanguml::t20013::B::b(double)",
          "id": "5125983075889322302",
          "name": "b",
          "namespace": "clanguml::t20013",
          "source_location": {
            "column": 12,
            "file": "t20013.cc",
            "line": 12,
            "translation_unit": "t20013.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b(const char *)",
          "full_name": "clanguml::t20013::B::b(const char *)",
          "id": "8535486994915273137",
          "name": "b",
          "namespace": "clanguml::t20013",
          "source_location": {
            "column": 17,
            "file": "t20013.cc",
            "line": 13,
            "translation_unit": "t20013.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20013::B",
      "id": "8851260884903610424",
      "name": "B",
      "namespace": "clanguml::t20013",
      "source_location": {
        "column": 8,
        "file": "t20013.cc",
        "line": 10,
        "translation_unit": "t20013.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a1(int)",
          "full_name": "clanguml::t20013::A::a1(int)",
          "id": "8272218263536264033",
          "name": "a1",
          "namespace": "clanguml::t20013",
          "source_location": {
            "column": 9,
            "file": "t20013.cc",
            "line": 5,
            "translation_unit": "t20013.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a2(double)",
          "full_name": "clanguml::t20013::A::a2(double)",
          "id": "3152427199126511320",
          "name": "a2",
          "namespace": "clanguml::t20013",
          "source_location": {
            "column": 12,
            "file": "t20013.cc",
            "line": 6,
            "translation_unit": "t20013.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a3(const char *)",
          "full_name": "clanguml::t20013::A::a3(const char *)",
          "id": "14729914571966940889",
          "name": "a3",
          "namespace": "clanguml::t20013",
          "source_location": {
            "column": 17,
            "file": "t20013.cc",
            "line": 7,
            "translation_unit": "t20013.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20013::A",
      "id": "7812985045593800637",
      "name": "A",
      "namespace": "clanguml::t20013",
      "source_location": {
        "column": 8,
        "file": "t20013.cc",
        "line": 4,
        "translation_unit": "t20013.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "9998149056622750574",
        "location": "clanguml::t20013::tmain(int,char **)"
      },
      "messages": [
        {
          "from": {
            "activity_id": "9998149056622750574",
            "participant_id": "9998149056622750574"
          },
          "name": "b(int)",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20013.cc",
            "line": 22,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "17158432866189463946",
            "participant_id": "8851260884903610424"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17158432866189463946",
            "participant_id": "8851260884903610424"
          },
          "name": "a1(int)",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 27,
            "file": "t20013.cc",
            "line": 11,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "8272218263536264033",
            "participant_id": "7812985045593800637"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8272218263536264033",
            "participant_id": "7812985045593800637"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 21,
            "file": "t20013.cc",
            "line": 5,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "17158432866189463946",
            "participant_id": "8851260884903610424"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "17158432866189463946",
            "participant_id": "8851260884903610424"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 20,
            "file": "t20013.cc",
            "line": 11,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "9998149056622750574",
            "participant_id": "9998149056622750574"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "9998149056622750574",
            "participant_id": "9998149056622750574"
          },
          "name": "b(double)",
          "return_type": "double",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20013.cc",
            "line": 23,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "5125983075889322302",
            "participant_id": "8851260884903610424"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5125983075889322302",
            "participant_id": "8851260884903610424"
          },
          "name": "a2(double)",
          "return_type": "double",
          "scope": "normal",
          "source_location": {
            "column": 33,
            "file": "t20013.cc",
            "line": 12,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "3152427199126511320",
            "participant_id": "7812985045593800637"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "3152427199126511320",
            "participant_id": "7812985045593800637"
          },
          "name": "",
          "return_type": "double",
          "scope": "normal",
          "source_location": {
            "column": 27,
            "file": "t20013.cc",
            "line": 6,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "5125983075889322302",
            "participant_id": "8851260884903610424"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "5125983075889322302",
            "participant_id": "8851260884903610424"
          },
          "name": "",
          "return_type": "double",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20013.cc",
            "line": 12,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "9998149056622750574",
            "participant_id": "9998149056622750574"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "9998149056622750574",
            "participant_id": "9998149056622750574"
          },
          "name": "b(const char *)",
          "return_type": "const char *",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20013.cc",
            "line": 24,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "8535486994915273137",
            "participant_id": "8851260884903610424"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8535486994915273137",
            "participant_id": "8851260884903610424"
          },
          "name": "a3(const char *)",
          "return_type": "const char *",
          "scope": "normal",
          "source_location": {
            "column": 43,
            "file": "t20013.cc",
            "line": 13,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "14729914571966940889",
            "participant_id": "7812985045593800637"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14729914571966940889",
            "participant_id": "7812985045593800637"
          },
          "name": "",
          "return_type": "const char *",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20013.cc",
            "line": 7,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "8535486994915273137",
            "participant_id": "8851260884903610424"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "8535486994915273137",
            "participant_id": "8851260884903610424"
          },
          "name": "",
          "return_type": "const char *",
          "scope": "normal",
          "source_location": {
            "column": 36,
            "file": "t20013.cc",
            "line": 13,
            "translation_unit": "t20013.cc"
          },
          "to": {
            "activity_id": "9998149056622750574",
            "participant_id": "9998149056622750574"
          },
          "type": "return"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20013"
}
```
## Generated GraphML models
