# t20006 - Class template specialization basic sequence diagram
## Config
```yaml
diagrams:
  t20006_sequence:
    type: sequence
    glob:
      - t20006.cc
    include:
      namespaces:
        - clanguml::t20006
    using_namespace: clanguml::t20006
    from:
      - function: "clanguml::t20006::tmain()"
```
## Source code
File `tests/t20006/t20006.cc`
```cpp
#include <string>

namespace clanguml {
namespace t20006 {

template <typename T> struct A {
    T a1(T arg) { return arg; }
    T a2(T arg) { return arg + arg; }
};

template <typename T> struct B {
    T b(T arg) { return a_.a1(arg); }
    A<T> a_;
};

template <> struct B<std::string> {
    std::string b(std::string arg) { return a_.a2(arg); }
    A<std::string> a_;
};

template <typename T> struct AA {
    void aa1(T t) { }
    void aa2(T t) { }
};

template <typename T, typename F> struct BB {
    void bb1(T t, F f) { aa_.aa1(t); }
    void bb2(T t, F f) { aa_.aa2(t); }

    AA<T> aa_;
};

template <typename T> struct BB<T, std::string> {
    void bb1(T t, std::string f) { aa_->aa2(t); }
    void bb2(T t, std::string f) { aa_->aa1(t); }

    BB(AA<T> *aa)
        : aa_{aa}
    {
    }

    AA<T> *aa_;
};

template <typename T> struct BB<T, float> {
    void bb1(T t, float f) { bb2(t, f); }
    void bb2(T t, float f) { aa_.aa2(t); }

    BB(AA<T> &aa)
        : aa_{aa}
    {
    }

    AA<T> &aa_;
};

void tmain()
{
    B<int> bint;
    B<std::string> bstring;

    bint.b(1);
    bstring.b("bstring");

    BB<int, int> bbint;
    AA<int> aaint;
    BB<int, std::string> bbstring{&aaint};
    BB<int, float> bbfloat{aaint};

    bbint.bb1(1, 1);
    bbint.bb2(2, 2);

    bbstring.bb1(1, "calling aa2");
    bbstring.bb2(1, "calling aa1");

    bbfloat.bb1(1, 1.0f);
}
}
}
```
## Generated PlantUML diagrams
![t20006_sequence](./t20006_sequence.svg "Class template specialization basic sequence diagram")
## Generated Mermaid diagrams
![t20006_sequence](./t20006_sequence_mermaid.svg "Class template specialization basic sequence diagram")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20006_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20006::tmain()",
      "id": "2911724675589447667",
      "name": "tmain",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 6,
        "file": "t20006.cc",
        "line": 57,
        "translation_unit": "t20006.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "b(int)",
          "full_name": "clanguml::t20006::B<int>::b(int)",
          "id": "2001977743110748701",
          "name": "b",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 7,
            "file": "t20006.cc",
            "line": 12,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<int>",
      "full_name": "clanguml::t20006::B<int>",
      "id": "17582083986095384286",
      "name": "B",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 30,
        "file": "t20006.cc",
        "line": 11,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a1(int)",
          "full_name": "clanguml::t20006::A<int>::a1(int)",
          "id": "1571123903899165357",
          "name": "a1",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 7,
            "file": "t20006.cc",
            "line": 7,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<int>",
      "full_name": "clanguml::t20006::A<int>",
      "id": "4771878368998632313",
      "name": "A",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 30,
        "file": "t20006.cc",
        "line": 6,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b(std::string)",
          "full_name": "clanguml::t20006::B<std::string>::b(std::string)",
          "id": "104397060422969259",
          "name": "b",
          "namespace": "clanguml::t20006::B<std",
          "source_location": {
            "column": 17,
            "file": "t20006.cc",
            "line": 17,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<std::string>",
      "full_name": "clanguml::t20006::B<std::string>",
      "id": "16820981295866927848",
      "name": "B",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 20,
        "file": "t20006.cc",
        "line": 16,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a2(std::string)",
          "full_name": "clanguml::t20006::A<std::string>::a2(std::string)",
          "id": "94100708992903256",
          "name": "a2",
          "namespace": "clanguml::t20006::A<std",
          "source_location": {
            "column": 7,
            "file": "t20006.cc",
            "line": 8,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<std::string>",
      "full_name": "clanguml::t20006::A<std::string>",
      "id": "3307679003323050191",
      "name": "A",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 30,
        "file": "t20006.cc",
        "line": 6,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "BB(AA<int> *)",
          "full_name": "clanguml::t20006::BB<int,std::string>::BB(AA<int> *)",
          "id": "3053863014462091843",
          "name": "BB",
          "namespace": "clanguml::t20006::BB<int, std",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 37,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb1(int,std::string)",
          "full_name": "clanguml::t20006::BB<int,std::string>::bb1(int,std::string)",
          "id": "8502992045696113005",
          "name": "bb1",
          "namespace": "clanguml::t20006::BB<int, std",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 34,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb2(int,std::string)",
          "full_name": "clanguml::t20006::BB<int,std::string>::bb2(int,std::string)",
          "id": "6301641519958225878",
          "name": "bb2",
          "namespace": "clanguml::t20006::BB<int, std",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 35,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "BB<int,std::string>",
      "full_name": "clanguml::t20006::BB<int,std::string>",
      "id": "18157942666412443777",
      "name": "BB",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 30,
        "file": "t20006.cc",
        "line": 33,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "BB(AA<int> &)",
          "full_name": "clanguml::t20006::BB<int,float>::BB(AA<int> &)",
          "id": "8408105624578590737",
          "name": "BB",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 49,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb1(int,float)",
          "full_name": "clanguml::t20006::BB<int,float>::bb1(int,float)",
          "id": "11705510764579885710",
          "name": "bb1",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 46,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb2(int,float)",
          "full_name": "clanguml::t20006::BB<int,float>::bb2(int,float)",
          "id": "5858901370635215228",
          "name": "bb2",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 47,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "BB<int,float>",
      "full_name": "clanguml::t20006::BB<int,float>",
      "id": "13948024298884041299",
      "name": "BB",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 30,
        "file": "t20006.cc",
        "line": 45,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "bb1(int,int)",
          "full_name": "clanguml::t20006::BB<int,int>::bb1(int,int)",
          "id": "9710920974634781233",
          "name": "bb1",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 27,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb2(int,int)",
          "full_name": "clanguml::t20006::BB<int,int>::bb2(int,int)",
          "id": "2893200991334342837",
          "name": "bb2",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 28,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "BB<int,int>",
      "full_name": "clanguml::t20006::BB<int,int>",
      "id": "2115141231118907078",
      "name": "BB",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 42,
        "file": "t20006.cc",
        "line": 26,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "aa1(int)",
          "full_name": "clanguml::t20006::AA<int>::aa1(int)",
          "id": "9883425311925361535",
          "name": "aa1",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 22,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aa2(int)",
          "full_name": "clanguml::t20006::AA<int>::aa2(int)",
          "id": "4656782618682138323",
          "name": "aa2",
          "namespace": "clanguml::t20006",
          "source_location": {
            "column": 10,
            "file": "t20006.cc",
            "line": 23,
            "translation_unit": "t20006.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "AA<int>",
      "full_name": "clanguml::t20006::AA<int>",
      "id": "15228537831157090497",
      "name": "AA",
      "namespace": "clanguml::t20006",
      "source_location": {
        "column": 30,
        "file": "t20006.cc",
        "line": 21,
        "translation_unit": "t20006.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "2911724675589447667",
        "location": "clanguml::t20006::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "b(int)",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 62,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "2001977743110748701",
            "participant_id": "17582083986095384286"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2001977743110748701",
            "participant_id": "17582083986095384286"
          },
          "name": "a1(int)",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20006.cc",
            "line": 12,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "1571123903899165357",
            "participant_id": "4771878368998632313"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1571123903899165357",
            "participant_id": "4771878368998632313"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 19,
            "file": "t20006.cc",
            "line": 7,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "2001977743110748701",
            "participant_id": "17582083986095384286"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "2001977743110748701",
            "participant_id": "17582083986095384286"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20006.cc",
            "line": 12,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "b(std::string)",
          "return_type": "std::string",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 63,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "104397060422969259",
            "participant_id": "16820981295866927848"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "104397060422969259",
            "participant_id": "16820981295866927848"
          },
          "name": "a2(std::string)",
          "return_type": "std::string",
          "scope": "normal",
          "source_location": {
            "column": 45,
            "file": "t20006.cc",
            "line": 17,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "94100708992903256",
            "participant_id": "3307679003323050191"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "94100708992903256",
            "participant_id": "3307679003323050191"
          },
          "name": "",
          "return_type": "class std::string",
          "scope": "normal",
          "source_location": {
            "column": 19,
            "file": "t20006.cc",
            "line": 8,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "104397060422969259",
            "participant_id": "16820981295866927848"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "104397060422969259",
            "participant_id": "16820981295866927848"
          },
          "name": "",
          "return_type": "std::string",
          "scope": "normal",
          "source_location": {
            "column": 38,
            "file": "t20006.cc",
            "line": 17,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "BB(AA<int> *)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20006.cc",
            "line": 67,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "3053863014462091843",
            "participant_id": "18157942666412443777"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "BB(AA<int> &)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 20,
            "file": "t20006.cc",
            "line": 68,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "8408105624578590737",
            "participant_id": "13948024298884041299"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "bb1(int,int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 70,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "9710920974634781233",
            "participant_id": "2115141231118907078"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9710920974634781233",
            "participant_id": "2115141231118907078"
          },
          "name": "aa1(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20006.cc",
            "line": 27,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "9883425311925361535",
            "participant_id": "15228537831157090497"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "bb2(int,int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 71,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "2893200991334342837",
            "participant_id": "2115141231118907078"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2893200991334342837",
            "participant_id": "2115141231118907078"
          },
          "name": "aa2(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20006.cc",
            "line": 28,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "4656782618682138323",
            "participant_id": "15228537831157090497"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "bb1(int,std::string)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 73,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "8502992045696113005",
            "participant_id": "18157942666412443777"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8502992045696113005",
            "participant_id": "18157942666412443777"
          },
          "name": "aa2(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 36,
            "file": "t20006.cc",
            "line": 34,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "4656782618682138323",
            "participant_id": "15228537831157090497"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "bb2(int,std::string)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 74,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "6301641519958225878",
            "participant_id": "18157942666412443777"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6301641519958225878",
            "participant_id": "18157942666412443777"
          },
          "name": "aa1(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 36,
            "file": "t20006.cc",
            "line": 35,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "9883425311925361535",
            "participant_id": "15228537831157090497"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2911724675589447667",
            "participant_id": "2911724675589447667"
          },
          "name": "bb1(int,float)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20006.cc",
            "line": 76,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "11705510764579885710",
            "participant_id": "13948024298884041299"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "11705510764579885710",
            "participant_id": "13948024298884041299"
          },
          "name": "bb2(int,float)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 30,
            "file": "t20006.cc",
            "line": 46,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "5858901370635215228",
            "participant_id": "13948024298884041299"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5858901370635215228",
            "participant_id": "13948024298884041299"
          },
          "name": "aa2(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 30,
            "file": "t20006.cc",
            "line": 47,
            "translation_unit": "t20006.cc"
          },
          "to": {
            "activity_id": "4656782618682138323",
            "participant_id": "15228537831157090497"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20006"
}
```
## Generated GraphML models
