# t00056 - Basic C++20 concepts test case
## Config
```yaml
diagrams:
  t00056_class:
    type: class
    glob:
      - t00056.cc
    include:
      namespaces:
        - clanguml::t00056
    using_namespace: clanguml::t00056
```
## Source code
File `tests/t00056/t00056.cc`
```cpp
#include <concepts>
#include <string>

namespace clanguml {
namespace t00056 {

template <typename T, typename L>
concept greater_than_simple = sizeof(T) > sizeof(L);

template <typename T, typename P>
concept greater_than_with_requires =
    requires(T l, P r) { sizeof(l) > sizeof(r); };

// Constraint expression
template <typename T>
concept max_four_bytes = sizeof(T) <= 4;

// Simple requirement
template <typename T>
concept iterable = requires(T container) {
    container.begin();
    container.end();
};

// Type requirement
template <typename T>
concept has_value_type = requires { typename T::value_type; };

template <typename T>
concept convertible_to_string = max_four_bytes<T> && requires(T s) {
    std::string{s};
    { std::to_string(s) } noexcept;
    { std::to_string(s) } -> std::same_as<std::string>;
};

// Compound requirement
// ...

// Combined concept
template <typename T>
concept iterable_with_value_type = iterable<T> && has_value_type<T>;

template <typename T>
concept iterable_or_small_value_type =
    iterable_with_value_type<T> || max_four_bytes<T>;

// Simple type constraint
template <max_four_bytes T> struct A {
    T a;
};

// Requires constant expression
template <typename T>
    requires iterable_or_small_value_type<T>
struct B {
    T b;
};

// Anonymous concept requirement (TODO)
template <convertible_to_string T>
    requires requires(T t) {
        --t;
        t--;
    }
struct C {
    T c;
};

template <iterable T1, typename T2, iterable T3, typename T4, typename T5>
    requires max_four_bytes<T2> && max_four_bytes<T5>
struct D { };

template <typename T1, typename T2, typename T3>
    requires greater_than_with_requires<T1, T3>
struct E {
    T1 e1;
    T2 e2;
    T3 e3;
};

template <typename T1, typename T2, typename T3>
    requires greater_than_simple<T1, T3>
struct F {
    T1 f1;
    T2 f2;
    T3 f3;
};
}
}
```
## Generated PlantUML diagrams
![t00056_class](./t00056_class.svg "Basic C++20 concepts test case")
## Generated Mermaid diagrams
![t00056_class](./t00056_class_mermaid.svg "Basic C++20 concepts test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "greater_than_simple<T,L>",
      "id": "7220333570897953632",
      "name": "greater_than_simple",
      "namespace": "clanguml::t00056",
      "parameters": [],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 8,
        "translation_unit": "t00056.cc"
      },
      "statements": [],
      "type": "concept"
    },
    {
      "display_name": "greater_than_with_requires<T,P>",
      "id": "14645732685101884614",
      "name": "greater_than_with_requires",
      "namespace": "clanguml::t00056",
      "parameters": [
        {
          "name": "l",
          "type": "T"
        },
        {
          "name": "r",
          "type": "P"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 11,
        "translation_unit": "t00056.cc"
      },
      "statements": [
        "sizeof (l) > sizeof (r)"
      ],
      "type": "concept"
    },
    {
      "display_name": "max_four_bytes<T>",
      "id": "3082044181533866602",
      "name": "max_four_bytes",
      "namespace": "clanguml::t00056",
      "parameters": [],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 16,
        "translation_unit": "t00056.cc"
      },
      "statements": [],
      "type": "concept"
    },
    {
      "display_name": "iterable<T>",
      "id": "3140327690817993937",
      "name": "iterable",
      "namespace": "clanguml::t00056",
      "parameters": [
        {
          "name": "container",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 20,
        "translation_unit": "t00056.cc"
      },
      "statements": [
        "container.begin()",
        "container.end()"
      ],
      "type": "concept"
    },
    {
      "display_name": "has_value_type<T>",
      "id": "14803154489810213430",
      "name": "has_value_type",
      "namespace": "clanguml::t00056",
      "parameters": [],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 27,
        "translation_unit": "t00056.cc"
      },
      "statements": [
        "typename T::value_type"
      ],
      "type": "concept"
    },
    {
      "display_name": "convertible_to_string<T>",
      "id": "1098439696568435981",
      "name": "convertible_to_string",
      "namespace": "clanguml::t00056",
      "parameters": [
        {
          "name": "s",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 30,
        "translation_unit": "t00056.cc"
      },
      "statements": [
        "std::string{s}",
        "{std::to_string(s)} noexcept",
        "{std::to_string(s)} -> std::same_as<std::string>"
      ],
      "type": "concept"
    },
    {
      "display_name": "iterable_with_value_type<T>",
      "id": "8347184497174008159",
      "name": "iterable_with_value_type",
      "namespace": "clanguml::t00056",
      "parameters": [],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 41,
        "translation_unit": "t00056.cc"
      },
      "statements": [],
      "type": "concept"
    },
    {
      "display_name": "iterable_or_small_value_type<T>",
      "id": "6930764924409789751",
      "name": "iterable_or_small_value_type",
      "namespace": "clanguml::t00056",
      "parameters": [],
      "source_location": {
        "column": 9,
        "file": "t00056.cc",
        "line": 44,
        "translation_unit": "t00056.cc"
      },
      "statements": [],
      "type": "concept"
    },
    {
      "bases": [],
      "display_name": "A<max_four_bytes T>",
      "id": "11346667996363373290",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "t00056.cc",
            "line": 49,
            "translation_unit": "t00056.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00056",
      "source_location": {
        "column": 36,
        "file": "t00056.cc",
        "line": 48,
        "translation_unit": "t00056.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<T>",
      "id": "14514843974519823043",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 7,
            "file": "t00056.cc",
            "line": 56,
            "translation_unit": "t00056.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00056",
      "source_location": {
        "column": 8,
        "file": "t00056.cc",
        "line": 55,
        "translation_unit": "t00056.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<convertible_to_string T>",
      "id": "12100945585932392719",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 7,
            "file": "t00056.cc",
            "line": 66,
            "translation_unit": "t00056.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00056",
      "source_location": {
        "column": 8,
        "file": "t00056.cc",
        "line": 65,
        "translation_unit": "t00056.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D<iterable T1,T2,iterable T3,T4,T5>",
      "id": "13080876813041584751",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00056",
      "source_location": {
        "column": 8,
        "file": "t00056.cc",
        "line": 71,
        "translation_unit": "t00056.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T1",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T2",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T3",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T4",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T5",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E<T1,T2,T3>",
      "id": "11433806415564968716",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "e1",
          "source_location": {
            "column": 8,
            "file": "t00056.cc",
            "line": 76,
            "translation_unit": "t00056.cc"
          },
          "type": "T1"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "e2",
          "source_location": {
            "column": 8,
            "file": "t00056.cc",
            "line": 77,
            "translation_unit": "t00056.cc"
          },
          "type": "T2"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "e3",
          "source_location": {
            "column": 8,
            "file": "t00056.cc",
            "line": 78,
            "translation_unit": "t00056.cc"
          },
          "type": "T3"
        }
      ],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00056",
      "source_location": {
        "column": 8,
        "file": "t00056.cc",
        "line": 75,
        "translation_unit": "t00056.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T1",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T2",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T3",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "F<T1,T2,T3>",
      "id": "6850408983780368279",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "f1",
          "source_location": {
            "column": 8,
            "file": "t00056.cc",
            "line": 84,
            "translation_unit": "t00056.cc"
          },
          "type": "T1"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "f2",
          "source_location": {
            "column": 8,
            "file": "t00056.cc",
            "line": 85,
            "translation_unit": "t00056.cc"
          },
          "type": "T2"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "f3",
          "source_location": {
            "column": 8,
            "file": "t00056.cc",
            "line": 86,
            "translation_unit": "t00056.cc"
          },
          "type": "T3"
        }
      ],
      "methods": [],
      "name": "F",
      "namespace": "clanguml::t00056",
      "source_location": {
        "column": 8,
        "file": "t00056.cc",
        "line": 83,
        "translation_unit": "t00056.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T1",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T2",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T3",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00056_class",
  "package_type": "namespace",
  "relationships": [
    {
      "destination": "3082044181533866602",
      "label": "T",
      "source": "1098439696568435981",
      "type": "constraint"
    },
    {
      "destination": "3140327690817993937",
      "label": "T",
      "source": "8347184497174008159",
      "type": "constraint"
    },
    {
      "destination": "14803154489810213430",
      "label": "T",
      "source": "8347184497174008159",
      "type": "constraint"
    },
    {
      "destination": "8347184497174008159",
      "label": "T",
      "source": "6930764924409789751",
      "type": "constraint"
    },
    {
      "destination": "3082044181533866602",
      "label": "T",
      "source": "6930764924409789751",
      "type": "constraint"
    },
    {
      "destination": "3082044181533866602",
      "label": "T",
      "source": "11346667996363373290",
      "type": "constraint"
    },
    {
      "destination": "6930764924409789751",
      "label": "T",
      "source": "14514843974519823043",
      "type": "constraint"
    },
    {
      "destination": "1098439696568435981",
      "label": "T",
      "source": "12100945585932392719",
      "type": "constraint"
    },
    {
      "destination": "3140327690817993937",
      "label": "T1",
      "source": "13080876813041584751",
      "type": "constraint"
    },
    {
      "destination": "3140327690817993937",
      "label": "T3",
      "source": "13080876813041584751",
      "type": "constraint"
    },
    {
      "destination": "3082044181533866602",
      "label": "T2",
      "source": "13080876813041584751",
      "type": "constraint"
    },
    {
      "destination": "3082044181533866602",
      "label": "T5",
      "source": "13080876813041584751",
      "type": "constraint"
    },
    {
      "destination": "14645732685101884614",
      "label": "T1,T3",
      "source": "11433806415564968716",
      "type": "constraint"
    },
    {
      "destination": "7220333570897953632",
      "label": "T1,T3",
      "source": "6850408983780368279",
      "type": "constraint"
    }
  ],
  "using_namespace": "clanguml::t00056"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00056</data>
  <node id="n0">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[greater_than_simple<T,L>]]></data>
  </node>
  <node id="n1">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[greater_than_with_requires<T,P>]]></data>
  </node>
  <node id="n2">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[max_four_bytes<T>]]></data>
  </node>
  <node id="n3">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[iterable<T>]]></data>
  </node>
  <node id="n4">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[has_value_type<T>]]></data>
  </node>
  <node id="n5">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[convertible_to_string<T>]]></data>
  </node>
  <node id="n6">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[iterable_with_value_type<T>]]></data>
  </node>
  <node id="n7">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[iterable_or_small_value_type<T>]]></data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<max_four_bytes T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<convertible_to_string T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D<iterable T1,T2,iterable T3,T4,T5>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E<T1,T2,T3>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n13">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[F<T1,T2,T3>]]></data>
   <data key="nd6">true</data>
  </node>
  <edge id="e0" source="n8" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e1" source="n9" target="n7">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e2" source="n10" target="n5">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e3" source="n11" target="n3">
   <data key="ed0">constraint</data>
   <data key="ed2">T1</data>
  </edge>
  <edge id="e4" source="n11" target="n3">
   <data key="ed0">constraint</data>
   <data key="ed2">T3</data>
  </edge>
  <edge id="e5" source="n11" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">T2</data>
  </edge>
  <edge id="e6" source="n11" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">T5</data>
  </edge>
  <edge id="e7" source="n12" target="n1">
   <data key="ed0">constraint</data>
   <data key="ed2">T1,T3</data>
  </edge>
  <edge id="e8" source="n13" target="n0">
   <data key="ed0">constraint</data>
   <data key="ed2">T1,T3</data>
  </edge>
  <edge id="e9" source="n5" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e10" source="n6" target="n3">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e11" source="n6" target="n4">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e12" source="n7" target="n6">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e13" source="n7" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
 </graph>
</graphml>

```
