(in-package :djula)

(pushnew :gettext *translation-backends*)

(defvar *gettext-domain* nil)

(defmethod backend-translate ((backend (eql :gettext)) string language &rest args)
  (apply #'format-translation
         (gettext:gettext* string *gettext-domain* nil (string language))
         args))

;; Some extra utility functions for working with gettext

(defun xgettext-templates (gettext-package output-file &key templates-directories)
  "
Extract gettext entries from templates.
Those entries can then be used with xgettext command to generate .pot files.

Arguments:
- GETTEXT-PACKAGE is a package initialized using GETTEXT:SETUP-GETTEXT.
- OUTPUT-FILE is a pathname where gettext entries are to be written to.
- TEMPLATES-DIRECTORIES in the list of directories where to look for templates. If is NIL, then templates are searched in the search-path of the current Djula store."
  (let* ((templates-directories (or templates-directories
                                    (djula::search-path djula::*current-store*)))
         (messages
           (loop for dir in templates-directories
                 appending
                 (djula.locale:directory-translate-strings dir))))
    (with-open-file (file output-file
                          :direction :output :if-exists :supersede
                          :if-does-not-exist :create)
      (write-string ";; THIS FILE IS AUTOGENERATED. DON'T CHANGE BY HAND. USE XGETTEXT-TEMPLATES FUNCTION." file)
      (terpri file)
      (loop for message in messages
            do
               (prin1 `(,(intern "GETTEXT" gettext-package) ,message) file)
               (terpri file)))))
