/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class IntArray
extends AArray {
    public IntArray(Object object) throws Throwable {
        super(object);
    }

    public IntArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (int[])this.o;
            }
            case 2: {
                return (int[][])this.o;
            }
            case 3: {
                return (int[][][])this.o;
            }
            case 4: {
                return (int[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != Integer.TYPE && clazz != Short.TYPE) {
            throw new Throwable("Only int and short targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        int n2 = clazz == Short.TYPE ? 2 : 4;
        ByteBuffer byteBuffer = this.allocate(n2);
        if (clazz == Short.TYPE) {
            return this.doShort(byteBuffer);
        }
        return this.doInt(byteBuffer);
    }

    ByteBuffer doShort(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        short[] sArray = null;
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        switch (this.dim) {
            case 1: {
                int[] nArray2 = (int[])this.o;
                sArray = new short[nArray2.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    sArray[i] = (short)nArray2[i];
                }
                shortBuffer.put(sArray);
                return byteBuffer;
            }
            case 2: {
                int[][] nArray3 = (int[][])this.o;
                sArray = new short[nArray[1]];
                for (int i = 0; i < nArray[0]; ++i) {
                    int[] nArray4 = nArray3[i];
                    for (int j = 0; j < nArray[1]; ++j) {
                        sArray[j] = (short)nArray4[j];
                    }
                    shortBuffer.put(sArray);
                }
                return byteBuffer;
            }
            case 3: {
                int[][][] nArray5 = (int[][][])this.o;
                if (this.rowMajority) {
                    sArray = new short[nArray[2]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            int[] nArray6 = nArray5[i][j];
                            for (int k = 0; k < nArray[2]; ++k) {
                                sArray[k] = (short)nArray6[k];
                            }
                            shortBuffer.put(sArray);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                shortBuffer.put((short)nArray5[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                int[][][][] nArray7 = (int[][][][])this.o;
                if (this.rowMajority) {
                    sArray = new short[nArray[3]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                int[] nArray8 = nArray7[i][j][k];
                                for (int i2 = 0; i2 < nArray[3]; ++i2) {
                                    sArray[i2] = (short)nArray8[i2];
                                }
                                shortBuffer.put(sArray);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i3 = 0; i3 < nArray[1]; ++i3) {
                                    shortBuffer.put((short)nArray7[i][i3][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }

    ByteBuffer doInt(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        switch (this.dim) {
            case 1: {
                int[] nArray2 = (int[])this.o;
                intBuffer.put(nArray2);
                return byteBuffer;
            }
            case 2: {
                int[][] nArray3 = (int[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    intBuffer.put(nArray3[i]);
                }
                return byteBuffer;
            }
            case 3: {
                int[][][] nArray4 = (int[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            intBuffer.put(nArray4[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                intBuffer.put(nArray4[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                int[][][][] nArray5 = (int[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                intBuffer.put(nArray5[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    intBuffer.put(nArray5[i][i2][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }
}

