/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class FloatArray
extends AArray {
    public FloatArray(Object object) throws Throwable {
        super(object, true);
    }

    public FloatArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (float[])this.o;
            }
            case 2: {
                return (float[][])this.o;
            }
            case 3: {
                return (float[][][])this.o;
            }
            case 4: {
                return (float[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != Float.TYPE) {
            throw new Throwable("Only float targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        ByteBuffer byteBuffer = this.allocate(4);
        int[] nArray = this.aa.getDimensions();
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        switch (this.dim) {
            case 1: {
                float[] fArray = (float[])this.o;
                floatBuffer.put(fArray);
                return byteBuffer;
            }
            case 2: {
                float[][] fArray = (float[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    floatBuffer.put(fArray[i]);
                }
                return byteBuffer;
            }
            case 3: {
                float[][][] fArray = (float[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            floatBuffer.put(fArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                floatBuffer.put(fArray[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                float[][][][] fArray = (float[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                floatBuffer.put(fArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    floatBuffer.put(fArray[i][i2][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }
}

