/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ByteArray;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteVarContainer
extends BaseVarContainer
implements VDataContainer.CByte {
    final byte[] bpad;

    public ByteVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray, true, ByteOrder.BIG_ENDIAN, Byte.TYPE);
        Object object = this.thisCDF.getPadValue(variable);
        if (DataTypes.isStringType(this.type)) {
            String[] stringArray = (String[])object;
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                n += stringArray[i].length();
            }
            this.bpad = new byte[n];
            n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                byte[] byArray = stringArray[i].getBytes();
                for (int j = 0; j < byArray.length; ++j) {
                    this.bpad[n++] = byArray[j];
                }
            }
        } else {
            double[] dArray = (double[])object;
            this.bpad = new byte[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.bpad[i] = (byte)dArray[i];
            }
        }
    }

    @Override
    ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(this.order);
        return byteBuffer;
    }

    @Override
    public Object allocateDataArray(int n) {
        return null;
    }

    @Override
    void doMissing(int n, ByteBuffer byteBuffer, Object object, int n2) {
        byte[] byArray = null;
        try {
            byArray = n2 < 0 ? this.bpad : this.var.asByteArray(new int[]{n2});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Should not see this.");
        }
        int n3 = n;
        byte[] byArray2 = new byte[n3 * this.elements];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            byArray2[n4++] = byArray[0];
            for (int j = 1; j < byArray.length; ++j) {
                byArray2[n4++] = byArray[j];
            }
        }
        byteBuffer.put(byArray2, 0, n3 * this.elements);
    }

    @Override
    void doData(ByteBuffer byteBuffer, int n, int n2, int n3, ByteBuffer byteBuffer2, Object object) {
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer3.limit(this.itemSize * n3);
        byteBuffer2.put(byteBuffer3);
    }

    public static boolean isCompatible(int n, boolean bl) {
        return ByteVarContainer.isCompatible(n, bl, Byte.TYPE);
    }

    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 4) {
            throw new Throwable("Rank > 4 not supported at this time.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining();
        int n3 = -1;
        switch (n) {
            case 0: {
                if (this.singlePoint) {
                    return new Byte(byteBuffer.get());
                }
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                return byArray;
            }
            case 1: {
                int n4 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / n4;
                byte[][] byArray = new byte[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    byteBuffer.get(byArray[i]);
                }
                return this.singlePoint ? (Object)byArray[0] : byArray;
            }
            case 2: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                int n6 = (Integer)this.var.getElementCount().elementAt(1);
                n3 = n2 / (n5 * n6);
                byte[][][] byArray = new byte[n3][n5][n6];
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        byteBuffer.get(byArray[i][j]);
                    }
                }
                return this.singlePoint ? (Object)byArray[0] : byArray;
            }
            case 3: {
                int n7 = (Integer)this.var.getElementCount().elementAt(0);
                int n8 = (Integer)this.var.getElementCount().elementAt(1);
                int n9 = (Integer)this.var.getElementCount().elementAt(2);
                n3 = n2 / (n7 * n8 * n9);
                byte[][][][] byArray = new byte[n3][n7][n8][n9];
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        for (int k = 0; k < n8; ++k) {
                            byteBuffer.get(byArray[i][j][k]);
                        }
                    }
                }
                return this.singlePoint ? (Object)byArray[0] : byArray;
            }
            case 4: {
                int n10 = (Integer)this.var.getElementCount().elementAt(0);
                int n11 = (Integer)this.var.getElementCount().elementAt(1);
                int n12 = (Integer)this.var.getElementCount().elementAt(2);
                int n13 = (Integer)this.var.getElementCount().elementAt(3);
                n3 = n2 / (n10 * n11 * n12 * n13);
                byte[][][][][] byArray = new byte[n3][n10][n11][n12][n13];
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n10; ++j) {
                        for (int k = 0; k < n11; ++k) {
                            for (int i2 = 0; i2 < n12; ++i2) {
                                byteBuffer.get(byArray[i][j][k][i2]);
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)byArray[0] : byArray;
            }
        }
        throw new Throwable("Internal error");
    }

    public void fillArray(byte[] byArray, int n, int n2, int n3) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int n4 = (n3 - n2 + 1) * this.elements;
        ByteBuffer byteBuffer = this.getBuffer();
        int n5 = (n2 - this.getRecordRange()[0]) * this.elements * this.getLength();
        byteBuffer.position(n5);
        byteBuffer.get(byArray, n, n4);
    }

    @Override
    public byte[] as1DArray() {
        return (byte[])super.as1DArray();
    }

    @Override
    public byte[] asOneDArray() {
        return (byte[])super.asOneDArray(true);
    }

    @Override
    public byte[] asOneDArray(boolean bl) {
        return (byte[])super.asOneDArray(bl);
    }

    @Override
    public AArray asArray() throws Throwable {
        return new ByteArray(this._asArray());
    }
}

