/*
   Copyright (C) 2010 Clozure Associates
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Clozure CL.  

   Clozure CL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with Clozure CL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with Clozure CL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   Clozure CL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/

#define WORD_SIZE 32
#define PLATFORM_OS PLATFORM_OS_DARWIN
#define PLATFORM_CPU PLATFORM_CPU_ARM
#define PLATFORM_WORD_SIZE PLATFORM_WORD_SIZE_32

#include <sys/signal.h>
#include <sys/ucontext.h>

typedef ucontext_t ExceptionInformation;

#include "standard-inttypes.h"


#define MAXIMUM_MAPPABLE_MEMORY (256<<20) /* uh, no */
#define IMAGE_BASE_ADDRESS 0x04001000

#include "lisptypes.h"
#include "arm-constants.h"

#define UC_MCONTEXT(UC) UC->uc_mcontext

/* xp accessors */
#define xpGPRvector(x) ((natural *)&((x)->uc_mcontext->__ss.__r[0]))
#define xpGPR(x,gprno) (xpGPRvector(x))[gprno]
#define xpPC(x) (*((pc*)(&(xpGPR(x,15)))))
#define xpLR(x) (*((pc*)(&(xpGPR(x,14)))))
#define xpPSR(x) xpGPR(x,16)
#define xpFaultAddress(x) ((x)->uc_mcontext->__es.__far)
#define xpFaultStatus(x)  ((x)->uc_mcontext->__es.__fsr)


#define DarwinSigReturn(context)
#define SIGRETURN(context)

#include "os-darwin.h"

