/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2014 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            K.U. Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "bonmin_interface.hpp"
      #include <string>

      const std::string casadi::BonminInterface::meta_doc=
      "\n"
"When in warmstart mode, output NLPSOL_LAM_X may be used as input\n"
"\n"
"NOTE: Even when max_iter == 0, it is not guaranteed that\n"
"input(NLPSOL_X0) == output(NLPSOL_X). Indeed if bounds on X or\n"
"constraints are unmet, they will differ.\n"
"\n"
"For a good tutorial on IPOPT, seehttp://drops.dagstuhl.de/volltexte/2009/2089/pdf/09061.WaechterAndreas.Paper.2089.pdf\n"
"\n"
"A good resource about the algorithms in IPOPT is: Wachter and L. T.\n"
"Biegler, On the Implementation of an Interior-Point Filter Line-Search\n"
"Algorithm for Large-Scale Nonlinear Programming, Mathematical\n"
"Programming 106(1), pp. 25-57, 2006 (As Research Report RC 23149, IBM\n"
"T. J. Watson Research Center, Yorktown, USA\n"
"\n"
"Caveats:\n"
"with default options, multipliers for the decision variables are wrong\n"
"for equality constraints. Change the 'fixed_variable_treatment' to\n"
"'make_constraint' or 'relax_bounds' to obtain correct results.\n"
"\n"
"\n"
"\n"
">List of available options\n"
"\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"|       Id        |      Type       |     Default     |   Description   |\n"
"+=================+=================+=================+=================+\n"
"| accept_after_ma | OT_INT      | -1              | Accept a trial  |\n"
"| x_steps         |                 |                 | point after     |\n"
"|                 |                 |                 | maximal this    |\n"
"|                 |                 |                 | number of       |\n"
"|                 |                 |                 | steps. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| accept_every_tr | OT_STRING       | no              | Always accept   |\n"
"| ial_step        |                 |                 | the first trial |\n"
"|                 |                 |                 | step. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| acceptable_comp | OT_DOUBLE         | 0.010           | \"Acceptance\"    |\n"
"| l_inf_tol       |                 |                 | threshold for   |\n"
"|                 |                 |                 | the             |\n"
"|                 |                 |                 | complementarity |\n"
"|                 |                 |                 | conditions.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| acceptable_cons | OT_DOUBLE         | 0.010           | \"Acceptance\"    |\n"
"| tr_viol_tol     |                 |                 | threshold for   |\n"
"|                 |                 |                 | the constraint  |\n"
"|                 |                 |                 | violation. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| acceptable_dual | OT_DOUBLE         | 1.000e+10       | \"Acceptance\"    |\n"
"| _inf_tol        |                 |                 | threshold for   |\n"
"|                 |                 |                 | the dual        |\n"
"|                 |                 |                 | infeasibility.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| acceptable_iter | OT_INT      | 15              | Number of       |\n"
"|                 |                 |                 | \"acceptable\"    |\n"
"|                 |                 |                 | iterates before |\n"
"|                 |                 |                 | triggering      |\n"
"|                 |                 |                 | termination.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| acceptable_obj_ | OT_DOUBLE         | 1.000e+20       | \"Acceptance\"    |\n"
"| change_tol      |                 |                 | stopping        |\n"
"|                 |                 |                 | criterion based |\n"
"|                 |                 |                 | on objective    |\n"
"|                 |                 |                 | function        |\n"
"|                 |                 |                 | change. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| acceptable_tol  | OT_DOUBLE         | 0.000           | \"Acceptable\"    |\n"
"|                 |                 |                 | convergence     |\n"
"|                 |                 |                 | tolerance       |\n"
"|                 |                 |                 | (relative).     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_glo | OT_STRING       | obj-constr-     | Globalization   |\n"
"| balization      |                 | filter          | strategy for    |\n"
"|                 |                 |                 | the adaptive mu |\n"
"|                 |                 |                 | selection mode. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_kkt | OT_STRING       | 2-norm-squared  | Norm used for   |\n"
"| _norm_type      |                 |                 | the KKT error   |\n"
"|                 |                 |                 | in the adaptive |\n"
"|                 |                 |                 | mu              |\n"
"|                 |                 |                 | globalization   |\n"
"|                 |                 |                 | strategies.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_kkt | OT_DOUBLE         | 1.000           | Sufficient      |\n"
"| error_red_fact  |                 |                 | decrease factor |\n"
"|                 |                 |                 | for \"kkt-error\" |\n"
"|                 |                 |                 | globalization   |\n"
"|                 |                 |                 | strategy. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_kkt | OT_INT      | 4               | Maximum number  |\n"
"| error_red_iters |                 |                 | of iterations   |\n"
"|                 |                 |                 | requiring       |\n"
"|                 |                 |                 | sufficient      |\n"
"|                 |                 |                 | progress. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_mon | OT_DOUBLE         | 0.800           | Determines the  |\n"
"| otone_init_fact |                 |                 | initial value   |\n"
"| or              |                 |                 | of the barrier  |\n"
"|                 |                 |                 | parameter when  |\n"
"|                 |                 |                 | switching to    |\n"
"|                 |                 |                 | the monotone    |\n"
"|                 |                 |                 | mode. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_res | OT_STRING       | no              | Indicates if    |\n"
"| tore_previous_i |                 |                 | the previous    |\n"
"| terate          |                 |                 | iterate should  |\n"
"|                 |                 |                 | be restored if  |\n"
"|                 |                 |                 | the monotone    |\n"
"|                 |                 |                 | mode is         |\n"
"|                 |                 |                 | entered. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| adaptive_mu_saf | OT_DOUBLE         | 0               | (see IPOPT      |\n"
"| eguard_factor   |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| alpha_for_y     | OT_STRING       | primal          | Method to       |\n"
"|                 |                 |                 | determine the   |\n"
"|                 |                 |                 | step size for   |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | multipliers.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| alpha_for_y_tol | OT_DOUBLE         | 10              | Tolerance for   |\n"
"|                 |                 |                 | switching to    |\n"
"|                 |                 |                 | full equality   |\n"
"|                 |                 |                 | multiplier      |\n"
"|                 |                 |                 | steps. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| alpha_min_frac  | OT_DOUBLE         | 0.050           | Safety factor   |\n"
"|                 |                 |                 | for the minimal |\n"
"|                 |                 |                 | step size       |\n"
"|                 |                 |                 | (before         |\n"
"|                 |                 |                 | switching to    |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase). (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| alpha_red_facto | OT_DOUBLE         | 0.500           | Fractional      |\n"
"| r               |                 |                 | reduction of    |\n"
"|                 |                 |                 | the trial step  |\n"
"|                 |                 |                 | size in the     |\n"
"|                 |                 |                 | backtracking    |\n"
"|                 |                 |                 | line search.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| barrier_tol_fac | OT_DOUBLE         | 10              | Factor for mu   |\n"
"| tor             |                 |                 | in barrier stop |\n"
"|                 |                 |                 | test. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| bound_frac      | OT_DOUBLE         | 0.010           | Desired minimum |\n"
"|                 |                 |                 | relative        |\n"
"|                 |                 |                 | distance from   |\n"
"|                 |                 |                 | the initial     |\n"
"|                 |                 |                 | point to bound. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| bound_mult_init | OT_STRING       | constant        | Initialization  |\n"
"| _method         |                 |                 | method for      |\n"
"|                 |                 |                 | bound           |\n"
"|                 |                 |                 | multipliers     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| bound_mult_init | OT_DOUBLE         | 1               | Initial value   |\n"
"| _val            |                 |                 | for the bound   |\n"
"|                 |                 |                 | multipliers.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| bound_mult_rese | OT_DOUBLE         | 1000            | Threshold for   |\n"
"| t_threshold     |                 |                 | resetting bound |\n"
"|                 |                 |                 | multipliers     |\n"
"|                 |                 |                 | after the       |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| bound_push      | OT_DOUBLE         | 0.010           | Desired minimum |\n"
"|                 |                 |                 | absolute        |\n"
"|                 |                 |                 | distance from   |\n"
"|                 |                 |                 | the initial     |\n"
"|                 |                 |                 | point to bound. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| bound_relax_fac | OT_DOUBLE         | 0.000           | Factor for      |\n"
"| tor             |                 |                 | initial         |\n"
"|                 |                 |                 | relaxation of   |\n"
"|                 |                 |                 | the bounds.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| check_derivativ | OT_STRING       | no              | Indicates       |\n"
"| es_for_naninf   |                 |                 | whether it is   |\n"
"|                 |                 |                 | desired to      |\n"
"|                 |                 |                 | check for       |\n"
"|                 |                 |                 | Nan/Inf in      |\n"
"|                 |                 |                 | derivative      |\n"
"|                 |                 |                 | matrices (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| chi_cup         | OT_DOUBLE         | 1.500           | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| chi_hat         | OT_DOUBLE         | 2               | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| chi_tilde       | OT_DOUBLE         | 5               | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| compl_inf_tol   | OT_DOUBLE         | 0.000           | Desired         |\n"
"|                 |                 |                 | threshold for   |\n"
"|                 |                 |                 | the             |\n"
"|                 |                 |                 | complementarity |\n"
"|                 |                 |                 | conditions.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| con_integer_md  | OT_DICT   | None            | Integer         |\n"
"|                 |                 |                 | metadata (a     |\n"
"|                 |                 |                 | dictionary with |\n"
"|                 |                 |                 | lists of        |\n"
"|                 |                 |                 | integers) about |\n"
"|                 |                 |                 | constraints to  |\n"
"|                 |                 |                 | be passed to    |\n"
"|                 |                 |                 | IPOPT           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| con_numeric_md  | OT_DICT   | None            | Numeric         |\n"
"|                 |                 |                 | metadata (a     |\n"
"|                 |                 |                 | dictionary with |\n"
"|                 |                 |                 | lists of reals) |\n"
"|                 |                 |                 | about           |\n"
"|                 |                 |                 | constraints to  |\n"
"|                 |                 |                 | be passed to    |\n"
"|                 |                 |                 | IPOPT           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| con_string_md   | OT_DICT   | None            | String metadata |\n"
"|                 |                 |                 | (a dictionary   |\n"
"|                 |                 |                 | with lists of   |\n"
"|                 |                 |                 | strings) about  |\n"
"|                 |                 |                 | constraints to  |\n"
"|                 |                 |                 | be passed to    |\n"
"|                 |                 |                 | IPOPT           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| constr_mult_ini | OT_DOUBLE         | 1000            | Maximum allowed |\n"
"| t_max           |                 |                 | least-square    |\n"
"|                 |                 |                 | guess of        |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | multipliers.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| constr_mult_res | OT_DOUBLE         | 0               | Threshold for   |\n"
"| et_threshold    |                 |                 | resetting       |\n"
"|                 |                 |                 | equality and    |\n"
"|                 |                 |                 | inequality      |\n"
"|                 |                 |                 | multipliers     |\n"
"|                 |                 |                 | after           |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| constr_viol_tol | OT_DOUBLE         | 0.000           | Desired         |\n"
"|                 |                 |                 | threshold for   |\n"
"|                 |                 |                 | the constraint  |\n"
"|                 |                 |                 | violation. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| constraint_viol | OT_STRING       | 1-norm          | Norm to be used |\n"
"| ation_norm_type |                 |                 | for the         |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation in    |\n"
"|                 |                 |                 | the line        |\n"
"|                 |                 |                 | search. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| corrector_compl | OT_DOUBLE         | 1               | Complementarity |\n"
"| _avrg_red_fact  |                 |                 | tolerance       |\n"
"|                 |                 |                 | factor for      |\n"
"|                 |                 |                 | accepting       |\n"
"|                 |                 |                 | corrector step  |\n"
"|                 |                 |                 | (unsupported!). |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| corrector_type  | OT_STRING       | none            | The type of     |\n"
"|                 |                 |                 | corrector steps |\n"
"|                 |                 |                 | that should be  |\n"
"|                 |                 |                 | taken           |\n"
"|                 |                 |                 | (unsupported!). |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| delta           | OT_DOUBLE         | 1               | Multiplier for  |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation in    |\n"
"|                 |                 |                 | the switching   |\n"
"|                 |                 |                 | rule. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| delta_y_max     | OT_DOUBLE         | 1.000e+12       | a parameter     |\n"
"|                 |                 |                 | used to check   |\n"
"|                 |                 |                 | if the fast     |\n"
"|                 |                 |                 | direction can   |\n"
"|                 |                 |                 | be used asthe   |\n"
"|                 |                 |                 | line search     |\n"
"|                 |                 |                 | direction (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| dependency_dete | OT_STRING       | no              | Indicates if    |\n"
"| ction_with_rhs  |                 |                 | the right hand  |\n"
"|                 |                 |                 | sides of the    |\n"
"|                 |                 |                 | constraints     |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | considered      |\n"
"|                 |                 |                 | during          |\n"
"|                 |                 |                 | dependency      |\n"
"|                 |                 |                 | detection (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| dependency_dete | OT_STRING       | none            | Indicates which |\n"
"| ctor            |                 |                 | linear solver   |\n"
"|                 |                 |                 | should be used  |\n"
"|                 |                 |                 | to detect       |\n"
"|                 |                 |                 | linearly        |\n"
"|                 |                 |                 | dependent       |\n"
"|                 |                 |                 | equality        |\n"
"|                 |                 |                 | constraints.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| derivative_test | OT_STRING       | none            | Enable          |\n"
"|                 |                 |                 | derivative      |\n"
"|                 |                 |                 | checker (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| derivative_test | OT_INT      | -2              | Index of first  |\n"
"| _first_index    |                 |                 | quantity to be  |\n"
"|                 |                 |                 | checked by      |\n"
"|                 |                 |                 | derivative      |\n"
"|                 |                 |                 | checker (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| derivative_test | OT_DOUBLE         | 0.000           | Size of the     |\n"
"| _perturbation   |                 |                 | finite          |\n"
"|                 |                 |                 | difference      |\n"
"|                 |                 |                 | perturbation in |\n"
"|                 |                 |                 | derivative      |\n"
"|                 |                 |                 | test. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| derivative_test | OT_STRING       | no              | Indicates       |\n"
"| _print_all      |                 |                 | whether         |\n"
"|                 |                 |                 | information for |\n"
"|                 |                 |                 | all estimated   |\n"
"|                 |                 |                 | derivatives     |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | printed. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| derivative_test | OT_DOUBLE         | 0.000           | Threshold for   |\n"
"| _tol            |                 |                 | indicating      |\n"
"|                 |                 |                 | wrong           |\n"
"|                 |                 |                 | derivative.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| diverging_itera | OT_DOUBLE         | 1.000e+20       | Threshold for   |\n"
"| tes_tol         |                 |                 | maximal value   |\n"
"|                 |                 |                 | of primal       |\n"
"|                 |                 |                 | iterates. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| dual_inf_tol    | OT_DOUBLE         | 1               | Desired         |\n"
"|                 |                 |                 | threshold for   |\n"
"|                 |                 |                 | the dual        |\n"
"|                 |                 |                 | infeasibility.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| epsilon_c       | OT_DOUBLE         | 0.010           | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| eta_min         | OT_DOUBLE         | 10              | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| eta_penalty     | OT_DOUBLE         | 0.000           | Relaxation      |\n"
"|                 |                 |                 | factor in the   |\n"
"|                 |                 |                 | Armijo          |\n"
"|                 |                 |                 | condition for   |\n"
"|                 |                 |                 | the penalty     |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| eta_phi         | OT_DOUBLE         | 0.000           | Relaxation      |\n"
"|                 |                 |                 | factor in the   |\n"
"|                 |                 |                 | Armijo          |\n"
"|                 |                 |                 | condition. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| evaluate_orig_o | OT_STRING       | yes             | Determines if   |\n"
"| bj_at_resto_tri |                 |                 | the original    |\n"
"| al              |                 |                 | objective       |\n"
"|                 |                 |                 | function should |\n"
"|                 |                 |                 | be evaluated at |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase trial     |\n"
"|                 |                 |                 | points. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| expect_infeasib | OT_STRING       | no              | Enable          |\n"
"| le_problem      |                 |                 | heuristics to   |\n"
"|                 |                 |                 | quickly detect  |\n"
"|                 |                 |                 | an infeasible   |\n"
"|                 |                 |                 | problem. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| expect_infeasib | OT_DOUBLE         | 0.001           | Threshold for   |\n"
"| le_problem_ctol |                 |                 | disabling \"expe |\n"
"|                 |                 |                 | ct_infeasible_p |\n"
"|                 |                 |                 | roblem\" option. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| expect_infeasib | OT_DOUBLE         | 100000000       | Multiplier      |\n"
"| le_problem_ytol |                 |                 | threshold for   |\n"
"|                 |                 |                 | activating \"exp |\n"
"|                 |                 |                 | ect_infeasible_ |\n"
"|                 |                 |                 | problem\"        |\n"
"|                 |                 |                 | option. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| fast_des_fact   | OT_DOUBLE         | 0.100           | a parameter     |\n"
"|                 |                 |                 | used to check   |\n"
"|                 |                 |                 | if the fast     |\n"
"|                 |                 |                 | direction can   |\n"
"|                 |                 |                 | be used asthe   |\n"
"|                 |                 |                 | line search     |\n"
"|                 |                 |                 | direction (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| fast_step_compu | OT_STRING       | no              | Indicates if    |\n"
"| tation          |                 |                 | the linear      |\n"
"|                 |                 |                 | system should   |\n"
"|                 |                 |                 | be solved       |\n"
"|                 |                 |                 | quickly. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| file_print_leve | OT_INT      | 5               | Verbosity level |\n"
"| l               |                 |                 | for output      |\n"
"|                 |                 |                 | file. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| filter_margin_f | OT_DOUBLE         | 0.000           | Factor          |\n"
"| act             |                 |                 | determining     |\n"
"|                 |                 |                 | width of margin |\n"
"|                 |                 |                 | for obj-constr- |\n"
"|                 |                 |                 | filter adaptive |\n"
"|                 |                 |                 | globalization   |\n"
"|                 |                 |                 | strategy. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| filter_max_marg | OT_DOUBLE         | 1               | Maximum width   |\n"
"| in              |                 |                 | of margin in    |\n"
"|                 |                 |                 | obj-constr-     |\n"
"|                 |                 |                 | filter adaptive |\n"
"|                 |                 |                 | globalization   |\n"
"|                 |                 |                 | strategy. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| filter_reset_tr | OT_INT      | 5               | Number of       |\n"
"| igger           |                 |                 | iterations that |\n"
"|                 |                 |                 | trigger the     |\n"
"|                 |                 |                 | filter reset.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| findiff_perturb | OT_DOUBLE         | 0.000           | Size of the     |\n"
"| ation           |                 |                 | finite          |\n"
"|                 |                 |                 | difference      |\n"
"|                 |                 |                 | perturbation    |\n"
"|                 |                 |                 | for derivative  |\n"
"|                 |                 |                 | approximation.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| first_hessian_p | OT_DOUBLE         | 0.000           | Size of first   |\n"
"| erturbation     |                 |                 | x-s             |\n"
"|                 |                 |                 | perturbation    |\n"
"|                 |                 |                 | tried. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| fixed_mu_oracle | OT_STRING       | average_compl   | Oracle for the  |\n"
"|                 |                 |                 | barrier         |\n"
"|                 |                 |                 | parameter when  |\n"
"|                 |                 |                 | switching to    |\n"
"|                 |                 |                 | fixed mode.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| fixed_variable_ | OT_STRING       | make_parameter  | Determines how  |\n"
"| treatment       |                 |                 | fixed variables |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | handled. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| gamma_hat       | OT_DOUBLE         | 0.040           | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| gamma_phi       | OT_DOUBLE         | 0.000           | Relaxation      |\n"
"|                 |                 |                 | factor in the   |\n"
"|                 |                 |                 | filter margin   |\n"
"|                 |                 |                 | for the barrier |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| gamma_theta     | OT_DOUBLE         | 0.000           | Relaxation      |\n"
"|                 |                 |                 | factor in the   |\n"
"|                 |                 |                 | filter margin   |\n"
"|                 |                 |                 | for the         |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| gamma_tilde     | OT_DOUBLE         | 4               | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| hessian_approxi | OT_STRING       | exact           | Indicates what  |\n"
"| mation          |                 |                 | Hessian         |\n"
"|                 |                 |                 | information is  |\n"
"|                 |                 |                 | to be used.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| hessian_approxi | OT_STRING       | nonlinear-      | Indicates in    |\n"
"| mation_space    |                 | variables       | which subspace  |\n"
"|                 |                 |                 | the Hessian     |\n"
"|                 |                 |                 | information is  |\n"
"|                 |                 |                 | to be           |\n"
"|                 |                 |                 | approximated.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| hessian_constan | OT_STRING       | no              | Indicates       |\n"
"| t               |                 |                 | whether the     |\n"
"|                 |                 |                 | problem is a    |\n"
"|                 |                 |                 | quadratic       |\n"
"|                 |                 |                 | problem (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| honor_original_ | OT_STRING       | yes             | Indicates       |\n"
"| bounds          |                 |                 | whether final   |\n"
"|                 |                 |                 | points should   |\n"
"|                 |                 |                 | be projected    |\n"
"|                 |                 |                 | into original   |\n"
"|                 |                 |                 | bounds. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| inf_pr_output   | OT_STRING       | original        | Determines what |\n"
"|                 |                 |                 | value is        |\n"
"|                 |                 |                 | printed in the  |\n"
"|                 |                 |                 | \"inf_pr\" output |\n"
"|                 |                 |                 | column. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| jac_c_constant  | OT_STRING       | no              | Indicates       |\n"
"|                 |                 |                 | whether all     |\n"
"|                 |                 |                 | equality        |\n"
"|                 |                 |                 | constraints are |\n"
"|                 |                 |                 | linear (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| jac_d_constant  | OT_STRING       | no              | Indicates       |\n"
"|                 |                 |                 | whether all     |\n"
"|                 |                 |                 | inequality      |\n"
"|                 |                 |                 | constraints are |\n"
"|                 |                 |                 | linear (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| jacobian_approx | OT_STRING       | exact           | Specifies       |\n"
"| imation         |                 |                 | technique to    |\n"
"|                 |                 |                 | compute         |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | Jacobian (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| jacobian_regula | OT_DOUBLE         | 0.250           | Exponent for mu |\n"
"| rization_expone |                 |                 | in the          |\n"
"| nt              |                 |                 | regularization  |\n"
"|                 |                 |                 | for rank-       |\n"
"|                 |                 |                 | deficient       |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | Jacobians. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| jacobian_regula | OT_DOUBLE         | 0.000           | Size of the     |\n"
"| rization_value  |                 |                 | regularization  |\n"
"|                 |                 |                 | for rank-       |\n"
"|                 |                 |                 | deficient       |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | Jacobians. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| kappa_d         | OT_DOUBLE         | 0.000           | Weight for      |\n"
"|                 |                 |                 | linear damping  |\n"
"|                 |                 |                 | term (to handle |\n"
"|                 |                 |                 | one-sided       |\n"
"|                 |                 |                 | bounds). (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| kappa_sigma     | OT_DOUBLE         | 1.000e+10       | Factor limiting |\n"
"|                 |                 |                 | the deviation   |\n"
"|                 |                 |                 | of dual         |\n"
"|                 |                 |                 | variables from  |\n"
"|                 |                 |                 | primal          |\n"
"|                 |                 |                 | estimates. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| kappa_soc       | OT_DOUBLE         | 0.990           | Factor in the   |\n"
"|                 |                 |                 | sufficient      |\n"
"|                 |                 |                 | reduction rule  |\n"
"|                 |                 |                 | for second      |\n"
"|                 |                 |                 | order           |\n"
"|                 |                 |                 | correction.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| kappa_x_dis     | OT_DOUBLE         | 100             | a parameter     |\n"
"|                 |                 |                 | used to check   |\n"
"|                 |                 |                 | if the fast     |\n"
"|                 |                 |                 | direction can   |\n"
"|                 |                 |                 | be used asthe   |\n"
"|                 |                 |                 | line search     |\n"
"|                 |                 |                 | direction (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| kappa_y_dis     | OT_DOUBLE         | 10000           | a parameter     |\n"
"|                 |                 |                 | used to check   |\n"
"|                 |                 |                 | if the fast     |\n"
"|                 |                 |                 | direction can   |\n"
"|                 |                 |                 | be used asthe   |\n"
"|                 |                 |                 | line search     |\n"
"|                 |                 |                 | direction (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| least_square_in | OT_STRING       | no              | Least square    |\n"
"| it_duals        |                 |                 | initialization  |\n"
"|                 |                 |                 | of all dual     |\n"
"|                 |                 |                 | variables (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| least_square_in | OT_STRING       | no              | Least square    |\n"
"| it_primal       |                 |                 | initialization  |\n"
"|                 |                 |                 | of the primal   |\n"
"|                 |                 |                 | variables (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_STRING       | sherman-        | Strategy for    |\n"
"| aug_solver      |                 | morrison        | solving the     |\n"
"|                 |                 |                 | augmented       |\n"
"|                 |                 |                 | system for low- |\n"
"|                 |                 |                 | rank Hessian.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_DOUBLE         | 1               | Value for B0 in |\n"
"| init_val        |                 |                 | low-rank        |\n"
"|                 |                 |                 | update. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_DOUBLE         | 100000000       | Upper bound on  |\n"
"| init_val_max    |                 |                 | value for B0 in |\n"
"|                 |                 |                 | low-rank        |\n"
"|                 |                 |                 | update. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_DOUBLE         | 0.000           | Lower bound on  |\n"
"| init_val_min    |                 |                 | value for B0 in |\n"
"|                 |                 |                 | low-rank        |\n"
"|                 |                 |                 | update. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_STRING       | scalar1         | Initialization  |\n"
"| initialization  |                 |                 | strategy for    |\n"
"|                 |                 |                 | the limited     |\n"
"|                 |                 |                 | memory quasi-   |\n"
"|                 |                 |                 | Newton          |\n"
"|                 |                 |                 | approximation.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_INT      | 6               | Maximum size of |\n"
"| max_history     |                 |                 | the history for |\n"
"|                 |                 |                 | the limited     |\n"
"|                 |                 |                 | quasi-Newton    |\n"
"|                 |                 |                 | Hessian         |\n"
"|                 |                 |                 | approximation.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_INT      | 2               | Threshold for   |\n"
"| max_skipping    |                 |                 | successive      |\n"
"|                 |                 |                 | iterations      |\n"
"|                 |                 |                 | where update is |\n"
"|                 |                 |                 | skipped. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_STRING       | no              | Determines if   |\n"
"| special_for_res |                 |                 | the quasi-      |\n"
"| to              |                 |                 | Newton updates  |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | special during  |\n"
"|                 |                 |                 | the restoration |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| limited_memory_ | OT_STRING       | bfgs            | Quasi-Newton    |\n"
"| update_type     |                 |                 | update formula  |\n"
"|                 |                 |                 | for the limited |\n"
"|                 |                 |                 | memory          |\n"
"|                 |                 |                 | approximation.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| line_search_met | OT_STRING       | filter          | Globalization   |\n"
"| hod             |                 |                 | method used in  |\n"
"|                 |                 |                 | backtracking    |\n"
"|                 |                 |                 | line search     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| linear_scaling_ | OT_STRING       | yes             | Flag indicating |\n"
"| on_demand       |                 |                 | that linear     |\n"
"|                 |                 |                 | scaling is only |\n"
"|                 |                 |                 | done if it      |\n"
"|                 |                 |                 | seems required. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| linear_solver   | OT_STRING       | mumps           | Linear solver   |\n"
"|                 |                 |                 | used for step   |\n"
"|                 |                 |                 | computations.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| linear_system_s | OT_STRING       | none            | Method for      |\n"
"| caling          |                 |                 | scaling the     |\n"
"|                 |                 |                 | linear system.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_ignore_sin | OT_STRING       | no              | Enables MA27's  |\n"
"| gularity        |                 |                 | ability to      |\n"
"|                 |                 |                 | solve a linear  |\n"
"|                 |                 |                 | system even if  |\n"
"|                 |                 |                 | the matrix is   |\n"
"|                 |                 |                 | singular. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_la_init_fa | OT_DOUBLE         | 5               | Real workspace  |\n"
"| ctor            |                 |                 | memory for      |\n"
"|                 |                 |                 | MA27. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_liw_init_f | OT_DOUBLE         | 5               | Integer         |\n"
"| actor           |                 |                 | workspace       |\n"
"|                 |                 |                 | memory for      |\n"
"|                 |                 |                 | MA27. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_meminc_fac | OT_DOUBLE         | 2               | Increment       |\n"
"| tor             |                 |                 | factor for      |\n"
"|                 |                 |                 | workspace size  |\n"
"|                 |                 |                 | for MA27. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_pivtol     | OT_DOUBLE         | 0.000           | Pivot tolerance |\n"
"|                 |                 |                 | for the linear  |\n"
"|                 |                 |                 | solver MA27.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_pivtolmax  | OT_DOUBLE         | 0.000           | Maximum pivot   |\n"
"|                 |                 |                 | tolerance for   |\n"
"|                 |                 |                 | the linear      |\n"
"|                 |                 |                 | solver MA27.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma27_skip_inert | OT_STRING       | no              | Always pretend  |\n"
"| ia_check        |                 |                 | inertia is      |\n"
"|                 |                 |                 | correct. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma28_pivtol     | OT_DOUBLE         | 0.010           | Pivot tolerance |\n"
"|                 |                 |                 | for linear      |\n"
"|                 |                 |                 | solver MA28.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_automatic_ | OT_STRING       | no              | Controls MA57   |\n"
"| scaling         |                 |                 | automatic       |\n"
"|                 |                 |                 | scaling (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_block_size | OT_INT      | 16              | Controls block  |\n"
"|                 |                 |                 | size used by    |\n"
"|                 |                 |                 | Level 3 BLAS in |\n"
"|                 |                 |                 | MA57BD (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_node_amalg | OT_INT      | 16              | Node            |\n"
"| amation         |                 |                 | amalgamation    |\n"
"|                 |                 |                 | parameter (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_pivot_orde | OT_INT      | 5               | Controls pivot  |\n"
"| r               |                 |                 | order in MA57   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_pivtol     | OT_DOUBLE         | 0.000           | Pivot tolerance |\n"
"|                 |                 |                 | for the linear  |\n"
"|                 |                 |                 | solver MA57.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_pivtolmax  | OT_DOUBLE         | 0.000           | Maximum pivot   |\n"
"|                 |                 |                 | tolerance for   |\n"
"|                 |                 |                 | the linear      |\n"
"|                 |                 |                 | solver MA57.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_pre_alloc  | OT_DOUBLE         | 1.050           | Safety factor   |\n"
"|                 |                 |                 | for work space  |\n"
"|                 |                 |                 | memory          |\n"
"|                 |                 |                 | allocation for  |\n"
"|                 |                 |                 | the linear      |\n"
"|                 |                 |                 | solver MA57.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma57_small_pivo | OT_INT      | 0               | If set to 1,    |\n"
"| t_flag          |                 |                 | then when small |\n"
"|                 |                 |                 | entries defined |\n"
"|                 |                 |                 | by CNTL(2) are  |\n"
"|                 |                 |                 | detected they   |\n"
"|                 |                 |                 | are removed and |\n"
"|                 |                 |                 | the             |\n"
"|                 |                 |                 | corresponding   |\n"
"|                 |                 |                 | pivots placed   |\n"
"|                 |                 |                 | at the end of   |\n"
"|                 |                 |                 | the             |\n"
"|                 |                 |                 | factorization.  |\n"
"|                 |                 |                 | This can be     |\n"
"|                 |                 |                 | particularly    |\n"
"|                 |                 |                 | efficient if    |\n"
"|                 |                 |                 | the matrix is   |\n"
"|                 |                 |                 | highly rank     |\n"
"|                 |                 |                 | deficient. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_buffer_lpa | OT_INT      | 4096            | Number of       |\n"
"| ge              |                 |                 | scalars per     |\n"
"|                 |                 |                 | MA77 buffer     |\n"
"|                 |                 |                 | page (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_buffer_npa | OT_INT      | 1600            | Number of pages |\n"
"| ge              |                 |                 | that make up    |\n"
"|                 |                 |                 | MA77 buffer     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_file_size  | OT_INT      | 2097152         | Target size of  |\n"
"|                 |                 |                 | each temporary  |\n"
"|                 |                 |                 | file for MA77,  |\n"
"|                 |                 |                 | scalars per     |\n"
"|                 |                 |                 | type (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_maxstore   | OT_INT      | 0               | Maximum storage |\n"
"|                 |                 |                 | size for MA77   |\n"
"|                 |                 |                 | in-core mode    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_nemin      | OT_INT      | 8               | Node            |\n"
"|                 |                 |                 | Amalgamation    |\n"
"|                 |                 |                 | parameter (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_order      | OT_STRING       | amd             | Controls type   |\n"
"|                 |                 |                 | of ordering     |\n"
"|                 |                 |                 | used by         |\n"
"|                 |                 |                 | HSL_MA77 (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_print_leve | OT_INT      | -1              | Debug printing  |\n"
"| l               |                 |                 | level for the   |\n"
"|                 |                 |                 | linear solver   |\n"
"|                 |                 |                 | MA77 (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_small      | OT_DOUBLE         | 0.000           | Zero Pivot      |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_static     | OT_DOUBLE         | 0               | Static Pivoting |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_u          | OT_DOUBLE         | 0.000           | Pivoting        |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma77_umax       | OT_DOUBLE         | 0.000           | Maximum         |\n"
"|                 |                 |                 | Pivoting        |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_nemin      | OT_INT      | 32              | Node            |\n"
"|                 |                 |                 | Amalgamation    |\n"
"|                 |                 |                 | parameter (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_order      | OT_STRING       | amd             | Controls type   |\n"
"|                 |                 |                 | of ordering     |\n"
"|                 |                 |                 | used by         |\n"
"|                 |                 |                 | HSL_MA86 (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_print_leve | OT_INT      | -1              | Debug printing  |\n"
"| l               |                 |                 | level for the   |\n"
"|                 |                 |                 | linear solver   |\n"
"|                 |                 |                 | MA86 (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_scaling    | OT_STRING       | mc64            | Controls        |\n"
"|                 |                 |                 | scaling of      |\n"
"|                 |                 |                 | matrix (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_small      | OT_DOUBLE         | 0.000           | Zero Pivot      |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_static     | OT_DOUBLE         | 0               | Static Pivoting |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_u          | OT_DOUBLE         | 0.000           | Pivoting        |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma86_umax       | OT_DOUBLE         | 0.000           | Maximum         |\n"
"|                 |                 |                 | Pivoting        |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_nemin      | OT_INT      | 8               | Node            |\n"
"|                 |                 |                 | Amalgamation    |\n"
"|                 |                 |                 | parameter (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_order      | OT_STRING       | auto            | Controls type   |\n"
"|                 |                 |                 | of ordering     |\n"
"|                 |                 |                 | used by         |\n"
"|                 |                 |                 | HSL_MA97 (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_print_leve | OT_INT      | 0               | Debug printing  |\n"
"| l               |                 |                 | level for the   |\n"
"|                 |                 |                 | linear solver   |\n"
"|                 |                 |                 | MA97 (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_scaling    | OT_STRING       | dynamic         | Specifies       |\n"
"|                 |                 |                 | strategy for    |\n"
"|                 |                 |                 | scaling in      |\n"
"|                 |                 |                 | HSL_MA97 linear |\n"
"|                 |                 |                 | solver (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_scaling1   | OT_STRING       | mc64            | First scaling.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_scaling2   | OT_STRING       | mc64            | Second scaling. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_scaling3   | OT_STRING       | mc64            | Third scaling.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_small      | OT_DOUBLE         | 0.000           | Zero Pivot      |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_solve_blas | OT_STRING       | no              | Controls if     |\n"
"| 3               |                 |                 | blas2 or blas3  |\n"
"|                 |                 |                 | routines are    |\n"
"|                 |                 |                 | used for solve  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_switch1    | OT_STRING       | od_hd_reuse     | First switch,   |\n"
"|                 |                 |                 | determine when  |\n"
"|                 |                 |                 | ma97_scaling1   |\n"
"|                 |                 |                 | is enabled.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_switch2    | OT_STRING       | never           | Second switch,  |\n"
"|                 |                 |                 | determine when  |\n"
"|                 |                 |                 | ma97_scaling2   |\n"
"|                 |                 |                 | is enabled.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_switch3    | OT_STRING       | never           | Third switch,   |\n"
"|                 |                 |                 | determine when  |\n"
"|                 |                 |                 | ma97_scaling3   |\n"
"|                 |                 |                 | is enabled.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_u          | OT_DOUBLE         | 0.000           | Pivoting        |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| ma97_umax       | OT_DOUBLE         | 0.000           | Maximum         |\n"
"|                 |                 |                 | Pivoting        |\n"
"|                 |                 |                 | Threshold (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| magic_steps     | OT_STRING       | no              | Enables magic   |\n"
"|                 |                 |                 | steps. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_cpu_time    | OT_DOUBLE         | 1000000         | Maximum number  |\n"
"|                 |                 |                 | of CPU seconds. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_filter_rese | OT_INT      | 5               | Maximal allowed |\n"
"| ts              |                 |                 | number of       |\n"
"|                 |                 |                 | filter resets   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_hessian_per | OT_DOUBLE         | 1.000e+20       | Maximum value   |\n"
"| turbation       |                 |                 | of              |\n"
"|                 |                 |                 | regularization  |\n"
"|                 |                 |                 | parameter for   |\n"
"|                 |                 |                 | handling        |\n"
"|                 |                 |                 | negative        |\n"
"|                 |                 |                 | curvature. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_iter        | OT_INT      | 3000            | Maximum number  |\n"
"|                 |                 |                 | of iterations.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_refinement_ | OT_INT      | 10              | Maximum number  |\n"
"| steps           |                 |                 | of iterative    |\n"
"|                 |                 |                 | refinement      |\n"
"|                 |                 |                 | steps per       |\n"
"|                 |                 |                 | linear system   |\n"
"|                 |                 |                 | solve. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_resto_iter  | OT_INT      | 3000000         | Maximum number  |\n"
"|                 |                 |                 | of successive   |\n"
"|                 |                 |                 | iterations in   |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_soc         | OT_INT      | 4               | Maximum number  |\n"
"|                 |                 |                 | of second order |\n"
"|                 |                 |                 | correction      |\n"
"|                 |                 |                 | trial steps at  |\n"
"|                 |                 |                 | each iteration. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| max_soft_resto_ | OT_INT      | 10              | Maximum number  |\n"
"| iters           |                 |                 | of iterations   |\n"
"|                 |                 |                 | performed       |\n"
"|                 |                 |                 | successively in |\n"
"|                 |                 |                 | soft            |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mehrotra_algori | OT_STRING       | no              | Indicates if we |\n"
"| thm             |                 |                 | want to do      |\n"
"|                 |                 |                 | Mehrotra's      |\n"
"|                 |                 |                 | algorithm. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| min_alpha_prima | OT_DOUBLE         | 0.000           | LIFENG WRITES   |\n"
"| l               |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| min_hessian_per | OT_DOUBLE         | 0.000           | Smallest        |\n"
"| turbation       |                 |                 | perturbation of |\n"
"|                 |                 |                 | the Hessian     |\n"
"|                 |                 |                 | block. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| min_refinement_ | OT_INT      | 1               | Minimum number  |\n"
"| steps           |                 |                 | of iterative    |\n"
"|                 |                 |                 | refinement      |\n"
"|                 |                 |                 | steps per       |\n"
"|                 |                 |                 | linear system   |\n"
"|                 |                 |                 | solve. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_allow_fast_m | OT_STRING       | yes             | Allow skipping  |\n"
"| onotone_decreas |                 |                 | of barrier      |\n"
"| e               |                 |                 | problem if      |\n"
"|                 |                 |                 | barrier test is |\n"
"|                 |                 |                 | already met.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_init         | OT_DOUBLE         | 0.100           | Initial value   |\n"
"|                 |                 |                 | for the barrier |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_linear_decre | OT_DOUBLE         | 0.200           | Determines      |\n"
"| ase_factor      |                 |                 | linear decrease |\n"
"|                 |                 |                 | rate of barrier |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_max          | OT_DOUBLE         | 100000          | Maximum value   |\n"
"|                 |                 |                 | for barrier     |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_max_fact     | OT_DOUBLE         | 1000            | Factor for      |\n"
"|                 |                 |                 | initialization  |\n"
"|                 |                 |                 | of maximum      |\n"
"|                 |                 |                 | value for       |\n"
"|                 |                 |                 | barrier         |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_min          | OT_DOUBLE         | 0.000           | Minimum value   |\n"
"|                 |                 |                 | for barrier     |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_oracle       | OT_STRING       | quality-        | Oracle for a    |\n"
"|                 |                 | function        | new barrier     |\n"
"|                 |                 |                 | parameter in    |\n"
"|                 |                 |                 | the adaptive    |\n"
"|                 |                 |                 | strategy. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_strategy     | OT_STRING       | monotone        | Update strategy |\n"
"|                 |                 |                 | for barrier     |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_superlinear_ | OT_DOUBLE         | 1.500           | Determines      |\n"
"| decrease_power  |                 |                 | superlinear     |\n"
"|                 |                 |                 | decrease rate   |\n"
"|                 |                 |                 | of barrier      |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mu_target       | OT_DOUBLE         | 0               | Desired value   |\n"
"|                 |                 |                 | of complementar |\n"
"|                 |                 |                 | ity. (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mult_diverg_fea | OT_DOUBLE         | 0.000           | tolerance for   |\n"
"| sibility_tol    |                 |                 | deciding if the |\n"
"|                 |                 |                 | multipliers are |\n"
"|                 |                 |                 | diverging (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mult_diverg_y_t | OT_DOUBLE         | 100000000       | tolerance for   |\n"
"| ol              |                 |                 | deciding if the |\n"
"|                 |                 |                 | multipliers are |\n"
"|                 |                 |                 | diverging (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_dep_tol   | OT_DOUBLE         | 0               | Pivot threshold |\n"
"|                 |                 |                 | for detection   |\n"
"|                 |                 |                 | of linearly     |\n"
"|                 |                 |                 | dependent       |\n"
"|                 |                 |                 | constraints in  |\n"
"|                 |                 |                 | MUMPS. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_mem_perce | OT_INT      | 1000            | Percentage      |\n"
"| nt              |                 |                 | increase in the |\n"
"|                 |                 |                 | estimated       |\n"
"|                 |                 |                 | working space   |\n"
"|                 |                 |                 | for MUMPS. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_permuting | OT_INT      | 7               | Controls        |\n"
"| _scaling        |                 |                 | permuting and   |\n"
"|                 |                 |                 | scaling in      |\n"
"|                 |                 |                 | MUMPS (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_pivot_ord | OT_INT      | 7               | Controls pivot  |\n"
"| er              |                 |                 | order in MUMPS  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_pivtol    | OT_DOUBLE         | 0.000           | Pivot tolerance |\n"
"|                 |                 |                 | for the linear  |\n"
"|                 |                 |                 | solver MUMPS.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_pivtolmax | OT_DOUBLE         | 0.100           | Maximum pivot   |\n"
"|                 |                 |                 | tolerance for   |\n"
"|                 |                 |                 | the linear      |\n"
"|                 |                 |                 | solver MUMPS.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| mumps_scaling   | OT_INT      | 77              | Controls        |\n"
"|                 |                 |                 | scaling in      |\n"
"|                 |                 |                 | MUMPS (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| neg_curv_test_t | OT_DOUBLE         | 0               | Tolerance for   |\n"
"| ol              |                 |                 | heuristic to    |\n"
"|                 |                 |                 | ignore wrong    |\n"
"|                 |                 |                 | inertia. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| never_use_fact_ | OT_STRING       | no              | Toggle to       |\n"
"| cgpen_direction |                 |                 | switch off the  |\n"
"|                 |                 |                 | fast Chen-      |\n"
"|                 |                 |                 | Goldfarb        |\n"
"|                 |                 |                 | direction (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| never_use_piece | OT_STRING       | no              | Toggle to       |\n"
"| wise_penalty_ls |                 |                 | switch off the  |\n"
"|                 |                 |                 | piecewise       |\n"
"|                 |                 |                 | penalty method  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_lower_bound | OT_DOUBLE         | -1.000e+19      | any bound less  |\n"
"| _inf            |                 |                 | or equal this   |\n"
"|                 |                 |                 | value will be   |\n"
"|                 |                 |                 | considered -inf |\n"
"|                 |                 |                 | (i.e. not lower |\n"
"|                 |                 |                 | bounded). (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_scaling_con | OT_DOUBLE         | 0               | Target value    |\n"
"| str_target_grad |                 |                 | for constraint  |\n"
"| ient            |                 |                 | function        |\n"
"|                 |                 |                 | gradient size.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_scaling_max | OT_DOUBLE         | 100             | Maximum         |\n"
"| _gradient       |                 |                 | gradient after  |\n"
"|                 |                 |                 | NLP scaling.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_scaling_met | OT_STRING       | gradient-based  | Select the      |\n"
"| hod             |                 |                 | technique used  |\n"
"|                 |                 |                 | for scaling the |\n"
"|                 |                 |                 | NLP. (see IPOPT |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_scaling_min | OT_DOUBLE         | 0.000           | Minimum value   |\n"
"| _value          |                 |                 | of gradient-    |\n"
"|                 |                 |                 | based scaling   |\n"
"|                 |                 |                 | values. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_scaling_obj | OT_DOUBLE         | 0               | Target value    |\n"
"| _target_gradien |                 |                 | for objective   |\n"
"| t               |                 |                 | function        |\n"
"|                 |                 |                 | gradient size.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nlp_upper_bound | OT_DOUBLE         | 1.000e+19       | any bound       |\n"
"| _inf            |                 |                 | greater or this |\n"
"|                 |                 |                 | value will be   |\n"
"|                 |                 |                 | considered +inf |\n"
"|                 |                 |                 | (i.e. not upper |\n"
"|                 |                 |                 | bounded). (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nu_inc          | OT_DOUBLE         | 0.000           | Increment of    |\n"
"|                 |                 |                 | the penalty     |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| nu_init         | OT_DOUBLE         | 0.000           | Initial value   |\n"
"|                 |                 |                 | of the penalty  |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| num_linear_vari | OT_INT      | 0               | Number of       |\n"
"| ables           |                 |                 | linear          |\n"
"|                 |                 |                 | variables (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| obj_max_inc     | OT_DOUBLE         | 5               | Determines the  |\n"
"|                 |                 |                 | upper bound on  |\n"
"|                 |                 |                 | the acceptable  |\n"
"|                 |                 |                 | increase of     |\n"
"|                 |                 |                 | barrier         |\n"
"|                 |                 |                 | objective       |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| obj_scaling_fac | OT_DOUBLE         | 1               | Scaling factor  |\n"
"| tor             |                 |                 | for the         |\n"
"|                 |                 |                 | objective       |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| option_file_nam | OT_STRING       | bonmin.opt       | File name of    |\n"
"| e               |                 |                 | options file.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| output_file     | OT_STRING       |                 | File name of    |\n"
"|                 |                 |                 | desired output  |\n"
"|                 |                 |                 | file (leave     |\n"
"|                 |                 |                 | unset for no    |\n"
"|                 |                 |                 | file output).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_co | OT_INT      | 5000            | Maximum Size of |\n"
"| arse_size       |                 |                 | Coarse Grid     |\n"
"|                 |                 |                 | Matrix (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_dr | OT_DOUBLE         | 0.500           | dropping value  |\n"
"| opping_factor   |                 |                 | for incomplete  |\n"
"|                 |                 |                 | factor (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_dr | OT_DOUBLE         | 0.100           | dropping value  |\n"
"| opping_schur    |                 |                 | for sparsify    |\n"
"|                 |                 |                 | schur           |\n"
"|                 |                 |                 | complement      |\n"
"|                 |                 |                 | factor (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_in | OT_DOUBLE         | 5000000         | (see IPOPT      |\n"
"| verse_norm_fact |                 |                 | documentation)  |\n"
"| or              |                 |                 |                 |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_ma | OT_INT      | 10              | Maximum Size of |\n"
"| x_levels        |                 |                 | Grid Levels     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_ma | OT_INT      | 10000000        | max fill for    |\n"
"| x_row_fill      |                 |                 | each row (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iter_re | OT_DOUBLE         | 0.000           | Relative        |\n"
"| lative_tol      |                 |                 | Residual        |\n"
"|                 |                 |                 | Convergence     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_iterati | OT_STRING       | no              | Switch on       |\n"
"| ve              |                 |                 | iterative       |\n"
"|                 |                 |                 | solver in       |\n"
"|                 |                 |                 | Pardiso library |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_matchin | OT_STRING       | complete+2x2    | Matching        |\n"
"| g_strategy      |                 |                 | strategy to be  |\n"
"|                 |                 |                 | used by Pardiso |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_max_dro | OT_INT      | 4               | Maximal number  |\n"
"| ptol_correction |                 |                 | of decreases of |\n"
"| s               |                 |                 | drop tolerance  |\n"
"|                 |                 |                 | during one      |\n"
"|                 |                 |                 | solve. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_max_ite | OT_INT      | 500             | Maximum number  |\n"
"| r               |                 |                 | of Krylov-      |\n"
"|                 |                 |                 | Subspace        |\n"
"|                 |                 |                 | Iteration (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_max_ite | OT_INT      | 0               | Limit on number |\n"
"| rative_refineme |                 |                 | of iterative    |\n"
"| nt_steps        |                 |                 | refinement      |\n"
"|                 |                 |                 | steps. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_msglvl  | OT_INT      | 0               | Pardiso message |\n"
"|                 |                 |                 | level (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_order   | OT_STRING       | five            | Controls the    |\n"
"|                 |                 |                 | fill-in         |\n"
"|                 |                 |                 | reduction       |\n"
"|                 |                 |                 | ordering        |\n"
"|                 |                 |                 | algorithm for   |\n"
"|                 |                 |                 | the input       |\n"
"|                 |                 |                 | matrix. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_redo_sy | OT_STRING       | no              | Toggle for      |\n"
"| mbolic_fact_onl |                 |                 | handling case   |\n"
"| y_if_inertia_wr |                 |                 | when elements   |\n"
"| ong             |                 |                 | were perturbed  |\n"
"|                 |                 |                 | by Pardiso.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_repeate | OT_STRING       | no              | Interpretation  |\n"
"| d_perturbation_ |                 |                 | of perturbed    |\n"
"| means_singular  |                 |                 | elements. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pardiso_skip_in | OT_STRING       | no              | Always pretend  |\n"
"| ertia_check     |                 |                 | inertia is      |\n"
"|                 |                 |                 | correct. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pass_nonlinear_ | OT_BOOL      | False           | n/a             |\n"
"| variables       |                 |                 |                 |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pen_des_fact    | OT_DOUBLE         | 0.200           | a parameter     |\n"
"|                 |                 |                 | used in penalty |\n"
"|                 |                 |                 | parameter       |\n"
"|                 |                 |                 | computation     |\n"
"|                 |                 |                 | (for Chen-      |\n"
"|                 |                 |                 | Goldfarb line   |\n"
"|                 |                 |                 | search). (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pen_init_fac    | OT_DOUBLE         | 50              | a parameter     |\n"
"|                 |                 |                 | used to choose  |\n"
"|                 |                 |                 | initial penalty |\n"
"|                 |                 |                 | parameterswhen  |\n"
"|                 |                 |                 | the regularized |\n"
"|                 |                 |                 | Newton method   |\n"
"|                 |                 |                 | is used. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| pen_theta_max_f | OT_DOUBLE         | 10000           | Determines      |\n"
"| act             |                 |                 | upper bound for |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation in    |\n"
"|                 |                 |                 | the filter.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| penalty_init_ma | OT_DOUBLE         | 100000          | Maximal value   |\n"
"| x               |                 |                 | for the intial  |\n"
"|                 |                 |                 | penalty         |\n"
"|                 |                 |                 | parameter (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| penalty_init_mi | OT_DOUBLE         | 1               | Minimal value   |\n"
"| n               |                 |                 | for the intial  |\n"
"|                 |                 |                 | penalty         |\n"
"|                 |                 |                 | parameter for   |\n"
"|                 |                 |                 | line search(for |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| penalty_max     | OT_DOUBLE         | 1.000e+30       | Maximal value   |\n"
"|                 |                 |                 | for the penalty |\n"
"|                 |                 |                 | parameter (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| penalty_update_ | OT_DOUBLE         | 10              | LIFENG WRITES   |\n"
"| compl_tol       |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| penalty_update_ | OT_DOUBLE         | 0.000           | Threshold for   |\n"
"| infeasibility_t |                 |                 | infeasibility   |\n"
"| ol              |                 |                 | in penalty      |\n"
"|                 |                 |                 | parameter       |\n"
"|                 |                 |                 | update test.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| perturb_always_ | OT_STRING       | no              | Active          |\n"
"| cd              |                 |                 | permanent       |\n"
"|                 |                 |                 | perturbation of |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | linearization.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| perturb_dec_fac | OT_DOUBLE         | 0.333           | Decrease factor |\n"
"| t               |                 |                 | for x-s         |\n"
"|                 |                 |                 | perturbation.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| perturb_inc_fac | OT_DOUBLE         | 8               | Increase factor |\n"
"| t               |                 |                 | for x-s         |\n"
"|                 |                 |                 | perturbation.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| perturb_inc_fac | OT_DOUBLE         | 100             | Increase factor |\n"
"| t_first         |                 |                 | for x-s         |\n"
"|                 |                 |                 | perturbation    |\n"
"|                 |                 |                 | for very first  |\n"
"|                 |                 |                 | perturbation.   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| piecewisepenalt | OT_DOUBLE         | 0.000           | LIFENG WRITES   |\n"
"| y_gamma_infeasi |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| piecewisepenalt | OT_DOUBLE         | 0.000           | LIFENG WRITES   |\n"
"| y_gamma_obj     |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| point_perturbat | OT_DOUBLE         | 10              | Maximal         |\n"
"| ion_radius      |                 |                 | perturbation of |\n"
"|                 |                 |                 | an evaluation   |\n"
"|                 |                 |                 | point. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_frequency | OT_INT      | 1               | Determines at   |\n"
"| _iter           |                 |                 | which iteration |\n"
"|                 |                 |                 | frequency the   |\n"
"|                 |                 |                 | summarizing     |\n"
"|                 |                 |                 | iteration       |\n"
"|                 |                 |                 | output line     |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | printed. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_frequency | OT_DOUBLE         | 0               | Determines at   |\n"
"| _time           |                 |                 | which time      |\n"
"|                 |                 |                 | frequency the   |\n"
"|                 |                 |                 | summarizing     |\n"
"|                 |                 |                 | iteration       |\n"
"|                 |                 |                 | output line     |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | printed. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_info_stri | OT_STRING       | no              | Enables         |\n"
"| ng              |                 |                 | printing of     |\n"
"|                 |                 |                 | additional info |\n"
"|                 |                 |                 | string at end   |\n"
"|                 |                 |                 | of iteration    |\n"
"|                 |                 |                 | output. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_level     | OT_INT      | 5               | Output          |\n"
"|                 |                 |                 | verbosity       |\n"
"|                 |                 |                 | level. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_options_d | OT_STRING       | no              | Switch to print |\n"
"| ocumentation    |                 |                 | all algorithmic |\n"
"|                 |                 |                 | options. (see   |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_options_l | OT_STRING       | no              | Undocumented    |\n"
"| atex_mode       |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_time      | OT_BOOL      | True            | print           |\n"
"|                 |                 |                 | information     |\n"
"|                 |                 |                 | about execution |\n"
"|                 |                 |                 | time            |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_timing_st | OT_STRING       | no              | Switch to print |\n"
"| atistics        |                 |                 | timing          |\n"
"|                 |                 |                 | statistics.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| print_user_opti | OT_STRING       | no              | Print all       |\n"
"| ons             |                 |                 | options set by  |\n"
"|                 |                 |                 | the user. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| quality_functio | OT_STRING       | none            | The balancing   |\n"
"| n_balancing_ter |                 |                 | term included   |\n"
"| m               |                 |                 | in the quality  |\n"
"|                 |                 |                 | function for    |\n"
"|                 |                 |                 | centrality.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| quality_functio | OT_STRING       | none            | The penalty     |\n"
"| n_centrality    |                 |                 | term for        |\n"
"|                 |                 |                 | centrality that |\n"
"|                 |                 |                 | is included in  |\n"
"|                 |                 |                 | quality         |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| quality_functio | OT_INT      | 8               | Maximum number  |\n"
"| n_max_section_s |                 |                 | of search steps |\n"
"| teps            |                 |                 | during direct   |\n"
"|                 |                 |                 | search          |\n"
"|                 |                 |                 | procedure       |\n"
"|                 |                 |                 | determining the |\n"
"|                 |                 |                 | optimal         |\n"
"|                 |                 |                 | centering       |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| quality_functio | OT_STRING       | 2-norm-squared  | Norm used for   |\n"
"| n_norm_type     |                 |                 | components of   |\n"
"|                 |                 |                 | the quality     |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| quality_functio | OT_DOUBLE         | 0               | Tolerance for   |\n"
"| n_section_qf_to |                 |                 | the golden      |\n"
"| l               |                 |                 | section search  |\n"
"|                 |                 |                 | procedure       |\n"
"|                 |                 |                 | determining the |\n"
"|                 |                 |                 | optimal         |\n"
"|                 |                 |                 | centering       |\n"
"|                 |                 |                 | parameter (in   |\n"
"|                 |                 |                 | the function    |\n"
"|                 |                 |                 | value space).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| quality_functio | OT_DOUBLE         | 0.010           | Tolerance for   |\n"
"| n_section_sigma |                 |                 | the section     |\n"
"| _tol            |                 |                 | search          |\n"
"|                 |                 |                 | procedure       |\n"
"|                 |                 |                 | determining the |\n"
"|                 |                 |                 | optimal         |\n"
"|                 |                 |                 | centering       |\n"
"|                 |                 |                 | parameter (in   |\n"
"|                 |                 |                 | sigma space).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| recalc_y        | OT_STRING       | no              | Tells the       |\n"
"|                 |                 |                 | algorithm to    |\n"
"|                 |                 |                 | recalculate the |\n"
"|                 |                 |                 | equality and    |\n"
"|                 |                 |                 | inequality      |\n"
"|                 |                 |                 | multipliers as  |\n"
"|                 |                 |                 | least square    |\n"
"|                 |                 |                 | estimates. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| recalc_y_feas_t | OT_DOUBLE         | 0.000           | Feasibility     |\n"
"| ol              |                 |                 | threshold for   |\n"
"|                 |                 |                 | recomputation   |\n"
"|                 |                 |                 | of multipliers. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| replace_bounds  | OT_STRING       | no              | Indicates if    |\n"
"|                 |                 |                 | all variable    |\n"
"|                 |                 |                 | bounds should   |\n"
"|                 |                 |                 | be replaced by  |\n"
"|                 |                 |                 | inequality      |\n"
"|                 |                 |                 | constraints     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| required_infeas | OT_DOUBLE         | 0.900           | Required        |\n"
"| ibility_reducti |                 |                 | reduction of    |\n"
"| on              |                 |                 | infeasibility   |\n"
"|                 |                 |                 | before leaving  |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| residual_improv | OT_DOUBLE         | 1.000           | Minimal         |\n"
"| ement_factor    |                 |                 | required        |\n"
"|                 |                 |                 | reduction of    |\n"
"|                 |                 |                 | residual test   |\n"
"|                 |                 |                 | ratio in        |\n"
"|                 |                 |                 | iterative       |\n"
"|                 |                 |                 | refinement.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| residual_ratio_ | OT_DOUBLE         | 0.000           | Iterative       |\n"
"| max             |                 |                 | refinement      |\n"
"|                 |                 |                 | tolerance (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| residual_ratio_ | OT_DOUBLE         | 0.000           | Threshold for   |\n"
"| singular        |                 |                 | declaring       |\n"
"|                 |                 |                 | linear system   |\n"
"|                 |                 |                 | singular after  |\n"
"|                 |                 |                 | failed          |\n"
"|                 |                 |                 | iterative       |\n"
"|                 |                 |                 | refinement.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| resto_failure_f | OT_DOUBLE         | 0               | Threshold for   |\n"
"| easibility_thre |                 |                 | primal          |\n"
"| shold           |                 |                 | infeasibility   |\n"
"|                 |                 |                 | to declare      |\n"
"|                 |                 |                 | failure of      |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| resto_penalty_p | OT_DOUBLE         | 1000            | Penalty         |\n"
"| arameter        |                 |                 | parameter in    |\n"
"|                 |                 |                 | the restoration |\n"
"|                 |                 |                 | phase objective |\n"
"|                 |                 |                 | function. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| resto_proximity | OT_DOUBLE         | 1               | Weighting       |\n"
"| _weight         |                 |                 | factor for the  |\n"
"|                 |                 |                 | proximity term  |\n"
"|                 |                 |                 | in restoration  |\n"
"|                 |                 |                 | phase           |\n"
"|                 |                 |                 | objective. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| rho             | OT_DOUBLE         | 0.100           | Value in        |\n"
"|                 |                 |                 | penalty         |\n"
"|                 |                 |                 | parameter       |\n"
"|                 |                 |                 | update formula. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| s_max           | OT_DOUBLE         | 100             | Scaling         |\n"
"|                 |                 |                 | threshold for   |\n"
"|                 |                 |                 | the NLP error.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| s_phi           | OT_DOUBLE         | 2.300           | Exponent for    |\n"
"|                 |                 |                 | linear barrier  |\n"
"|                 |                 |                 | function model  |\n"
"|                 |                 |                 | in the          |\n"
"|                 |                 |                 | switching rule. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| s_theta         | OT_DOUBLE         | 1.100           | Exponent for    |\n"
"|                 |                 |                 | current         |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation in    |\n"
"|                 |                 |                 | the switching   |\n"
"|                 |                 |                 | rule. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| sb              | OT_STRING       | no              | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| sigma_max       | OT_DOUBLE         | 100             | Maximum value   |\n"
"|                 |                 |                 | of the          |\n"
"|                 |                 |                 | centering       |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| sigma_min       | OT_DOUBLE         | 0.000           | Minimum value   |\n"
"|                 |                 |                 | of the          |\n"
"|                 |                 |                 | centering       |\n"
"|                 |                 |                 | parameter. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| skip_corr_if_ne | OT_STRING       | yes             | Skip the        |\n"
"| g_curv          |                 |                 | corrector step  |\n"
"|                 |                 |                 | in negative     |\n"
"|                 |                 |                 | curvature       |\n"
"|                 |                 |                 | iteration       |\n"
"|                 |                 |                 | (unsupported!). |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| skip_corr_in_mo | OT_STRING       | yes             | Skip the        |\n"
"| notone_mode     |                 |                 | corrector step  |\n"
"|                 |                 |                 | during monotone |\n"
"|                 |                 |                 | barrier         |\n"
"|                 |                 |                 | parameter mode  |\n"
"|                 |                 |                 | (unsupported!). |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| skip_finalize_s | OT_STRING       | no              | Indicates if    |\n"
"| olution_call    |                 |                 | call to NLP::Fi |\n"
"|                 |                 |                 | nalizeSolution  |\n"
"|                 |                 |                 | after           |\n"
"|                 |                 |                 | optimization    |\n"
"|                 |                 |                 | should be       |\n"
"|                 |                 |                 | suppressed (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| slack_bound_fra | OT_DOUBLE         | 0.010           | Desired minimum |\n"
"| c               |                 |                 | relative        |\n"
"|                 |                 |                 | distance from   |\n"
"|                 |                 |                 | the initial     |\n"
"|                 |                 |                 | slack to bound. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| slack_bound_pus | OT_DOUBLE         | 0.010           | Desired minimum |\n"
"| h               |                 |                 | absolute        |\n"
"|                 |                 |                 | distance from   |\n"
"|                 |                 |                 | the initial     |\n"
"|                 |                 |                 | slack to bound. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| slack_move      | OT_DOUBLE         | 0.000           | Correction size |\n"
"|                 |                 |                 | for very small  |\n"
"|                 |                 |                 | slacks. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| soft_resto_pder | OT_DOUBLE         | 1.000           | Required        |\n"
"| ror_reduction_f |                 |                 | reduction in    |\n"
"| actor           |                 |                 | primal-dual     |\n"
"|                 |                 |                 | error in the    |\n"
"|                 |                 |                 | soft            |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| start_with_rest | OT_STRING       | no              | Tells algorithm |\n"
"| o               |                 |                 | to switch to    |\n"
"|                 |                 |                 | restoration     |\n"
"|                 |                 |                 | phase in first  |\n"
"|                 |                 |                 | iteration. (see |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| suppress_all_ou | OT_STRING       | no              | Undocumented    |\n"
"| tput            |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| tau_min         | OT_DOUBLE         | 0.990           | Lower bound on  |\n"
"|                 |                 |                 | fraction-to-    |\n"
"|                 |                 |                 | the-boundary    |\n"
"|                 |                 |                 | parameter tau.  |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| theta_max_fact  | OT_DOUBLE         | 10000           | Determines      |\n"
"|                 |                 |                 | upper bound for |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation in    |\n"
"|                 |                 |                 | the filter.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| theta_min       | OT_DOUBLE         | 0.000           | LIFENG WRITES   |\n"
"|                 |                 |                 | THIS. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| theta_min_fact  | OT_DOUBLE         | 0.000           | Determines      |\n"
"|                 |                 |                 | constraint      |\n"
"|                 |                 |                 | violation       |\n"
"|                 |                 |                 | threshold in    |\n"
"|                 |                 |                 | the switching   |\n"
"|                 |                 |                 | rule. (see      |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| tiny_step_tol   | OT_DOUBLE         | 0.000           | Tolerance for   |\n"
"|                 |                 |                 | detecting       |\n"
"|                 |                 |                 | numerically     |\n"
"|                 |                 |                 | insignificant   |\n"
"|                 |                 |                 | steps. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| tiny_step_y_tol | OT_DOUBLE         | 0.010           | Tolerance for   |\n"
"|                 |                 |                 | quitting        |\n"
"|                 |                 |                 | because of      |\n"
"|                 |                 |                 | numerically     |\n"
"|                 |                 |                 | insignificant   |\n"
"|                 |                 |                 | steps. (see     |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| tol             | OT_DOUBLE         | 0.000           | Desired         |\n"
"|                 |                 |                 | convergence     |\n"
"|                 |                 |                 | tolerance       |\n"
"|                 |                 |                 | (relative).     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| var_integer_md  | OT_DICT   | None            | Integer         |\n"
"|                 |                 |                 | metadata (a     |\n"
"|                 |                 |                 | dictionary with |\n"
"|                 |                 |                 | lists of        |\n"
"|                 |                 |                 | integers) about |\n"
"|                 |                 |                 | variables to be |\n"
"|                 |                 |                 | passed to IPOPT |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| var_numeric_md  | OT_DICT   | None            | Numeric         |\n"
"|                 |                 |                 | metadata (a     |\n"
"|                 |                 |                 | dictionary with |\n"
"|                 |                 |                 | lists of reals) |\n"
"|                 |                 |                 | about variables |\n"
"|                 |                 |                 | to be passed to |\n"
"|                 |                 |                 | IPOPT           |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| var_string_md   | OT_DICT   | None            | String metadata |\n"
"|                 |                 |                 | (a dictionary   |\n"
"|                 |                 |                 | with lists of   |\n"
"|                 |                 |                 | strings) about  |\n"
"|                 |                 |                 | variables to be |\n"
"|                 |                 |                 | passed to IPOPT |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| vartheta        | OT_DOUBLE         | 0.500           | a parameter     |\n"
"|                 |                 |                 | used to check   |\n"
"|                 |                 |                 | if the fast     |\n"
"|                 |                 |                 | direction can   |\n"
"|                 |                 |                 | be used asthe   |\n"
"|                 |                 |                 | line search     |\n"
"|                 |                 |                 | direction (for  |\n"
"|                 |                 |                 | Chen-Goldfarb   |\n"
"|                 |                 |                 | line search).   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_boun | OT_DOUBLE         | 0.001           | same as         |\n"
"| d_frac          |                 |                 | bound_frac for  |\n"
"|                 |                 |                 | the regular     |\n"
"|                 |                 |                 | initializer.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_boun | OT_DOUBLE         | 0.001           | same as         |\n"
"| d_push          |                 |                 | bound_push for  |\n"
"|                 |                 |                 | the regular     |\n"
"|                 |                 |                 | initializer.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_enti | OT_STRING       | no              | Tells algorithm |\n"
"| re_iterate      |                 |                 | whether to use  |\n"
"|                 |                 |                 | the GetWarmStar |\n"
"|                 |                 |                 | tIterate method |\n"
"|                 |                 |                 | in the NLP.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_init | OT_STRING       | no              | Warm-start for  |\n"
"| _point          |                 |                 | initial point   |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_mult | OT_DOUBLE         | 0.001           | same as         |\n"
"| _bound_push     |                 |                 | mult_bound_push |\n"
"|                 |                 |                 | for the regular |\n"
"|                 |                 |                 | initializer.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_mult | OT_DOUBLE         | 1000000         | Maximum initial |\n"
"| _init_max       |                 |                 | value for the   |\n"
"|                 |                 |                 | equality        |\n"
"|                 |                 |                 | multipliers.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_same | OT_STRING       | no              | Indicates       |\n"
"| _structure      |                 |                 | whether a       |\n"
"|                 |                 |                 | problem with a  |\n"
"|                 |                 |                 | structure       |\n"
"|                 |                 |                 | identical to    |\n"
"|                 |                 |                 | the previous    |\n"
"|                 |                 |                 | one is to be    |\n"
"|                 |                 |                 | solved. (see    |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_slac | OT_DOUBLE         | 0.001           | same as slack_b |\n"
"| k_bound_frac    |                 |                 | ound_frac for   |\n"
"|                 |                 |                 | the regular     |\n"
"|                 |                 |                 | initializer.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_slac | OT_DOUBLE         | 0.001           | same as slack_b |\n"
"| k_bound_push    |                 |                 | ound_push for   |\n"
"|                 |                 |                 | the regular     |\n"
"|                 |                 |                 | initializer.    |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| warm_start_targ | OT_DOUBLE         | 0               | Unsupported!    |\n"
"| et_mu           |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| watchdog_shorte | OT_INT      | 10              | Number of       |\n"
"| ned_iter_trigge |                 |                 | shortened       |\n"
"| r               |                 |                 | iterations that |\n"
"|                 |                 |                 | trigger the     |\n"
"|                 |                 |                 | watchdog. (see  |\n"
"|                 |                 |                 | IPOPT           |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| watchdog_trial_ | OT_INT      | 3               | Maximum number  |\n"
"| iter_max        |                 |                 | of watchdog     |\n"
"|                 |                 |                 | iterations.     |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"| wsmp_iterative  | OT_STRING       | no              | Switches to     |\n"
"|                 |                 |                 | iterative       |\n"
"|                 |                 |                 | solver in WSMP. |\n"
"|                 |                 |                 | (see IPOPT      |\n"
"|                 |                 |                 | documentation)  |\n"
"+-----------------+-----------------+-----------------+-----------------+\n"
"\n"
"\n"
">List of available monitors\n"
"\n"
"+-------------+\n"
"|     Id      |\n"
"+=============+\n"
"| eval_f      |\n"
"+-------------+\n"
"| eval_g      |\n"
"+-------------+\n"
"| eval_grad_f |\n"
"+-------------+\n"
"| eval_h      |\n"
"+-------------+\n"
"| eval_jac_g  |\n"
"+-------------+\n"
"\n"
"\n"
">List of available stats\n"
"\n"
"+--------------------+\n"
"|         Id         |\n"
"+====================+\n"
"| con_integer_md     |\n"
"+--------------------+\n"
"| con_numeric_md     |\n"
"+--------------------+\n"
"| con_string_md      |\n"
"+--------------------+\n"
"| iter_count         |\n"
"+--------------------+\n"
"| iteration          |\n"
"+--------------------+\n"
"| iterations         |\n"
"+--------------------+\n"
"| n_eval_f           |\n"
"+--------------------+\n"
"| n_eval_g           |\n"
"+--------------------+\n"
"| n_eval_grad_f      |\n"
"+--------------------+\n"
"| n_eval_h           |\n"
"+--------------------+\n"
"| n_eval_jac_g       |\n"
"+--------------------+\n"
"| return_status      |\n"
"+--------------------+\n"
"| t_callback_fun     |\n"
"+--------------------+\n"
"| t_callback_prepare |\n"
"+--------------------+\n"
"| t_eval_f           |\n"
"+--------------------+\n"
"| t_eval_g           |\n"
"+--------------------+\n"
"| t_eval_grad_f      |\n"
"+--------------------+\n"
"| t_eval_h           |\n"
"+--------------------+\n"
"| t_eval_jac_g       |\n"
"+--------------------+\n"
"| t_mainloop         |\n"
"+--------------------+\n"
"| var_integer_md     |\n"
"+--------------------+\n"
"| var_numeric_md     |\n"
"+--------------------+\n"
"| var_string_md      |\n"
"+--------------------+\n"
"\n"
"\n"
"\n"
"\n"
;
