use strum_macros;

/// List from <https://man7.org/linux/man-pages/man5/ssh_config.5.html>
#[derive(Debug, strum_macros::Display, strum_macros::EnumString, Eq, PartialEq, Hash, Clone)]
#[strum(ascii_case_insensitive)]
pub enum EntryType {
    Unknown(String),
    Host,
    Match,
    AddKeysToAgent,
    AddressFamily,
    BatchMode,
    BindAddress,
    BindInterface,
    CanonicalDomains,
    CanonicalizeFallbackLocal,
    CanonicalizeHostname,
    CanonicalizeMaxDots,
    CanonicalizePermittedCNAMEs,
    CASignatureAlgorithms,
    CertificateFile,
    ChannelTimeout,
    CheckHostIP,
    Ciphers,
    ClearAllForwardings,
    Compression,
    ConnectionAttempts,
    ConnectTimeout,
    ControlMaster,
    ControlPath,
    ControlPersist,
    DynamicForward,
    EnableEscapeCommandline,
    EnableSSHKeysign,
    EscapeChar,
    ExitOnForwardFailure,
    FingerprintHash,
    ForkAfterAuthentication,
    ForwardAgent,
    ForwardX11,
    ForwardX11Timeout,
    ForwardX11Trusted,
    GatewayPorts,
    GlobalKnownHostsFile,
    GSSAPIAuthentication,
    GSSAPIDelegateCredentials,
    HashKnownHosts,
    HostbasedAcceptedAlgorithms,
    HostbasedAuthentication,
    HostKeyAlgorithms,
    HostKeyAlias,
    Hostname,
    IdentitiesOnly,
    IdentityAgent,
    IdentityFile,
    IgnoreUnknown,
    Include,
    IPQoS,
    KbdInteractiveAuthentication,
    KbdInteractiveDevices,
    KexAlgorithms,
    KnownHostsCommand,
    LocalCommand,
    LocalForward,
    LogLevel,
    LogVerbose,
    MACs,
    NoHostAuthenticationForLocalhost,
    NumberOfPasswordPrompts,
    ObscureKeystrokeTiming,
    PasswordAuthentication,
    PermitLocalCommand,
    PermitRemoteOpen,
    PKCS11Provider,
    Port,
    PreferredAuthentications,
    ProxyCommand,
    ProxyJump,
    ProxyUseFdpass,
    PubkeyAcceptedAlgorithms,
    PubkeyAuthentication,
    RekeyLimit,
    RemoteCommand,
    RemoteForward,
    RequestTTY,
    RequiredRSASize,
    RevokedHostKeys,
    SecurityKeyProvider,
    SendEnv,
    ServerAliveCountMax,
    ServerAliveInterval,
    SessionType,
    SetEnv,
    StdinNull,
    StreamLocalBindMask,
    StreamLocalBindUnlink,
    StrictHostKeyChecking,
    SyslogFacility,
    TCPKeepAlive,
    Tag,
    Tunnel,
    TunnelDevice,
    UpdateHostKeys,
    User,
    UserKnownHostsFile,
    VerifyHostKeyDNS,
    VisualHostKey,
    XAuthLocation,
}
