amends "package://github.com/jdx/hk/releases/download/v1.0.0/hk@1.0.0#/Config.pkl"
import "package://github.com/jdx/hk/releases/download/v1.0.0/hk@1.0.0#/Builtins.pkl"

local bash_glob = List("*.sh", "xtasks/**", "scripts/**", "e2e/**")
local bash_exclude = List("*.ps1", "*.fish", "*.ts", "*.js", "*.json", "*.bat", "**/.*", "src/assets/bash_zsh_support/**", "e2e/shell/xonsh_script")
local linters = new Mapping<String, Step> {
    // uses builtin prettier linter config
    ["prettier"] = (Builtins.prettier) {
      batch = false
    }
    //["clippy"] = (Builtins.cargo_clippy) {
    //  check = "cargo clippy --manifest-path {{workspace_indicator}} --all-features -- -Dwarnings"
    //  fix = "cargo clippy --manifest-path {{workspace_indicator}} --all-features --fix --allow-dirty --allow-staged -- -Dwarnings"
    //}
    ["cargo-check"] = (Builtins.cargo_check) {
      check = "cargo check --all-features"
    }
    ["shellcheck"] = (Builtins.shellcheck) {
      glob = bash_glob
      exclude = bash_exclude
      batch = true
      check = "shellcheck -x {{ files }}"
    }
    ["shfmt"] = (Builtins.shfmt) {
      check_list_files = """
files=$(shfmt -l -s {{ files }})
if [ -n "$files" ]; then
  echo "$files"
  exit 1
fi
"""
      fix = "shfmt -w -s {{ files }}"
      glob = bash_glob
      exclude = bash_exclude
    }

    // uses custom pkl linter config
    ["pkl"] {
        glob = "*.pkl"
        check = "pkl eval {{files}} >/dev/null"
    }
}

hooks {
    ["fix"] {
        fix = true
        steps = linters
    }
    ["check"] {
        steps = linters
    }
}
