#![allow(clippy::excessive_precision)]

pub const SINC_OVERSAMPLE_FACTOR: u32 = 512;

// Stopband attenuation of 80 dB, cutoff frequency of about 19350 Hz for a 48000 Hz target
// 15 zero crossings
pub const SINC_KERNEL: &[f32; 7937] = &[
    0.0016275687801941263,
    0.0016275544060048153,
    0.0016275256578586871,
    0.0016274825362207212,
    0.0016274250417883799,
    0.001627353175491585,
    0.0016272669384927105,
    0.0016271663321865536,
    0.0016270513582003043,
    0.0016269220183935279,
    0.0016267783148581072,
    0.0016266202499182194,
    0.0016264478261302816,
    0.0016262610462829034,
    0.0016260599133968365,
    0.0016258444307249039,
    0.0016256146017519487,
    0.001625370430194757,
    0.0016251119200019926,
    0.0016248390753541126,
    0.00162455190066329,
    0.0016242504005733274,
    0.0016239345799595624,
    0.001623604443928776,
    0.0016232599978190927,
    0.0016229012471998716,
    0.0016225281978716015,
    0.0016221408558657869,
    0.0016217392274448267,
    0.001621323319101901,
    0.0016208931375608245,
    0.0016204486897759415,
    0.0016199899829319655,
    0.0016195170244438534,
    0.0016190298219566554,
    0.0016185283833453652,
    0.0016180127167147664,
    0.0016174828303992758,
    0.0016169387329627736,
    0.0016163804331984458,
    0.0016158079401286044,
    0.001615221263004513,
    0.001614620411306208,
    0.0016140053947423095,
    0.0016133762232498335,
    0.001612732906993998,
    0.0016120754563680238,
    0.0016114038819929248,
    0.0016107181947173108,
    0.0016100184056171724,
    0.0016093045259956585,
    0.0016085765673828586,
    0.001607834541535578,
    0.0016070784604371084,
    0.0016063083362969947,
    0.001605524181550785,
    0.0016047260088598104,
    0.0016039138311109082,
    0.0016030876614161963,
    0.0016022475131128007,
    0.001601393399762596,
    0.0016005253351519502,
    0.0015996433332914443,
    0.0015987474084156038,
    0.001597837574982619,
    0.0015969138476740615,
    0.0015959762413945975,
    0.0015950247712716978,
    0.001594059452655342,
    0.0015930803011177173,
    0.0015920873324529097,
    0.0015910805626766077,
    0.001590060008025778,
    0.001589025684958346,
    0.0015879776101528904,
    0.0015869158005082987,
    0.001585840273143447,
    0.001584751045396864,
    0.0015836481348263905,
    0.0015825315592088397,
    0.001581401336539642,
    0.001580257485032507,
    0.0015791000231190533,
    0.0015779289694484574,
    0.0015767443428870856,
    0.0015755461625181271,
    0.0015743344476412263,
    0.0015731092177720869,
    0.0015718704926421167,
    0.0015706182921980285,
    0.0015693526366014465,
    0.001568073546228523,
    0.00156678104166953,
    0.0015654751437284744,
    0.0015641558734226667,
    0.0015628232519823352,
    0.0015614773008501934,
    0.0015601180416810329,
    0.0015587454963412965,
    0.0015573596869086518,
    0.0015559606356715593,
    0.001554548365128842,
    0.00155312289798924,
    0.0015516842571709662,
    0.0015502324658012753,
    0.001548767547215992,
    0.0015472895249590657,
    0.0015457984227821141,
    0.00154429426464395,
    0.0015427770747101289,
    0.0015412468773524618,
    0.0015397036971485521,
    0.0015381475588813066,
    0.0015365784875384643,
    0.0015349965083120995,
    0.0015334016465981314,
    0.0015317939279958352,
    0.0015301733783073385,
    0.0015285400235371183,
    0.0015268938898915,
    0.0015252350037781382,
    0.0015235633918055053,
    0.0015218790807823798,
    0.0015201820977173129,
    0.001518472469818114,
    0.0015167502244913121,
    0.0015150153893416245,
    0.0015132679921714203,
    0.0015115080609801814,
    0.0015097356239639512,
    0.0015079507095147905,
    0.0015061533462202249,
    0.0015043435628626879,
    0.0015025213884189569,
    0.001500686852059595,
    0.0014988399831483807,
    0.0014969808112417374,
    0.001495109366088159,
    0.001493225677627626,
    0.0014913297759910323,
    0.0014894216914995925,
    0.0014875014546642542,
    0.0014855690961851089,
    0.0014836246469507833,
    0.001481668138037852,
    0.0014796996007102293,
    0.0014777190664185596,
    0.001475726566799604,
    0.0014737221336756333,
    0.0014717057990538025,
    0.0014696775951255308,
    0.0014676375542658831,
    0.0014655857090329282,
    0.0014635220921671202,
    0.0014614467365906495,
    0.001459359675406818,
    0.0014572609418993844,
    0.0014551505695319215,
    0.0014530285919471715,
    0.0014508950429663904,
    0.0014487499565886874,
    0.0014465933669903684,
    0.001444425308524276,
    0.001442245815719123,
    0.0014400549232788133,
    0.0014378526660817823,
    0.00143563907918031,
    0.0014334141977998508,
    0.0014311780573383387,
    0.0014289306933655153,
    0.0014266721416222286,
    0.0014244024380197476,
    0.0014221216186390605,
    0.0014198297197301852,
    0.0014175267777114548,
    0.0014152128291688266,
    0.0014128879108551576,
    0.0014105520596895049,
    0.0014082053127564072,
    0.001405847707305169,
    0.0014034792807491332,
    0.001401100070664965,
    0.0013987101147919215,
    0.0013963094510311188,
    0.0013938981174448015,
    0.0013914761522556118,
    0.0013890435938458384,
    0.0013866004807566875,
    0.0013841468516875275,
    0.0013816827454951428,
    0.0013792082011929929,
    0.0013767232579504425,
    0.0013742279550920163,
    0.0013717223320966379,
    0.0013692064285968576,
    0.0013666802843781043,
    0.0013641439393779027,
    0.0013615974336851037,
    0.001359040807539124,
    0.0013564741013291476,
    0.001353897355593367,
    0.0013513106110181888,
    0.0013487139084374545,
    0.001346107288831647,
    0.0013434907933271068,
    0.0013408644631952365,
    0.0013382283398517053,
    0.0013355824648556482,
    0.0013329268799088677,
    0.0013302616268550318,
    0.001327586747678865,
    0.0013249022845053388,
    0.0013222082795988628,
    0.001319504775362472,
    0.0013167918143370037,
    0.0013140694392002902,
    0.0013113376927663242,
    0.0013085966179844455,
    0.001305846257938507,
    0.0013030866558460532,
    0.001300317855057484,
    0.001297539899055221,
    0.0012947528314528737,
    0.0012919566959943998,
    0.0012891515365532676,
    0.0012863373971316067,
    0.0012835143218593679,
    0.001280682354993474,
    0.0012778415409169738,
    0.0012749919241381766,
    0.0012721335492898176,
    0.0012692664611281806,
    0.001266390704532261,
    0.0012635063245028807,
    0.0012606133661618466,
    0.0012577118747510705,
    0.0012548018956317106,
    0.001251883474283293,
    0.0012489566563028502,
    0.0012460214874040398,
    0.0012430780134162706,
    0.0012401262802838274,
    0.0012371663340649845,
    0.0012341982209311347,
    0.0012312219871658922,
    0.001228237679164215,
    0.0012252453434315165,
    0.0012222450265827749,
    0.001219236775341639,
    0.0012162206365395386,
    0.0012131966571147868,
    0.0012101648841116826,
    0.0012071253646796121,
    0.0012040781460721489,
    0.0012010232756461499,
    0.001197960800860848,
    0.0011948907692769554,
    0.0011918132285557448,
    0.001188728226458144,
    0.0011856358108438248,
    0.0011825360296702934,
    0.0011794289309919647,
    0.0011763145629592605,
    0.0011731929738176795,
    0.0011700642119068828,
    0.0011669283256597741,
    0.0011637853636015738,
    0.001160635374348897,
    0.0011574784066088243,
    0.0011543145091779798,
    0.001151143730941596,
    0.0011479661208725908,
    0.0011447817280306268,
    0.0011415906015611885,
    0.0011383927906946387,
    0.0011351883447452895,
    0.0011319773131104576,
    0.001128759745269532,
    0.0011255356907830347,
    0.0011223051992916714,
    0.001119068320515398,
    0.001115825104252473,
    0.0011125756003785075,
    0.0011093198588455339,
    0.0011060579296810378,
    0.0011027898629870244,
    0.0010995157089390647,
    0.0010962355177853438,
    0.001092949339845709,
    0.0010896572255107149,
    0.001086359225240673,
    0.0010830553895646914,
    0.0010797457690797233,
    0.0010764304144496078,
    0.0010731093764041095,
    0.0010697827057379618,
    0.0010664504533099042,
    0.0010631126700417232,
    0.0010597694069172877,
    0.001056420714981589,
    0.0010530666453397739,
    0.00104970724915618,
    0.0010463425776533735,
    0.0010429726821111773,
    0.0010395976138657074,
    0.0010362174243084058,
    0.001032832164885062,
    0.001029441887094863,
    0.0010260466424894005,
    0.0010226464826717148,
    0.0010192414592953194,
    0.0010158316240632236,
    0.001012417028726969,
    0.001008997725085646,
    0.0010055737649849264,
    0.001002145200316086,
    0.000998712083015031,
    0.000995274465061316,
    0.000991832398477179,
    0.000988385935326552,
    0.0009849351277140927,
    0.0009814800277842038,
    0.0009780206877200506,
    0.0009745571597425907,
    0.0009710894961095888,
    0.0009676177491146372,
    0.0009641419710861797,
    0.0009606622143865297,
    0.0009571785314108889,
    0.0009536909745863668,
    0.0009501995963710017,
    0.0009467044492527778,
    0.0009432055857486419,
    0.0009397030584035271,
    0.0009361969197893676,
    0.0009326872225041156,
    0.0009291740191707597,
    0.0009256573624363456,
    0.0009221373049709906,
    0.0009186138994669039,
    0.0009150871986374003,
    0.0009115572552159202,
    0.0009080241219550488,
    0.0009044878516255285,
    0.0009009484970152813,
    0.0008974061109284248,
    0.0008938607461842864,
    0.0008903124556164278,
    0.0008867612920716562,
    0.0008832073084090455,
    0.000879650557498953,
    0.0008760910922220407,
    0.0008725289654682891,
    0.0008689642301360185,
    0.0008653969391309082,
    0.0008618271453650127,
    0.0008582549017557838,
    0.00085468026122509,
    0.0008511032766982368,
    0.0008475240011029821,
    0.0008439424873685653,
    0.000840358788424722,
    0.0008367729572007034,
    0.0008331850466243076,
    0.0008295951096208932,
    0.0008260031991124028,
    0.0008224093680163907,
    0.0008188136692450426,
    0.0008152161557042006,
    0.0008116168802923885,
    0.0008080158958998373,
    0.0008044132554075083,
    0.0008008090116861244,
    0.0007972032175951923,
    0.0007935959259820303,
    0.0007899871896808023,
    0.0007863770615115396,
    0.000782765594279175,
    0.0007791528407725709,
    0.0007755388537635521,
    0.0007719236860059351,
    0.0007683073902345656,
    0.0007646900191643439,
    0.0007610716254892691,
    0.0007574522618814644,
    0.0007538319809902215,
    0.0007502108354410294,
    0.000746588877834619,
    0.000742966160745998,
    0.0007393427367234893,
    0.0007357186582877763,
    0.0007320939779309392,
    0.000728468748115499,
    0.0007248430212734638,
    0.0007212168498053693,
    0.000717590286079325,
    0.0007139633824300639,
    0.0007103361911579871,
    0.0007067087645282127,
    0.000703081154769626,
    0.0006994534140739333,
    0.0006958255945947088,
    0.0006921977484464546,
    0.0006885699277036491,
    0.0006849421843998054,
    0.00068131457052653,
    0.0006776871380325787,
    0.0006740599388229159,
    0.0006704330247577811,
    0.0006668064476517421,
    0.0006631802592727643,
    0.0006595545113412779,
    0.0006559292555292383,
    0.0006523045434591953,
    0.0006486804267033673,
    0.0006450569567827061,
    0.0006414341851659702,
    0.0006378121632688018,
    0.000634190942452795,
    0.0006305705740245819,
    0.0006269511092348999,
    0.0006233325992776804,
    0.0006197150952891247,
    0.0006160986483467888,
    0.0006124833094686659,
    0.0006088691296122767,
    0.0006052561596737515,
    0.0006016444504869232,
    0.0005980340528224163,
    0.0005944250173867429,
    0.0005908173948213914,
    0.0005872112357019278,
    0.000583606590537093,
    0.000580003509767898,
    0.0005764020437667297,
    0.0005728022428364559,
    0.0005692041572095231,
    0.0005656078370470694,
    0.0005620133324380327,
    0.0005584206933982598,
    0.0005548299698696189,
    0.0005512412117191153,
    0.0005476544687380064,
    0.0005440697906409214,
    0.0005404872270649822,
    0.0005369068275689228,
    0.0005333286416322163,
    0.0005297527186541998,
    0.0005261791079532049,
    0.0005226078587656842,
    0.00051903902024535,
    0.0005154726414623003,
    0.0005119087714021652,
    0.000508347458965237,
    0.0005047887529656175,
    0.0005012327021303586,
    0.000497679355098607,
    0.0004941287604207531,
    0.0004905809665575789,
    0.0004870360218794145,
    0.00048349397466528613,
    0.0004799548731020752,
    0.00047641876528368006,
    0.0004728856992101729,
    0.00046935572278696447,
    0.0004658288838239699,
    0.00046230523003477756,
    0.00045878480903581827,
    0.0004552676683455386,
    0.0004517538553835758,
    0.00044824341746993533,
    0.0004447364018241721,
    0.00044123285556457037,
    0.00043773282570733213,
    0.0004342363591657604,
    0.0004307435027494541,
    0.00042725430316349443,
    0.0004237688070076461,
    0.00042028706077554994,
    0.0004168091108539249,
    0.00041333500352177144,
    0.00040986478494957546,
    0.00040639850119851464,
    0.0004029361982196738,
    0.0003994779218532517,
    0.00039602371782778144,
    0.00039257363175934683,
    0.0003891277091508036,
    0.00038568599539100327,
    0.00038224853575402,
    0.0003788153753983781,
    0.00037538655936628654,
    0.00037196213258287213,
    0.0003685421398554163,
    0.000365126625872596,
    0.0003617156352037282,
    0.000358309212298013,
    0.0003549074014837845,
    0.00035151024696776045,
    0.00034811779283429805,
    0.00034473008304465087,
    0.0003413471614362293,
    0.00033796907172186226,
    0.0003345958574890648,
    0.0003312275621993053,
    0.0003278642291872788,
    0.0003245059016601804,
    0.00032115262269698567,
    0.00031780443524772657,
    0.00031446138213278005,
    0.00031112350604215323,
    0.00030779084953477115,
    0.0003044634550377722,
    0.0003011413648458022,
    0.00029782462112031504,
    0.00029451326588887303,
    0.0002912073410444541,
    0.0002879068883447566,
    0.0002846119494115137,
    0.0002813225657298079,
    0.00027803877864738576,
    0.0002747606293739816,
    0.00027148815898064046,
    0.0002682214083990447,
    0.00026496041842084464,
    0.00026170522969699275,
    0.0002584558827370802,
    0.0002552124179086752,
    0.00025197487543666925,
    0.00024874329540262104,
    0.00024551771774410737,
    0.0002422981822540758,
    0.00023908472858020222,
    0.00023587739622424808,
    0.00023267622454142673,
    0.00022948125273976582,
    0.00022629251987948084,
    0.000223110064872345,
    0.0002199339264810676,
    0.00021676414331867275,
    0.00021360075384788406,
    0.0002104437963805082,
    0.0002072933090768279,
    0.00020414932994499433,
    0.00020101189684042318,
    0.000197881047465196,
    0.000194756819367463,
    0.0001916392499408513,
    0.00018852837642387437,
    0.00018542423589934789,
    0.0001823268652938057,
    0.0001792363013769211,
    0.00017615258076093365,
    0.00017307573990007515,
    0.0001700058150900018,
    0.00016694284246723072,
    0.0001638868580085776,
    0.00016083789753059923,
    0.0001577959966890413,
    0.00015476119097828563,
    0.00015173351573080385,
    0.00014871300611661668,
    0.0001456996971427514,
    0.00014269362365270725,
    0.00013969482032592377,
    0.00013670332167725076,
    0.00013371916205642438,
    0.0001307423756475464,
    0.00012777299646856495,
    0.0001248110583707616,
    0.00012185659503824155,
    0.00011890963998742641,
    0.00011597022656655144,
    0.00011303838795516757,
    0.00011011415716364393,
    0.00010719756703267819,
    0.00010428865023280869,
    0.00010138743926392865,
    9.849396645480763e-05,
    9.560826396261374e-05,
    9.273036377244201e-05,
    8.986029769684397e-05,
    8.699809737536448e-05,
    8.414379427407861e-05,
    8.129741968513364e-05,
    7.84590047262981e-05,
    7.562858034050886e-05,
    7.28061772954268e-05,
    6.999182618299371e-05,
    6.718555741899445e-05,
    6.438740124262194e-05,
    6.159738771604738e-05,
    5.881554672399213e-05,
    5.604190797330598e-05,
    5.3276500992547194e-05,
    5.051935513156839e-05,
    4.77704995611041e-05,
    4.5029963272365124e-05,
    4.229777507663275e-05,
    3.957396360486122e-05,
    3.6858557307281987e-05,
    3.4151584453010875e-05,
    3.1453073129661396e-05,
    2.876305124296074e-05,
    2.6081546516369774e-05,
    2.340858649070723e-05,
    2.0744198523778796e-05,
    1.808840979000695e-05,
    1.5441247280069037e-05,
    1.280273780053711e-05,
    1.0172907973520743e-05,
    7.551784236315989e-06,
    4.939392841057135e-06,
    2.3357598543726606e-06,
    -2.590888429549453e-07,
    -2.8451275563243044e-06,
    -5.422330777648249e-06,
    -7.990673185681988e-06,
    -1.0550129646345247e-05,
    -1.3100675213043365e-05,
    -1.5642285126984167e-05,
    -1.817493481748808e-05,
    -2.0698599902295917e-05,
    -2.3213256187874903e-05,
    -2.57188796697151e-05,
    -2.8215446532627728e-05,
    -3.07029331510353e-05,
    -3.3181316089260065e-05,
    -3.565057210180584e-05,
    -3.811067813364018e-05,
    -4.056161132046637e-05,
    -4.30033489889971e-05,
    -4.543586865722141e-05,
    -4.785914803466608e-05,
    -5.027316502265568e-05,
    -5.267789771456851e-05,
    -5.507332439608588e-05,
    -5.7459423545438515e-05,
    -5.9836173833651285e-05,
    -6.220355412477914e-05,
    -6.456154347614327e-05,
    -6.691012113856115e-05,
    -6.92492665565717e-05,
    -7.157895936865784e-05,
    -7.389917940746574e-05,
    -7.62099067000168e-05,
    -7.851112146791761e-05,
    -8.080280412756723e-05,
    -8.308493529035625e-05,
    -8.535749576286577e-05,
    -8.762046654706086e-05,
    -8.987382884047784e-05,
    -9.211756403641039e-05,
    -9.435165372409141e-05,
    -9.657607968886731e-05,
    -9.879082391237255e-05,
    -0.00010099586857269758,
    -0.00010319119604455232,
    -0.00010537678889942678,
    -0.0001075526299057478,
    -0.0001097187020290303,
    -0.00011187498843202383,
    -0.00011402147247485892,
    -0.00011615813771518357,
    -0.00011828496790830019,
    -0.00012040194700729728,
    -0.00012250905916317463,
    -0.0001246062887249668,
    -0.00012669362023986342,
    -0.00012877103845332203,
    -0.00013083852830917848,
    -0.00013289607494975443,
    -0.00013494366371595833,
    -0.00013698128014738418,
    -0.00013900890998240538,
    -0.00014102653915826398,
    -0.00014303415381115565,
    -0.00014503174027631358,
    -0.00014701928508808286,
    -0.0001489967749799953,
    -0.00015096419688483888,
    -0.00015292153793472008,
    -0.00015486878546112811,
    -0.00015680592699498895,
    -0.0001587329502667188,
    -0.00016064984320627196,
    -0.00016255659394318674,
    -0.00016445319080662252,
    -0.00016633962232539813,
    -0.00016821587722802372,
    -0.00017008194444272662,
    -0.0001719378130974761,
    -0.00017378347252000348,
    -0.00017561891223781656,
    -0.00017744412197821048,
    -0.0001792590916682766,
    -0.0001810638114349034,
    -0.00018285827160477658,
    -0.00018464246270437454,
    -0.00018641637545995692,
    -0.00018818000079755286,
    -0.00018993332984294388,
    -0.00019167635392164113,
    -0.00019340906455885963,
    -0.00019513145347949034,
    -0.00019684351260806321,
    -0.0001985452340687123,
    -0.0002002366101851332,
    -0.0002019176334805345,
    -0.00020358829667758993,
    -0.00020524859269838465,
    -0.00020689851466435503,
    -0.0002085380558962274,
    -0.00021016720991395195,
    -0.0002117859704366309,
    -0.00021339433138244603,
    -0.0002149922868685781,
    -0.00021657983121112605,
    -0.000218156958925019,
    -0.00021972366472392655,
    -0.00022127994352016302,
    -0.00022282579042459062,
    -0.00022436120074651508,
    -0.00022588616999357955,
    -0.0002274006938716532,
    -0.00022890476828471836,
    -0.00023039838933474965,
    -0.0002318815533215924,
    -0.00023335425674283664,
    -0.00023481649629368366,
    -0.00023626826886681454,
    -0.00023770957155225123,
    -0.00023914040163721065,
    -0.00024056075660596236,
    -0.0002419706341396751,
    -0.0002433700321162646,
    -0.0002447589486102326,
    -0.0002461373818925076,
    -0.0002475053304302759,
    -0.00024886279288681266,
    -0.0002502097681213087,
    -0.00025154625518869006,
    -0.0002528722533394389,
    -0.00025418776201940576,
    -0.00025549278086962033,
    -0.00025678730972609874,
    -0.0002580713486196455,
    -0.00025934489777565097,
    -0.00026060795761388857,
    -0.00026186052874830403,
    -0.0002631026119868032,
    -0.0002643342083310351,
    -0.0002655553189761718,
    -0.00026676594531068316,
    -0.0002679660889161089,
    -0.00026915575156682785,
    -0.00027033493522982073,
    -0.0002715036420644298,
    -0.00027266187442211794,
    -0.00027380963484621994,
    -0.0002749469260716912,
    -0.0002760737510248539,
    -0.0002771901128231373,
    -0.0002782960147748176,
    -0.0002793914603787502,
    -0.0002804764533241002,
    -0.000281550997490069,
    -0.0002826150969456184,
    -0.000283668755949188,
    -0.00028471197894841137,
    -0.00028574477057982905,
    -0.00028676713566859317,
    -0.0002877790792281766,
    -0.0002887806064600694,
    -0.000289771722753478,
    -0.00029075243368501924,
    -0.00029172274501840863,
    -0.0002926826627041469,
    -0.000293632192879203,
    -0.00029457134186669325,
    -0.0002955001161755562,
    -0.0002964185225002236,
    -0.0002973265677202906,
    -0.00029822425890017944,
    -0.0002991116032887986,
    -0.0002999886083192034,
    -0.00030085528160824854,
    -0.00030171163095623726,
    -0.00030255766434657093,
    -0.00030339338994539065,
    -0.00030421881610121675,
    -0.000305033951344587,
    -0.0003058388043876877,
    -0.00030663338412398414,
    -0.0003074176996278464,
    -0.0003081917601541719,
    -0.00030895557513800425,
    -0.00030970915419414955,
    -0.00031045250711678743,
    -0.0003111856438790816,
    -0.000311908574632784,
    -0.0003126213097078379,
    -0.00031332385961197417,
    -0.0003140162350303107,
    -0.00031469844682494106,
    -0.00031537050603452346,
    -0.00031603242387386873,
    -0.0003166842117335187,
    -0.0003173258811793278,
    -0.0003179574439520365,
    -0.00031857891196684446,
    -0.00031919029731297986,
    -0.0003197916122532627,
    -0.00032038286922367055,
    -0.0003209640808328948,
    -0.0003215352598618978,
    -0.00032209641926346505,
    -0.0003226475721617561,
    -0.00032318873185184824,
    -0.000323719911799282,
    -0.0003242411256395996,
    -0.0003247523871778831,
    -0.00032525371038828684,
    -0.00032574510941356784,
    -0.00032622659856461507,
    -0.00032669819231997163,
    -0.0003271599053253572,
    -0.0003276117523931857,
    -0.0003280537485020809,
    -0.0003284859087963876,
    -0.00032890824858568176,
    -0.0003293207833442752,
    -0.0003297235287107202,
    -0.0003301165004873081,
    -0.00033049971463956594,
    -0.0003308731872957524,
    -0.0003312369347463471,
    -0.0003315909734435397,
    -0.00033193532000071435,
    -0.00033226999119193295,
    -0.0003325950039514129,
    -0.0003329103753730054,
    -0.0003332161227096677,
    -0.0003335122633729345,
    -0.00033379881493238536,
    -0.00033407579511511066,
    -0.00033434322180517185,
    -0.00033460111304306337,
    -0.00033484948702516745,
    -0.00033508836210320846,
    -0.00033531775678370413,
    -0.00033553768972741343,
    -0.00033574817974878316,
    -0.00033594924581538887,
    -0.0003361409070473771,
    -0.0003363231827169009,
    -0.00033649609224755615,
    -0.00033665965521381333,
    -0.00033681389134044556,
    -0.00033695882050195685,
    -0.0003370944627220058,
    -0.0003372208381728273,
    -0.00033733796717465075,
    -0.0003374458701951179,
    -0.0003375445678486948,
    -0.0003376340808960836,
    -0.0003377144302436332,
    -0.000337785636942742,
    -0.0003378477221892644,
    -0.0003379007073229114,
    -0.00033794461382664746,
    -0.0003379794633260888,
    -0.00033800527758889724,
    -0.00033802207852416964,
    -0.0003380298881818292,
    -0.00033802872875200957,
    -0.0003380186225644418,
    -0.0003379995920878327,
    -0.00033797165992924803,
    -0.00033793484883348686,
    -0.00033788918168245653,
    -0.00033783468149454674,
    -0.0003377713714239984,
    -0.0003376992747602712,
    -0.0003376184149274108,
    -0.0003375288154834103,
    -0.00033743050011957244,
    -0.0003373234926598694,
    -0.00033720781706029644,
    -0.0003370834974082299,
    -0.0003369505579217777,
    -0.0003368090229491297,
    -0.00033665891696790687,
    -0.00033650026458450453,
    -0.00033633309053343987,
    -0.0003361574196766906,
    -0.00033597327700303606,
    -0.0003357806876273957,
    -0.0003355796767901614,
    -0.00033537026985653586,
    -0.00033515249231585905,
    -0.0003349263697809412,
    -0.00033469192798739,
    -0.000334449192792935,
    -0.000334198190176751,
    -0.0003339389462387818,
    -0.0003336714871990587,
    -0.00033339583939701766,
    -0.000333112029290818,
    -0.00033282008345665283,
    -0.00033252002858806507,
    -0.0003322118914952557,
    -0.0003318956991043928,
    -0.00033157147845692,
    -0.0003312392567088586,
    -0.0003308990611301144,
    -0.0003305509191037766,
    -0.0003301948581254194,
    -0.0003298309058023989,
    -0.00032945908985315106,
    -0.00032907943810648536,
    -0.0003286919785008779,
    -0.0003282967390837633,
    -0.00032789374801082515,
    -0.0003274830335452839,
    -0.0003270646240571822,
    -0.00032663854802267235,
    -0.00032620483402329706,
    -0.000325763510745275,
    -0.000325314606978778,
    -0.00032485815161721084,
    -0.00032439417365649086,
    -0.00032392270219432025,
    -0.000323443766429464,
    -0.00032295739566102105,
    -0.0003224636192876966,
    -0.00032196246680707224,
    -0.00032145396781487476,
    -0.0003209381520042438,
    -0.0003204150491649978,
    -0.0003198846891828988,
    -0.0003193471020389164,
    -0.00031880231780849006,
    -0.000318250366660789,
    -0.0003176912788579718,
    -0.0003171250847544463,
    -0.0003165518147961258,
    -0.00031597149951968507,
    -0.00031538416955181425,
    -0.0003147898556084739,
    -0.0003141885884941468,
    -0.00031358039910108876,
    -0.00031296531840857914,
    -0.00031234337748216995,
    -0.0003117146074729336,
    -0.0003110790396167089,
    -0.000310436705233349,
    -0.0003097876357259644,
    -0.000309131862580166,
    -0.0003084694173633106,
    -0.00030780033172373924,
    -0.0003071246373900207,
    -0.0003064423661701895,
    -0.0003057535499509861,
    -0.0003050582206970935,
    -0.0003043564104503752,
    -0.00030364815132911103,
    -0.000302933475527233,
    -0.00030221241531355785,
    -0.00030148500303102334,
    -0.00030075127109591984,
    -0.0003000112519971214,
    -0.00029926497829531795,
    -0.0002985124826222458,
    -0.000297753797679917,
    -0.0002969889562398492,
    -0.00029621799114229236,
    -0.000295440935295457,
    -0.00029465782167474293,
    -0.00029386868332196165,
    -0.00029307355334456654,
    -0.0002922724649148741,
    -0.00029146545126929074,
    -0.0002906525457075343,
    -0.00028983378159186114,
    -0.0002890091923462841,
    -0.0002881788114557989,
    -0.00028734267246560236,
    -0.00028650080898031673,
    -0.00028565325466320743,
    -0.00028480004323540645,
    -0.0002839412084751282,
    -0.0002830767842168927,
    -0.00028220680435074293,
    -0.0002813313028214624,
    -0.0002804503136277959,
    -0.00027956387082166373,
    -0.00027867200850738386,
    -0.00027777476084088417,
    -0.0002768721620289235,
    -0.00027596424632830597,
    -0.0002750510480450973,
    -0.00027413260153384266,
    -0.00027320894119678077,
    -0.00027228010148305966,
    -0.0002713461168879533,
    -0.0002704070219520768,
    -0.00026946285126059943,
    -0.0002685136394424621,
    -0.00026755942116959156,
    -0.0002666002311561142,
    -0.00026563610415757127,
    -0.00026466707497013373,
    -0.00026369317842981716,
    -0.00026271444941169454,
    -0.00026173092282911304,
    -0.00026074263363290673,
    -0.00025974961681061147,
    -0.00025875190738567993,
    -0.00025774954041669543,
    -0.00025674255099658724,
    -0.00025573097425184605,
    -0.0002547148453417357,
    -0.0002536941994575117,
    -0.0002526690718216342,
    -0.00025163949768698446,
    -0.0002506055123360787,
    -0.0002495671510802854,
    -0.0002485244492590392,
    -0.0002474774422390596,
    -0.0002464261654135646,
    -0.0002453706542014886,
    -0.0002443109440466981,
    -0.00024324707041721067,
    -0.00024217906880441017,
    -0.0002411069747222662,
    -0.0002400308237065518,
    -0.0002389506513140603,
    -0.00023786649312182594,
    -0.00023677838472634292,
    -0.00023568636174278398,
    -0.00023459045980422187,
    -0.00023349071456084747,
    -0.00023238716167919366,
    -0.0002312798368413547,
    -0.00023016877574420888,
    -0.00022905401409864103,
    -0.00022793558762876468,
    -0.0002268135320711476,
    -0.0002256878831740328,
    -0.0002245586766965656,
    -0.00022342594840801908,
    -0.00022228973408701706,
    -0.0002211500695207644,
    -0.00022000699050427113,
    -0.0002188605328395821,
    -0.00021771073233500476,
    -0.00021655762480433794,
    -0.00021540124606610268,
    -0.0002142416319427725,
    -0.00021307881826000403,
    -0.00021191284084587066,
    -0.00021074373553009378,
    -0.00020957153814327875,
    -0.0002083962845161466,
    -0.00020721801047877156,
    -0.00020603675185981656,
    -0.00020485254448576994,
    -0.0002036654241801843,
    -0.00020247542676291478,
    -0.00020128258804935802,
    -0.00020008694384969527,
    -0.00019888852996813113,
    -0.000197687382202138,
    -0.00019648353634169906,
    -0.00019527702816855315,
    -0.00019406789345543984,
    -0.00019285616796534602,
    -0.0001916418874507545,
    -0.00019042508765289097,
    -0.00018920580430097555,
    -0.00018798407311147297,
    -0.00018675992978734344,
    -0.0001855334100172977,
    -0.00018430454947504976,
    -0.0001830733838185722,
    -0.00018183994868935425,
    -0.0001806042797116574,
    -0.00017936641249177612,
    -0.00017812638261729646,
    -0.0001768842256563583,
    -0.00017563997715691788,
    -0.00017439367264601114,
    -0.00017314534762901966,
    -0.0001718950375889361,
    -0.00017064277798563198,
    -0.00016938860425512838,
    -0.000168132551808864,
    -0.00016687465603296739,
    -0.000165614952287532,
    -0.00016435347590588754,
    -0.0001630902621938788,
    -0.00016182534642914073,
    -0.00016055876386037783,
    -0.00015929054970664522,
    -0.00015802073915662836,
    -0.00015674936736792777,
    -0.00015547646946634263,
    -0.00015420208054515728,
    -0.00015292623566442854,
    -0.00015164896985027474,
    -0.0001503703180941664,
    -0.00014909031535221886,
    -0.0001478089965444846,
    -0.0001465263965542511,
    -0.00014524255022733469,
    -0.0001439574923713819,
    -0.00014267125775516804,
    -0.0001413838811078985,
    -0.00014009539711851471,
    -0.00013880584043499654,
    -0.00013751524566367067,
    -0.00013622364736851883,
    -0.00013493108007048805,
    -0.00013363757824680226,
    -0.00013234317633027673,
    -0.00013104790870863272,
    -0.0001297518097238157,
    -0.00012845491367131332,
    -0.00012715725479947753,
    -0.00012585886730884514,
    -0.00012455978535146482,
    -0.00012326004303022195,
    -0.0001219596743981662,
    -0.00012065871345784331,
    -0.00011935719416062581,
    -0.00011805515040604612,
    -0.00011675261604113439,
    -0.00011544962485975393,
    -0.00011414621060194212,
    -0.00011284240695325086,
    -0.00011153824754409148,
    -0.00011023376594907812,
    -0.00010892899568637689,
    -0.00010762397021705497,
    -0.0001063187229444304,
    -0.00010501328721342732,
    -0.0001037076963099316,
    -0.00010240198346014574,
    -0.00010109618182995198,
    -9.979032452427124e-05,
    -9.848444458642718e-05,
    -9.717857499751387e-05,
    -9.587274867576137e-05,
    -9.456699847590703e-05,
    -9.326135718856745e-05,
    -9.195585753961242e-05,
    -9.065053218954204e-05,
    -8.934541373286467e-05,
    -8.80405346974781e-05,
    -8.673592754405258e-05,
    -8.543162466541561e-05,
    -8.412765838594067e-05,
    -8.282406096093463e-05,
    -8.152086457603131e-05,
    -8.021810134658623e-05,
    -7.891580331707027e-05,
    -7.761400246047148e-05,
    -7.63127306776942e-05,
    -7.501201979696271e-05,
    -7.371190157322691e-05,
    -7.241240768757029e-05,
    -7.111356974662002e-05,
    -6.981541928195949e-05,
    -6.851798774954323e-05,
    -6.72213065291145e-05,
    -6.592540692362426e-05,
    -6.463032015865453e-05,
    -6.333607738184086e-05,
    -6.204270966230074e-05,
    -6.075024799006304e-05,
    -5.94587232754977e-05,
    -5.816816634875258e-05,
    -5.687860795918816e-05,
    -5.559007877481651e-05,
    -5.4302609381744646e-05,
    -5.30162302836164e-05,
    -5.1730971901060006e-05,
    -5.044686457113705e-05,
    -4.916393854679367e-05,
    -4.788222399631467e-05,
    -4.660175100278021e-05,
    -4.532254956352476e-05,
    -4.404464958959868e-05,
    -4.2768080905232486e-05,
    -4.149287324730438e-05,
    -4.021905626480756e-05,
    -3.894665951832425e-05,
    -3.7675712479500014e-05,
    -3.6406244530518816e-05,
    -3.513828496358594e-05,
    -3.387186298040776e-05,
    -3.260700769167802e-05,
    -3.134374811656537e-05,
    -3.0082113182203418e-05,
    -2.8822131723183924e-05,
    -2.7563832481052413e-05,
    -2.630724410380654e-05,
    -2.5052395145396963e-05,
    -2.3799314065231108e-05,
    -2.2548029227680502e-05,
    -2.1298568901587824e-05,
    -2.0050961259780677e-05,
    -1.880523437858626e-05,
    -1.756141623734646e-05,
    -1.631953471794108e-05,
    -1.507961760430849e-05,
    -1.3841692581971186e-05,
    -1.2605787237566185e-05,
    -1.1371929058373995e-05,
    -1.0140145431853722e-05,
    -8.910463645179498e-06,
    -7.682910884780177e-06,
    -6.457514235881591e-06,
    -5.23430068205179e-06,
    -4.013297104749071e-06,
    -2.7945302828728315e-06,
    -1.5780268923170246e-06,
    -3.6381350552779616e-07,
    8.480834089394428e-07,
    2.0576374868547996e-06,
    3.264822468750864e-06,
    4.469612200354692e-06,
    5.671980633015004e-06,
    6.8719018241304965e-06,
    8.06934993757232e-06,
    9.26429924410359e-06,
    1.0456724121799045e-05,
    1.164659905645766e-05,
    1.2833898642014313e-05,
    1.401859758095045e-05,
    1.5200670684697781e-05,
    1.6380092874041593e-05,
    1.7556839179521197e-05,
    1.8730884741827186e-05,
    1.9902204812193562e-05,
    2.1070774752790463e-05,
    2.2236570037112265e-05,
    2.339956625036072e-05,
    2.455973908982887e-05,
    2.5717064365280295e-05,
    2.687151799932229e-05,
    2.802307602778298e-05,
    2.917171460007856e-05,
    3.031740997958052e-05,
    3.146013854398134e-05,
    3.259987678565386e-05,
    3.373660131200912e-05,
    3.487028884585298e-05,
    3.600091622573646e-05,
    3.7128460406304404e-05,
    3.825289845864244e-05,
    3.937420757061958e-05,
    4.049236504722628e-05,
    4.160734831091274e-05,
    4.271913490192248e-05,
    4.382770247862093e-05,
    4.4933028817824915e-05,
    4.603509181512598e-05,
    4.713386948521109e-05,
    4.822933996218219e-05,
    4.9321481499870226e-05,
    5.0410272472146225e-05,
    5.1495691373232564e-05,
    5.257771681800647e-05,
    5.3656327542303145e-05,
    5.4731502403215684e-05,
    5.580322037939186e-05,
    5.68714605713256e-05,
    5.7936202201648934e-05,
    5.89974246154187e-05,
    6.005510728039873e-05,
    6.110922978734277e-05,
    6.215977185027166e-05,
    6.320671330674515e-05,
    6.425003411813759e-05,
    6.528971436990267e-05,
    6.632573427183913e-05,
    6.735807415835406e-05,
    6.838671448871982e-05,
    6.941163584732996e-05,
    7.043281894395278e-05,
    7.14502446139791e-05,
    7.246389381866863e-05,
    7.347374764539314e-05,
    7.447978730787673e-05,
    7.548199414643063e-05,
    7.648034962818801e-05,
    7.747483534733446e-05,
    7.84654330253324e-05,
    7.945212451114851e-05,
    8.043489178147195e-05,
    8.141371694093167e-05,
    8.238858222231269e-05,
    8.335946998676495e-05,
    8.432636272401194e-05,
    8.528924305255636e-05,
    8.624809371988034e-05,
    8.720289760264359e-05,
    8.815363770687973e-05,
    8.91002971681878e-05,
    9.004285925191959e-05,
    9.0981307353367e-05,
    9.191562499794388e-05,
    9.284579584136381e-05,
    9.377180366981771e-05,
    9.469363240014589e-05,
    9.561126608000672e-05,
    9.652468888804464e-05,
    9.743388513405209e-05,
    9.833883925912864e-05,
    9.923953583584006e-05,
    0.00010013595956836951,
    0.00010102809529266854,
    0.00010191592797660475,
    0.0001027994427201052,
    0.00010367862475529647,
    0.00010455345944664304,
    0.00010542393229108157,
    0.00010629002891815078,
    0.00010715173509012029,
    0.00010800903670211581,
    0.00010886191978223822,
    0.00010971037049168484,
    0.00011055437512486227,
    0.00011139392010949872,
    0.0001122289920067535,
    0.00011305957751132151,
    0.00011388566345153508,
    0.0001147072367894649,
    0.00011552428462101378,
    0.00011633679417600995,
    0.00011714475281829714,
    0.00011794814804582086,
    0.00011874696749070962,
    0.00011954119891935724,
    0.00012033083023249826,
    0.00012111584946528137,
    0.00012189624478734012,
    0.00012267200450286016,
    0.00012344311705064242,
    0.00012420957100416503,
    0.00012497135507163996,
    0.0001257284580960675,
    0.00012648086905528864,
    0.00012722857706203152,
    0.00012797157136395728,
    0.00012870984134370165,
    0.00012944337651891373,
    0.000130172166542291,
    0.00013089620120161155,
    0.00013161547041976403,
    0.0001323299642547722,
    0.0001330396728998187,
    0.00013374458668326548,
    0.00013444469606866736,
    0.0001351399916547892,
    0.00013583046417561334,
    0.00013651610450034766,
    0.00013719690363343015,
    0.0001378728527145283,
    0.0001385439430185378,
    0.00013921016595557767,
    0.00013987151307098,
    0.00014052797604527953,
    0.00014117954669419882,
    0.00014182621696863057,
    0.00014246797895461544,
    0.0001431048248733194,
    0.000143736747081006,
    0.00014436373806900557,
    0.00014498579046368266,
    0.00014560289702639985,
    0.00014621505065347666,
    0.00014682224437614872,
    0.0001474244713605217,
    0.00014802172490752121,
    0.00014861399845284332,
    0.00014920128556689759,
    0.00014978357995475017,
    0.0001503608754560633,
    0.00015093316604503044,
    0.00015150044583030914,
    0.00015206270905495194,
    0.0001526199500963328,
    0.00015317216346607054,
    0.00015371934380995012,
    0.00015426148590784095,
    0.0001547985846736102,
    0.00015533063515503698,
    0.00015585763253371892,
    0.00015637957212497937,
    0.0001568964493777694,
    0.0001574082598745692,
    0.00015791499933128262,
    0.0001584166635971333,
    0.0001589132486545544,
    0.00015940475061907716,
    0.00015989116573921524,
    0.00016037249039634833,
    0.00016084872110459916,
    0.0001613198545107119,
    0.0001617858873939239,
    0.0001622468166658368,
    0.00016270263937028404,
    0.00016315335268319515,
    0.00016359895391245688,
    0.00016403944049777375,
    0.00016447481001052202,
    0.0001649050601536031,
    0.00016533018876129443,
    0.0001657501937990964,
    0.00016616507336357584,
    0.00016657482568220878,
    0.00016697944911321864,
    0.00016737894214541158,
    0.00016777330339801027,
    0.00016816253162048369,
    0.00016854662569237386,
    0.00016892558462312175,
    0.00016929940755188767,
    0.0001696680937473707,
    0.0001700316426076252,
    0.00017039005365987334,
    0.0001707433265603163,
    0.00017109146109394157,
    0.00017143445717432846,
    0.0001717723148434501,
    0.000172105034271473,
    0.00017243261575655355,
    0.0001727550597246326,
    0.0001730723667292263,
    0.0001733845374512153,
    0.0001736915726986296,
    0.00017399347340643303,
    0.00017429024063630294,
    0.000174581875576408,
    0.0001748683795411839,
    0.0001751497539711053,
    0.00017542600043245573,
    0.000175697120617095,
    0.00017596311634222398,
    0.00017622398955014512,
    0.00017647974230802392,
    0.00017673037680764368,
    0.0001769758953651599,
    0.00017721630042085313,
    0.00017745159453887567,
    0.00017768178040699977,
    0.00017790686083635953,
    0.00017812683876119423,
    0.00017834171723858443,
    0.00017855149944819018,
    0.00017875618869198345,
    0.0001789557883939787,
    0.00017915030209996255,
    0.00017933973347721856,
    0.00017952408631425148,
    0.00017970336452050774,
    0.0001798775721260943,
    0.00018004671328149423,
    0.00018021079225728052,
    0.0001803698134438269,
    0.00018052378135101707,
    0.00018067270060795053,
    0.00018081657596264605,
    0.00018095541228174328,
    0.00018108921455020228,
    0.00018121798787099956,
    0.00018134173746482172,
    0.00018146046866975878,
    0.00018157418694099236,
    0.00018168289785048245,
    0.00018178660708665403,
    0.00018188532045407775,
    0.00018197904387315042,
    0.00018206778337977365,
    0.00018215154512502772,
    0.00018223033537484654,
    0.0001823041605096872,
    0.00018237302702419958,
    0.00018243694152689146,
    0.00018249591073979426,
    0.0001825499414981237,
    0.0001825990407499399,
    0.0001826432155558045,
    0.0001826824730884365,
    0.00018271682063236423,
    0.00018274626558357788,
    0.00018277081544917613,
    0.00018279047784701383,
    0.00018280526050534654,
    0.00018281517126247143,
    0.00018282021806636899,
    0.0001828204089743399,
    0.00018281575215264073,
    0.00018280625587611832,
    0.000182791928527841,
    0.00018277277859872834,
    0.00018274881468717866,
    0.00018272004549869342,
    0.00018268647984550273,
    0.00018264812664618463,
    0.00018260499492528542,
    0.00018255709381293712,
    0.0001825044325444718,
    0.0001824470204600361,
    0.00018238486700420195,
    0.0001823179817255756,
    0.0001822463742764062,
    0.00018217005441218976,
    0.00018208903199127418,
    0.00018200331697446024,
    0.0001819129194246004,
    0.00018181784950619878,
    0.00018171811748500513,
    0.00018161373372760977,
    0.00018150470870103574,
    0.00018139105297232923,
    0.0001812727772081479,
    0.00018114989217434793,
    0.00018102240873556853,
    0.00018089033785481505,
    0.00018075369059304086,
    0.00018061247810872616,
    0.00018046671165745603,
    0.0001803164025914969,
    0.00018016156235936984,
    0.0001800022025054244,
    0.00017983833466940773,
    0.00017966997058603605,
    0.00017949712208455935,
    0.00017931980108832943,
    0.0001791380196143628,
    0.00017895178977290382,
    0.00017876112376698458,
    0.00017856603389198474,
    0.00017836653253518905,
    0.00017816263217534361,
    0.0001779543453822087,
    0.000177741684816114,
    0.00017752466322750726,
    0.00017730329345650597,
    0.00017707758843244403,
    0.00017684756117341971,
    0.00017661322478583914,
    0.00017637459246396098,
    0.00017613167748943873,
    0.00017588449323085984,
    0.00017563305314328634,
    0.00017537737076779182,
    0.00017511745973099787,
    0.00017485333374460833,
    0.00017458500660494396,
    0.00017431249219247288,
    0.00017403580447134182,
    0.00017375495748890596,
    0.00017346996537525604,
    0.0001731808423427446,
    0.00017288760268551213,
    0.00017259026077900971,
    0.0001722888310795226,
    0.0001719833281236915,
    0.00017167376652803084,
    0.0001713601609884498,
    0.00017104252627976794,
    0.00017072087725523183,
    0.0001703952288460306,
    0.00017006559606080898,
    0.00016973199398517995,
    0.00016939443778123573,
    0.00016905294268705878,
    0.00016870752401623024,
    0.00016835819715733662,
    0.00016800497757347922,
    0.00016764788080177656,
    0.00016728692245287079,
    0.0001669221182104304,
    0.00016655348383065233,
    0.00016618103514176282,
    0.0001658047880435186,
    0.00016542475850670485,
    0.0001650409625726333,
    0.00016465341635263985,
    0.0001642621360275796,
    0.00016386713784732288,
    0.0001634684381302483,
    0.00016306605326273617,
    0.0001626599996986605,
    0.00016225029395888017,
    0.0001618369526307289,
    0.00016141999236750476,
    0.00016099942988795875,
    0.0001605752819757814,
    0.00016014756547908952,
    0.00015971629730991393,
    0.00015928149444368084,
    0.00015884317391869892,
    0.00015840135283564104,
    0.00015795604835702683,
    0.00015750727770670475,
    0.00015705505816933257,
    0.00015659940708985737,
    0.0001561403418729949,
    0.00015567787998270853,
    0.00015521203894168663,
    0.00015474283633081954,
    0.00015427028978867678,
    0.000153794417010982,
    0.0001533152357500884,
    0.00015283276381445284,
    0.00015234701906810996,
    0.00015185801943014496,
    0.0001513657828741664,
    0.00015087032742777792,
    0.00015037167117204915,
    0.00014986983224098737,
    0.00014936482882100657,
    0.00014885667915039743,
    0.00014834540151879716,
    0.0001478310142666568,
    0.0001473135357847095,
    0.0001467929845134388,
    0.0001462693789425445,
    0.00014574273761041047,
    0.00014521307910357007,
    0.00014468042205617078,
    0.0001441447851494411,
    0.00014360618711115543,
    0.00014306464671509604,
    0.00014252018278051954,
    0.0001419728141716204,
    0.00014142255979699152,
    0.0001408694386090905,
    0.00014031346960370066,
    0.00013975467181939278,
    0.000139193064336987,
    0.00013862866627901657,
    0.0001380614968091866,
    0.00013749157513183563,
    0.0001369189204913979,
    0.00013634355217186268,
    0.00013576548949623428,
    0.00013518475182599328,
    0.0001346013585605556,
    0.00013401532913673227,
    0.00013342668302818972,
    0.00013283543974490795,
    0.00013224161883264082,
    0.00013164523987237422,
    0.00013104632247978594,
    0.00013044488630470371,
    0.0001298409510305645,
    0.00012923453637387274,
    0.00012862566208365903,
    0.00012801434794093908,
    0.00012740061375817152,
    0.00012678447937871653,
    0.00012616596467629533,
    0.00012554508955444626,
    0.00012492187394598557,
    0.00012429633781246507,
    0.00012366850114362945,
    0.00012303838395687658,
    0.00012240600629671533,
    0.0001217713882342239,
    0.00012113454986650886,
    0.00012049551131616461,
    0.00011985429273073108,
    0.00011921091428215341,
    0.00011856539616624194,
    0.00011791775860213046,
    0.00011726802183173561,
    0.00011661620611921822,
    0.0001159623317504414,
    0.00011530641903243138,
    0.00011464848829283805,
    0.000113988559879395,
    0.00011332665415938079,
    0.0001126627915190796,
    0.00011199699236324296,
    0.00011132927711455058,
    0.00011065966621307325,
    0.00010998818011573422,
    0.00010931483929577205,
    0.00010863966424220336,
    0.00010796267545928605,
    0.00010728389346598265,
    0.00010660333879542459,
    0.00010592103199437613,
    0.00010523699362269924,
    0.0001045512442528188,
    0.00010386380446918745,
    0.0001031746948677519,
    0.00010248393605542073,
    0.00010179154864952803,
    0.00010109755327730331,
    0.00010040197057533943,
    9.970482118905894e-05,
    9.900612577218342e-05,
    9.830590498620475e-05,
    9.760417949985305e-05,
    9.690096998856589e-05,
    9.619629713396325e-05,
    9.549018162331506e-05,
    9.478264414901453e-05,
    9.407370540805241e-05,
    9.33633861014877e-05,
    9.265170693392362e-05,
    9.193868861298074e-05,
    9.122435184877302e-05,
    9.050871735338303e-05,
    8.979180584033903e-05,
    8.907363802409146e-05,
    8.835423461949164e-05,
    8.763361634126906e-05,
    8.691180390351202e-05,
    8.618881801914669e-05,
    8.546467939941813e-05,
    8.473940875337177e-05,
    8.401302678733579e-05,
    8.328555420440338e-05,
    8.25570117039178e-05,
    8.18274199809556e-05,
    8.109679972581363e-05,
    8.036517162349285e-05,
    7.963255635318755e-05,
    7.889897458777298e-05,
    7.81644469932925e-05,
    7.742899422844834e-05,
    7.669263694409303e-05,
    7.595539578271891e-05,
    7.521729137795023e-05,
    7.447834435403895e-05,
    7.373857532535652e-05,
    7.299800489588834e-05,
    7.22566536587326e-05,
    7.151454219559469e-05,
    7.077169107628507e-05,
    7.002812085822045e-05,
    6.928385208592113e-05,
    6.853890529051326e-05,
    6.779330098922978e-05,
    6.704705968491438e-05,
    6.630020186552443e-05,
    6.555274800363664e-05,
    6.480471855595252e-05,
    6.4056133962806e-05,
    6.330701464767115e-05,
    6.255738101667153e-05,
    6.180725345809074e-05,
    6.105665234188368e-05,
    6.0305598019189154e-05,
    5.955411082184357e-05,
    5.8802211061895694e-05,
    5.8049919031122864e-05,
    5.729725500054773e-05,
    5.6544239219957746e-05,
    5.57908919174225e-05,
    5.503723329881622e-05,
    5.4283283547340096e-05,
    5.352906282304272e-05,
    5.277459126234721e-05,
    5.2019888977576e-05,
    5.1264976056477e-05,
    5.050987256175113e-05,
    4.975459853058435e-05,
    4.899917397417552e-05,
    4.824361887726853e-05,
    4.7487953197687944e-05,
    4.673219686587069e-05,
    4.597636978440243e-05,
    4.522049182755658e-05,
    4.446458284083054e-05,
    4.370866264048641e-05,
    4.295275101309225e-05,
    4.2196867715064325e-05,
    4.1441032472211116e-05,
    4.0685264979278775e-05,
    3.99295848994974e-05,
    3.917401186412938e-05,
    3.8418565472018816e-05,
    3.766326528914242e-05,
    3.69081308481618e-05,
    3.6153181647977256e-05,
    3.539843715328302e-05,
    3.4643916794123806e-05,
    3.388963996545312e-05,
    3.313562602669275e-05,
    3.238189430129363e-05,
    3.1628464076299724e-05,
    3.08753546019095e-05,
    3.0122585091043944e-05,
    2.9370174718913533e-05,
    2.861814262258474e-05,
    2.7866507900552386e-05,
    2.7115289612311154e-05,
    2.6364506777927955e-05,
    2.5614178377616337e-05,
    2.486432335131538e-05,
    2.411496059826531e-05,
    2.3366108976587136e-05,
    2.2617787302866076e-05,
    2.187001435173209e-05,
    2.1122808855444376e-05,
    2.0376189503479474e-05,
    1.963017494211671e-05,
    1.8884783774028437e-05,
    1.814003455787095e-05,
    1.7395945807877023e-05,
    1.6652535993450184e-05,
    1.590982353876066e-05,
    1.5167826822342962e-05,
    1.4426564176695259e-05,
    1.368605388788031e-05,
    1.2946314195128258e-05,
    1.2207363290440933e-05,
    1.1469219318198093e-05,
    1.0731900374765231e-05,
    9.995424508102922e-06,
    9.259809717379415e-06,
    8.525073952581222e-06,
    7.791235114130198e-06,
    7.0583110525001904e-06,
    6.326319567833056e-06,
    5.595278409561185e-06,
    4.865205276029383e-06,
    4.136117814116339e-06,
    3.4080336188624286e-06,
    2.6809702330968046e-06,
    1.9549451470655333e-06,
    1.2299757980623155e-06,
    5.060795700635498e-07,
    -2.1672620663929572e-07,
    -9.384242558032076e-07,
    -1.6589973555930477e-06,
    -2.3784283389438794e-06,
    -3.0967000939176884e-06,
    -3.813795564059704e-06,
    -4.529697748752642e-06,
    -5.244389703569025e-06,
    -5.957854540621635e-06,
    -6.670075428912085e-06,
    -7.3810355946774505e-06,
    -8.090718321735053e-06,
    -8.79910695182525e-06,
    -9.506184884952393e-06,
    -1.0211935579723827e-05,
    -1.091634255368691e-05,
    -1.1619389383664157e-05,
    -1.2321059706086476e-05,
    -1.3021337217324319e-05,
    -1.3720205674017249e-05,
    -1.441764889340004e-05,
    -1.5113650753630454e-05,
    -1.580819519411044e-05,
    -1.6501266215807567e-05,
    -1.719284788157654e-05,
    -1.788292431647457e-05,
    -1.8571479708076714e-05,
    -1.9258498306791562e-05,
    -1.9943964426170464e-05,
    -2.0627862443217178e-05,
    -2.1310176798696266e-05,
    -2.1990891997438787e-05,
    -2.266999260864334e-05,
    -2.3347463266179773e-05,
    -2.40232886688882e-05,
    -2.469745358087444e-05,
    -2.5369942831807385e-05,
    -2.6040741317211032e-05,
    -2.6709833998755816e-05,
    -2.7377205904547656e-05,
    -2.8042842129415135e-05,
    -2.8706727835193956e-05,
    -2.936884825101034e-05,
    -3.0029188673561346e-05,
    -3.068773446739387e-05,
    -3.1344471065180946e-05,
    -3.1999383967996534e-05,
    -3.2652458745587746e-05,
    -3.330368103664526e-05,
    -3.3953036549071405e-05,
    -3.460051106024642e-05,
    -3.524609041729237e-05,
    -3.588976053733511e-05,
    -3.65315074077632e-05,
    -3.717131708648749e-05,
    -3.780917570219483e-05,
    -3.844506945460127e-05,
    -3.907898461470545e-05,
    -3.9710907525035546e-05,
    -4.034082459989642e-05,
    -4.0968722325616216e-05,
    -4.1594587260787175e-05,
    -4.221840603650629e-05,
    -4.284016535661467e-05,
    -4.345985199793382e-05,
    -4.4077452810497565e-05,
    -4.469295471778641e-05,
    -4.53063447169566e-05,
    -4.5917609879066195e-05,
    -4.6526737349302195e-05,
    -4.71337143472031e-05,
    -4.773852816687958e-05,
    -4.834116617723377e-05,
    -4.8941615822175566e-05,
    -4.953986462083731e-05,
    -5.013590016778587e-05,
    -5.072971013323278e-05,
    -5.1321282263242075e-05,
    -5.19106043799359e-05,
    -5.24976643816981e-05,
    -5.308245024337533e-05,
    -5.3664950016476395e-05,
    -5.42451518293685e-05,
    -5.4823043887472636e-05,
    -5.53986144734554e-05,
    -5.5971851947419746e-05,
    -5.6542744747091744e-05,
    -5.711128138800873e-05,
    -5.767745046370037e-05,
    -5.824124064587089e-05,
    -5.880264068457913e-05,
    -5.9361639408414246e-05,
    -5.9918225724670026e-05,
    -6.0472388619519255e-05,
    -6.10241171581821e-05,
    -6.157340048509409e-05,
    -6.212022782407289e-05,
    -6.266458847848209e-05,
    -6.32064718313901e-05,
    -6.374586734573182e-05,
    -6.428276456446443e-05,
    -6.481715311072107e-05,
    -6.534902268796459e-05,
    -6.587836308013674e-05,
    -6.640516415180626e-05,
    -6.692941584831429e-05,
    -6.74511081959179e-05,
    -6.797023130193117e-05,
    -6.848677535486382e-05,
    -6.900073062455791e-05,
    -6.95120874623224e-05,
    -7.002083630106477e-05,
    -7.052696765542154e-05,
    -7.103047212188509e-05,
    -7.153134037892958e-05,
    -7.202956318713407e-05,
    -7.252513138930291e-05,
    -7.301803591058482e-05,
    -7.350826775858912e-05,
    -7.399581802349893e-05,
    -7.448067787818531e-05,
    -7.496283857831447e-05,
    -7.54422914624557e-05,
    -7.591902795218781e-05,
    -7.639303955220067e-05,
    -7.686431785039528e-05,
    -7.733285451798436e-05,
    -7.779864130958632e-05,
    -7.82616700633197e-05,
    -7.872193270089516e-05,
    -7.917942122770512e-05,
    -7.963412773290954e-05,
    -8.008604438952193e-05,
    -8.053516345449209e-05,
    -8.09814772687853e-05,
    -8.142497825746178e-05,
    -8.186565892975176e-05,
    -8.230351187912932e-05,
    -8.273852978338386e-05,
    -8.317070540468943e-05,
    -8.360003158967102e-05,
    -8.402650126946994e-05,
    -8.445010745980612e-05,
    -8.487084326103784e-05,
    -8.528870185822024e-05,
    -8.570367652116084e-05,
    -8.611576060447321e-05,
    -8.652494754762763e-05,
    -8.693123087500134e-05,
    -8.73346041959241e-05,
    -8.773506120472335e-05,
    -8.813259568076699e-05,
    -8.852720148850222e-05,
    -8.891887257749538e-05,
    -8.930760298246586e-05,
    -8.969338682332048e-05,
    -9.007621830518478e-05,
    -9.045609171843205e-05,
    -9.083300143870941e-05,
    -9.120694192696365e-05,
    -9.157790772946326e-05,
    -9.194589347781779e-05,
    -9.231089388899694e-05,
    -9.267290376534657e-05,
    -9.303191799460077e-05,
    -9.338793154989487e-05,
    -9.374093948977446e-05,
    -9.409093695820135e-05,
    -9.443791918455946e-05,
    -9.478188148365755e-05,
    -9.512281925572897e-05,
    -9.546072798643033e-05,
    -9.579560324683809e-05,
    -9.612744069344194e-05,
    -9.645623606813647e-05,
    -9.678198519821143e-05,
    -9.710468399633879e-05,
    -9.742432846055801e-05,
    -9.774091467425926e-05,
    -9.805443880616433e-05,
    -9.836489711030586e-05,
    -9.867228592600319e-05,
    -9.89766016778375e-05,
    -9.927784087562441e-05,
    -9.957600011438375e-05,
    -9.987107607430715e-05,
    -0.00010016306552072567,
    -0.00010045196530407229,
    -0.00010073777235984343,
    -0.00010102048370855995,
    -0.00010130009645572346,
    -0.00010157660779177157,
    -0.0001018500149920325,
    -0.00010212031541667492,
    -0.00010238750651065691,
    -0.00010265158580367396,
    -0.0001029125509101035,
    -0.00010317039952894688,
    -0.00010342512944377069,
    -0.0001036767385226457,
    -0.00010392522471808226,
    -0.00010417058606696589,
    -0.00010441282069048913,
    -0.00010465192679408166,
    -0.00010488790266733889,
    -0.00010512074668394815,
    -0.00010535045730161247,
    -0.00010557703306197293,
    -0.00010580047259052876,
    -0.00010602077459655521,
    -0.00010623793787301928,
    -0.00010645196129649428,
    -0.0001066628438270712,
    -0.00010687058450826881,
    -0.00010707518246694143,
    -0.00010727663691318489,
    -0.00010747494714024053,
    -0.00010767011252439687,
    -0.00010786213252488913,
    -0.00010805100668379792,
    -0.00010823673462594471,
    -0.00010841931605878522,
    -0.0001085987507723025,
    -0.00010877503863889594,
    -0.00010894817961326923,
    -0.00010911817373231745,
    -0.00010928502111500991,
    -0.00010944872196227324,
    -0.00010960927655687056,
    -0.00010976668526328121,
    -0.00010992094852757565,
    -0.00011007206687729024,
    -0.00011022004092130081,
    -0.0001103648713496914,
    -0.0001105065589336242,
    -0.00011064510452520617,
    -0.00011078050905735338,
    -0.0001109127735436542,
    -0.00011104189907823068,
    -0.00011116788683559758,
    -0.0001112907380705192,
    -0.00011141045411786574,
    -0.0001115270363924659,
    -0.00011164048638895973,
    -0.0001117508056816473,
    -0.00011185799592433779,
    -0.00011196205885019498,
    -0.00011206299627158194,
    -0.00011216081007990387,
    -0.00011225550224544805,
    -0.00011234707481722341,
    -0.00011243552992279726,
    -0.00011252086976813122,
    -0.00011260309663741375,
    -0.00011268221289289281,
    -0.00011275822097470522,
    -0.00011283112340070535,
    -0.00011290092276629063,
    -0.00011296762174422763,
    -0.00011303122308447327,
    -0.00011309172961399749,
    -0.00011314914423660168,
    -0.0001132034699327369,
    -0.00011325470975931932,
    -0.00011330286684954491,
    -0.00011334794441270206,
    -0.00011338994573398172,
    -0.0001134288741742871,
    -0.00011346473317004098,
    -0.00011349752623299143,
    -0.00011352725695001538,
    -0.00011355392898292241,
    -0.00011357754606825375,
    -0.00011359811201708232,
    -0.00011361563071481015,
    -0.00011363010612096391,
    -0.00011364154226898912,
    -0.00011364994326604274,
    -0.00011365531329278409,
    -0.00011365765660316413,
    -0.00011365697752421257,
    -0.00011365328045582528,
    -0.0001136465698705476,
    -0.00011363685031335782,
    -0.000113624126401448,
    -0.00011360840282400439,
    -0.00011358968434198548,
    -0.0001135679757878984,
    -0.00011354328206557427,
    -0.00011351560814994138,
    -0.00011348495908679806,
    -0.00011345133999258252,
    -0.00011341475605414187,
    -0.0001133752125285004,
    -0.00011333271474262433,
    -0.00011328726809318765,
    -0.00011323887804633428,
    -0.00011318755013744013,
    -0.00011313328997087265,
    -0.0001130761032197502,
    -0.00011301599562569888,
    -0.00011295297299860824,
    -0.0001128870412163857,
    -0.00011281820622470909,
    -0.00011274647403677923,
    -0.00011267185073306843,
    -0.00011259434246107069,
    -0.00011251395543504751,
    -0.00011243069593577543,
    -0.00011234457031028892,
    -0.00011225558497162458,
    -0.00011216374639856258,
    -0.00011206906113536739,
    -0.0001119715357915262,
    -0.00011187117704148763,
    -0.00011176799162439717,
    -0.00011166198634383313,
    -0.00011155316806754006,
    -0.00011144154372716104,
    -0.00011132712031796954,
    -0.0001112099048985988,
    -0.00011108990459077077,
    -0.0001109671265790233,
    -0.00011084157811043652,
    -0.00011071326649435727,
    -0.00011058219910212344,
    -0.00011044838336678577,
    -0.00011031182678282949,
    -0.00011017253690589385,
    -0.00011003052135249128,
    -0.00010988578779972446,
    -0.00010973834398500359,
    -0.00010958819770576065,
    -0.00010943535681916387,
    -0.00010927982924183074,
    -0.00010912162294953924,
    -0.00010896074597693894,
    -0.00010879720641726033,
    -0.00010863101242202269,
    -0.00010846217220074194,
    -0.00010829069402063601,
    -0.00010811658620633058,
    -0.00010793985713956249,
    -0.00010776051525888254,
    -0.00010757856905935746,
    -0.00010739402709227072,
    -0.00010720689796482139,
    -0.00010701719033982373,
    -0.00010682491293540402,
    -0.00010663007452469729,
    -0.00010643268393554305,
    -0.00010623275005017927,
    -0.00010603028180493621,
    -0.0001058252881899292,
    -0.00010561777824874926,
    -0.00010540776107815447,
    -0.0001051952458277594,
    -0.00010498024169972344,
    -0.00010476275794843828,
    -0.00010454280388021581,
    -0.00010432038885297267,
    -0.00010409552227591536,
    -0.00010386821360922512,
    -0.00010363847236373996,
    -0.0001034063081006374,
    -0.00010317173043111558,
    -0.00010293474901607411,
    -0.00010269537356579319,
    -0.00010245361383961239,
    -0.00010220947964560912,
    -0.00010196298084027481,
    -0.00010171412732819184,
    -0.00010146292906170903,
    -0.00010120939604061533,
    -0.0001009535383118147,
    -0.0001006953659689988,
    -0.00010043488915231882,
    -0.00010017211804805786,
    -9.990706288830065e-05,
    -9.96397339506042e-05,
    -9.937014155766727e-05,
    -9.909829607699809e-05,
    -9.882420792058243e-05,
    -9.854788754455143e-05,
    -9.826934544884698e-05,
    -9.798859217688775e-05,
    -9.770563831523494e-05,
    -9.742049449325517e-05,
    -9.713317138278521e-05,
    -9.684367969779527e-05,
    -9.655203019405035e-05,
    -9.625823366877245e-05,
    -9.596230096030228e-05,
    -9.566424294775867e-05,
    -9.53640705506994e-05,
    -9.506179472878003e-05,
    -9.475742648141285e-05,
    -9.445097684742468e-05,
    -9.414245690471494e-05,
    -9.383187776991206e-05,
    -9.351925059803074e-05,
    -9.320458658212705e-05,
    -9.288789695295427e-05,
    -9.256919297861794e-05,
    -9.224848596422966e-05,
    -9.192578725156146e-05,
    -9.160110821869901e-05,
    -9.127446027969456e-05,
    -9.094585488421907e-05,
    -9.061530351721456e-05,
    -9.028281769854557e-05,
    -8.994840898264992e-05,
    -8.961208895818967e-05,
    -8.927386924770151e-05,
    -8.893376150724546e-05,
    -8.859177742605564e-05,
    -8.824792872618876e-05,
    -8.790222716217218e-05,
    -8.755468452065272e-05,
    -8.720531262004486e-05,
    -8.685412331017715e-05,
    -8.650112847194027e-05,
    -8.614634001693371e-05,
    -8.578976988711221e-05,
    -8.543143005443114e-05,
    -8.507133252049418e-05,
    -8.470948931619709e-05,
    -8.434591250137354e-05,
    -8.398061416444099e-05,
    -8.361360642204421e-05,
    -8.324490141870012e-05,
    -8.287451132644246e-05,
    -8.250244834446511e-05,
    -8.212872469876618e-05,
    -8.175335264179168e-05,
    -8.137634445207818e-05,
    -8.099771243389668e-05,
    -8.0617468916895e-05,
    -8.023562625574078e-05,
    -7.985219682976364e-05,
    -7.946719304259812e-05,
    -7.908062732182537e-05,
    -7.869251211861542e-05,
    -7.830285990736916e-05,
    -7.791168318536023e-05,
    -7.751899447237623e-05,
    -7.712480631036138e-05,
    -7.67291312630561e-05,
    -7.633198191564051e-05,
    -7.593337087437454e-05,
    -7.5533310766239e-05,
    -7.51318142385776e-05,
    -7.472889395873742e-05,
    -7.432456261371034e-05,
    -7.391883290977321e-05,
    -7.35117175721305e-05,
    -7.310322934455384e-05,
    -7.269338098902325e-05,
    -7.228218528536902e-05,
    -7.186965503091186e-05,
    -7.145580304010353e-05,
    -7.104064214416953e-05,
    -7.06241851907485e-05,
    -7.020644504353434e-05,
    -6.978743458191696e-05,
    -6.936716670062387e-05,
    -6.894565430936125e-05,
    -6.852291033245554e-05,
    -6.809894770849501e-05,
    -6.767377938997128e-05,
    -6.724741834292104e-05,
    -6.681987754656822e-05,
    -6.639116999296555e-05,
    -6.596130868663699e-05,
    -6.553030664422017e-05,
    -6.509817689410834e-05,
    -6.466493247609341e-05,
    -6.423058644100874e-05,
    -6.379515185037182e-05,
    -6.335864177602825e-05,
    -6.292106929979355e-05,
    -6.248244751309847e-05,
    -6.204278951663229e-05,
    -6.16021084199858e-05,
    -6.116041734129725e-05,
    -6.0717729406896016e-05,
    -6.027405775094746e-05,
    -5.9829415515097636e-05,
    -5.9383815848119826e-05,
    -5.8937271905559166e-05,
    -5.84897968493781e-05,
    -5.8041403847604536e-05,
    -5.759210607397661e-05,
    -5.7141916707589646e-05,
    -5.669084893254477e-05,
    -5.623891593759499e-05,
    -5.578613091579356e-05,
    -5.533250706414244e-05,
    -5.4878057583240475e-05,
    -5.442279567693283e-05,
    -5.396673455196004e-05,
    -5.3509887417607564e-05,
    -5.3052267485356435e-05,
    -5.259388796853349e-05,
    -5.2134762081962334e-05,
    -5.167490304161473e-05,
    -5.1214324064262656e-05,
    -5.075303836713004e-05,
    -5.0291059167546246e-05,
    -4.982839968259849e-05,
    -4.9365073128785836e-05,
    -4.8901092721673206e-05,
    -4.843647167554655e-05,
    -4.797122320306664e-05,
    -4.7505360514925706e-05,
    -4.703889681950391e-05,
    -4.6571845322524224e-05,
    -4.610421922671135e-05,
    -4.563603173144869e-05,
    -4.516729603243652e-05,
    -4.469802532135025e-05,
    -4.4228232785501274e-05,
    -4.3757931607495426e-05,
    -4.3287134964893334e-05,
    -4.2815856029873094e-05,
    -4.234410796889039e-05,
    -4.187190394234055e-05,
    -4.139925710422323e-05,
    -4.092618060180387e-05,
    -4.045268757527879e-05,
    -3.997879115743962e-05,
    -3.9504504473338835e-05,
    -3.90298406399556e-05,
    -3.855481276586236e-05,
    -3.807943395089239e-05,
    -3.760371728580751e-05,
    -3.712767585196692e-05,
    -3.665132272099655e-05,
    -3.617467095445902e-05,
    -3.5697733603524384e-05,
    -3.52205237086416e-05,
    -3.4743054299210794e-05,
    -3.426533839325597e-05,
    -3.378738899709878e-05,
    -3.3309219105032677e-05,
    -3.283084169899878e-05,
    -3.235226974826019e-05,
    -3.1873516209080104e-05,
    -3.139459402439914e-05,
    -3.091551612351201e-05,
    -3.0436295421748033e-05,
    -2.9956944820150715e-05,
    -2.9477477205157628e-05,
    -2.8997905448281548e-05,
    -2.85182424057941e-05,
    -2.8038500918407422e-05,
    -2.7558693810957785e-05,
    -2.7078833892091772e-05,
    -2.659893395395044e-05,
    -2.6119006771855468e-05,
    -2.563906510399797e-05,
    -2.515912169112478e-05,
    -2.467918925622841e-05,
    -2.41992805042365e-05,
    -2.3719408121702663e-05,
    -2.323958477649794e-05,
    -2.275982311750344e-05,
    -2.2280135774303615e-05,
    -2.180053535688061e-05,
    -2.1321034455309484e-05,
    -2.0841645639454385e-05,
    -2.0362381458665584e-05,
    -1.9883254441477574e-05,
    -1.9404277095307954e-05,
    -1.8925461906157413e-05,
    -1.844682133831059e-05,
    -1.796836783403798e-05,
    -1.7490113813298453e-05,
    -1.701207167344402e-05,
    -1.6534253788922933e-05,
    -1.6056672510986888e-05,
    -1.557934016739788e-05,
    -1.510226906213447e-05,
    -1.462547147510206e-05,
    -1.4148959661842498e-05,
    -1.3672745853244382e-05,
    -1.319684225525462e-05,
    -1.2721261048592894e-05,
    -1.2246014388464083e-05,
    -1.1771114404273306e-05,
    -1.1296573199343386e-05,
    -1.0822402850630552e-05,
    -1.034861540844255e-05,
    -9.875222896159423e-06,
    -9.40223730995214e-06,
    -8.929670618504906e-06,
    -8.457534762737441e-06,
    -7.985841655528594e-06,
    -7.5146031814410615e-06,
    -7.0438311964472e-06,
    -6.573537527655937e-06,
    -6.1037339730408244e-06,
    -5.63443230116921e-06,
    -5.165644250932548e-06,
    -4.697381531277808e-06,
    -4.2296558209401225e-06,
    -3.7624787681764357e-06,
    -3.2958619905002776e-06,
    -2.8298170744186074e-06,
    -2.364355575167392e-06,
    -1.8994890164514397e-06,
    -1.4352288901839567e-06,
    -9.715866562258266e-07,
    -5.085737421289728e-07,
    -4.6201542879469186e-08,
    4.155185793595992e-07,
    8.765752955011871e-07,
    1.336957309787738e-06,
    1.7966533600439025e-06,
    2.2556522179275486e-06,
    2.7139426891779757e-06,
    3.1715136138657504e-06,
    3.6283538666398906e-06,
    4.084452356972534e-06,
    4.539798029404442e-06,
    4.99437986378924e-06,
    5.448186875534352e-06,
    5.9012081158419646e-06,
    6.35343267195012e-06,
    6.804849667369742e-06,
    7.255448262121747e-06,
    7.705217652974414e-06,
    8.154147073676475e-06,
    8.60222579519052e-06,
    9.049443125926395e-06,
    9.49578841197053e-06,
    9.941251037315383e-06,
    1.0385820424088988e-05,
    1.0829486032780399e-05,
    1.127223736246518e-05,
    1.1714063951031216e-05,
    1.2154955375399383e-05,
    1.2594901251746713e-05,
    1.303389123572661e-05,
    1.3471915022686376e-05,
    1.3908962347886175e-05,
    1.4345022986715317e-05,
    1.478008675490568e-05,
    1.5214143508746777e-05,
    1.5647183145297794e-05,
    1.607919560259719e-05,
    1.6510170859873524e-05,
    1.694009893775357e-05,
    1.7368969898467696e-05,
    1.7796773846056645e-05,
    1.8223500926575557e-05,
    1.8649141328295445e-05,
    1.907368528190506e-05,
    1.949712306071174e-05,
    1.9919444980838513e-05,
    2.0340641401421384e-05,
    2.0760702724806108e-05,
    2.1179619396741533e-05,
    2.1597381906572213e-05,
    2.201398078743138e-05,
    2.242940661642963e-05,
    2.2843650014843805e-05,
    2.3256701648305353e-05,
    2.366855222698501e-05,
    2.407919250577724e-05,
    2.4488613284484523e-05,
    2.4896805407997677e-05,
    2.5303759766475934e-05,
    2.570946729552725e-05,
    2.6113918976383562e-05,
    2.6517105836077963e-05,
    2.6919018947619326e-05,
    2.7319649430163794e-05,
    2.7718988449187766e-05,
    2.811702721665785e-05,
    2.8513756991198373e-05,
    2.8909169078259664e-05,
    2.930325483028387e-05,
    2.9696005646868076e-05,
    3.0087412974928202e-05,
    3.047746830886034e-05,
    3.086616319069956e-05,
    3.125348921027941e-05,
    3.1639438005388944e-05,
    3.202400126192707e-05,
    3.2407170714057165e-05,
    3.2788938144360426e-05,
    3.3169295383985704e-05,
    3.354823431279908e-05,
    3.3925746859533214e-05,
    3.430182500193274e-05,
    3.4676460766899175e-05,
    3.504964623063608e-05,
    3.542137351878962e-05,
    3.5791634806589575e-05,
    3.616042231898929e-05,
    3.652772833080244e-05,
    3.689354516683903e-05,
    3.7257865202041236e-05,
    3.762068086161541e-05,
    3.798198462116368e-05,
    3.834176900681549e-05,
    3.870002659535426e-05,
    3.905675001434596e-05,
    3.9411931942264597e-05,
    3.9765565108615396e-05,
    4.011764229405811e-05,
    4.046815633052871e-05,
    4.081710010135721e-05,
    4.1164466541387474e-05,
    4.1510248637093086e-05,
    4.185443942669183e-05,
    4.219703200025997e-05,
    4.25380194998444e-05,
    4.2877395119572006e-05,
    4.3215152105759546e-05,
    4.355128375702125e-05,
    4.3885783424373684e-05,
    4.421864451134076e-05,
    4.454986047405719e-05,
    4.487942482136877e-05,
    4.5207331114932235e-05,
    4.553357296931469e-05,
    4.585814405208914e-05,
    4.618103808392982e-05,
    4.6502248838707e-05,
    4.6821770143577727e-05,
    4.713959587907706e-05,
    4.7455719979207626e-05,
    4.777013643152649e-05,
    4.8082839277231166e-05,
    4.839382261124513e-05,
    4.870308058229954e-05,
    4.90106073930152e-05,
    4.931639729998301e-05,
    4.96204446138412e-05,
    4.9922743699353166e-05,
    5.022328897548276e-05,
    5.052207491546711e-05,
    5.081909604688987e-05,
    5.111434695175193e-05,
    5.14078222665396e-05,
    5.169951668229332e-05,
    5.1989424944673674e-05,
    5.227754185402526e-05,
    5.256386226544036e-05,
    5.284838108882089e-05,
    5.313109328893694e-05,
    5.3411993885486715e-05,
    5.369107795315319e-05,
    5.39683406216588e-05,
    5.424377707581967e-05,
    5.4517382555598704e-05,
    5.478915235615566e-05,
    5.5059081827896065e-05,
    5.53271663765204e-05,
    5.55934014630689e-05,
    5.5857782603966966e-05,
    5.612030537106853e-05,
    5.638096539169751e-05,
    5.663975834868744e-05,
    5.689667998042129e-05,
    5.715172608086779e-05,
    5.740489249961659e-05,
    5.7656175141913625e-05,
    5.7905569968692844e-05,
    5.815307299660677e-05,
    5.839868029805763e-05,
    5.864238800122343e-05,
    5.888419229008593e-05,
    5.91240894044553e-05,
    5.936207563999295e-05,
    5.9598147348234045e-05,
    5.983230093660849e-05,
    6.006453286845855e-05,
    6.0294839663057314e-05,
    6.052321789562485e-05,
    6.07496641973415e-05,
    6.0974175255361915e-05,
    6.119674781282633e-05,
    6.14173786688697e-05,
    6.163606467863126e-05,
    6.185280275326104e-05,
    6.206758985992505e-05,
    6.228042302180947e-05,
    6.249129931812348e-05,
    6.270021588409988e-05,
    6.290716991099459e-05,
    6.311215864608495e-05,
    6.331517939266613e-05,
    6.351622951004609e-05,
    6.371530641353975e-05,
    6.391240757446029e-05,
    6.410753052011014e-05,
    6.430067283377076e-05,
    6.449183215468953e-05,
    6.468100617806614e-05,
    6.486819265503798e-05,
    6.505338939266282e-05,
    6.523659425390087e-05,
    6.541780515759556e-05,
    6.559702007845179e-05,
    6.577423704701388e-05,
    6.594945414964208e-05,
    6.612266952848605e-05,
    6.629388138145881e-05,
    6.646308796220874e-05,
    6.66302875800889e-05,
    6.679547860012656e-05,
    6.695865944299095e-05,
    6.711982858495804e-05,
    6.727898455787623e-05,
    6.743612594912919e-05,
    6.759125140159717e-05,
    6.77443596136176e-05,
    6.789544933894432e-05,
    6.804451938670418e-05,
    6.81915686213536e-05,
    6.83365959626337e-05,
    6.847960038552238e-05,
    6.862058092018704e-05,
    6.875953665193475e-05,
    6.889646672116135e-05,
    6.903137032329873e-05,
    6.916424670876165e-05,
    6.929509518289219e-05,
    6.942391510590348e-05,
    6.955070589282165e-05,
    6.96754670134265e-05,
    6.979819799219116e-05,
    6.991889840821968e-05,
    7.003756789518397e-05,
    7.015420614125877e-05,
    7.026881288905598e-05,
    7.038138793555663e-05,
    7.04919311320424e-05,
    7.060044238402565e-05,
    7.070692165117736e-05,
    7.081136894725473e-05,
    7.091378434002703e-05,
    7.101416795119964e-05,
    7.111251995633751e-05,
    7.120884058478716e-05,
    7.130313011959674e-05,
    7.139538889743554e-05,
    7.148561730851168e-05,
    7.157381579648873e-05,
    7.16599848584008e-05,
    7.174412504456705e-05,
    7.18262369585036e-05,
    7.190632125683507e-05,
    7.198437864920515e-05,
    7.206040989818471e-05,
    7.213441581917939e-05,
    7.220639728033642e-05,
    7.227635520244866e-05,
    7.234429055885891e-05,
    7.241020437536205e-05,
    7.247409773010622e-05,
    7.253597175349245e-05,
    7.259582762807376e-05,
    7.265366658845218e-05,
    7.2709489921175e-05,
    7.27632989646294e-05,
    7.281509510893651e-05,
    7.286487979584357e-05,
    7.291265451861502e-05,
    7.295842082192273e-05,
    7.300218030173458e-05,
    7.304393460520198e-05,
    7.308368543054628e-05,
    7.312143452694353e-05,
    7.315718369440923e-05,
    7.31909347836801e-05,
    7.322268969609585e-05,
    7.325245038348021e-05,
    7.328021884801911e-05,
    7.330599714213915e-05,
    7.332978736838471e-05,
    7.335159167929266e-05,
    7.337141227726788e-05,
    7.33892514144559e-05,
    7.340511139261533e-05,
    7.341899456298875e-05,
    7.343090332617282e-05,
    7.344084013198673e-05,
    7.344880747933994e-05,
    7.34548079160987e-05,
    7.345884403895124e-05,
    7.346091849327221e-05,
    7.34610339729857e-05,
    7.34591932204272e-05,
    7.345539902620462e-05,
    7.344965422905795e-05,
    7.34419617157183e-05,
    7.34323244207649e-05,
    7.342074532648244e-05,
    7.340722746271596e-05,
    7.33917739067255e-05,
    7.337438778303942e-05,
    7.335507226330652e-05,
    7.33338305661474e-05,
    7.331066595700473e-05,
    7.328558174799196e-05,
    7.325858129774187e-05,
    7.322966801125352e-05,
    7.319884533973774e-05,
    7.316611678046305e-05,
    7.31314858765988e-05,
    7.309495621705855e-05,
    7.305653143634189e-05,
    7.30162152143754e-05,
    7.29740112763529e-05,
    7.29299233925739e-05,
    7.28839553782818e-05,
    7.283611109350106e-05,
    7.278639444287308e-05,
    7.27348093754912e-05,
    7.268135988473486e-05,
    7.262605000810278e-05,
    7.256888382704516e-05,
    7.250986546679463e-05,
    7.2448999096197e-05,
    7.23862889275406e-05,
    7.232173921638387e-05,
    7.225535426138428e-05,
    7.218713840412359e-05,
    7.211709602893471e-05,
    7.204523156272534e-05,
    7.197154947480274e-05,
    7.189605427669629e-05,
    7.181875052197982e-05,
    7.173964280609252e-05,
    7.165873576615945e-05,
    7.157603408081137e-05,
    7.149154247000269e-05,
    7.140526569482961e-05,
    7.131720855734695e-05,
    7.122737590038431e-05,
    7.113577260736101e-05,
    7.104240360210084e-05,
    7.094727384864521e-05,
    7.085038835106623e-05,
    7.075175215327846e-05,
    7.065137033884993e-05,
    7.054924803081253e-05,
    7.044539039147168e-05,
    7.033980262221478e-05,
    7.023248996331905e-05,
    7.012345769375926e-05,
    7.001271113101347e-05,
    6.99002556308686e-05,
    6.978609658722605e-05,
    6.967023943190498e-05,
    6.955268963444584e-05,
    6.943345270191354e-05,
    6.93125341786983e-05,
    6.918993964631759e-05,
    6.906567472321657e-05,
    6.893974506456676e-05,
    6.881215636206649e-05,
    6.868291434373818e-05,
    6.8552024773726e-05,
    6.841949345209326e-05,
    6.828532621461801e-05,
    6.814952893258899e-05,
    6.801210751260033e-05,
    6.787306789634575e-05,
    6.773241606041188e-05,
    6.759015801607151e-05,
    6.744629980907568e-05,
    6.730084751944477e-05,
    6.715380726126045e-05,
    6.700518518245495e-05,
    6.685498746460118e-05,
    6.670322032270233e-05,
    6.654989000497937e-05,
    6.63950027926594e-05,
    6.62385649997633e-05,
    6.608058297289163e-05,
    6.592106309101132e-05,
    6.576001176524067e-05,
    6.559743543863521e-05,
    6.543334058597089e-05,
    6.526773371352864e-05,
    6.510062135887785e-05,
    6.493201009065834e-05,
    6.476190650836311e-05,
    6.459031724212006e-05,
    6.441724895247264e-05,
    6.424270833016079e-05,
    6.40667020959012e-05,
    6.388923700016667e-05,
    6.371031982296517e-05,
    6.352995737361881e-05,
    6.334815649054116e-05,
    6.316492404101609e-05,
    6.298026692097394e-05,
    6.279419205476855e-05,
    6.260670639495379e-05,
    6.241781692205897e-05,
    6.222753064436411e-05,
    6.203585459767545e-05,
    6.184279584509944e-05,
    6.164836147681653e-05,
    6.145255860985575e-05,
    6.125539438786695e-05,
    6.105687598089392e-05,
    6.085701058514725e-05,
    6.06558054227759e-05,
    6.04532677416384e-05,
    6.02494048150751e-05,
    6.004422394167876e-05,
    5.983773244506415e-05,
    5.962993767363929e-05,
    5.94208470003751e-05,
    5.92104678225741e-05,
    5.8998807561640186e-05,
    5.87858736628475e-05,
    5.8571673595108184e-05,
    5.835621485074118e-05,
    5.813950494523984e-05,
    5.792155141703918e-05,
    5.7702361827283295e-05,
    5.748194375959253e-05,
    5.726030481982945e-05,
    5.703745263586568e-05,
    5.681339485734803e-05,
    5.658813915546364e-05,
    5.63616932227066e-05,
    5.613406477264217e-05,
    5.590526153967216e-05,
    5.567529127880025e-05,
    5.544416176539578e-05,
    5.5211880794958443e-05,
    5.4978456182882425e-05,
    5.474389576422031e-05,
    5.450820739344632e-05,
    5.427139894422066e-05,
    5.4033478309152027e-05,
    5.3794453399560836e-05,
    5.355433214524265e-05,
    5.331312249423043e-05,
    5.307083241255695e-05,
    5.282746988401783e-05,
    5.258304290993362e-05,
    5.233755950891115e-05,
    5.209102771660639e-05,
    5.1843455585486306e-05,
    5.159485118458958e-05,
    5.1345222599289184e-05,
    5.109457793105373e-05,
    5.084292529720797e-05,
    5.059027283069497e-05,
    5.033662867983719e-05,
    5.0082001008096756e-05,
    4.982639799383709e-05,
    4.9569827830084206e-05,
    4.9312298724286245e-05,
    4.905381889807537e-05,
    4.879439658702837e-05,
    4.853404004042639e-05,
    4.8272757521016815e-05,
    4.801055730477302e-05,
    4.7747447680654777e-05,
    4.74834369503696e-05,
    4.721853342813257e-05,
    4.695274544042667e-05,
    4.668608132576415e-05,
    4.641854943444612e-05,
    4.615015812832316e-05,
    4.588091578055636e-05,
    4.561083077537747e-05,
    4.5339911507848944e-05,
    4.506816638362577e-05,
    4.479560381871492e-05,
    4.452223223923622e-05,
    4.4248060081183607e-05,
    4.3973095790185816e-05,
    4.369734782126618e-05,
    4.3420824638604826e-05,
    4.3143534715299304e-05,
    4.286548653312496e-05,
    4.258668858229685e-05,
    4.2307149361231005e-05,
    4.202687737630506e-05,
    4.174588114162038e-05,
    4.1464169178763705e-05,
    4.118175001656803e-05,
    4.0898632190875266e-05,
    4.061482424429812e-05,
    4.033033472598142e-05,
    4.00451721913651e-05,
    3.975934520194679e-05,
    3.9472862325043204e-05,
    3.918573213355435e-05,
    3.889796320572522e-05,
    3.860956412490917e-05,
    3.8320543479331816e-05,
    3.8030909861853544e-05,
    3.7740671869733454e-05,
    3.7449838104393564e-05,
    3.715841717118248e-05,
    3.686641767913926e-05,
    3.6573848240758995e-05,
    3.628071747175645e-05,
    3.598703399083112e-05,
    3.5692806419433105e-05,
    3.539804338152792e-05,
    3.510275350336179e-05,
    3.480694541322856e-05,
    3.451062774123533e-05,
    3.421380911906836e-05,
    3.391649817976067e-05,
    3.361870355745885e-05,
    3.332043388718949e-05,
    3.3021697804627775e-05,
    3.27225039458652e-05,
    3.242286094717688e-05,
    3.212277744479082e-05,
    3.182226207465692e-05,
    3.1521323472214846e-05,
    3.12199702721647e-05,
    3.091821110823652e-05,
    3.0616054612959574e-05,
    3.031350941743372e-05,
    3.0010584151100124e-05,
    2.9707287441511394e-05,
    2.9403627914104595e-05,
    2.9099614191971933e-05,
    2.8795254895633146e-05,
    2.8490558642808912e-05,
    2.818553404819296e-05,
    2.7880189723225487e-05,
    2.757453427586785e-05,
    2.7268576310375657e-05,
    2.696232442707366e-05,
    2.665578722213136e-05,
    2.6348973287337636e-05,
    2.6041891209876483e-05,
    2.5734549572104372e-05,
    2.5426956951325734e-05,
    2.5119121919570307e-05,
    2.4811053043371355e-05,
    2.4502758883543344e-05,
    2.4194247994959643e-05,
    2.3885528926332555e-05,
    2.3576610219992496e-05,
    2.3267500411666964e-05,
    2.295820803026188e-05,
    2.2648741597642278e-05,
    2.2339109628412767e-05,
    2.2029320629700252e-05,
    2.1719383100936076e-05,
    2.1409305533638108e-05,
    2.1099096411194694e-05,
    2.0788764208648733e-05,
    2.0478317392480797e-05,
    2.0167764420395122e-05,
    1.9857113741104846e-05,
    1.9546373794116904e-05,
    1.9235553009519926e-05,
    1.892465980777018e-05,
    1.861370259947907e-05,
    1.830268978520213e-05,
    1.799162975522684e-05,
    1.76805308893616e-05,
    1.7369401556726678e-05,
    1.7058250115543384e-05,
    1.6747084912925165e-05,
    1.6435914284669906e-05,
    1.6124746555051096e-05,
    1.5813590036610532e-05,
    1.55024530299524e-05,
    1.5191343823536683e-05,
    1.4880270693472638e-05,
    1.4569241903315757e-05,
    1.4258265703862378e-05,
    1.3947350332945576e-05,
    1.3636504015233003e-05,
    1.332573496202436e-05,
    1.301505137104876e-05,
    1.2704461426264413e-05,
    1.2393973297658196e-05,
    1.2083595141044738e-05,
    1.1773335097868235e-05,
    1.1463201295003812e-05,
    1.1153201844558757e-05,
    1.0843344843676127e-05,
    1.0533638374338275e-05,
    1.0224090503169933e-05,
    9.914709281244003e-06,
    9.605502743886966e-06,
    9.29647891048402e-06,
    8.9876457842874e-06,
    8.679011352222823e-06,
    8.370583584697808e-06,
    8.062370435411453e-06,
    7.754379841163235e-06,
    7.4466197216633495e-06,
    7.139097979344722e-06,
    6.831822499173847e-06,
    6.5248011484633695e-06,
    6.2180417766862605e-06,
    5.911552215288819e-06,
    5.605340277505462e-06,
    5.299413758175002e-06,
    4.993780433556424e-06,
    4.688448061144833e-06,
    4.383424379491017e-06,
    4.0787171080189086e-06,
    3.774333946844362e-06,
    3.4702825765960075e-06,
    3.1665706582360155e-06,
    2.8632058328806766e-06,
    2.5601957216236785e-06,
    2.257547925359185e-06,
    1.955270024604771e-06,
    1.6533695793270358e-06,
    1.3518541287670457e-06,
    1.0507311912656561e-06,
    7.500082640914903e-07,
    4.496928232687932e-07,
    1.4979232340504e-07,
    -1.4968580247813742e-07,
    -4.487341431157176e-07,
    -7.473453091681953e-07,
    -1.0455119333887352e-06,
    -1.3432266707913751e-06,
    -1.640482198817455e-06,
    -1.9372712175003044e-06,
    -2.233586449630942e-06,
    -2.52942064092202e-06,
    -2.8247665601699973e-06,
    -3.119616999418313e-06,
    -3.4139647741188114e-06,
    -3.7078027232913625e-06,
    -4.001123709684513e-06,
    -4.293920619934324e-06,
    -4.586186364721541e-06,
    -4.8779138789292545e-06,
    -5.169096121799683e-06,
    -5.459726077088703e-06,
    -5.7497967532204394e-06,
    -6.0393011834417985e-06,
    -6.32823242597433e-06,
    -6.616583564166149e-06,
    -6.904347706643819e-06,
    -7.191517987461577e-06,
    -7.4780875662505985e-06,
    -7.764049628368217e-06,
    -8.049397385044477e-06,
    -8.334124073528709e-06,
    -8.618222957236037e-06,
    -8.901687325891272e-06,
    -9.184510495672734e-06,
    -9.46668580935618e-06,
    -9.748206636455456e-06,
    -1.0029066373364589e-05,
    -1.0309258443497955e-05,
    -1.058877629742872e-05,
    -1.0867613413028045e-05,
    -1.1145763295602516e-05,
    -1.142321947802978e-05,
    -1.1699975520895001e-05,
    -1.1976025012625492e-05,
    -1.2251361569623561e-05,
    -1.2525978836400119e-05,
    -1.2799870485706656e-05,
    -1.3073030218665025e-05,
    -1.3345451764898536e-05,
    -1.3617128882660729e-05,
    -1.3888055358962856e-05,
    -1.4158225009701324e-05,
    -1.4427631679784417e-05,
    -1.4696269243256746e-05,
    -1.4964131603423403e-05,
    -1.523121269297427e-05,
    -1.5497506474105308e-05,
    -1.57630069386401e-05,
    -1.6027708108150984e-05,
    -1.6291604034077707e-05,
    -1.6554688797845784e-05,
    -1.681695651098544e-05,
    -1.7078401315245803e-05,
    -1.733901738271237e-05,
    -1.7598798915921462e-05,
    -1.785774014797223e-05,
    -1.81158353426409e-05,
    -1.8373078794492495e-05,
    -1.8629464828989783e-05,
    -1.8884987802604742e-05,
    -1.9139642102926437e-05,
    -1.939342214876883e-05,
    -1.9646322390277575e-05,
    -1.989833730903566e-05,
    -2.0149461418168217e-05,
    -2.0399689262446105e-05,
    -2.0649015418388925e-05,
    -2.089743449436647e-05,
    -2.1144941130699745e-05,
    -2.1391529999760502e-05,
    -2.1637195806070095e-05,
    -2.1881933286397237e-05,
    -2.2125737209854644e-05,
    -2.236860237799498e-05,
    -2.2610523624905312e-05,
    -2.2851495817301087e-05,
    -2.3091513854618686e-05,
    -2.3330572669107256e-05,
    -2.3568667225919255e-05,
    -2.3805792523200373e-05,
    -2.404194359217786e-05,
    -2.4277115497248597e-05,
    -2.4511303336065443e-05,
    -2.4744502239622967e-05,
    -2.4976707372341992e-05,
    -2.5207913932153336e-05,
    -2.54381171505803e-05,
    -2.5667312292820188e-05,
    -2.5895494657824903e-05,
    -2.6122659578380454e-05,
    -2.6348802421185374e-05,
    -2.657391858692857e-05,
    -2.679800351036465e-05,
    -2.7021052660391267e-05,
    -2.7243061540121794e-05,
    -2.7464025686958982e-05,
    -2.7683940672668417e-05,
    -2.7902802103448797e-05,
    -2.812060562000183e-05,
    -2.8337346897603264e-05,
    -2.855302164616945e-05,
    -2.876762561032472e-05,
    -2.898115456946887e-05,
    -2.919360433784103e-05,
    -2.940497076458356e-05,
    -2.9615249733806904e-05,
    -2.9824437164649872e-05,
    -3.003252901134086e-05,
    -3.023952126325947e-05,
    -3.0445409944993103e-05,
    -3.065019111639665e-05,
    -3.085386087264922e-05,
    -3.1056415344308773e-05,
    -3.1257850697368284e-05,
    -3.145816313330948e-05,
    -3.165734888915435e-05,
    -3.185540423751822e-05,
    -3.205232548666046e-05,
    -3.224810898053281e-05,
    -3.244275109882942e-05,
    -3.2636248257034264e-05,
    -3.2828596906466744e-05,
    -3.301979353432826e-05,
    -3.320983466374687e-05,
    -3.339871685381944e-05,
    -3.35864366996555e-05,
    -3.377299083241808e-05,
    -3.395837591936403e-05,
    -3.414258866388372e-05,
    -3.4325625805538894e-05,
    -3.450748412010051e-05,
    -3.468816041958465e-05,
    -3.48676515522878e-05,
    -3.5045954402821274e-05,
    -3.522306589214412e-05,
    -3.539898297759554e-05,
    -3.5573702652925854e-05,
    -3.574722194832662e-05,
    -3.5919537930459806e-05,
    -3.609064770248582e-05,
    -3.626054840409041e-05,
    -3.642923721151083e-05,
    -3.65967113375608e-05,
    -3.6762968031654325e-05,
    -3.692800457982882e-05,
    -3.7091818304766865e-05,
    -3.7254406565817226e-05,
    -3.74157667590146e-05,
    -3.757589631709861e-05,
    -3.773479270953158e-05,
    -3.7892453442515316e-05,
    -3.8048876059006906e-05,
    -3.820405813873354e-05,
    -3.835799729820643e-05,
    -3.851069119073339e-05,
    -3.866213750643019e-05,
    -3.881233397223238e-05,
    -3.896127835190417e-05,
    -3.9108968446046764e-05,
    -3.925540209210743e-05,
    -3.940057716438513e-05,
    -3.9544491574036054e-05,
    -3.968714326907943e-05,
    -3.982853023440023e-05,
    -3.99686504917518e-05,
    -4.010750209975857e-05,
    -4.02450831539157e-05,
    -4.0381391786588854e-05,
    -4.051642616701379e-05,
    -4.0650184501293155e-05,
    -4.0782665032392996e-05,
    -4.0913866040139883e-05,
    -4.104378584121375e-05,
    -4.117242278914299e-05,
    -4.129977527429694e-05,
    -4.142584172387699e-05,
    -4.155062060190788e-05,
    -4.167411040922783e-05,
    -4.17963096834764e-05,
    -4.19172169990829e-05,
    -4.203683096725359e-05,
    -4.2155150235956595e-05,
    -4.227217348990736e-05,
    -4.2387899450552944e-05,
    -4.250232687605401e-05,
    -4.261545456126749e-05,
    -4.272728133772775e-05,
    -4.283780607362575e-05,
    -4.2947027673789e-05,
    -4.305494507965928e-05,
    -4.3161557269269835e-05,
    -4.3266863257221513e-05,
    -4.337086209465819e-05,
    -4.347355286924086e-05,
    -4.357493470512098e-05,
    -4.3675006762913035e-05,
    -4.3773768239665645e-05,
    -4.387121836883238e-05,
    -4.396735642024101e-05,
    -4.4062181700062344e-05,
    -4.4155693550777674e-05,
    -4.424789135114561e-05,
    -4.433877451616779e-05,
    -4.44283424970539e-05,
    -4.45165947811853e-05,
    -4.460353089207811e-05,
    -4.468915038934541e-05,
    -4.477345286865829e-05,
    -4.485643796170593e-05,
    -4.493810533615506e-05,
    -4.5018454695608234e-05,
    -4.5097485779561195e-05,
    -4.517519836335973e-05,
    -4.525159225815488e-05,
    -4.5326667310858026e-05,
    -4.540042340409445e-05,
    -4.547286045615629e-05,
    -4.554397842095488e-05,
    -4.561377728797112e-05,
    -4.5682257082206605e-05,
    -4.574941786413228e-05,
    -4.581525972963687e-05,
    -4.587978280997511e-05,
    -4.594298727171358e-05,
    -4.600487331667681e-05,
    -4.606544118189243e-05,
    -4.612469113953482e-05,
    -4.618262349686826e-05,
    -4.623923859618946e-05,
    -4.629453681476884e-05,
    -4.634851856479077e-05,
    -4.6401184293293915e-05,
    -4.6452534482109404e-05,
    -4.650256964779886e-05,
    -4.655129034159196e-05,
    -4.659869714932229e-05,
    -4.664479069136255e-05,
    -4.6689571622559704e-05,
    -4.673304063216816e-05,
    -4.6775198443782835e-05,
    -4.6816045815271235e-05,
    -4.6855583538704477e-05,
    -4.6893812440287666e-05,
    -4.6930733380289805e-05,
    -4.6966347252971865e-05,
    -4.7000654986515035e-05,
    -4.7033657542947996e-05,
    -4.706535591807265e-05,
    -4.7095751141389806e-05,
    -4.712484427602402e-05,
    -4.715263641864695e-05,
    -4.7179128699400675e-05,
    -4.720432228182003e-05,
    -4.72282183627535e-05,
    -4.7250818172284476e-05,
    -4.72721229736506e-05,
    -4.729213406316294e-05,
    -4.731085277012434e-05,
    -4.732828045674691e-05,
    -4.734441851806841e-05,
    -4.735926838186871e-05,
    -4.737283150858437e-05,
    -4.738510939122335e-05,
    -4.7396103555278696e-05,
    -4.740581555864106e-05,
    -4.741424699151103e-05,
    -4.74213994763106e-05,
    -4.7427274667593355e-05,
    -4.743187425195486e-05,
    -4.743519994794111e-05,
    -4.743725350595756e-05,
    -4.7438036708176194e-05,
    -4.7437551368442866e-05,
    -4.7435799332183074e-05,
    -4.743278247630763e-05,
    -4.74285027091173e-05,
    -4.742296197020685e-05,
    -4.7416162230368206e-05,
    -4.740810549149318e-05,
    -4.7398793786475084e-05,
    -4.7388229179110294e-05,
    -4.737641376399812e-05,
    -4.736334966644109e-05,
    -4.7349039042343757e-05,
    -4.7333484078111155e-05,
    -4.731668699054623e-05,
    -4.729865002674723e-05,
    -4.727937546400392e-05,
    -4.72588656096929e-05,
    -4.723712280117297e-05,
    -4.721414940567937e-05,
    -4.718994782021724e-05,
    -4.7164520471454615e-05,
    -4.71378698156151e-05,
    -4.7109998338369173e-05,
    -4.7080908554725266e-05,
    -4.705060300892021e-05,
    -4.7019084274309195e-05,
    -4.698635495325431e-05,
    -4.6952417677013744e-05,
    -4.691727510562889e-05,
    -4.68809299278122e-05,
    -4.684338486083332e-05,
    -4.6804642650405244e-05,
    -4.6764706070569824e-05,
    -4.6723577923582274e-05,
    -4.6681261039795325e-05,
    -4.663775827754316e-05,
    -4.659307252302379e-05,
    -4.654720669018179e-05,
    -4.650016372059011e-05,
    -4.645194658333094e-05,
    -4.6402558274876544e-05,
    -4.6352001818969284e-05,
    -4.6300280266500946e-05,
    -4.624739669539176e-05,
    -4.619335421046865e-05,
    -4.6138155943342926e-05,
    -4.608180505228758e-05,
    -4.602430472211392e-05,
    -4.596565816404759e-05,
    -4.5905868615604284e-05,
    -4.5844939340464424e-05,
    -4.578287362834816e-05,
    -4.571967479488876e-05,
    -4.565534618150638e-05,
    -4.558989115528083e-05,
    -4.5523313108824036e-05,
    -4.5455615460151746e-05,
    -4.5386801652554996e-05,
    -4.531687515447083e-05,
    -4.5245839459352886e-05,
    -4.5173698085540894e-05,
    -4.5100454576130256e-05,
    -4.502611249884081e-05,
    -4.495067544588522e-05,
    -4.4874147033836906e-05,
    -4.4796530903497254e-05,
    -4.4717830719762984e-05,
    -4.463805017149191e-05,
    -4.4557192971369726e-05,
    -4.4475262855775046e-05,
    -4.439226358464455e-05,
    -4.430819894133787e-05,
    -4.422307273250143e-05,
    -4.413688878793243e-05,
    -4.404965096044205e-05,
    -4.396136312571847e-05,
    -4.3872029182188976e-05,
    -4.3781653050882285e-05,
    -4.369023867529021e-05,
    -4.3597790021228364e-05,
    -4.350431107669752e-05,
    -4.340980585174344e-05,
    -4.331427837831724e-05,
    -4.321773271013463e-05,
    -4.312017292253537e-05,
    -4.302160311234165e-05,
    -4.292202739771692e-05,
    -4.2821449918023595e-05,
    -4.271987483368065e-05,
    -4.261730632602101e-05,
    -4.251374859714858e-05,
    -4.240920586979429e-05,
    -4.230368238717262e-05,
    -4.219718241283747e-05,
    -4.208971023053715e-05,
    -4.1981270144070006e-05,
    -4.187186647713901e-05,
    -4.176150357320583e-05,
    -4.1650185795345515e-05,
    -4.153791752609991e-05,
    -4.142470316733089e-05,
    -4.1310547140074074e-05,
    -4.119545388439123e-05,
    -4.1079427859222475e-05,
    -4.0962473542239206e-05,
    -4.084459542969554e-05,
    -4.0725798036279495e-05,
    -4.0606085894965434e-05,
    -4.04854635568638e-05,
    -4.036393559107252e-05,
    -4.024150658452748e-05,
    -4.011818114185254e-05,
    -3.999396388520899e-05,
    -3.98688594541461e-05,
    -3.974287250544982e-05,
    -3.9616007712991895e-05,
    -3.948826976757909e-05,
    -3.935966337680149e-05,
    -3.923019326488093e-05,
    -3.909986417251911e-05,
    -3.89686808567457e-05,
    -3.8836648090765663e-05,
    -3.870377066380677e-05,
    -3.857005338096698e-05,
    -3.843550106306139e-05,
    -3.830011854646878e-05,
    -3.816391068297856e-05,
    -3.8026882339636736e-05,
    -3.788903839859237e-05,
    -3.775038375694351e-05,
    -3.761092332658288e-05,
    -3.747066203404355e-05,
    -3.732960482034428e-05,
    -3.718775664083487e-05,
    -3.7045122465041155e-05,
    -3.6901707276509927e-05,
    -3.675751607265369e-05,
    -3.661255386459512e-05,
    -3.646682567701173e-05,
    -3.6320336547979926e-05,
    -3.617309152881924e-05,
    -3.602509568393625e-05,
    -3.587635409066849e-05,
    -3.572687183912807e-05,
    -3.557665403204581e-05,
    -3.5425705784613506e-05,
    -3.527403222432844e-05,
    -3.512163849083651e-05,
    -3.496852973577434e-05,
    -3.481471112261344e-05,
    -3.466018782650295e-05,
    -3.450496503411156e-05,
    -3.434904794347123e-05,
    -3.4192441763819875e-05,
    -3.403515171544276e-05,
    -3.387718302951629e-05,
    -3.371854094795005e-05,
    -3.3559230723228414e-05,
    -3.33992576182538e-05,
    -3.323862690618861e-05,
    -3.30773438702967e-05,
    -3.291541380378665e-05,
    -3.275284200965293e-05,
    -3.25896338005179e-05,
    -3.242579449847464e-05,
    -3.226132943492805e-05,
    -3.2096243950436646e-05,
    -3.1930543394555577e-05,
    -3.1764233125677226e-05,
    -3.159731851087342e-05,
    -3.142980492573783e-05,
    -3.12616977542272e-05,
    -3.109300238850295e-05,
    -3.092372422877391e-05,
    -3.075386868313742e-05,
    -3.0583441167420915e-05,
    -3.0412447105024817e-05,
    -3.024089192676346e-05,
    -3.0068781070706943e-05,
    -2.9896119982024048e-05,
    -2.972291411282298e-05,
    -2.9549168921994093e-05,
    -2.9374889875051563e-05,
    -2.920008244397555e-05,
    -2.9024752107054335e-05,
    -2.8848904348726434e-05,
    -2.8672544659422817e-05,
    -2.849567853540911e-05,
    -2.8318311478628e-05,
    -2.814044899654173e-05,
    -2.796209660197432e-05,
    -2.7783259812954362e-05,
    -2.7603944152557578e-05,
    -2.742415514874945e-05,
    -2.7243898334228145e-05,
    -2.7063179246267407e-05,
    -2.6882003426559452e-05,
    -2.6700376421058215e-05,
    -2.6518303779822477e-05,
    -2.6335791056859145e-05,
    -2.6152843809966815e-05,
    -2.5969467600579173e-05,
    -2.5785667993608833e-05,
    -2.5601450557290988e-05,
    -2.5416820863027482e-05,
    -2.523178448523073e-05,
    -2.504634700116801e-05,
    -2.4860513990805917e-05,
    -2.4674291036654626e-05,
    -2.4487683723612596e-05,
    -2.4300697638811996e-05,
    -2.411333837146229e-05,
    -2.392561151269668e-05,
    -2.3737522655417223e-05,
    -2.3549077394139252e-05,
    -2.336028132483825e-05,
    -2.3171140044795404e-05,
    -2.2981659152442805e-05,
    -2.279184424721052e-05,
    -2.260170092937313e-05,
    -2.241123479989511e-05,
    -2.2220451460278762e-05,
    -2.202935651241114e-05,
    -2.1837955558410286e-05,
    -2.16462542004735e-05,
    -2.1454258040725233e-05,
    -2.1261972681063422e-05,
    -2.106940372300949e-05,
    -2.0876556767555276e-05,
    -2.0683437415011623e-05,
    -2.0490051264858137e-05,
    -2.0296403915591204e-05,
    -2.0102500964573107e-05,
    -1.9908348007882656e-05,
    -1.9713950640163786e-05,
    -1.9519314454475605e-05,
    -1.932444504214362e-05,
    -1.9129347992609222e-05,
    -1.8934028893280386e-05,
    -1.8738493329383874e-05,
    -1.8542746883815353e-05,
    -1.8346795136991043e-05,
    -1.815064366670063e-05,
    -1.7954298047958155e-05,
    -1.7757763852855154e-05,
    -1.7561046650413113e-05,
    -1.7364152006436628e-05,
    -1.71670854833666e-05,
    -1.696985264013384e-05,
    -1.6772459032013092e-05,
    -1.6574910210477157e-05,
    -1.637721172305142e-05,
    -1.6179369113168784e-05,
    -1.598138792002476e-05,
    -1.578327367843297e-05,
    -1.5585031918681037e-05,
    -1.5386668166386573e-05,
    -1.5188187942353865e-05,
    -1.498959676243053e-05,
    -1.4790900137364691e-05,
    -1.4592103572662594e-05,
    -1.4393212568446263e-05,
    -1.4194232619311907e-05,
    -1.3995169214188298e-05,
    -1.3796027836195745e-05,
    -1.3596813962505392e-05,
    -1.3397533064198816e-05,
    -1.3198190606127994e-05,
    -1.2998792046775751e-05,
    -1.2799342838116409e-05,
    -1.2599848425476984e-05,
    -1.240031424739865e-05,
    -1.2200745735498627e-05,
    -1.2001148314332457e-05,
    -1.180152740125666e-05,
    -1.1601888406291634e-05,
    -1.1402236731985826e-05,
    -1.1202577773278182e-05,
    -1.1002916917363697e-05,
    -1.0803259543557917e-05,
    -1.0603611023160987e-05,
    -1.0403976719324186e-05,
    -1.0204361986915922e-05,
    -1.0004772172386798e-05,
    -9.805212613637557e-06,
    -9.605688639886245e-06,
    -9.40620557153461e-06,
    -9.20676872003729e-06,
    -9.007383387770323e-06,
    -8.808054867898774e-06,
    -8.608788444247304e-06,
    -8.409589391169952e-06,
    -8.210462973418974e-06,
    -8.011414446017435e-06,
    -7.812449054128957e-06,
    -7.613572032929285e-06,
    -7.414788607479569e-06,
    -7.216103992597603e-06,
    -7.0175233927308025e-06,
    -6.819052001830814e-06,
    -6.620695003226242e-06,
    -6.422457569496946e-06,
    -6.2243448623501416e-06,
    -6.026362032494462e-06,
    -5.8285142195157814e-06,
    -5.6308065517546844e-06,
    -5.433244146182027e-06,
    -5.23583210827616e-06,
    -5.038575531901917e-06,
    -4.841479499187482e-06,
    -4.64454908040379e-06,
    -4.447789333843622e-06,
    -4.2512053057013375e-06,
    -4.054802029953113e-06,
    -3.858584528237657e-06,
    -3.6625578097375116e-06,
    -3.4667268710607547e-06,
    -3.271096696123307e-06,
    -3.0756722560317144e-06,
    -2.880458508966465e-06,
    -2.685460400065823e-06,
    -2.490682861310171e-06,
    -2.2961308114069104e-06,
    -2.101809155675864e-06,
    -1.9077227859352247e-06,
    -1.7138765803880245e-06,
    -1.520275403509163e-06,
    -1.3269241059329422e-06,
    -1.1338275243411755e-06,
    -9.409904813518139e-07,
    -7.484177854081312e-07,
    -5.561142306684498e-07,
    -3.640845968964292e-07,
    -1.7233364935188624e-07,
    1.9133861317810385e-08,
    2.1031319918580196e-07,
    4.0119964315323514e-07,
    5.917884870562026e-07,
    7.820750397721128e-07,
    9.720546253255025e-07,
    1.1617225829932787e-06,
    1.3510742674095176e-06,
    1.5401050486689104e-06,
    1.7288103124316067e-06,
    1.917185460024981e-06,
    2.105225908546002e-06,
    2.2929270909642144e-06,
    2.4802844562217686e-06,
    2.6672934693340425e-06,
    2.853949611490877e-06,
    3.0402483801548375e-06,
    3.2261852891600884e-06,
    3.411755868811844e-06,
    3.596955665982873e-06,
    3.7817802442105845e-06,
    3.966225183794693e-06,
    4.150286081891926e-06,
    4.3339585526113485e-06,
    4.517238227110289e-06,
    4.7001207536866755e-06,
    4.8826017978737705e-06,
    5.064677042533036e-06,
    5.246342187945265e-06,
    5.427592951903361e-06,
    5.60842506980341e-06,
    5.788834294733909e-06,
    5.968816397566755e-06,
    6.148367167046439e-06,
    6.327482409877462e-06,
    6.506157950813412e-06,
    6.684389632744359e-06,
    6.862173316782337e-06,
    7.039504882348624e-06,
    7.2163802272591646e-06,
    7.392795267808303e-06,
    7.568745938854192e-06,
    7.744228193901742e-06,
    7.91923800518574e-06,
    8.093771363753042e-06,
    8.267824279544332e-06,
    8.441392781475133e-06,
    8.614472917516153e-06,
    8.787060754773097e-06,
    8.959152379565742e-06,
    9.130743897506424e-06,
    9.301831433577857e-06,
    9.472411132210343e-06,
    9.642479157358258e-06,
    9.81203169257602e-06,
    9.981064941093257e-06,
    1.0149575125889454e-05,
    1.0317558489767902e-05,
    1.0485011295428933e-05,
    1.0651929825542666e-05,
    1.0818310382820903e-05,
    1.0984149290088492e-05,
    1.1149442890354046e-05,
    1.1314187546879918e-05,
    1.1478379643251604e-05,
    1.1642015583446432e-05,
    1.1805091791901611e-05,
    1.1967604713581656e-05,
    1.2129550814045034e-05,
    1.2290926579510341e-05,
    1.2451728516921619e-05,
    1.2611953154013138e-05,
    1.2771597039373473e-05,
    1.2930656742509e-05,
    1.3089128853906077e-05,
    1.3247009985094327e-05,
    1.3404296768706896e-05,
    1.3560985858541335e-05,
    1.3717073929620539e-05,
    1.3872557678251335e-05,
    1.4027433822082976e-05,
    1.4181699100166432e-05,
    1.4335350273010603e-05,
    1.4488384122639147e-05,
    1.464079745264745e-05,
    1.4792587088257065e-05,
    1.4943749876370334e-05,
    1.5094282685625487e-05,
    1.5244182406448902e-05,
    1.5393445951107845e-05,
    1.554207025376357e-05,
    1.5690052270520998e-05,
    1.5837388979480588e-05,
    1.5984077380788204e-05,
    1.613011449668344e-05,
    1.6275497371549266e-05,
    1.642022307195982e-05,
    1.6564288686726816e-05,
    1.670769132694703e-05,
    1.685042812604816e-05,
    1.699249623983313e-05,
    1.7133892846525524e-05,
    1.7274615146813436e-05,
    1.741466036389174e-05,
    1.7554025743505507e-05,
    1.769270855399172e-05,
    1.7830706086319598e-05,
    1.7968015654131943e-05,
    1.810463459378447e-05,
    1.824056026438499e-05,
    1.837579004783174e-05,
    1.851032134885113e-05,
    1.864415159503482e-05,
    1.8777278236875976e-05,
    1.8909698747804997e-05,
    1.904141062422454e-05,
    1.91724113855437e-05,
    1.930269857421178e-05,
    1.943226975575109e-05,
    1.9561122518789335e-05,
    1.9689254475091035e-05,
    1.9816663259588563e-05,
    1.994334653041228e-05,
    2.0069301968920142e-05,
    2.0194527279726368e-05,
    2.0319020190729815e-05,
    2.044277845314137e-05,
    2.056579984151074e-05,
    2.0688082153752608e-05,
    2.080962321117204e-05,
    2.093042085848935e-05,
    2.1050472963864e-05,
    2.1169777418918242e-05,
    2.1288332138759614e-05,
    2.1406135062003134e-05,
    2.1523184150792668e-05,
    2.163947739082155e-05,
    2.1755012791352414e-05,
    2.186978838523715e-05,
    2.1983802228934988e-05,
    2.2097052402530315e-05,
    2.220953700975088e-05,
    2.2321254177983564e-05,
    2.2432202058290386e-05,
    2.2542378825424604e-05,
    2.265178267784442e-05,
    2.2760411837727016e-05,
    2.2868264550982583e-05,
    2.2975339087266166e-05,
    2.3081633739989473e-05,
    2.3187146826332966e-05,
    2.329187668725573e-05,
    2.339582168750527e-05,
    2.3498980215627705e-05,
    2.360135068397506e-05,
    2.370293152871414e-05,
    2.380372120983359e-05,
    2.390371821114991e-05,
    2.4002921040313968e-05,
    2.410132822881633e-05,
    2.4198938331991084e-05,
    2.4295749929020457e-05,
    2.4391761622938115e-05,
    2.4486972040630972e-05,
    2.4581379832842015e-05,
    2.4674983674171314e-05,
    2.4767782263076163e-05,
    2.485977432187168e-05,
    2.4950958596730016e-05,
    2.5041333857678475e-05,
    2.5130898898598116e-05,
    2.521965253722086e-05,
    2.530759361512619e-05,
    2.5394720997737104e-05,
    2.5481033574315717e-05,
    2.556653025795777e-05,
    2.5651209985586918e-05,
    2.573507171794796e-05,
    2.5818114439599957e-05,
    2.5900337158908024e-05,
    2.5981738908035098e-05,
    2.6062318742932705e-05,
    2.6142075743331252e-05,
    2.6221009012729475e-05,
    2.6299117678383534e-05,
    2.6376400891295356e-05,
    2.6452857826200044e-05,
    2.6528487681553307e-05,
    2.6603289679517518e-05,
    2.6677263065947724e-05,
    2.6750407110376626e-05,
    2.6822721105999215e-05,
    2.6894204369656598e-05,
    2.6964856241819297e-05,
    2.703467608656974e-05,
    2.710366329158455e-05,
    2.7171817268115563e-05,
    2.723913745097098e-05,
    2.7305623298495188e-05,
    2.737127429254845e-05,
    2.7436089938485773e-05,
    2.7500069765135225e-05,
    2.7563213324775627e-05,
    2.762552019311336e-05,
    2.768698996925936e-05,
    2.7747622275704496e-05,
    2.7807416758294843e-05,
    2.786637308620661e-05,
    2.792449095191989e-05,
    2.7981770071192054e-05,
    2.8038210183030897e-05,
    2.8093811049666558e-05,
    2.814857245652302e-05,
    2.8202494212189732e-05,
    2.8255576148391338e-05,
    2.830781811995786e-05,
    2.8359220004794063e-05,
    2.8409781703847775e-05,
    2.8459503141078124e-05,
    2.8508384263423207e-05,
    2.8556425040766498e-05,
    2.8603625465903676e-05,
    2.8649985554508124e-05,
    2.8695505345095985e-05,
    2.8740184898990757e-05,
    2.8784024300287715e-05,
    2.882702365581658e-05,
    2.886918309510494e-05,
    2.891050277034053e-05,
    2.8950982856332514e-05,
    2.8990623550472963e-05,
    2.9029425072697533e-05,
    2.9067387665445096e-05,
    2.9104511593617558e-05,
    2.9140797144538545e-05,
    2.9176244627911843e-05,
    2.921085437577914e-05,
    2.9244626742477283e-05,
    2.9277562104594988e-05,
    2.930966086092889e-05,
    2.9340923432439175e-05,
    2.9371350262204674e-05,
    2.9400941815377212e-05,
    2.9429698579135784e-05,
    2.945762106263978e-05,
    2.948470979698191e-05,
    2.951096533514073e-05,
    2.95363882519321e-05,
    2.956097914396085e-05,
    2.9584738629571294e-05,
    2.960766734879751e-05,
    2.9629765963313115e-05,
    2.9651035156380368e-05,
    2.96714756327989e-05,
    2.9691088118853815e-05,
    2.9709873362263287e-05,
    2.972783213212581e-05,
    2.9744965218866695e-05,
    2.9761273434184188e-05,
    2.977675761099508e-05,
    2.97914186033798e-05,
    2.9805257286527014e-05,
    2.9818274556677586e-05,
    2.9830471331068458e-05,
    2.984184854787541e-05,
    2.985240716615585e-05,
    2.9862148165791e-05,
    2.9871072547427188e-05,
    2.9879181332417445e-05,
    2.9886475562761752e-05,
    2.9892956301047513e-05,
    2.989862463038905e-05,
    2.990348165436685e-05,
    2.9907528496966523e-05,
    2.9910766302516765e-05,
    2.99131962356273e-05,
    2.9914819481126334e-05,
    2.9915637243997236e-05,
    2.9915650749315037e-05,
    2.991486124218239e-05,
    2.9913269987665098e-05,
    2.9910878270726955e-05,
    2.990768739616469e-05,
    2.99036986885418e-05,
    2.9898913492122302e-05,
    2.9893333170804127e-05,
    2.9886959108051742e-05,
    2.987979270682859e-05,
    2.987183538952915e-05,
    2.9863088597910192e-05,
    2.9853553793021898e-05,
    2.9843232455138687e-05,
    2.983212608368922e-05,
    2.982023619718628e-05,
    2.9807564333156063e-05,
    2.979411204806709e-05,
    2.977988091725891e-05,
    2.9764872534870044e-05,
    2.9749088513765747e-05,
    2.973253048546525e-05,
    2.971520010006875e-05,
    2.969709902618371e-05,
    2.9678228950851143e-05,
    2.9658591579471183e-05,
    2.963818863572839e-05,
    2.9617021861516603e-05,
    2.959509301686348e-05,
    2.9572403879854623e-05,
    2.9548956246557356e-05,
    2.952475193094393e-05,
    2.9499792764814644e-05,
    2.9474080597720293e-05,
    2.9447617296884566e-05,
    2.9420404747125714e-05,
    2.9392444850778104e-05,
    2.9363739527613365e-05,
    2.9334290714761042e-05,
    2.9304100366629086e-05,
    2.927317045482382e-05,
    2.924150296806967e-05,
    2.9209099912128437e-05,
    2.9175963309718233e-05,
    2.914209520043217e-05,
    2.91074976406568e-05,
    2.9072172703489553e-05,
    2.9036122478657026e-05,
    2.899934907243167e-05,
    2.8961854607549064e-05,
    2.8923641223124363e-05,
    2.8884711074568632e-05,
    2.8845066333504765e-05,
    2.8804709187683233e-05,
    2.8763641840897216e-05,
    2.8721866512897695e-05,
    2.8679385439308194e-05,
    2.863620087153904e-05,
    2.8592315076701447e-05,
    2.854773033752139e-05,
    2.850244895225296e-05,
    2.8456473234591532e-05,
    2.8409805513586573e-05,
    2.8362448133554442e-05,
    2.831440345399042e-05,
    2.826567384948081e-05,
    2.8216261709614726e-05,
    2.8166169438895228e-05,
    2.8115399456650853e-05,
    2.806395419694631e-05,
    2.8011836108493032e-05,
    2.795904765455944e-05,
    2.7905591312881426e-05,
    2.785146957557151e-05,
    2.7796684949028867e-05,
    2.7741239953848574e-05,
    2.7685137124730194e-05,
    2.7628379010387162e-05,
    2.7570968173454926e-05,
    2.751290719039913e-05,
    2.7454198651424075e-05,
    2.7394845160380044e-05,
    2.7334849334671085e-05,
    2.727421380516242e-05,
    2.721294121608736e-05,
    2.7151034224953964e-05,
    2.7088495502452226e-05,
    2.702532773235999e-05,
    2.6961533611449252e-05,
    2.689711584939234e-05,
    2.683207716866733e-05,
    2.6766420304463848e-05,
    2.6700148004588208e-05,
    2.663326302936871e-05,
    2.6565768151560464e-05,
    2.649766615625006e-05,
    2.6428959840760253e-05,
    2.6359652014554154e-05,
    2.628974549913939e-05,
    2.6219243127972078e-05,
    2.6148147746360662e-05,
    2.6076462211369353e-05,
    2.600418939172164e-05,
    2.5931332167703458e-05,
    2.5857893431066247e-05,
    2.5783876084929937e-05,
    2.5709283043685543e-05,
    2.563411723289771e-05,
    2.5558381589207215e-05,
    2.5482079060233093e-05,
    2.5405212604474768e-05,
    2.5327785191214016e-05,
    2.524979980041658e-05,
    2.5171259422633986e-05,
    2.5092167058904938e-05,
    2.5012525720656587e-05,
    2.4932338429605935e-05,
    2.48516082176607e-05,
    2.4770338126820347e-05,
    2.4688531209076904e-05,
    2.460619052631568e-05,
    2.4523319150215647e-05,
    2.4439920162150073e-05,
    2.4355996653086906e-05,
    2.4271551723488553e-05,
    2.418658848321249e-05,
    2.4101110051411128e-05,
    2.4015119556431293e-05,
    2.3928620135714486e-05,
    2.3841614935696586e-05,
    2.375410711170686e-05,
    2.3666099827868093e-05,
    2.357759625699575e-05,
    2.3488599580497088e-05,
    2.339911298827063e-05,
    2.3309139678605484e-05,
    2.3218682858079737e-05,
    2.312774574146017e-05,
    2.303633155160094e-05,
    2.2944443519342068e-05,
    2.2852084883408883e-05,
    2.2759258890310177e-05,
    2.2665968794236952e-05,
    2.257221785696146e-05,
    2.247800934773513e-05,
    2.2383346543187334e-05,
    2.2288232727224e-05,
    2.2192671190925803e-05,
    2.2096665232446243e-05,
    2.2000218156910708e-05,
    2.190333327631398e-05,
    2.1806013909418696e-05,
    2.17082633816539e-05,
    2.1610085025012812e-05,
    2.1511482177950912e-05,
    2.1412458185284534e-05,
    2.1313016398088515e-05,
    2.1213160173594482e-05,
    2.1112892875088854e-05,
    2.1012217871810906e-05,
    2.0911138538850846e-05,
    2.0809658257047828e-05,
    2.070778041288798e-05,
    2.0605508398402495e-05,
    2.0502845611065576e-05,
    2.039979545369252e-05,
    2.029636133433783e-05,
    2.0192546666193144e-05,
    2.008835486748545e-05,
    1.9983789361375047e-05,
    1.987885357585371e-05,
    1.9773550943642916e-05,
    1.9667884902091767e-05,
    1.9561858893075393e-05,
    1.945547636289309e-05,
    1.9348740762166503e-05,
    1.9241655545738015e-05,
    1.9134224172568997e-05,
    1.9026450105638166e-05,
    1.8918336811840016e-05,
    1.8809887761883268e-05,
    1.8701106430189392e-05,
    1.8591996294791118e-05,
    1.8482560837231047e-05,
    1.8372803542460397e-05,
    1.826272789873754e-05,
    1.8152337397527226e-05,
    1.8041635533398754e-05,
    1.793062580392547e-05,
    1.7819311709583814e-05,
    1.7707696753651697e-05,
    1.759578444210837e-05,
    1.7483578283533603e-05,
    1.7371081789006357e-05,
    1.725829847200487e-05,
    1.7145231848306063e-05,
    1.7031885435884548e-05,
    1.6918262754812855e-05,
    1.6804367327161307e-05,
    1.6690202676897158e-05,
    1.657577232978524e-05,
    1.6461079813288005e-05,
    1.634612865646495e-05,
    1.623092238987403e-05,
    1.6115464545471186e-05,
    1.599975865651098e-05,
    1.588380825744773e-05,
    1.5767616883835758e-05,
    1.5651188072230176e-05,
    1.5534525360088485e-05,
    1.541763228567116e-05,
    1.530051238794277e-05,
    1.5183169206474153e-05,
    1.506560628134316e-05,
    1.4947827153036328e-05,
    1.4829835362351409e-05,
    1.4711634450298556e-05,
    1.4593227958002413e-05,
    1.447461942660512e-05,
    1.4355812397167788e-05,
    1.4236810410573529e-05,
    1.411761700742994e-05,
    1.3998235727972143e-05,
    1.3878670111965575e-05,
    1.3758923698609305e-05,
    1.363900002643925e-05,
    1.3518902633231825e-05,
    1.339863505590741e-05,
    1.327820083043443e-05,
    1.3157603491733106e-05,
    1.3036846573579893e-05,
    1.2915933608511686e-05,
    1.2794868127730442e-05,
    1.2673653661007914e-05,
    1.2552293736590547e-05,
    1.243079188110466e-05,
    1.2309151619461632e-05,
    1.2187376474763562e-05,
    1.2065469968208807e-05,
    1.1943435618997968e-05,
    1.182127694423997e-05,
    1.169899745885837e-05,
    1.1576600675497773e-05,
    1.1454090104430708e-05,
    1.1331469253464386e-05,
    1.1208741627847928e-05,
    1.1085910730179666e-05,
    1.0962980060314752e-05,
    1.083995311527291e-05,
    1.0716833389146444e-05,
    1.0593624373008469e-05,
    1.0470329554821293e-05,
    1.034695241934551e-05,
    1.0223496448048091e-05,
    1.0099965119012246e-05,
    9.976361906846836e-06,
    9.852690282595218e-06,
    9.72895371364589e-06,
    9.605155663642526e-06,
    9.481299592393624e-06,
    9.357388955783826e-06,
    9.233427205684708e-06,
    9.109417789865204e-06,
    8.985364151903597e-06,
    8.86126973109914e-06,
    8.737137962383198e-06,
    8.612972276232022e-06,
    8.488776098579173e-06,
    8.364552850727295e-06,
    8.240305949262147e-06,
    8.11603880596496e-06,
    7.991754827725844e-06,
    7.867457416458226e-06,
    7.743149969012093e-06,
    7.618835877088191e-06,
    7.494518527153351e-06,
    7.370201300354455e-06,
    7.245887572433581e-06,
    7.121580713644092e-06,
    6.99728408866549e-06,
    6.873001056519408e-06,
    6.748734970486528e-06,
    6.624489178022333e-06,
    6.500267020673955e-06,
    6.376071833997943e-06,
    6.251906947476896e-06,
    6.1277756844374895e-06,
    6.003681361968429e-06,
    5.879627290838695e-06,
    5.755616775416164e-06,
    5.631653113586468e-06,
    5.507739596672222e-06,
    5.383879509352514e-06,
    5.260076129582714e-06,
    5.136332728514621e-06,
    5.012652570416892e-06,
    4.889038912595799e-06,
    4.765495005316313e-06,
    4.6420240917234915e-06,
    4.518629407764186e-06,
    4.395314182109085e-06,
    4.2720816360750785e-06,
    4.14893498354793e-06,
    4.025877430905297e-06,
    3.9029121769400715e-06,
    3.780042412784062e-06,
    3.6572713218319733e-06,
    3.5346020796657662e-06,
    3.412037853979329e-06,
    3.2895818045034746e-06,
    3.167237082931309e-06,
    3.045006832843899e-06,
    2.9228941896363225e-06,
    2.800902280444037e-06,
    2.6790342240695924e-06,
    2.5572931309097023e-06,
    2.43568210288266e-06,
    2.3142042333560103e-06,
    2.1928626070750884e-06,
    2.0716603000906478e-06,
    1.9506003796884262e-06,
    1.8296859043183376e-06,
    1.7089199235232305e-06,
    1.5883054778695439e-06,
    1.4678455988775547e-06,
    1.3475433089512337e-06,
    1.227401621309971e-06,
    1.107423539919913e-06,
    9.876120594249144e-07,
    8.679701650793529e-07,
    7.485008326805667e-07,
    6.29207028500914e-07,
    5.100917092216914e-07,
    3.911578218666814e-07,
    2.724083037352481e-07,
    1.5384608233778424e-07,
    3.547407532955892e-08,
    -8.270480955423677e-08,
    -2.0068767456232417e-07,
    -3.1847163199227327e-07,
    -4.3605380425431696e-07,
    -5.534313239340482e-07,
    -6.706013338562068e-07,
    -7.875609871473478e-07,
    -9.043074472973837e-07,
    -1.02083788822222e-06,
    -1.1371494943252586e-06,
    -1.2532394605577834e-06,
    -1.3691049924804257e-06,
    -1.4847433063234992e-06,
    -1.600151629046214e-06,
    -1.7153271983970472e-06,
    -1.8302672629724863e-06,
    -1.94496908227589e-06,
    -2.0594299267758365e-06,
    -2.1736470779641113e-06,
    -2.287617828413273e-06,
    -2.401339481833818e-06,
    -2.514809353130968e-06,
    -2.628024768461033e-06,
    -2.740983065287377e-06,
    -2.853681592435997e-06,
    -2.966117710150675e-06,
    -3.0782887901477336e-06,
    -3.1901922156703946e-06,
    -3.301825381542723e-06,
    -3.4131856942231586e-06,
    -3.524270571857648e-06,
    -3.635077444332361e-06,
    -3.745603753325999e-06,
    -3.855846952361704e-06,
    -3.965804506858519e-06,
    -4.075473894182493e-06,
    -4.184852603697302e-06,
    -4.2939381368145475e-06,
    -4.402728007043518e-06,
    -4.5112197400406704e-06,
    -4.619410873658579e-06,
    -4.727298957994542e-06,
    -4.834881555438733e-06,
    -4.942156240721951e-06,
    -5.049120600962936e-06,
    -5.15577223571527e-06,
    -5.262108757013964e-06,
    -5.368127789421112e-06,
    -5.47382697007228e-06,
    -5.579203948721085e-06,
    -5.684256387783952e-06,
    -5.788981962385171e-06,
    -5.89337836040016e-06,
    -5.997443282499025e-06,
    -6.101174442190248e-06,
    -6.2045695658627745e-06,
    -6.307626392828198e-06,
    -6.410342675363256e-06,
    -6.512716178750547e-06,
    -6.6147446813194925e-06,
    -6.716425974487562e-06,
    -6.817757862799643e-06,
    -6.918738163967761e-06,
    -7.019364708911056e-06,
    -7.1196353417935375e-06,
    -7.219547920063241e-06,
    -7.31910031449011e-06,
    -7.418290409202917e-06,
    -7.517116101726969e-06,
    -7.615575303020759e-06,
    -7.713665937511568e-06,
    -7.811385943131868e-06,
    -7.908733271354653e-06,
    -8.00570588722776e-06,
    -8.102301769408972e-06,
    -8.19851891020008e-06,
    -8.294355315579822e-06,
    -8.389809005237749e-06,
    -8.484878012606936e-06,
    -8.579560384895665e-06,
    -8.673854183120006e-06,
    -8.7677574821349e-06,
    -8.861268370665203e-06,
    -8.95438495133632e-06,
    -9.047105340704248e-06,
    -9.139427669285348e-06,
    -9.231350081585517e-06,
    -9.322870736129065e-06,
    -9.41398780548708e-06,
    -9.504699476305367e-06,
    -9.595003949331952e-06,
    -9.684899439444135e-06,
    -9.774384175675164e-06,
    -9.863456401240386e-06,
    -9.952114373563001e-06,
    -1.004035636429942e-05,
    -1.0128180659364129e-05,
    -1.0215585558954077e-05,
    -1.0302569377572772e-05,
    -1.038913044405375e-05,
    -1.0475267101583797e-05,
    -1.0560977707725551e-05,
    -1.0646260634439879e-05,
    -1.0731114268107549e-05,
    -1.0815537009550665e-05,
    -1.089952727405365e-05,
    -1.0983083491383713e-05,
    -1.106620410581092e-05,
    -1.1148887576127803e-05,
    -1.1231132375668645e-05,
    -1.1312936992327898e-05,
    -1.139429992857917e-05,
    -1.1475219701492489e-05,
    -1.1555694842751774e-05,
    -1.1635723898672413e-05,
    -1.1715305430217282e-05,
    -1.1794438013012863e-05,
    -1.187312023736549e-05,
    -1.1951350708276098e-05,
    -1.2029128045455057e-05,
    -1.2106450883337105e-05,
    -1.2183317871094696e-05,
    -1.2259727672651684e-05,
    -1.2335678966696838e-05,
    -1.2411170446695946e-05,
    -1.2486200820904189e-05,
    -1.2560768812378335e-05,
    -1.2634873158987477e-05,
    -1.2708512613424364e-05,
    -1.2781685943216023e-05,
    -1.2854391930733286e-05,
    -1.2926629373200897e-05,
    -1.2998397082706746e-05,
    -1.3069693886210112e-05,
    -1.3140518625550623e-05,
    -1.3210870157456024e-05,
    -1.3280747353549204e-05,
    -1.335014910035584e-05,
    -1.3419074299310897e-05,
    -1.3487521866764487e-05,
    -1.355549073398799e-05,
    -1.3622979847179497e-05,
    -1.3689988167468226e-05,
    -1.375651467091948e-05,
    -1.3822558348538761e-05,
    -1.3888118206274892e-05,
    -1.3953193265023825e-05,
    -1.4017782560631152e-05,
    -1.4081885143894576e-05,
    -1.4145500080565736e-05,
    -1.4208626451351946e-05,
    -1.4271263351917179e-05,
    -1.4333409892882755e-05,
    -1.4395065199827686e-05,
    -1.4456228413288512e-05,
    -1.4516898688758698e-05,
    -1.4577075196687703e-05,
    -1.463675712247956e-05,
    -1.4695943666491105e-05,
    -1.475463404402969e-05,
    -1.4812827485350574e-05,
    -1.4870523235653892e-05,
    -1.4927720555081118e-05,
    -1.4984418718711251e-05,
    -1.5040617016556515e-05,
    -1.5096314753557628e-05,
    -1.5151511249578653e-05,
    -1.52062058394016e-05,
    -1.5260397872720372e-05,
    -1.5314086714134438e-05,
    -1.5367271743142186e-05,
    -1.5419952354133657e-05,
    -1.5472127956383045e-05,
    -1.552379797404074e-05,
    -1.5574961846124917e-05,
    -1.5625619026512806e-05,
    -1.5675768983931475e-05,
    -1.5725411201948406e-05,
    -1.5774545178961337e-05,
    -1.5823170428187897e-05,
    -1.5871286477655076e-05,
    -1.5918892870187815e-05,
    -1.5965989163397398e-05,
    -1.601257492966987e-05,
    -1.60586497561533e-05,
    -1.6104213244745067e-05,
    -1.6149265012079065e-05,
    -1.6193804689511794e-05,
    -1.623783192310852e-05,
    -1.6281346373629223e-05,
    -1.6324347716513617e-05,
    -1.6366835641866046e-05,
    -1.6408809854440378e-05,
    -1.6450270073623638e-05,
    -1.6491216033420165e-05,
    -1.6531647482434935e-05,
    -1.6571564183856267e-05,
    -1.6610965915438754e-05,
    -1.664985246948552e-05,
    -1.6688223652829702e-05,
    -1.672607928681626e-05,
    -1.676341920728316e-05,
    -1.6800243264541664e-05,
    -1.6836551323357077e-05,
    -1.687234326292867e-05,
    -1.6907618976869057e-05,
    -1.6942378373183637e-05,
    -1.6976621374249575e-05,
    -1.7010347916793843e-05,
    -1.704355795187189e-05,
    -1.7076251444845035e-05,
    -1.7108428375358016e-05,
    -1.7140088737316034e-05,
    -1.7171232538861395e-05,
    -1.720185980234977e-05,
    -1.7231970564326274e-05,
    -1.7261564875500907e-05,
    -1.729064280072394e-05,
    -1.7319204418960737e-05,
    -1.734724982326617e-05,
    -1.7374779120759032e-05,
    -1.7401792432595662e-05,
    -1.742828989394339e-05,
    -1.7454271653953878e-05,
    -1.747973787573567e-05,
    -1.7504688736326682e-05,
    -1.752912442666638e-05,
    -1.7553045151567336e-05,
    -1.757645112968678e-05,
    -1.7599342593497556e-05,
    -1.7621719789258903e-05,
    -1.7643582976986672e-05,
    -1.7664932430423623e-05,
    -1.768576843700884e-05,
    -1.7706091297847283e-05,
    -1.7725901327678767e-05,
    -1.7745198854846577e-05,
    -1.776398422126599e-05,
    -1.7782257782392156e-05,
    -1.780001990718798e-05,
    -1.7817270978091276e-05,
    -1.783401139098202e-05,
    -1.7850241555149022e-05,
    -1.7865961893256336e-05,
    -1.788117284130936e-05,
    -1.7895874848620526e-05,
    -1.791006837777498e-05,
    -1.7923753904595457e-05,
    -1.7936931918107244e-05,
    -1.794960292050271e-05,
    -1.796176742710551e-05,
    -1.797342596633431e-05,
    -1.7984579079666657e-05,
    -1.7995227321602e-05,
    -1.8005371259624742e-05,
    -1.8015011474167024e-05,
    -1.802414855857093e-05,
    -1.8032783119050563e-05,
    -1.8040915774654002e-05,
    -1.8048547157224437e-05,
    -1.8055677911361665e-05,
    -1.806230869438281e-05,
    -1.8068440176282875e-05,
    -1.8074073039695135e-05,
    -1.807920797985107e-05,
    -1.8083845704540095e-05,
    -1.808798693406897e-05,
    -1.8091632401221047e-05,
    -1.80947828512149e-05,
    -1.8097439041663227e-05,
    -1.8099601742530814e-05,
    -1.8101271736092786e-05,
    -1.810244981689226e-05,
    -1.810313679169786e-05,
    -1.810333347946074e-05,
    -1.8103040711271816e-05,
    -1.8102259330318152e-05,
    -1.8100990191839408e-05,
    -1.8099234163084014e-05,
    -1.809699212326501e-05,
    -1.8094264963515545e-05,
    -1.8091053586844302e-05,
    -1.8087358908090552e-05,
    -1.8083181853878886e-05,
    -1.80785233625738e-05,
    -1.8073384384234086e-05,
    -1.806776588056669e-05,
    -1.8061668824880673e-05,
    -1.8055094202040658e-05,
    -1.8048043008420116e-05,
    -1.8040516251854417e-05,
    -1.8032514951593753e-05,
    -1.802404013825542e-05,
    -1.801509285377647e-05,
    -1.8005674151365518e-05,
    -1.79957850954547e-05,
    -1.7985426761651254e-05,
    -1.7974600236688885e-05,
    -1.7963306618378918e-05,
    -1.795154701556116e-05,
    -1.7939322548054603e-05,
    -1.792663434660788e-05,
    -1.7913483552849495e-05,
    -1.7899871319237738e-05,
    -1.788579880901056e-05,
    -1.787126719613508e-05,
    -1.785627766525696e-05,
    -1.784083141164946e-05,
    -1.7824929641162408e-05,
    -1.7808573570170823e-05,
    -1.779176442552351e-05,
    -1.7774503444491163e-05,
    -1.775679187471467e-05,
    -1.7738630974152686e-05,
    -1.772002201102948e-05,
    -1.7700966263782363e-05,
    -1.768146502100887e-05,
    -1.7661519581413903e-05,
    -1.7641131253756496e-05,
    -1.76203013567965e-05,
    -1.759903121924115e-05,
    -1.757732217969119e-05,
    -1.7555175586587056e-05,
    -1.7532592798154766e-05,
    -1.750957518235161e-05,
    -1.748612411681165e-05,
    -1.7462240988791178e-05,
    -1.7437927195113753e-05,
    -1.7413184142115277e-05,
    -1.7388013245588786e-05,
    -1.7362415930729028e-05,
    -1.7336393632077056e-05,
    -1.7309947793464412e-05,
    -1.728307986795725e-05,
    -1.725579131780042e-05,
    -1.7228083614361073e-05,
    -1.7199958238072433e-05,
    -1.7171416678377236e-05,
    -1.7142460433670994e-05,
    -1.71130910112451e-05,
    -1.7083309927230034e-05,
    -1.7053118706537947e-05,
    -1.7022518882805487e-05,
    -1.6991511998336262e-05,
    -1.696009960404337e-05,
    -1.692828325939142e-05,
    -1.6896064532338815e-05,
    -1.686344499927962e-05,
    -1.683042624498536e-05,
    -1.6797009862546766e-05,
    -1.6763197453315232e-05,
    -1.6728990626844244e-05,
    -1.6694391000830657e-05,
    -1.665940020105582e-05,
    -1.6624019861326565e-05,
    -1.658825162341611e-05,
    -1.655209713700478e-05,
    -1.651555805962065e-05,
    -1.6478636056580073e-05,
    -1.6441332800928018e-05,
    -1.6403649973378347e-05,
    -1.6365589262254006e-05,
    -1.632715236342695e-05,
    -1.6288340980258244e-05,
    -1.6249156823537656e-05,
    -1.620960161142354e-05,
    -1.616967706938232e-05,
    -1.612938493012805e-05,
    -1.608872693356172e-05,
    -1.6047704826710614e-05,
    -1.6006320363667468e-05,
    -1.596457530552951e-05,
    -1.5922471420337538e-05,
    -1.58800104830147e-05,
    -1.5837194275305523e-05,
    -1.5794024585714298e-05,
    -1.5750503209443925e-05,
    -1.570663194833449e-05,
    -1.566241261080153e-05,
    -1.561784701177456e-05,
    -1.557293697263537e-05,
    -1.5527684321156072e-05,
    -1.5482090891437394e-05,
    -1.5436158523846806e-05,
    -1.538988906495621e-05,
    -1.534328436748011e-05,
    -1.5296346290213522e-05,
    -1.5249076697969427e-05,
    -1.5201477461516781e-05,
    -1.5153550457518104e-05,
    -1.5105297568466907e-05,
    -1.5056720682625445e-05,
    -1.5007821693962069e-05,
    -1.4958602502088557e-05,
    -1.4909065012197703e-05,
    -1.485921113500046e-05,
    -1.480904278666308e-05,
    -1.4758561888744676e-05,
    -1.4707770368134061e-05,
    -1.4656670156986928e-05,
    -1.4605263192663096e-05,
    -1.4553551417663324e-05,
    -1.4501536779566336e-05,
    -1.4449221230965977e-05,
    -1.4396606729407891e-05,
    -1.4343695237326408e-05,
    -1.4290488721981692e-05,
    -1.423698915539613e-05,
    -1.4183198514291488e-05,
    -1.4129118780025478e-05,
    -1.4074751938528547e-05,
    -1.4020099980240625e-05,
    -1.3965164900047794e-05,
    -1.390994869721894e-05,
    -1.3854453375342509e-05,
    -1.3798680942263009e-05,
    -1.374263341001778e-05,
    -1.3686312794773523e-05,
    -1.3629721116762926e-05,
    -1.357286040022134e-05,
    -1.3515732673323238e-05,
    -1.3458339968118934e-05,
    -1.3400684320471038e-05,
    -1.3342767769991222e-05,
    -1.328459235997663e-05,
    -1.3226160137346556e-05,
    -1.3167473152579042e-05,
    -1.3108533459647406e-05,
    -1.3049343115956996e-05,
    -1.2989904182281599e-05,
    -1.2930218722700277e-05,
    -1.2870288804533864e-05,
    -1.2810116498281688e-05,
    -1.2749703877558267e-05,
    -1.2689053019029925e-05,
    -1.2628166002351586e-05,
    -1.2567044910103402e-05,
    -1.2505691827727774e-05,
    -1.2444108843465702e-05,
    -1.2382298048293971e-05,
    -1.232026153586194e-05,
    -1.2258001402428185e-05,
    -1.2195519746797632e-05,
    -1.2132818670258544e-05,
    -1.2069900276519162e-05,
    -1.2006766671645057e-05,
    -1.1943419963996181e-05,
    -1.187986226416361e-05,
    -1.181609568490709e-05,
    -1.1752122341092081e-05,
    -1.1687944349626797e-05,
    -1.162356382939974e-05,
    -1.1558982901217052e-05,
    -1.1494203687739505e-05,
    -1.1429228313420492e-05,
    -1.1364058904443116e-05,
    -1.1298697588657721e-05,
    -1.1233146495519885e-05,
    -1.1167407756027695e-05,
    -1.1101483502659472e-05,
    -1.1035375869311966e-05,
    -1.0969086991237808e-05,
    -1.09026190049834e-05,
    -1.0835974048327366e-05,
    -1.0769154260218145e-05,
    -1.0702161780712208e-05,
    -1.0634998750912548e-05,
    -1.056766731290665e-05,
    -1.0500169609704858e-05,
    -1.0432507785179093e-05,
    -1.0364683984001093e-05,
    -1.0296700351581043e-05,
    -1.0228559034006421e-05,
    -1.0160262177980565e-05,
    -1.009181193076164e-05,
    -1.0023210440101538e-05,
    -9.954459854184931e-06,
    -9.885562321568357e-06,
    -9.816519991119457e-06,
    -9.747335011956292e-06,
    -9.678009533386673e-06,
    -9.60854570484777e-06,
    -9.538945675845653e-06,
    -9.469211595894943e-06,
    -9.399345614458725e-06,
    -9.32934988088837e-06,
    -9.259226544363563e-06,
    -9.18897775383243e-06,
    -9.118605657951771e-06,
    -9.048112405027369e-06,
    -8.977500142954472e-06,
    -8.906771019158288e-06,
    -8.835927180534763e-06,
    -8.764970773391259e-06,
    -8.69390394338756e-06,
    -8.622728835476807e-06,
    -8.55144759384671e-06,
    -8.480062361860794e-06,
    -8.408575281999785e-06,
    -8.336988495803145e-06,
    -8.265304143810671e-06,
    -8.193524365504301e-06,
    -8.121651299249988e-06,
    -8.049687082239907e-06,
    -7.977633850434166e-06,
    -7.905493738503566e-06,
    -7.833268879771968e-06,
    -7.76096140615846e-06,
    -7.688573448120513e-06,
    -7.616107134596778e-06,
    -7.54356459294967e-06,
    -7.470947948908924e-06,
    -7.3982593265148105e-06,
    -7.325500848061217e-06,
    -7.252674634039532e-06,
    -7.179782803082419e-06,
    -7.106827471907234e-06,
    -7.033810755260421e-06,
    -6.960734765861705e-06,
    -6.887601614347897e-06,
    -6.814413409218071e-06,
    -6.741172256777637e-06,
    -6.667880261083186e-06,
    -6.594539523887793e-06,
    -6.521152144585714e-06,
    -6.447720220157635e-06,
    -6.374245845116511e-06,
    -6.300731111452707e-06,
    -6.227178108579759e-06,
    -6.153588923280698e-06,
    -6.079965639653706e-06,
    -6.006310339058342e-06,
    -5.932625100062398e-06,
    -5.8589119983880745e-06,
    -5.785173106858689e-06,
    -5.711410495346062e-06,
    -5.63762623071716e-06,
    -5.563822376781579e-06,
    -5.4900009942389784e-06,
    -5.416164140626709e-06,
    -5.342313870267611e-06,
    -5.268452234218044e-06,
    -5.194581280216029e-06,
    -5.120703052629617e-06,
    -5.046819592405446e-06,
    -4.972932937017451e-06,
    -4.899045120415806e-06,
    -4.825158172975974e-06,
    -4.751274121448066e-06,
    -4.677394988906256e-06,
    -4.603522794698501e-06,
    -4.529659554396385e-06,
    -4.455807279745164e-06,
    -4.381967978614051e-06,
    -4.3081436549466276e-06,
    -4.234336308711498e-06,
    -4.1605479358531334e-06,
    -4.0867805282429164e-06,
    -4.013036073630357e-06,
    -3.9393165555945635e-06,
    -3.8656239534958385e-06,
    -3.7919602424275804e-06,
    -3.718327393168277e-06,
    -3.644727372133784e-06,
    -3.571162141329775e-06,
    -3.4976336583044267e-06,
    -3.4241438761012538e-06,
    -3.3506947432122195e-06,
    -3.2772882035309715e-06,
    -3.2039261963065845e-06,
    -3.1306106560967784e-06,
    -3.057343512722316e-06,
    -2.9841266912210988e-06,
    -2.9109621118021127e-06,
    -2.8378516898004296e-06,
    -2.764797335632e-06,
    -2.691800954748205e-06,
    -2.6188644475915334e-06,
    -2.54598970955102e-06,
    -2.4731786309174575e-06,
    -2.400433096839744e-06,
    -2.3277549872809594e-06,
    -2.2551461769742798e-06,
    -2.1826085353799542e-06,
    -2.110143926642085e-06,
    -2.0377542095451487e-06,
    -1.9654412374718954e-06,
    -1.8932068583603344e-06,
    -1.8210529146613986e-06,
    -1.7489812432973077e-06,
    -1.6769936756192762e-06,
    -1.6050920373658711e-06,
    -1.5332781486220702e-06,
    -1.4615538237776482e-06,
    -1.3899208714862541e-06,
    -1.3183810946251442e-06,
    -1.2469362902542888e-06,
    -1.1755882495761392e-06,
    -1.1043387578960751e-06,
    -1.033189594582208e-06,
    -9.621425330258693e-07,
    -8.911993406027652e-07,
    -8.203617786334459e-07,
    -7.496316023447512e-07,
    -6.790105608312e-07,
    -6.085003970166673e-07,
    -5.381028476163069e-07,
    -4.678196430987165e-07,
    -3.976525076483394e-07,
    -3.2760315912811884e-07,
    -2.576733090423893e-07,
    -1.878646625000178e-07,
    -1.1817891817778641e-07,
    -4.861776828402464e-08,
    2.0817101477513616e-08,
    9.012401194357277e-08,
    1.5930129052678202e-07,
    2.2834727125151463e-07,
    2.972602947885843e-07,
    3.660387084901237e-07,
    4.346808664246475e-07,
    5.031851294109953e-07,
    5.715498650524615e-07,
    6.39773447771097e-07,
    7.078542588409037e-07,
    7.757906864212032e-07,
    8.435811255901755e-07,
    9.112239783773004e-07,
    9.787176537959548e-07,
    1.0460605678761989e-06,
    1.1132511436964382e-06,
    1.1802878114152644e-06,
    1.2471690083034666e-06,
    1.3138931787749319e-06,
    1.3804587744177549e-06,
    1.4468642540252393e-06,
    1.5131080836264986e-06,
    1.5791887365163262e-06,
    1.6451046932856423e-06,
    1.7108544418512802e-06,
    1.7764364774850715e-06,
    1.8418493028435197e-06,
    1.9070914279967908e-06,
    1.9721613704570338e-06,
    2.0370576552072556e-06,
    2.1017788147295393e-06,
    2.166323389032563e-06,
    2.2306899256797044e-06,
    2.2948769798164558e-06,
    2.3588831141971655e-06,
    2.422706899212346e-06,
    2.486346912915296e-06,
    2.5498017410480556e-06,
    2.6130699770679196e-06,
    2.676150222173254e-06,
    2.7390410853286837e-06,
    2.8017411832907697e-06,
    2.8642491406330762e-06,
    2.9265635897705137e-06,
    2.988683170984262e-06,
    3.050606532445993e-06,
    3.1123323302414556e-06,
    3.173859228394577e-06,
    3.2351858988909248e-06,
    3.296311021700284e-06,
    3.3572332848003863e-06,
    3.417951384199133e-06,
    3.478464023956583e-06,
    3.538769916207883e-06,
    3.598867781184473e-06,
    3.658756347235684e-06,
    3.7184343508504564e-06,
    3.7779005366779217e-06,
    3.837153657548198e-06,
    3.896192474493236e-06,
    3.955015756766657e-06,
    4.01362228186371e-06,
    4.072010835541298e-06,
    4.130180211837037e-06,
    4.188129213088381e-06,
    4.245856649951854e-06,
    4.303361341421294e-06,
    4.36064211484615e-06,
    4.417697805949944e-06,
    4.474527258847664e-06,
    4.531129326063286e-06,
    4.587502868547392e-06,
    4.643646755693785e-06,
    4.6995598653561726e-06,
    4.755241083864994e-06,
    4.810689306043205e-06,
    4.865903435222183e-06,
    4.920882383257715e-06,
    4.9756250705449665e-06,
    5.030130426033603e-06,
    5.084397387242953e-06,
    5.1384249002761665e-06,
    5.192211919834538e-06,
    5.24575740923181e-06,
    5.299060340407617e-06,
    5.352119693940925e-06,
    5.4049344590634405e-06,
    5.457503633672525e-06,
    5.509826224343538e-06,
    5.561901246342565e-06,
    5.613727723638507e-06,
    5.665304688914612e-06,
    5.7166311835803935e-06,
    5.767706257782938e-06,
    5.818528970417578e-06,
    5.8690983891390475e-06,
    5.919413590371971e-06,
    5.9694736593207236e-06,
    6.019277689979799e-06,
    6.068824785143453e-06,
    6.118114056414827e-06,
    6.167144624215443e-06,
    6.215915617794083e-06,
    6.264426175235096e-06,
    6.3126754434671265e-06,
    6.360662578271128e-06,
    6.408386744287938e-06,
    6.455847115026113e-06,
    6.50304287286927e-06,
    6.549973209082768e-06,
    6.5966373238207805e-06,
    6.643034426132821e-06,
    6.689163733969661e-06,
    6.735024474189563e-06,
    6.78061588256412e-06,
    6.825937203783066e-06,
    6.870987691460262e-06,
    6.915766608138201e-06,
    6.960273225292371e-06,
    7.004506823336291e-06,
    7.048466691625197e-06,
    7.092152128459858e-06,
    7.135562441090542e-06,
    7.178696945720054e-06,
    7.221554967506757e-06,
    7.264135840567775e-06,
    7.306438907981145e-06,
    7.348463521788193e-06,
    7.390209042995848e-06,
    7.4316748415781e-06,
    7.472860296477547e-06,
    7.5137647956069095e-06,
    7.554387735849808e-06,
    7.594728523061406e-06,
    7.634786572069292e-06,
    7.674561306673338e-06,
    7.714052159645722e-06,
    7.753258572730898e-06,
    7.792179996644796e-06,
    7.830815891074038e-06,
    7.86916572467513e-06,
    7.907228975072919e-06,
    7.945005128859024e-06,
    7.982493681590304e-06,
    8.01969413778651e-06,
    8.056606010928002e-06,
    8.093228823453412e-06,
    8.129562106756621e-06,
    8.16560540118365e-06,
    8.201358256029518e-06,
    8.23682022953467e-06,
    8.271990888880924e-06,
    8.306869810187651e-06,
    8.34145657850748e-06,
    8.375750787821475e-06,
    8.409752041034556e-06,
    8.443459949970516e-06,
    8.476874135366406e-06,
    8.509994226867274e-06,
    8.542819863020388e-06,
    8.575350691268908e-06,
    8.607586367945939e-06,
    8.639526558267935e-06,
    8.671170936327764e-06,
    8.702519185087899e-06,
    8.733570996373194e-06,
    8.764326070863211e-06,
    8.794784118084645e-06,
    8.824944856403452e-06,
    8.854808013016364e-06,
    8.884373323942728e-06,
    8.913640534015803e-06,
    8.942609396873617e-06,
    8.97127967495011e-06,
    8.999651139465681e-06,
    9.027723570417396e-06,
    9.055496756569362e-06,
    9.082970495442636e-06,
    9.110144593304707e-06,
    9.137018865159173e-06,
    9.163593134734972e-06,
    9.189867234475086e-06,
    9.21584100552573e-06,
    9.241514297724611e-06,
    9.266886969589229e-06,
    9.291958888305209e-06,
    9.316729929713901e-06,
    9.341199978300062e-06,
    9.365368927179463e-06,
    9.38923667808581e-06,
    9.412803141357787e-06,
    9.436068235925974e-06,
    9.45903188929911e-06,
    9.481694037550476e-06,
    9.50405462530409e-06,
    9.52611360572038e-06,
    9.547870940481918e-06,
    9.569326599778885e-06,
    9.590480562294194e-06,
    9.611332815188433e-06,
    9.63188335408482e-06,
    9.652132183053587e-06,
    9.672079314596339e-06,
    9.691724769630346e-06,
    9.71106857747227e-06,
    9.730110775821896e-06,
    9.748851410745799e-06,
    9.767290536660461e-06,
    9.785428216315358e-06,
    9.803264520775935e-06,
    9.820799529406229e-06,
    9.838033329851201e-06,
    9.85496601801923e-06,
    9.871597698063974e-06,
    9.887928482366221e-06,
    9.903958491515662e-06,
    9.919687854292237e-06,
    9.93511670764735e-06,
    9.950245196684963e-06,
    9.965073474642498e-06,
    9.97960170287129e-06,
    9.993830050817228e-06,
    1.0007758696000928e-05,
    1.0021387823997742e-05,
    1.0034717628417703e-05,
    1.0047748310885163e-05,
    1.0060480081018207e-05,
    1.0072913156408032e-05,
    1.0085047762598012e-05,
    1.009688413306253e-05,
    1.010842250918574e-05,
    1.0119663140240197e-05,
    1.013060628336496e-05,
    1.0141252203543958e-05,
    1.015160117358391e-05,
    1.0161653474092016e-05,
    1.0171409393453626e-05,
    1.0180869227809758e-05,
    1.0190033281034083e-05,
    1.0198901864710224e-05,
    1.0207475298108584e-05,
    1.0215753908162908e-05,
    1.0223738029446955e-05,
    1.0231428004150834e-05,
    1.023882418205709e-05,
    1.0245926920516748e-05,
    1.0252736584425221e-05,
    1.0259253546197753e-05,
    1.0265478185745176e-05,
    1.027141089044899e-05,
    1.0277052055136592e-05,
    1.0282402082056309e-05,
    1.0287461380852126e-05,
    1.0292230368538325e-05,
    1.0296709469474005e-05,
    1.0300899115337438e-05,
    1.0304799745100046e-05,
    1.0308411805000602e-05,
    1.031173574851893e-05,
    1.0314772036349546e-05,
    1.0317521136375306e-05,
    1.0319983523640643e-05,
    1.0322159680324744e-05,
    1.0324050095714701e-05,
    1.0325655266178325e-05,
    1.032697569513683e-05,
    1.032801189303751e-05,
    1.0328764377326117e-05,
    1.0329233672419107e-05,
    1.0329420309675843e-05,
    1.0329324827370536e-05,
    1.0328947770664013e-05,
    1.032828969157557e-05,
    1.0327351148954306e-05,
    1.0326132708450676e-05,
    1.0324634942487713e-05,
    1.0322858430232075e-05,
    1.0320803757565109e-05,
    1.031847151705364e-05,
    1.0315862307920627e-05,
    1.0312976736015822e-05,
    1.0309815413786103e-05,
    1.0306378960245787e-05,
    1.0302668000946803e-05,
    1.0298683167948682e-05,
    1.0294425099788519e-05,
    1.0289894441450558e-05,
    1.0285091844336058e-05,
    1.028001796623259e-05,
    1.0274673471283527e-05,
    1.0269059029957247e-05,
    1.0263175319016256e-05,
    1.0257023021486187e-05,
    1.0250602826624697e-05,
    1.0243915429890184e-05,
    1.0236961532910466e-05,
    1.0229741843451225e-05,
    1.0222257075384468e-05,
    1.0214507948656768e-05,
    1.0206495189257475e-05,
    1.0198219529186658e-05,
    1.0189681706423184e-05,
    1.0180882464892388e-05,
    1.0171822554433903e-05,
    1.0162502730769188e-05,
    1.015292375546904e-05,
    1.0143086395920965e-05,
    1.013299142529647e-05,
    1.0122639622518237e-05,
    1.0112031772227137e-05,
    1.0101168664749268e-05,
    1.0090051096062721e-05,
    1.0078679867764427e-05,
    1.0067055787036749e-05,
    1.0055179666614063e-05,
    1.0043052324749236e-05,
    1.0030674585179965e-05,
    1.0018047277095018e-05,
    1.0005171235100475e-05,
    9.992047299185771e-06,
    9.978676314689665e-06,
    9.965059132266182e-06,
    9.951196607850358e-06,
    9.937089602624054e-06,
    9.922738982981476e-06,
    9.908145620494803e-06,
    9.893310391879639e-06,
    9.878234178960324e-06,
    9.862917868635315e-06,
    9.847362352842312e-06,
    9.831568528523463e-06,
    9.81553729759039e-06,
    9.799269566889158e-06,
    9.782766248165142e-06,
    9.76602825802793e-06,
    9.749056517915959e-06,
    9.731851954061301e-06,
    9.714415497454184e-06,
    9.696748083807533e-06,
    9.67885065352148e-06,
    9.660724151647688e-06,
    9.64236952785372e-06,
    9.623787736387243e-06,
    9.604979736040318e-06,
    9.585946490113396e-06,
    9.566688966379476e-06,
    9.547208137048085e-06,
    9.527504978729216e-06,
    9.50758047239715e-06,
    9.487435603354397e-06,
    9.467071361195384e-06,
    9.446488739770132e-06,
    9.425688737148013e-06,
    9.40467235558126e-06,
    9.383440601468528e-06,
    9.361994485318443e-06,
    9.340335021713032e-06,
    9.318463229271022e-06,
    9.296380130611344e-06,
    9.274086752316327e-06,
    9.251584124894963e-06,
    9.228873282746173e-06,
    9.205955264121929e-06,
    9.18283111109037e-06,
    9.159501869498957e-06,
    9.135968588937423e-06,
    9.11223232270083e-06,
    9.08829412775254e-06,
    9.064155064687138e-06,
    9.039816197693277e-06,
    9.015278594516682e-06,
    8.990543326422812e-06,
    8.965611468159709e-06,
    8.940484097920857e-06,
    8.915162297307804e-06,
    8.88964715129287e-06,
    8.863939748181954e-06,
    8.838041179577014e-06,
    8.81195254033878e-06,
    8.78567492854946e-06,
    8.759209445475102e-06,
    8.732557195528295e-06,
    8.705719286230755e-06,
    8.678696828175676e-06,
    8.651490934990374e-06,
    8.624102723298754e-06,
    8.59653331268367e-06,
    8.5687838256495e-06,
    8.540855387584579e-06,
    8.51274912672352e-06,
    8.484466174109674e-06,
    8.456007663557672e-06,
    8.427374731615571e-06,
    8.398568517527434e-06,
    8.369590163195644e-06,
    8.340440813143254e-06,
    8.311121614476367e-06,
    8.281633716846584e-06,
    8.251978272413182e-06,
    8.22215643580565e-06,
    8.19216936408601e-06,
    8.162018216711047e-06,
    8.131704155494832e-06,
    8.101228344571051e-06,
    8.070591950355255e-06,
    8.039796141507392e-06,
    8.008842088894126e-06,
    7.977730965551126e-06,
    7.946463946645587e-06,
    7.915042209438633e-06,
    7.883466933247656e-06,
    7.851739299408693e-06,
    7.819860491239065e-06,
    7.787831693999645e-06,
    7.755654094857323e-06,
    7.723328882847646e-06,
    7.690857248837148e-06,
    7.658240385485912e-06,
    7.62547948721018e-06,
    7.592575750144828e-06,
    7.559530372105894e-06,
    7.526344552553336e-06,
    7.493019492553528e-06,
    7.459556394741849e-06,
    7.425956463285555e-06,
    7.392220903846311e-06,
    7.358350923542881e-06,
    7.324347730914073e-06,
    7.29021253588134e-06,
    7.255946549711593e-06,
    7.221550984980221e-06,
    7.187027055533783e-06,
    7.152375976452895e-06,
    7.117598964015407e-06,
    7.082697235659136e-06,
    7.047672009944923e-06,
    7.01252450651985e-06,
    6.97725594608013e-06,
    6.941867550334308e-06,
    6.906360541966492e-06,
    6.870736144599492e-06,
    6.834995582758009e-06,
    6.799140081832203e-06,
    6.763170868040673e-06,
    6.7270891683940194e-06,
    6.6908962106584624e-06,
    6.654593223318919e-06,
    6.618181435542853e-06,
    6.581662077143786e-06,
    6.5450363785447934e-06,
    6.508305570742334e-06,
    6.471470885269983e-06,
    6.434533554162059e-06,
    6.397494809917614e-06,
    6.360355885464378e-06,
    6.323118014122465e-06,
    6.285782429568594e-06,
    6.248350365800191e-06,
    6.210823057099273e-06,
    6.173201737996823e-06,
    6.135487643237102e-06,
    6.097682007741672e-06,
    6.059786066574045e-06,
    6.02180105490406e-06,
    5.983728207972209e-06,
    5.9455687610543795e-06,
    5.907323949426524e-06,
    5.868995008329112e-06,
    5.830583172932139e-06,
    5.792089678299916e-06,
    5.753515759355817e-06,
    5.714862650847427e-06,
    5.676131587311603e-06,
    5.6373238030393695e-06,
    5.598440532041369e-06,
    5.559483008013049e-06,
    5.520452464299941e-06,
    5.481350133863047e-06,
    5.442177249244562e-06,
    5.402935042533221e-06,
    5.363624745329963e-06,
    5.324247588713868e-06,
    5.284804803207761e-06,
    5.245297618744108e-06,
    5.205727264631207e-06,
    5.16609496951902e-06,
    5.126401961365358e-06,
    5.086649467402264e-06,
    5.04683871410216e-06,
    5.006970927144227e-06,
    4.967047331381099e-06,
    4.9270691508052496e-06,
    4.887037608515638e-06,
    4.846953926684675e-06,
    4.806819326524858e-06,
    4.766635028255712e-06,
    4.726402251071029e-06,
    4.686122213105758e-06,
    4.645796131403239e-06,
    4.605425221882714e-06,
    4.565010699306526e-06,
    4.524553777247595e-06,
    4.48405566805727e-06,
    4.443517582832761e-06,
    4.40294073138495e-06,
    4.362326322206516e-06,
    4.3216755624396776e-06,
    4.280989657844279e-06,
    4.2402698127663125e-06,
    4.199517230105725e-06,
    4.158733111285167e-06,
    4.117918656218463e-06,
    4.07707506327898e-06,
    4.036203529268581e-06,
    3.995305249386429e-06,
    3.954381417197678e-06,
    3.9134332246027435e-06,
    3.872461861806422e-06,
    3.8314685172869e-06,
    3.7904543777653772e-06,
    3.749420628175485e-06,
    3.708368451632645e-06,
    3.6672990294039824e-06,
    3.6262135408781518e-06,
    3.585113163534964e-06,
    3.5439990729156755e-06,
    3.5028724425931214e-06,
    3.4617344441417152e-06,
    3.42058624710808e-06,
    3.3794290189814975e-06,
    3.3382639251642945e-06,
    3.297092128942786e-06,
    3.255914791458103e-06,
    3.214733071676925e-06,
    3.173548126362774e-06,
    3.1323611100471954e-06,
    3.0911731750008673e-06,
    3.0499854712052373e-06,
    3.00879914632408e-06,
    2.9676153456749568e-06,
    2.9264352122012236e-06,
    2.8852598864439466e-06,
    2.844090506513826e-06,
    2.8029282080633637e-06,
    2.7617741242593692e-06,
    2.7206293857551604e-06,
    2.679495120663099e-06,
    2.638372454527511e-06,
    2.5972625102972614e-06,
    2.5561664082986434e-06,
    2.515085266208721e-06,
    2.4740201990282533e-06,
    2.4329723190550037e-06,
    2.3919427358574417e-06,
    2.3509325562480787e-06,
    2.309942884257169e-06,
    2.268974821106786e-06,
    2.2280294651845695e-06,
    2.1871079120178153e-06,
    2.1462112542479607e-06,
    2.1053405816047202e-06,
    2.064496980880573e-06,
    2.0236815359056754e-06,
    1.9828953275223608e-06,
    1.942139433560074e-06,
    1.9014149288106557e-06,
    1.8607228850032828e-06,
    1.8200643707797907e-06,
    1.7794404516703719e-06,
    1.7388521900689375e-06,
    1.6983006452088483e-06,
    1.6577868731390305e-06,
    1.6173119266997477e-06,
    1.5768768554987335e-06,
    1.5364827058878551e-06,
    1.496130520939013e-06,
    1.455821340421095e-06,
    1.4155562007766623e-06,
    1.3753361350985704e-06,
    1.3351621731072115e-06,
    1.295035341127666e-06,
    1.2549566620667299e-06,
    1.2149271553906117e-06,
    1.1749478371024867e-06,
    1.1350197197199903e-06,
    1.0951438122533135e-06,
    1.0553211201832203e-06,
    1.0155526454389544e-06,
    9.758393863767835e-07,
    9.361823377584496e-07,
    8.965824907295157e-07,
    8.570408327983539e-07,
    8.175583478150262e-07,
    7.781360159500809e-07,
    7.387748136739799e-07,
    6.994757137364283e-07,
    6.602396851456107e-07,
    6.210676931480642e-07,
    5.819606992084553e-07,
    5.429196609892664e-07,
    5.039455323311156e-07,
    4.6503926323298156e-07,
    4.2620179983234334e-07,
    3.8743408438594867e-07,
    3.487370552504928e-07,
    3.101116468632107e-07,
    2.7155878972309946e-07,
    2.3307941037202497e-07,
    1.9467443137590252e-07,
    1.5634477130610892e-07,
    1.1809134472131363e-07,
    7.991506214898306e-08,
    4.1816830067278684e-08,
    3.79755088734598e-09,
    -3.414187706471967e-08,
    -7.200055956551445e-08,
    -1.0977760651157658e-07,
    -1.474721319369579e-07,
    -1.8508325403040135e-07,
    -2.2261009515213107e-07,
    -2.600517818509563e-07,
    -2.974074448809872e-07,
    -3.346762192179577e-07,
    -3.718572440758651e-07,
    -4.0894966292321886e-07,
    -4.459526234988954e-07,
    -4.828652778283126e-07,
    -5.196867822392071e-07,
    -5.564162973770253e-07,
    -5.930529882206255e-07,
    -6.295960240975851e-07,
    -6.660445786991247e-07,
    -7.023978300953362e-07,
    -7.386549607500216e-07,
    -7.748151575351477e-07,
    -8.108776117455977e-07,
    -8.468415191135418e-07,
    -8.827060798224144e-07,
    -9.184704985212001e-07,
    -9.541339843383494e-07,
    -9.896957508951646e-07,
    -1.0251550163198814e-06,
    -1.0605110032607346e-06,
    -1.0957629388992493e-06,
    -1.1309100549635683e-06,
    -1.1659515877411733e-06,
    -1.2008867780916681e-06,
    -1.2357148714596417e-06,
    -1.2704351178868998e-06,
    -1.3050467720247874e-06,
    -1.339549093146557e-06,
    -1.373941345159148e-06,
    -1.4082227966150124e-06,
    -1.4423927207240158e-06,
    -1.4764503953647365e-06,
    -1.5103951030958177e-06,
    -1.5442261311673964e-06,
    -1.5779427715319079e-06,
    -1.6115443208549821e-06,
    -1.645030080526383e-06,
    -1.6783993566703382e-06,
    -1.711651460155962e-06,
    -1.7447857066077062e-06,
    -1.7778014164152344e-06,
    -1.8106979147433438e-06,
    -1.843474531541949e-06,
    -1.8761306015554913e-06,
    -1.9086654643323598e-06,
    -1.941078464234424e-06,
    -1.973368950445932e-06,
    -2.0055362769824964e-06,
    -2.037579802700117e-06,
    -2.069498891303623e-06,
    -2.101292911355195e-06,
    -2.1329612362827965e-06,
    -2.1645032443883728e-06,
    -2.1959183188556733e-06,
    -2.2272058477583094e-06,
    -2.258365224067465e-06,
    -2.2893958456592365e-06,
    -2.3202971153222256e-06,
    -2.351068440764767e-06,
    -2.3817092346217885e-06,
    -2.41221891446195e-06,
    -2.4425969027943726e-06,
    -2.4728426270750497e-06,
    -2.5029555197134848e-06,
    -2.532935018078971e-06,
    -2.5627805645065224e-06,
    -2.592491606303035e-06,
    -2.622067595753101e-06,
    -2.6515079901244634e-06,
    -2.68081225167371e-06,
    -2.709979847651613e-06,
    -2.739010250308116e-06,
    -2.7679029368975596e-06,
    -2.7966573896835486e-06,
    -2.8252730959434712e-06,
    -2.8537495479732618e-06,
    -2.882086243091781e-06,
    -2.910282683644897e-06,
    -2.9383383770097507e-06,
    -2.9662528355987214e-06,
    -2.9940255768629115e-06,
    -3.02165612329617e-06,
    -3.049144002438383e-06,
    -3.076488746878581e-06,
    -3.1036898942585335e-06,
    -3.1307469872754367e-06,
    -3.1576595736848093e-06,
    -3.1844272063033566e-06,
    -3.2110494430113555e-06,
    -3.2375258467550433e-06,
    -3.263855985549039e-06,
    -3.2900394324782472e-06,
    -3.316075765699804e-06,
    -3.341964568445034e-06,
    -3.3677054290209082e-06,
    -3.3932979408115155e-06,
    -3.418741702279581e-06,
    -3.4440363169674586e-06,
    -3.4691813934981667e-06,
    -3.494176545576421e-06,
    -3.5190213919892035e-06,
    -3.543715556606336e-06,
    -3.5682586683810647e-06,
    -3.5926503613501725e-06,
    -3.6168902746341157e-06,
    -3.6409780524371448e-06,
    -3.6649133440469934e-06,
    -3.6886958038345333e-06,
    -3.712325091253492e-06,
    -3.735800870839651e-06,
    -3.759122812210114e-06,
    -3.7822905900625184e-06,
    -3.8053038841738416e-06,
    -3.828162379399211e-06,
    -3.850865765670617e-06,
    -3.873413737995435e-06,
    -3.89580599645464e-06,
    -3.9180422462011396e-06,
    -3.940122197457895e-06,
    -3.962045565515628e-06,
    -3.983812070730802e-06,
    -4.005421438523231e-06,
    -4.026873399373423e-06,
    -4.048167688820082e-06,
    -4.069304047457312e-06,
    -4.090282220931523e-06,
    -4.111101959938505e-06,
    -4.1317630202202016e-06,
    -4.15226516256122e-06,
    -4.172608152785437e-06,
    -4.192791761752382e-06,
    -4.212815765353294e-06,
    -4.232679944507349e-06,
    -4.252384085157593e-06,
    -4.2719279782665775e-06,
    -4.291311419812203e-06,
    -4.310534210783188e-06,
    -4.329596157174339e-06,
    -4.34849706998193e-06,
    -4.367236765198809e-06,
    -4.385815063809219e-06,
    -4.404231791783786e-06,
    -4.422486780074215e-06,
    -4.440579864607703e-06,
    -4.458510886281515e-06,
    -4.476279690957285e-06,
    -4.493886129454979e-06,
    -4.511330057547205e-06,
    -4.528611335952892e-06,
    -4.545729830331098e-06,
    -4.562685411274726e-06,
    -4.579477954303918e-06,
    -4.596107339859412e-06,
    -4.612573453295887e-06,
    -4.628876184874974e-06,
    -4.6450154297582024e-06,
    -4.66099108799996e-06,
    -4.676803064540116e-06,
    -4.692451269196568e-06,
    -4.707935616657867e-06,
    -4.72325602647538e-06,
    -4.738412423055511e-06,
    -4.753404735651902e-06,
    -4.768232898357262e-06,
    -4.782896850095185e-06,
    -4.797396534611971e-06,
    -4.811731900468077e-06,
    -4.825902901029573e-06,
    -4.839909494459579e-06,
    -4.853751643709352e-06,
    -4.867429316509376e-06,
    -4.880942485360405e-06,
    -4.89429112752424e-06,
    -4.907475225014382e-06,
    -4.920494764586771e-06,
    -4.933349737730152e-06,
    -4.946040140656406e-06,
    -4.958565974290927e-06,
    -4.970927244262592e-06,
    -4.9831239608938005e-06,
    -4.995156139190396e-06,
    -5.00702379883144e-06,
    -5.018726964158737e-06,
    -5.0302656641664935e-06,
    -5.041639932490751e-06,
    -5.052849807398532e-06,
    -5.0638953317771544e-06,
    -5.074776553123326e-06,
    -5.085493523531971e-06,
    -5.096046299685206e-06,
    -5.1064349428410426e-06,
    -5.116659518821945e-06,
    -5.126720098003422e-06,
    -5.136616755302424e-06,
    -5.146349570165557e-06,
    -5.155918626557359e-06,
    -5.165324012948363e-06,
    -5.174565822302977e-06,
    -5.1836441520674195e-06,
    -5.19255910415751e-06,
    -5.201310784946177e-06,
    -5.20989930525113e-06,
    -5.218324780322249e-06,
    -5.22658732982888e-06,
    -5.2346870778470995e-06,
    -5.2426241528468635e-06,
    -5.250398687678924e-06,
    -5.258010819561853e-06,
    -5.265460690068835e-06,
    -5.272748445114316e-06,
    -5.279874234940697e-06,
    -5.286838214104837e-06,
    -5.293640541464366e-06,
    -5.300281380164167e-06,
    -5.306760897622468e-06,
    -5.3130792655169845e-06,
    -5.319236659771003e-06,
    -5.325233260539246e-06,
    -5.331069252193697e-06,
    -5.336744823309405e-06,
    -5.3422601666500506e-06,
    -5.347615479153529e-06,
    -5.3528109619174325e-06,
    -5.357846820184356e-06,
    -5.362723263327183e-06,
    -5.367440504834309e-06,
    -5.371998762294675e-06,
    -5.376398257382778e-06,
    -5.3806392158436154e-06,
    -5.384721867477473e-06,
    -5.38864644612462e-06,
    -5.392413189650051e-06,
    -5.396022339927962e-06,
    -5.399474142826238e-06,
    -5.402768848190857e-06,
    -5.405906709830192e-06,
    -5.408887985499177e-06,
    -5.411712936883522e-06,
    -5.414381829583685e-06,
    -5.416894933098875e-06,
    -5.419252520810936e-06,
    -5.4214548699681605e-06,
    -5.4235022616689674e-06,
    -5.4253949808455995e-06,
    -5.4271333162476684e-06,
    -5.428717560425596e-06,
    -5.4301480097141156e-06,
    -5.431424964215511e-06,
    -5.432548727782921e-06,
    -5.4335196080035005e-06,
    -5.434337916181519e-06,
    -5.4350039673214026e-06,
    -5.43551808011067e-06,
    -5.4358805769028446e-06,
    -5.4360917837002e-06,
    -5.436152030136574e-06,
    -5.436061649459977e-06,
    -5.435820978515193e-06,
    -5.435430357726332e-06,
    -5.434890131079263e-06,
    -5.434200646103981e-06,
    -5.433362253856966e-06,
    -5.432375308903406e-06,
    -5.431240169299374e-06,
    -5.4299571965739765e-06,
    -5.428526755711375e-06,
    -5.426949215132788e-06,
    -5.42522494667839e-06,
    -5.423354325589235e-06,
    -5.421337730488976e-06,
    -5.419175543365634e-06,
    -5.416868149553302e-06,
    -5.4144159377136895e-06,
    -5.411819299817743e-06,
    -5.409078631127099e-06,
    -5.406194330175526e-06,
    -5.403166798750314e-06,
    -5.399996441873599e-06,
    -5.396683667783585e-06,
    -5.393228887915795e-06,
    -5.389632516884217e-06,
    -5.385894972462372e-06,
    -5.382016675564388e-06,
    -5.377998050225987e-06,
    -5.373839523585393e-06,
    -5.3695415258642664e-06,
    -5.365104490348486e-06,
    -5.360528853368962e-06,
    -5.355815054282384e-06,
    -5.3509635354518705e-06,
    -5.3459747422276225e-06,
    -5.3408491229275145e-06,
    -5.335587128817625e-06,
    -5.330189214092756e-06,
    -5.324655835856848e-06,
    -5.318987454103403e-06,
    -5.313184531695843e-06,
    -5.307247534347818e-06,
    -5.301176930603498e-06,
    -5.294973191817764e-06,
    -5.288636792136443e-06,
    -5.282168208476421e-06,
    -5.275567920505766e-06,
    -5.268836410623781e-06,
    -5.261974163941066e-06,
    -5.254981668259454e-06,
    -5.2478594140520075e-06,
    -5.2406078944429215e-06,
    -5.233227605187396e-06,
    -5.225719044651475e-06,
    -5.218082713791874e-06,
    -5.210319116135733e-06,
    -5.202428757760375e-06,
    -5.194412147272993e-06,
    -5.186269795790339e-06,
    -5.178002216918368e-06,
    -5.1696099267318435e-06,
    -5.161093443753929e-06,
    -5.152453288935735e-06,
    -5.1436899856358236e-06,
    -5.134804059599754e-06,
    -5.125796038939517e-06,
    -5.11666645411294e-06,
    -5.10741583790319e-06,
    -5.098044725398092e-06,
    -5.088553653969508e-06,
    -5.078943163252709e-06,
    -5.0692137951256496e-06,
    -5.059366093688287e-06,
    -5.049400605241851e-06,
    -5.039317878268087e-06,
    -5.029118463408485e-06,
    -5.018802913443498e-06,
    -5.008371783271739e-06,
    -4.997825629889103e-06,
    -4.987165012368003e-06,
    -4.976390491836435e-06,
    -4.9655026314571005e-06,
    -4.954501996406573e-06,
    -4.943389153854312e-06,
    -4.932164672941752e-06,
    -4.920829124761412e-06,
    -4.909383082335859e-06,
    -4.897827120596782e-06,
    -4.886161816364046e-06,
    -4.874387748324616e-06,
    -4.8625054970116115e-06,
    -4.850515644783291e-06,
    -4.83841877580201e-06,
    -4.8262154760131725e-06,
    -4.813906333124259e-06,
    -4.801491936583681e-06,
    -4.7889728775598015e-06,
    -4.77634974891985e-06,
    -4.763623145208834e-06,
    -4.750793662628486e-06,
    -4.737861899016212e-06,
    -4.724828453823936e-06,
    -4.711693928097094e-06,
    -4.6984589244535e-06,
    -4.685124047062282e-06,
    -4.6716899016227515e-06,
    -4.658157095343396e-06,
    -4.644526236920672e-06,
    -4.630797936518026e-06,
    -4.616972805744738e-06,
    -4.60305145763484e-06,
    -4.58903450662607e-06,
    -4.574922568538764e-06,
    -4.5607162605547646e-06,
    -4.546416201196358e-06,
    -4.532023010305252e-06,
    -4.51753730902143e-06,
    -4.50295971976215e-06,
    -4.488290866200916e-06,
    -4.473531373246361e-06,
    -4.458681867021267e-06,
    -4.4437429748415685e-06,
    -4.428715325195252e-06,
    -4.41359954772141e-06,
    -4.3983962731892556e-06,
    -4.38310613347711e-06,
    -4.3677297615514045e-06,
    -4.352267791445812e-06,
    -4.336720858240213e-06,
    -4.321089598039777e-06,
    -4.305374647954108e-06,
    -4.289576646076265e-06,
    -4.273696231461884e-06,
    -4.257734044108382e-06,
    -4.2416907249340065e-06,
    -4.225566915757019e-06,
    -4.209363259274947e-06,
    -4.1930803990436835e-06,
    -4.176718979456747e-06,
    -4.1602796457245575e-06,
    -4.143763043853624e-06,
    -4.12716982062583e-06,
    -4.1105006235778096e-06,
    -4.093756100980182e-06,
    -4.076936901816915e-06,
    -4.060043675764729e-06,
    -4.0430770731724615e-06,
    -4.026037745040431e-06,
    -4.0089263429999985e-06,
    -3.991743519292903e-06,
    -3.974489926750816e-06,
    -3.957166218774897e-06,
    -3.939773049315226e-06,
    -3.922311072850436e-06,
    -3.904780944367394e-06,
    -3.887183319340671e-06,
    -3.869518853712296e-06,
    -3.851788203871461e-06,
    -3.833992026634151e-06,
    -3.816130979222973e-06,
    -3.798205719246918e-06,
    -3.7802169046811324e-06,
    -3.762165193846801e-06,
    -3.744051245391056e-06,
    -3.7258757182667823e-06,
    -3.7076392717126627e-06,
    -3.6893425652331506e-06,
    -3.670986258578407e-06,
    -3.652571011724414e-06,
    -3.634097484853107e-06,
    -3.6155663383323637e-06,
    -3.5969782326962834e-06,
    -3.5783338286253805e-06,
    -3.5596337869267215e-06,
    -3.5408787685143056e-06,
    -3.5220694343893772e-06,
    -3.503206445620686e-06,
    -3.484290463324975e-06,
    -3.4653221486474275e-06,
    -3.4463021627420296e-06,
    -3.4272311667522285e-06,
    -3.40810982179144e-06,
    -3.388938788923608e-06,
    -3.36971872914391e-06,
    -3.3504503033594776e-06,
    -3.33113417237005e-06,
    -3.3117709968487944e-06,
    -3.2923614373231856e-06,
    -3.272906154155808e-06,
    -3.2534058075252706e-06,
    -3.233861057407275e-06,
    -3.214272563555521e-06,
    -3.1946409854827764e-06,
    -3.1749669824420864e-06,
    -3.15525121340784e-06,
    -3.1354943370569634e-06,
    -3.115697011750285e-06,
    -3.095859895513757e-06,
    -3.0759836460197757e-06,
    -3.0560689205687498e-06,
    -3.03611637607041e-06,
    -3.0161266690253406e-06,
    -2.9961004555066537e-06,
    -2.9760383911414985e-06,
    -2.955941131092727e-06,
    -2.9358093300407347e-06,
    -2.9156436421651327e-06,
    -2.895444721126579e-06,
    -2.8752132200487744e-06,
    -2.854949791500299e-06,
    -2.8346550874766165e-06,
    -2.814329759382239e-06,
    -2.7939744580127323e-06,
    -2.7735898335368845e-06,
    -2.7531765354790436e-06,
    -2.7327352127013026e-06,
    -2.7122665133858098e-06,
    -2.6917710850173763e-06,
    -2.671249574365671e-06,
    -2.650702627467917e-06,
    -2.6301308896114775e-06,
    -2.609535005316367e-06,
    -2.5889156183180816e-06,
    -2.5682733715503543e-06,
    -2.5476089071278907e-06,
    -2.5269228663293307e-06,
    -2.506215889580247e-06,
    -2.4854886164360068e-06,
    -2.464741685564986e-06,
    -2.443975734731706e-06,
    -2.423191400779916e-06,
    -2.402389319615982e-06,
    -2.381570126192228e-06,
    -2.360734454490201e-06,
    -2.3398829375042773e-06,
    -2.3190162072251627e-06,
    -2.2981348946234025e-06,
    -2.277239629633133e-06,
    -2.2563310411358295e-06,
    -2.2354097569439814e-06,
    -2.2144764037850706e-06,
    -2.193531607285508e-06,
    -2.1725759919545104e-06,
    -2.1516101811682947e-06,
    -2.130634797154213e-06,
    -2.109650460974839e-06,
    -2.0886577925123603e-06,
    -2.0676574104529424e-06,
    -2.0466499322709996e-06,
    -2.025635974213827e-06,
    -2.0046161512861304e-06,
    -1.9835910772346032e-06,
    -1.962561364532627e-06,
    -1.941527624365147e-06,
    -1.920490466613409e-06,
    -1.8994504998398748e-06,
    -1.878408331273324e-06,
    -1.8573645667938128e-06,
    -1.836319810917794e-06,
    -1.8152746667834602e-06,
    -1.794229736135898e-06,
    -1.7731856193124584e-06,
    -1.752142915228296e-06,
    -1.7311022213617616e-06,
    -1.7100641337399938e-06,
    -1.6890292469246822e-06,
    -1.6679981539976904e-06,
    -1.646971446546866e-06,
    -1.6259497146520416e-06,
    -1.6049335468708776e-06,
    -1.5839235302249055e-06,
    -1.5629202501857605e-06,
    -1.5419242906612545e-06,
    -1.5209362339816466e-06,
    -1.4999566608861127e-06,
    -1.478986150509049e-06,
    -1.4580252803665762e-06,
    -1.4370746263432487e-06,
    -1.4161347626785875e-06,
    -1.395206261953826e-06,
    -1.37428969507885e-06,
    -1.353385631278971e-06,
    -1.332494638081898e-06,
    -1.3116172813049774e-06,
    -1.2907541250420718e-06,
    -1.269905731650953e-06,
    -1.2490726617406067e-06,
    -1.2282554741584725e-06,
    -1.2074547259780398e-06,
    -1.1866709724863817e-06,
    -1.165904767171661e-06,
    -1.1451566617109568e-06,
    -1.1244272059580496e-06,
    -1.1037169479311667e-06,
    -1.0830264338010614e-06,
    -1.062356207879037e-06,
    -1.041706812604951e-06,
    -1.0210787885355209e-06,
    -1.0004726743326254e-06,
    -9.798890067515265e-07,
    -9.59328320629451e-07,
    -9.387911488741201e-07,
    -9.182780224522376e-07,
    -8.977894703783146e-07,
    -8.773260197034486e-07,
    -8.568881955040684e-07,
    -8.364765208710092e-07,
    -8.160915168985427e-07,
    -7.957337026733793e-07,
    -7.754035952639888e-07,
    -7.551017097098966e-07,
    -7.348285590109272e-07,
    -7.145846541167903e-07,
    -6.943705039166239e-07,
    -6.741866152285018e-07,
    -6.540334927892702e-07,
    -6.339116392443362e-07,
    -6.138215551374975e-07,
    -5.937637389009041e-07,
    -5.737386868452375e-07,
    -5.537468931497317e-07,
    -5.337888498524078e-07,
    -5.138650468405079e-07,
    -4.939759718407834e-07,
    -4.7412211040997786e-07,
    -4.5430394592553093e-07,
    -4.3452195957611816e-07,
    -4.1477663035240225e-07,
    -3.950684350379908e-07,
    -3.753978482002407e-07,
    -3.5576534218127e-07,
    -3.361713870891763e-07,
    -3.1661645078910307e-07,
    -2.9710099889451465e-07,
    -2.776254947586736e-07,
    -2.581903994659744e-07,
    -2.387961718234761e-07,
    -2.1944326835264653e-07,
    -2.0013214328095566e-07,
    -1.8086324853367403e-07,
    -1.6163703372587928e-07,
    -1.4245394615431307e-07,
    -1.2331443078944377e-07,
    -1.0421893026773659e-07,
    -8.516788488377484e-08,
    -6.616173258258658e-08,
    -4.7200908952179466e-08,
    -2.8285847215925947e-08,
    -9.416978225142521e-09,
    9.40526954804644e-09,
    2.8180470018201903e-08,
    4.6908199493529656e-08,
    6.558803668294832e-08,
    8.421956270317255e-08,
    1.0280236108547373e-07,
    1.2133601778246908e-07,
    1.3982012117493968e-07,
    1.58254262078326e-07,
    1.7663803374925166e-07,
    1.949710318920752e-07,
    2.132528546651217e-07,
    2.314831026869401e-07,
    2.496613790425895e-07,
    2.677872892896052e-07,
    2.858604414639916e-07,
    3.038804460862423e-07,
    3.218469161670407e-07,
    3.397594672129885e-07,
    3.576177172323584e-07,
    3.754212867405323e-07,
    3.931697987654617e-07,
    4.1086287885315787e-07,
    4.285001550728642e-07,
    4.4608125802225144e-07,
    4.636058208326414e-07,
    4.81073479173917e-07,
    4.984838712594523e-07,
    5.158366378510718e-07,
    5.331314222636941e-07,
    5.503678703700007e-07,
    5.675456306051298e-07,
    5.846643539710536e-07,
    6.017236940410014e-07,
    6.187233069638202e-07,
    6.356628514682231e-07,
    6.525419888668115e-07,
    6.693603830602473e-07,
    6.861177005412156e-07,
    7.028136103981938e-07,
    7.194477843193536e-07,
    7.360198965962654e-07,
    7.525296241274032e-07,
    7.689766464217873e-07,
    7.853606456024255e-07,
    8.016813064095568e-07,
    8.179383162040339e-07,
    8.341313649704997e-07,
    8.502601453203792e-07,
    8.663243524949907e-07,
    8.823236843684722e-07,
    8.982578414505041e-07,
    9.141265268891734e-07,
    9.299294464736261e-07,
    9.456663086365453e-07,
    9.61336824456746e-07,
    9.769407076615762e-07,
    9.924776746291366e-07,
    1.0079474443906133e-06,
    1.0233497386324266e-06,
    1.0386842816981935e-06,
    1.0539508005907994e-06,
    1.0691490249743126e-06,
    1.0842786871756192e-06,
    1.0993395221863703e-06,
    1.1143312676645114e-06,
    1.129253663935736e-06,
    1.1441064539951667e-06,
    1.1588893835085782e-06,
    1.1736022008137117e-06,
    1.188244656921592e-06,
    1.2028165055175477e-06,
    1.2173175029622745e-06,
    1.2317474082928886e-06,
    1.2461059832237046e-06,
    1.2603929921470407e-06,
    1.2746082021340298e-06,
    1.2887513829351433e-06,
    1.3028223069807505e-06,
    1.3168207493816754e-06,
    1.330746487929483e-06,
    1.3445993030967785e-06,
    1.3583789780375273e-06,
    1.372085298587087e-06,
    1.38571805326227e-06,
    1.3992770332614055e-06,
    1.4127620324641416e-06,
    1.426172847431252e-06,
    1.4395092774044555e-06,
    1.4527711243059785e-06,
    1.4659581927381227e-06,
    1.4790702899828336e-06,
    1.492107226001028e-06,
    1.5050688134319123e-06,
    1.5179548675923278e-06,
    1.5307652064758176e-06,
    1.54349965075172e-06,
    1.5561580237642716e-06,
    1.568740151531435e-06,
    1.5812458627437688e-06,
    1.5936749887632309e-06,
    1.6060273636218907e-06,
    1.6183028240204477e-06,
    1.6305012093268627e-06,
    1.6426223615748112e-06,
    1.6546661254619765e-06,
    1.6666323483484485e-06,
    1.6785208802549485e-06,
    1.6903315738608836e-06,
    1.7020642845025216e-06,
    1.7137188701709743e-06,
    1.7252951915100399e-06,
    1.7367931118141267e-06,
    1.7482124970260348e-06,
    1.7595532157345367e-06,
    1.7708151391721593e-06,
    1.7819981412125692e-06,
    1.7931020983681216e-06,
    1.8041268897872731e-06,
    1.8150723972518772e-06,
    1.8259385051743679e-06,
    1.8367251005950548e-06,
    1.8474320731791118e-06,
    1.8580593152136293e-06,
    1.8686067216046273e-06,
    1.8790741898738833e-06,
    1.889461620155689e-06,
    1.8997689151937126e-06,
    1.9099959803375305e-06,
    1.9201427235392755e-06,
    1.9302090553501927e-06,
    1.9401948889170463e-06,
    1.95010013997846e-06,
    1.9599247268612675e-06,
    1.969668570476798e-06,
    1.9793315943169118e-06,
    1.9889137244502268e-06,
    1.998414889518086e-06,
    2.0078350207304863e-06,
    2.017174051861998e-06,
    2.0264319192476322e-06,
    2.0356085617784805e-06,
    2.044703920897507e-06,
    2.0537179405951167e-06,
    2.0626505674046743e-06,
    2.0715017503980066e-06,
    2.0802714411808744e-06,
    2.0889595938882065e-06,
    2.09756616517947e-06,
    2.1060911142338707e-06,
    2.114534402745443e-06,
    2.1228959949181707e-06,
    2.1311758574610625e-06,
    2.1393739595829733e-06,
    2.14749027298762e-06,
    2.155524771868351e-06,
    2.1634774329028706e-06,
    2.1713482352479736e-06,
    2.1791371605342137e-06,
    2.1868441928603803e-06,
    2.194469318788097e-06,
    2.202012527336235e-06,
    2.2094738099752034e-06,
    2.21685316062144e-06,
    2.224150575631559e-06,
    2.2313660537965294e-06,
    2.2384995963359117e-06,
    2.245551206891822e-06,
    2.252520891523013e-06,
    2.2594086586988308e-06,
    2.2662145192930944e-06,
    2.2729384865779072e-06,
    2.279580576217497e-06,
    2.2861408062618687e-06,
    2.2926191971404948e-06,
    2.2990157716559365e-06,
    2.3053305549773835e-06,
    2.311563574634079e-06,
    2.3177148605088576e-06,
    2.3237844448314242e-06,
    2.329772362171708e-06,
    2.3356786494331547e-06,
    2.3415033458458976e-06,
    2.3472464929598893e-06,
    2.3529081346380666e-06,
    2.3584883170493103e-06,
    2.3639870886614776e-06,
    2.3694045002343464e-06,
    2.3747406048124785e-06,
    2.3799954577180176e-06,
    2.385169116543521e-06,
    2.3902616411446223e-06,
    2.3952730936327314e-06,
    2.400203538367656e-06,
    2.4050530419501692e-06,
    2.4098216732144738e-06,
    2.4145095032207243e-06,
    2.419116605247427e-06,
    2.423643054783767e-06,
    2.428088929521966e-06,
    2.4324543093495296e-06,
    2.4367392763414437e-06,
    2.4409439147523457e-06,
    2.4450683110086855e-06,
    2.449112553700712e-06,
    2.4530767335745755e-06,
    2.4569609435242717e-06,
    2.460765278583531e-06,
    2.464489835917746e-06,
    2.4681347148158097e-06,
    2.471700016681856e-06,
    2.475185845027056e-06,
    2.4785923054612867e-06,
    2.4819195056847853e-06,
    2.485167555479743e-06,
    2.4883365667019238e-06,
    2.491426653272119e-06,
    2.4944379311676645e-06,
    2.4973705184138798e-06,
    2.5002245350754164e-06,
    2.5030001032476433e-06,
    2.5056973470479643e-06,
    2.5083163926070447e-06,
    2.510857368060067e-06,
    2.5133204035379105e-06,
    2.515705631158281e-06,
    2.518013185016816e-06,
    2.5202432011781792e-06,
    2.522395817667036e-06,
    2.52447117445909e-06,
    2.5264694134719835e-06,
    2.5283906785562326e-06,
    2.530235115486095e-06,
    2.532002871950424e-06,
    2.5336940975433963e-06,
    2.5353089437553654e-06,
    2.536847563963507e-06,
    2.5383101134225433e-06,
    2.539696749255395e-06,
    2.5410076304437994e-06,
    2.5422429178188586e-06,
    2.543402774051646e-06,
    2.5444873636436633e-06,
    2.545496852917336e-06,
    2.5464314100064905e-06,
    2.547291204846737e-06,
    2.548076409165838e-06,
    2.548787196474098e-06,
    2.5494237420546387e-06,
    2.5499862229537065e-06,
    2.5504748179709297e-06,
    2.5508897076495257e-06,
    2.5512310742664983e-06,
    2.5514991018228163e-06,
    2.551693976033519e-06,
    2.5518158843178393e-06,
    2.5518650157892762e-06,
    2.551841561245651e-06,
    2.5517457131590925e-06,
    2.5515776656660678e-06,
    2.551337614557315e-06,
    2.5510257572677996e-06,
    2.5506422928666094e-06,
    2.5501874220468634e-06,
    2.5496613471155306e-06,
    2.5490642719832926e-06,
    2.5483964021543467e-06,
    2.5476579447161715e-06,
    2.5468491083293126e-06,
    2.5459701032170864e-06,
    2.5450211411553235e-06,
    2.5440024354620173e-06,
    2.54291420098703e-06,
    2.5417566541016986e-06,
    2.5405300126884782e-06,
    2.5392344961305375e-06,
    2.5378703253013257e-06,
    2.5364377225541326e-06,
    2.534936911711635e-06,
    2.5333681180553933e-06,
    2.5317315683153635e-06,
    2.5300274906593646e-06,
    2.5282561146825394e-06,
    2.5264176713967904e-06,
    2.524512393220195e-06,
    2.522540513966421e-06,
    2.520502268834104e-06,
    2.5183978943962023e-06,
    2.5162276285893698e-06,
    2.5139917107032777e-06,
    2.5116903813699257e-06,
    2.5093238825529608e-06,
    2.50689245753695e-06,
    2.504396350916657e-06,
    2.5018358085863067e-06,
    2.499211077728814e-06,
    2.496522406805019e-06,
    2.4937700455429124e-06,
    2.4909542449268213e-06,
    2.488075257186605e-06,
    2.4851333357868433e-06,
    2.48212873541599e-06,
    2.4790617119755196e-06,
    2.475932522569094e-06,
    2.472741425491669e-06,
    2.469488680218627e-06,
    2.466174547394893e-06,
    2.4627992888240207e-06,
    2.459363167457298e-06,
    2.455866447382821e-06,
    2.452309393814565e-06,
    2.4486922730814623e-06,
    2.4450153526164508e-06,
    2.4412789009455216e-06,
    2.4374831876767692e-06,
    2.4336284834894173e-06,
    2.429715060122852e-06,
    2.425743190365648e-06,
    2.4217131480445873e-06,
    2.4176252080136617e-06,
    2.4134796461430752e-06,
    2.409276739308269e-06,
    2.405016765378886e-06,
    2.4007000032077957e-06,
    2.3963267326200614e-06,
    2.391897234401936e-06,
    2.387411790289838e-06,
    2.382870682959341e-06,
    2.3782741960141435e-06,
    2.373622613975052e-06,
    2.36891622226895e-06,
    2.364155307217778e-06,
    2.359340156027489e-06,
    2.3544710567770503e-06,
    2.3495482984073858e-06,
    2.3445721707103587e-06,
    2.339542964317756e-06,
    2.334460970690244e-06,
    2.329326482106343e-06,
    2.3241397916514225e-06,
    2.318901193206662e-06,
    2.3136109814380326e-06,
    2.308269451785288e-06,
    2.3028769004509384e-06,
    2.2974336243892496e-06,
    2.2919399212952345e-06,
    2.2863960895936485e-06,
    2.2808024284279767e-06,
    2.275159237649465e-06,
    2.269466817806109e-06,
    2.2637254701316716e-06,
    2.257935496534719e-06,
    2.252097199587641e-06,
    2.2462108825156644e-06,
    2.240276849185933e-06,
    2.234295404096506e-06,
    2.2282668523654536e-06,
    2.2221914997199114e-06,
    2.2160696524851172e-06,
    2.2099016175735227e-06,
    2.2036877024738813e-06,
    2.197428215240314e-06,
    2.191123464481444e-06,
    2.1847737593494994e-06,
    2.178379409529431e-06,
    2.171940725228046e-06,
    2.1654580171631774e-06,
    2.1589315965527953e-06,
    2.1523617751042247e-06,
    2.145748865003287e-06,
    2.1390931789034907e-06,
    2.1323950299152498e-06,
    2.125654731595102e-06,
    2.118872597934899e-06,
    2.1120489433510922e-06,
    2.1051840826739725e-06,
    2.0982783311369036e-06,
    2.0913320043656424e-06,
    2.084345418367632e-06,
    2.077318889521279e-06,
    2.070252734565314e-06,
    2.063147270588124e-06,
    2.056002815017077e-06,
    2.0488196856079214e-06,
    2.0415982004341835e-06,
    2.034338677876526e-06,
    2.027041436612221e-06,
    2.0197067956045555e-06,
    2.0123350740922776e-06,
    2.0049265915790885e-06,
    1.9974816678231327e-06,
    1.9900006228264805e-06,
    1.982483776824683e-06,
    1.9749314502763135e-06,
    1.967343963852497e-06,
    1.9597216384265213e-06,
    1.9520647950634464e-06,
    1.944373755009717e-06,
    1.936648839682783e-06,
    1.9288903706608067e-06,
    1.921098669672297e-06,
    1.9132740585858415e-06,
    1.9054168593998352e-06,
    1.8975273942322258e-06,
    1.889605985310248e-06,
    1.881652954960277e-06,
    1.8736686255975747e-06,
    1.8656533197161625e-06,
    1.8576073598786835e-06,
    1.8495310687062788e-06,
    1.8414247688684562e-06,
    1.8332887830730856e-06,
    1.8251234340562862e-06,
    1.8169290445724372e-06,
    1.80870593738418e-06,
    1.800454435252442e-06,
    1.7921748609264546e-06,
    1.7838675371338861e-06,
    1.7755327865708935e-06,
    1.7671709318922568e-06,
    1.7587822957015682e-06,
    1.7503672005413807e-06,
    1.7419259688833871e-06,
    1.7334589231187294e-06,
    1.7249663855481761e-06,
    1.7164486783724296e-06,
    1.7079061236825161e-06,
    1.6993390434500075e-06,
    1.6907477595174498e-06,
    1.6821325935887899e-06,
    1.6734938672197358e-06,
    1.6648319018082642e-06,
    1.6561470185850831e-06,
    1.6474395386041307e-06,
    1.6387097827331267e-06,
    1.629958071644176e-06,
    1.6211847258043035e-06,
    1.6123900654661503e-06,
    1.6035744106586057e-06,
    1.5947380811774798e-06,
    1.585881396576249e-06,
    1.5770046761568306e-06,
    1.5681082389603061e-06,
    1.5591924037578026e-06,
    1.5502574890413082e-06,
    1.541303813014534e-06,
    1.532331693583844e-06,
    1.5233414483492288e-06,
    1.5143333945952082e-06,
    1.5053078492819178e-06,
    1.4962651290361052e-06,
    1.487205550142201e-06,
    1.4781294285334308e-06,
    1.4690370797829991e-06,
    1.459928819095179e-06,
    1.4508049612966107e-06,
    1.4416658208274894e-06,
    1.432511711732843e-06,
    1.4233429476538466e-06,
    1.4141598418191997e-06,
    1.4049627070364813e-06,
    1.3957518556835342e-06,
    1.3865275996999925e-06,
    1.377290250578682e-06,
    1.3680401193571917e-06,
    1.3587775166094376e-06,
    1.3495027524372348e-06,
    1.3402161364619084e-06,
    1.330917977816018e-06,
    1.3216085851349932e-06,
    1.3122882665489033e-06,
    1.3029573296742503e-06,
    1.2936160816057664e-06,
    1.2842648289082294e-06,
    1.2749038776084151e-06,
    1.2655335331869645e-06,
    1.2561541005703641e-06,
    1.2467658841229716e-06,
    1.2373691876390325e-06,
    1.2279643143347276e-06,
    1.2185515668403561e-06,
    1.2091312471924177e-06,
    1.1997036568258322e-06,
    1.1902690965662e-06,
    1.1808278666220382e-06,
    1.1713802665770676e-06,
    1.1619265953826294e-06,
    1.1524671513499975e-06,
    1.143002232142828e-06,
    1.1335321347697038e-06,
    1.1240571555765013e-06,
    1.1145775902390286e-06,
    1.1050937337556168e-06,
    1.095605880439679e-06,
    1.0861143239124532e-06,
    1.0766193570956758e-06,
    1.0671212722043065e-06,
    1.057620360739343e-06,
    1.0481169134806813e-06,
    1.0386112204799074e-06,
    1.0291035710532912e-06,
    1.0195942537747043e-06,
    1.0100835564685927e-06,
    1.0005717662030345e-06,
    9.910591692828577e-07,
    9.815460512426704e-07,
    9.720326968401154e-07,
    9.625193900490234e-07,
    9.53006414052655e-07,
    9.434940512369987e-07,
    9.339825831841369e-07,
    9.244722906655469e-07,
    9.149634536355913e-07,
    9.054563512249395e-07,
    8.959512617340518e-07,
    8.864484626267437e-07,
    8.769482305238103e-07,
    8.674508411965705e-07,
    8.579565695606276e-07,
    8.484656896695471e-07,
    8.389784747085971e-07,
    8.294951969885719e-07,
    8.200161279396681e-07,
    8.105415381053448e-07,
    8.010716971362305e-07,
    7.91606873784181e-07,
    7.821473358962179e-07,
    7.726933504086346e-07,
    7.632451833411284e-07,
    7.538030997909323e-07,
    7.44367363926978e-07,
    7.349382389842236e-07,
    7.255159872578602e-07,
    7.161008700976762e-07,
    7.066931479024607e-07,
    6.972930801144033e-07,
    6.879009252135203e-07,
    6.785169407122526e-07,
    6.691413831499381e-07,
    6.597745080874497e-07,
    6.50416570101861e-07,
    6.410678227811191e-07,
    6.317285187187403e-07,
    6.223989095086783e-07,
    6.130792457400633e-07,
    6.037697769921155e-07,
    5.944707518290805e-07,
    5.851824177951705e-07,
    5.759050214095372e-07,
    5.666388081614063e-07,
    5.573840225050963e-07,
    5.481409078551946e-07,
    5.389097065817747e-07,
    5.296906600056081e-07,
    5.204840083934081e-07,
    5.112899909532402e-07,
    5.021088458298028e-07,
    4.92940810099925e-07,
    4.83786119768001e-07,
    4.7464500976147095e-07,
    4.6551771392640424e-07,
    4.564044650231377e-07,
    4.4730549472183937e-07,
    4.382210335982864e-07,
    4.2915131112956925e-07,
    4.200965556898563e-07,
    4.110569945462464e-07,
    4.020328538546863e-07,
    3.9302435865580937e-07,
    3.8403173287099113e-07,
    3.750551992983295e-07,
    3.660949796086843e-07,
    3.571512943418105e-07,
    3.4822436290254714e-07,
    3.393144035569388e-07,
    3.304216334285632e-07,
    3.215462684947907e-07,
    3.1268852358310073e-07,
    3.0384861236749166e-07,
    2.9502674736494867e-07,
    2.8622313993183787e-07,
    2.7743800026051655e-07,
    2.686715373758664e-07,
    2.5992395913188846e-07,
    2.5119547220839e-07,
    2.424862821077283e-07,
    2.3379659315148487e-07,
    2.2512660847734963e-07,
    2.1647653003593238e-07,
    2.0784655858763618e-07,
    1.992368936996186e-07,
    1.9064773374280198e-07,
    1.8207927588888357e-07,
    1.7353171610737807e-07,
    1.6500524916282352e-07,
    1.5650006861187208e-07,
    1.4801636680054013e-07,
    1.3955433486149413e-07,
    1.3111416271133663e-07,
    1.2269603904792582e-07,
    1.143001513478566e-07,
    1.05926685863826e-07,
    9.757582762216109e-08,
    8.924776042037792e-08,
    8.09426668247432e-08,
    7.266072816787e-08,
    6.440212454647165e-08,
    5.6167034819003416e-08,
    4.7955636603463064e-08,
    3.976810627522507e-08,
    3.160461896487577e-08,
    2.3465348556082328e-08,
    1.5350467683620064e-08,
    7.260147731287579e-09,
    -8.054411700203771e-10,
    -8.846130144206071e-09,
    -1.6861751571861558e-08,
    -2.4852139092127252e-08,
    -3.2817127604393695e-08,
    -4.075655327011462e-08,
    -4.867025351447434e-08,
    -5.655806702795502e-08,
    -6.441983376806994e-08,
    -7.225539496084069e-08,
    -8.006459310228561e-08,
    -8.784727195996292e-08,
    -9.560327657431403e-08,
    -1.0333245326007377e-07,
    -1.110346496076232e-07,
    -1.1870971448425574e-07,
    -1.2635749803538684e-07,
    -1.3397785168583006e-07,
    -1.4157062814087393e-07,
    -1.4913568138742615e-07,
    -1.5667286669510057e-07,
    -1.6418204061721816e-07,
    -1.716630609917524e-07,
    -1.791157869423395e-07,
    -1.8654007887909388e-07,
    -1.939357984994867e-07,
    -2.0130280878917128e-07,
    -2.0864097402272008e-07,
    -2.1595015976431046e-07,
    -2.2323023286847153e-07,
    -2.3048106148063936e-07,
    -2.3770251503777545e-07,
    -2.44894464268931e-07,
    -2.520567811957263e-07,
    -2.5918933913277667e-07,
    -2.662920126881803e-07,
    -2.733646777638172e-07,
    -2.8040721155570894e-07,
    -2.874194925543285e-07,
    -2.9440140054482063e-07,
    -3.013528166071848e-07,
    -3.082736231164564e-07,
    -3.151637037428532e-07,
    -3.2202294345177985e-07,
    -3.288512285039349e-07,
    -3.356484464552683e-07,
    -3.4241448615691537e-07,
    -3.4914923775512205e-07,
    -3.5585259269114334e-07,
    -3.6252444370099993e-07,
    -3.6916468481533147e-07,
    -3.757732113591085e-07,
    -3.8234991995131546e-07,
    -3.888947085046341e-07,
    -3.954074762250889e-07,
    -4.0188812361156226e-07,
    -4.0833655245539864e-07,
    -4.14752665839875e-07,
    -4.211363681396401e-07,
    -4.2748756502015206e-07,
    -4.3380616343708223e-07,
    -4.400920716355898e-07,
    -4.4634519914968446e-07,
    -4.525654568014558e-07,
    -4.5875275670027236e-07,
    -4.649070122419822e-07,
    -4.710281381080788e-07,
    -4.771160502647348e-07,
    -4.831706659619319e-07,
    -4.891919037324621e-07,
    -4.951796833908461e-07,
    -5.011339260323922e-07,
    -5.070545540320331e-07,
    -5.129414910431792e-07,
    -5.187946619966098e-07,
    -5.246139930992029e-07,
    -5.303994118327129e-07,
    -5.361508469525054e-07,
    -5.418682284862161e-07,
    -5.475514877323652e-07,
    -5.532005572590209e-07,
    -5.588153709023007e-07,
    -5.6439586376493e-07,
    -5.699419722147478e-07,
    -5.754536338831431e-07,
    -5.80930787663444e-07,
    -5.863733737093641e-07,
    -5.917813334332821e-07,
    -5.971546095045741e-07,
    -6.024931458479061e-07,
    -6.077968876414508e-07,
    -6.130657813150579e-07,
    -6.182997745484838e-07,
    -6.234988162694562e-07,
    -6.286628566517932e-07,
    -6.337918471134775e-07,
    -6.388857403146629e-07,
    -6.439444901556353e-07,
    -6.489680517748241e-07,
    -6.539563815466632e-07,
    -6.589094370794985e-07,
    -6.638271772134517e-07,
    -6.687095620182204e-07,
    -6.735565527908437e-07,
    -6.78368112053464e-07,
    -6.831442035510637e-07,
    -6.878847922490911e-07,
    -6.925898443311613e-07,
    -6.97259327196646e-07,
    -7.01893209458237e-07,
    -7.064914609395093e-07,
    -7.110540526724598e-07,
    -7.155809568949357e-07,
    -7.200721470481357e-07,
    -7.245275977740054e-07,
    -7.289472849126078e-07,
    -7.333311854994914e-07,
    -7.376792777630345e-07,
    -7.419915411216825e-07,
    -7.462679561812604e-07,
    -7.505085047321754e-07,
    -7.547131697466015e-07,
    -7.588819353756564e-07,
    -7.63014786946562e-07,
    -7.671117109596967e-07,
    -7.711726950857184e-07,
    -7.751977281625888e-07,
    -7.79186800192571e-07,
    -7.831399023392304e-07,
    -7.870570269244078e-07,
    -7.909381674250985e-07,
    -7.947833184703914e-07,
    -7.985924758383222e-07,
    -8.023656364526885e-07,
    -8.061027983798805e-07,
    -8.098039608256751e-07,
    -8.134691241319487e-07,
    -8.170982897734365e-07,
    -8.20691460354426e-07,
    -8.242486396053708e-07,
    -8.277698323796118e-07,
    -8.312550446499478e-07,
    -8.347042835052019e-07,
    -8.381175571468293e-07,
    -8.414948748854014e-07,
    -8.448362471371293e-07,
    -8.481416854203568e-07,
    -8.514112023519988e-07,
    -8.54644811643942e-07,
    -8.578425280995003e-07,
    -8.610043676097313e-07,
    -8.64130347149812e-07,
    -8.672204847753685e-07,
    -8.702747996187643e-07,
    -8.732933118853513e-07,
    -8.76276042849763e-07,
    -8.7922301485209e-07,
    -8.821342512941009e-07,
    -8.850097766354241e-07,
    -8.878496163896881e-07,
    -8.906537971206247e-07,
    -8.934223464382234e-07,
    -8.96155292994753e-07,
    -8.988526664808467e-07,
    -9.015144976215389e-07,
    -9.041408181722629e-07,
    -9.067316609148231e-07,
    -9.092870596533957e-07,
    -9.118070492104308e-07,
    -9.142916654225856e-07,
    -9.167409451366367e-07,
    -9.191549262053407e-07,
    -9.21533647483275e-07,
    -9.238771488226869e-07,
    -9.261854710693142e-07,
    -9.284586560581393e-07,
    -9.306967466091941e-07,
    -9.32899786523293e-07,
    -9.350678205777516e-07,
    -9.372008945221011e-07,
    -9.392990550737924e-07,
    -9.41362349913829e-07,
    -9.433908276824474e-07,
    -9.453845379747303e-07,
    -9.473435313362084e-07,
    -9.492678592584565e-07,
    -9.511575741746822e-07,
    -9.530127294552402e-07,
    -9.548333794032015e-07,
    -9.566195792498564e-07,
    -9.583713851501974e-07,
    -9.600888541784122e-07,
    -9.617720443233553e-07,
    -9.634210144839632e-07,
    -9.650358244647121e-07,
    -9.666165349710123e-07,
    -9.681632076045907e-07,
    -9.696759048588783e-07,
    -9.71154690114385e-07,
    -9.725996276340048e-07,
    -9.740107825583784e-07,
    -9.753882209011917e-07,
    -9.767320095444445e-07,
    -9.780422162337811e-07,
    -9.793189095737197e-07,
    -9.805621590228996e-07,
    -9.817720348893372e-07,
    -9.829486083256277e-07,
    -9.840919513241478e-07,
    -9.852021367122637e-07,
    -9.862792381474996e-07,
    -9.87323330112682e-07,
    -9.883344879111192e-07,
    -9.8931278766171e-07,
    -9.902583062940746e-07,
    -9.91171121543672e-07,
    -9.92051311946886e-07,
    -9.928989568361e-07,
    -9.93714136334788e-07,
    -9.944969313525507e-07,
    -9.952474235801716e-07,
    -9.959656954846524e-07,
    -9.966518303042346e-07,
    -9.973059120433975e-07,
    -9.979280254678744e-07,
    -9.98518256099625e-07,
    -9.990766902118171e-07,
    -9.996034148238001e-07,
    -1.0000985176960512e-06,
    -1.0005620873251145e-06,
    -1.0009942129385555e-06,
    -1.0013949844898625e-06,
    -1.001764492653371e-06,
    -1.0021028288191755e-06,
    -1.0024100850880188e-06,
    -1.002686354266172e-06,
    -1.0029317298603195e-06,
    -1.0031463060724273e-06,
    -1.0033301777945968e-06,
    -1.0034834406039248e-06,
    -1.0036061907573409e-06,
    -1.0036985251864384e-06,
    -1.003760541492308e-06,
    -1.0037923379403593e-06,
    -1.0037940134551212e-06,
    -1.003765667615059e-06,
    -1.0037074006473665e-06,
    -1.0036193134227538e-06,
    -1.0035015074502326e-06,
    -1.0033540848718998e-06,
    -1.0031771484576965e-06,
    -1.0029708016001864e-06,
    -1.0027351483093048e-06,
    -1.0024702932071144e-06,
    -1.0021763415225515e-06,
    -1.0018533990861747e-06,
    -1.001501572324893e-06,
    -1.0011209682567027e-06,
    -1.0007116944854181e-06,
    -1.0002738591953816e-06,
    -9.998075711461968e-07,
    -9.99312939667435e-07,
    -9.987900746533411e-07,
    -9.982390865575494e-07,
    -9.97660086387781e-07,
    -9.970531857005361e-07,
    -9.964184965958022e-07,
    -9.957561317117403e-07,
    -9.950662042193684e-07,
    -9.943488278172624e-07,
    -9.93604116726228e-07,
    -9.92832185683984e-07,
    -9.920331499398528e-07,
    -9.912071252494265e-07,
    -9.903542278692442e-07,
    -9.894745745514713e-07,
    -9.885682825385705e-07,
    -9.876354695579687e-07,
    -9.86676253816738e-07,
    -9.856907539962524e-07,
    -9.846790892468664e-07,
    -9.836413791825816e-07,
    -9.825777438757084e-07,
    -9.814883038515416e-07,
    -9.803731800830282e-07,
    -9.792324939854272e-07,
    -9.780663674109864e-07,
    -9.768749226436089e-07,
    -9.756582823935198e-07,
    -9.744165697919421e-07,
    -9.731499083857628e-07,
    -9.718584221322122e-07,
    -9.705422353935297e-07,
    -9.69201472931651e-07,
    -9.678362599028738e-07,
    -9.664467218525469e-07,
    -9.650329847097461e-07,
    -9.635951747819656e-07,
    -9.621334187497942e-07,
    -9.606478436616134e-07,
    -9.591385769282844e-07,
    -9.576057463178464e-07,
    -9.56049479950214e-07,
    -9.54469906291879e-07,
    -9.528671541506118e-07,
    -9.512413526701782e-07,
    -9.495926313250425e-07,
    -9.479211199150933e-07,
    -9.462269485603565e-07,
    -9.445102476957272e-07,
    -9.42771148065694e-07,
    -9.410097807190768e-07,
    -9.39226277003765e-07,
    -9.374207685614598e-07,
    -9.355933873224294e-07,
    -9.337442655002548e-07,
    -9.318735355865995e-07,
    -9.29981330345971e-07,
    -9.280677828104905e-07,
    -9.261330262746742e-07,
    -9.241771942902155e-07,
    -9.222004206607776e-07,
    -9.202028394367861e-07,
    -9.181845849102365e-07,
    -9.161457916095005e-07,
    -9.14086594294147e-07,
    -9.120071279497634e-07,
    -9.099075277827866e-07,
    -9.077879292153451e-07,
    -9.056484678801039e-07,
    -9.034892796151153e-07,
    -9.013105004586885e-07,
    -8.991122666442507e-07,
    -8.968947145952292e-07,
    -8.94657980919945e-07,
    -8.924022024064957e-07,
    -8.901275160176638e-07,
    -8.878340588858347e-07,
    -8.855219683079076e-07,
    -8.831913817402387e-07,
    -8.808424367935709e-07,
    -8.784752712279844e-07,
    -8.76090022947858e-07,
    -8.736868299968393e-07,
    -8.712658305528162e-07,
    -8.688271629229093e-07,
    -8.663709655384743e-07,
    -8.638973769500997e-07,
    -8.614065358226326e-07,
    -8.588985809302088e-07,
    -8.56373651151289e-07,
    -8.538318854637115e-07,
    -8.512734229397585e-07,
    -8.486984027412176e-07,
    -8.461069641144745e-07,
    -8.434992463856099e-07,
    -8.408753889554978e-07,
    -8.38235531294933e-07,
    -8.355798129397587e-07,
    -8.329083734860042e-07,
    -8.302213525850416e-07,
    -8.275188899387589e-07,
    -8.248011252947259e-07,
    -8.220681984413972e-07,
    -8.19320249203312e-07,
    -8.165574174363055e-07,
    -8.137798430227413e-07,
    -8.109876658667593e-07,
    -8.081810258895252e-07,
    -8.053600630244943e-07,
    -8.025249172127047e-07,
    -7.996757283980647e-07,
    -7.968126365226593e-07,
    -7.939357815220811e-07,
    -7.910453033207628e-07,
    -7.881413418273198e-07,
    -7.85224036929931e-07,
    -7.822935284916989e-07,
    -7.793499563460523e-07,
    -7.763934602921569e-07,
    -7.734241800903312e-07,
    -7.704422554574771e-07,
    -7.674478260625453e-07,
    -7.644410315219929e-07,
    -7.614220113952577e-07,
    -7.583909051802708e-07,
    -7.553478523089569e-07,
    -7.522929921427573e-07,
    -7.492264639681871e-07,
    -7.461484069923761e-07,
    -7.430589603386476e-07,
    -7.399582630421182e-07,
    -7.368464540452908e-07,
    -7.337236721936727e-07,
    -7.305900562314278e-07,
    -7.274457447970169e-07,
    -7.242908764188632e-07,
    -7.211255895110663e-07,
    -7.179500223690673e-07,
    -7.147643131653882e-07,
    -7.115685999453744e-07,
    -7.083630206229254e-07,
    -7.051477129762861e-07,
    -7.019228146438242e-07,
    -6.986884631198286e-07,
    -6.954447957503366e-07,
    -6.921919497289791e-07,
    -6.889300620928144e-07,
    -6.85659269718231e-07,
    -6.823797093168155e-07,
    -6.790915174312672e-07,
    -6.757948304313235e-07,
    -6.724897845097148e-07,
    -6.691765156781064e-07,
    -6.658551597630972e-07,
    -6.625258524022134e-07,
    -6.591887290399127e-07,
    -6.558439249236316e-07,
    -6.52491575099842e-07,
    -6.49131814410103e-07,
    -6.457647774871777e-07,
    -6.42390598751126e-07,
    -6.390094124054268e-07,
    -6.35621352433135e-07,
    -6.322265525930531e-07,
    -6.288251464158919e-07,
    -6.254172672004998e-07,
    -6.220030480100731e-07,
    -6.18582621668392e-07,
    -6.151561207560876e-07,
    -6.117236776069293e-07,
    -6.082854243041163e-07,
    -6.048414926765911e-07,
    -6.013920142953963e-07,
    -5.979371204700134e-07,
    -5.944769422447479e-07,
    -5.91011610395138e-07,
    -5.87541255424364e-07,
    -5.840660075596719e-07,
    -5.805859967488632e-07,
    -5.77101352656742e-07,
    -5.736122046616261e-07,
    -5.701186818518715e-07,
    -5.666209130224032e-07,
    -5.631190266712655e-07,
    -5.596131509962267e-07,
    -5.561034138913487e-07,
    -5.52589942943622e-07,
    -5.490728654296138e-07,
    -5.455523083121205e-07,
    -5.420283982368389e-07,
    -5.385012615290975e-07,
    -5.349710241905482e-07,
    -5.314378118959305e-07,
    -5.279017499898357e-07,
    -5.243629634834916e-07,
    -5.208215770515562e-07,
    -5.172777150289742e-07,
    -5.137315014077976e-07,
    -5.101830598340705e-07,
    -5.066325136047266e-07,
    -5.03079985664496e-07,
    -4.995255986028286e-07,
    -4.959694746508752e-07,
    -4.924117356784378e-07,
    -4.88852503190991e-07,
    -4.852918983266927e-07,
    -4.817300418534192e-07,
    -4.78167054165835e-07,
    -4.746030552824915e-07,
    -4.7103816484290443e-07,
    -4.6747250210471017e-07,
    -4.639061859408051e-07,
    -4.603393348365094e-07,
    -4.5677206688676865e-07,
    -4.532044997933818e-07,
    -4.496367508622111e-07,
    -4.4606893700046966e-07,
    -4.425011747139902e-07,
    -4.3893358010452237e-07,
    -4.3536626886706403e-07,
    -4.31799356287222e-07,
    -4.282329572385571e-07,
    -4.2466718617999817e-07,
    -4.2110215715324713e-07,
    -4.175379837802094e-07,
    -4.139747792604564e-07,
    -4.1041265636872025e-07,
    -4.0685172745236974e-07,
    -4.0329210442896143e-07,
    -3.9973389878377716e-07,
    -3.9617722156738446e-07,
    -3.9262218339323834e-07,
    -3.8906889443530594e-07,
    -3.8551746442567983e-07,
    -3.8196800265225945e-07,
    -3.784206179564258e-07,
    -3.7487541873073536e-07,
    -3.7133251291665724e-07,
    -3.6779200800232766e-07,
    -3.6425401102031724e-07,
    -3.6071862854540945e-07,
    -3.5718596669244913e-07,
    -3.536561311141518e-07,
    -3.501292269989796e-07,
    -3.4660535906903054e-07,
    -3.430846315779426e-07,
    -3.395671483088068e-07,
    -3.360530125721509e-07,
    -3.325423272038842e-07,
    -3.2903519456330875e-07,
    -3.255317165311466e-07,
    -3.220319945075759e-07,
    -3.185361294102827e-07,
    -3.15044221672578e-07,
    -3.115563712414817e-07,
    -3.080726775758656e-07,
    -3.0459323964461976e-07,
    -3.0111815592482124e-07,
    -2.9764752439992606e-07,
    -2.9418144255801884e-07,
    -2.907200073900317e-07,
    -2.8726331538802706e-07,
    -2.8381146254349653e-07,
    -2.8036454434566776e-07,
    -2.7692265577982953e-07,
    -2.734858913257199e-07,
    -2.7005434495588006e-07,
    -2.666281101340681e-07,
    -2.632072798137145e-07,
    -2.597919464363235e-07,
    -2.5638220192997654e-07,
    -2.5297813770783213e-07,
    -2.495798446666184e-07,
    -2.461874131852013e-07,
    -2.4280093312313426e-07,
    -2.39420493819238e-07,
    -2.3604618409021457e-07,
    -2.3267809222929182e-07,
    -2.2931630600484687e-07,
    -2.2596091265911137e-07,
    -2.2261199890685574e-07,
    -2.1926965093410294e-07,
    -2.1593395439687956e-07,
    -2.1260499441999178e-07,
    -2.092828555957861e-07,
    -2.0596762198298683e-07,
    -2.0265937710551707e-07,
    -1.9935820395134437e-07,
    -1.9606418497136694e-07,
    -1.9277740207832353e-07,
    -1.8949793664568787e-07,
    -1.862258695066401e-07,
    -1.8296128095302012e-07,
    -1.797042507343087e-07,
    -1.7645485805664418e-07,
    -1.7321318158186851e-07,
    -1.699792994265516e-07,
    -1.6675328916109728e-07,
    -1.635352278088292e-07,
    -1.6032519184510312e-07,
    -1.5712325719645733e-07,
    -1.5392949923978506e-07,
    -1.5074399280151243e-07,
    -1.47566812156795e-07,
    -1.4439803102877514e-07,
    -1.4123772258780588e-07,
    -1.3808595945073608e-07,
    -1.349428136802146e-07,
    -1.318083567839975e-07,
    -1.286826597142759e-07,
    -1.255657928670631e-07,
    -1.2245782608154902e-07,
    -1.1935882863951487e-07,
    -1.1626886926476604e-07,
    -1.1318801612256969e-07,
    -1.1011633681911144e-07,
    -1.0705389840101101e-07,
    -1.0400076735480494e-07,
    -1.0095700960649039e-07,
    -9.792269052108532e-08,
    -9.489787490219475e-08,
    -9.188262699159354e-08,
    -8.88770104688708e-08,
    -8.588108845103876e-08,
    -8.289492349220371e-08,
    -7.991857758325224e-08,
    -7.695211215154356e-08,
    -7.399558806061929e-08,
    -7.104906560997172e-08,
    -6.811260453477975e-08,
    -6.518626400570317e-08,
    -6.227010262869484e-08,
    -5.9364178444817035e-08,
    -5.6468548930075034e-08,
    -5.358327099530949e-08,
    -5.07084009860519e-08,
    -4.784399468245744e-08,
    -4.4990107299220714e-08,
    -4.214679348551445e-08,
    -3.931410732496487e-08,
    -3.6492102335650265e-08,
    -3.368083147008175e-08,
    -3.0880347115257623e-08,
    -2.8090701092699356e-08,
    -2.5311944658511518e-08,
    -2.2544128503476626e-08,
    -1.9787302753173783e-08,
    -1.7041516968079037e-08,
    -1.4306820143738397e-08,
    -1.1583260710922795e-08,
    -8.870886535806383e-09,
    -6.169744920179359e-09,
    -3.4798826016839046e-09,
    -8.013457540322317e-10,
    1.865820012703898e-09,
    4.521569651821651e-09,
    7.1658586796926555e-09,
    9.798643175434472e-09,
    1.2419879780559604e-08,
    1.5029525698642122e-08,
    1.762753869491405e-08,
    2.0213877095879476e-08,
    2.2788499788906356e-08,
    2.5351366221784788e-08,
    2.7902436402263107e-08,
    3.044167089760197e-08,
    3.296903083405868e-08,
    3.5484477896389774e-08,
    3.798797432733129e-08,
    4.0479482927046515e-08,
    4.295896705255529e-08,
    4.5426390617159823e-08,
    4.78817180898558e-08,
    5.032491449468991e-08,
    5.275594541014915e-08,
    5.5174776968496755e-08,
    5.7581375855094426e-08,
    5.997570930771996e-08,
    6.235774511587179e-08,
    6.47274516200203e-08,
    6.708479771089069e-08,
    6.942975282869407e-08,
    7.176228696234372e-08,
    7.40823706486691e-08,
    7.638997497161533e-08,
    7.868507156139163e-08,
    8.096763259365043e-08,
    8.32376307886156e-08,
    8.549503941019733e-08,
    8.77398322651036e-08,
    8.997198370193827e-08,
    9.219146861024937e-08,
    9.43982624196067e-08,
    9.659234109863213e-08,
    9.87736811540131e-08,
    1.0094225962951596e-07,
    1.0309805410498612e-07,
    1.0524104269529781e-07,
    1.073712040493351e-07,
    1.094885173489268e-07,
    1.1159296230774924e-07,
    1.1368451917027576e-07,
    1.1576316871064797e-07,
    1.1782889223154771e-07,
    1.1988167156308398e-07,
    1.2192148906161603e-07,
    1.2394832760859843e-07,
    1.2596217060940157e-07,
    1.2796300199210915e-07,
    1.29950806206295e-07,
    1.3192556822181681e-07,
    1.3388727352755202e-07,
    1.3583590813014803e-07,
    1.377714585527573e-07,
    1.3969391183374276e-07,
    1.4160325552536726e-07,
    1.434994776924993e-07,
    1.453825669112599e-07,
    1.4725251226768846e-07,
    1.4910930335638795e-07,
    1.5095293027914672e-07,
    1.5278338364354227e-07,
    1.546006545615605e-07,
    1.564047346481605e-07,
    1.5819561601985454e-07,
    1.599732912932714e-07,
    1.6173775358369468e-07,
    1.63488996503585e-07,
    1.652270141611169e-07,
    1.669518011586627e-07,
    1.6866335259129346e-07,
    1.7036166404525978e-07,
    1.7204673159645242e-07,
    1.7371855180884823e-07,
    1.753771217329541e-07,
    1.7702243890424289e-07,
    1.78654501341546e-07,
    1.8027330754547454e-07,
    1.8187885649680043e-07,
    1.8347114765482541e-07,
    1.8505018095575261e-07,
    1.8661595681104507e-07,
    1.881684761057467e-07,
    1.897077401968309e-07,
    1.9123375091150597e-07,
    1.927465105455154e-07,
    1.9424602186143534e-07,
    1.9573228808696414e-07,
    1.9720531291317224e-07,
    1.9866510049278014e-07,
    2.0011165543839625e-07,
    2.015449828207473e-07,
    2.0296508816690919e-07,
    2.0437197745852717e-07,
    2.057656571300002e-07,
    2.0714613406669318e-07,
    2.0851341560310684e-07,
    2.098675095210457e-07,
    2.1120842404778232e-07,
    2.1253616785421472e-07,
    2.1385075005298802e-07,
    2.1515218019664009e-07,
    2.1644046827571748e-07,
    2.177156247168655e-07,
    2.1897766038095701e-07,
    2.2022658656116463e-07,
    2.214624149810355e-07,
    2.2268515779257873e-07,
    2.2389482757430643e-07,
    2.2509143732929484e-07,
    2.2627500048322815e-07,
    2.2744553088242778e-07,
    2.2860304279186743e-07,
    2.297475508932045e-07,
    2.3087907028276827e-07,
    2.3199761646956316e-07,
    2.3310320537326243e-07,
    2.3419585332218032e-07,
    2.3527557705123779e-07,
    2.363423936999384e-07,
    2.3739632081030916e-07,
    2.3843737632484944e-07,
    2.394655785844751e-07,
    2.404809463264414e-07,
    2.4148349868226e-07,
    2.424732551756261e-07,
    2.434502357203095e-07,
    2.4441446061805907e-07,
    2.4536595055649795e-07,
    2.463047266070023e-07,
    2.4723081022257035e-07,
    2.481442232357056e-07,
    2.4904498785626566e-07,
    2.4993312666931953e-07,
    2.508086626330012e-07,
    2.5167161907634565e-07,
    2.5252201969711924e-07,
    2.5335988855964944e-07,
    2.541852500926533e-07,
    2.5499812908703627e-07,
    2.557985506937149e-07,
    2.565865404214113e-07,
    2.5736212413444636e-07,
    2.581253280505305e-07,
    2.588761787385574e-07,
    2.5961470311636294e-07,
    2.6034092844851304e-07,
    2.6105488234406436e-07,
    2.6175659275432054e-07,
    2.624460879705912e-07,
    2.6312339662194715e-07,
    2.63788547672953e-07,
    2.644415704214178e-07,
    2.650824944961256e-07,
    2.657113498545595e-07,
    2.6632816678063154e-07,
    2.66932975882406e-07,
    2.6752580808980434e-07,
    2.681066946523262e-07,
    2.686756671367501e-07,
    2.692327574248326e-07,
    2.697779977110093e-07,
    2.7031142050009223e-07,
    2.7083305860494815e-07,
    2.71342945144194e-07,
    2.7184111353987534e-07,
    2.7232759751513894e-07,
    2.7280243109190947e-07,
    2.7326564858856577e-07,
    2.7371728461759744e-07,
    2.741573740832777e-07,
    2.745859521793139e-07,
    2.7500305438651006e-07,
    2.754087164704223e-07,
    2.758029744790071e-07,
    2.7618586474026425e-07,
    2.76557423859892e-07,
    2.769176887189198e-07,
    2.7726669647135216e-07,
    2.7760448454180723e-07,
    2.779310906231493e-07,
    2.7824655267411867e-07,
    2.785509089169687e-07,
    2.788441978350847e-07,
    2.791264581706156e-07,
    2.793977289220977e-07,
    2.7965804934207624e-07,
    2.7990745893472067e-07,
    2.801459974534525e-07,
    2.803737048985527e-07,
    2.805906215147814e-07,
    2.807967877889947e-07,
    2.809922444477544e-07,
    2.8117703245493495e-07,
    2.8135119300934574e-07,
    2.815147675423263e-07,
    2.8166779771536407e-07,
    2.8181032541770013e-07,
    2.819423927639353e-07,
    2.820640420916335e-07,
    2.821753159589337e-07,
    2.822762571421481e-07,
    2.823669086333689e-07,
    2.8244731363807753e-07,
    2.825175155727433e-07,
    2.82577558062426e-07,
    2.826274849383858e-07,
    2.826673402356847e-07,
    2.826971681907871e-07,
    2.8271701323916965e-07,
    2.8272692001292486e-07,
    2.827269333383623e-07,
    2.827170982336168e-07,
    2.826974599062587e-07,
    2.826680637508925e-07,
    2.82628955346772e-07,
    2.825801804554056e-07,
    2.825217850181636e-07,
    2.82453815153893e-07,
    2.8237631715652846e-07,
    2.8228933749269937e-07,
    2.8219292279935354e-07,
    2.8208711988136455e-07,
    2.819719757091521e-07,
    2.818475374162988e-07,
    2.81713852297174e-07,
    2.8157096780455e-07,
    2.814189315472306e-07,
    2.8125779128767457e-07,
    2.8108759493962126e-07,
    2.8090839056572174e-07,
    2.8072022637517346e-07,
    2.805231507213473e-07,
    2.803172120994285e-07,
    2.8010245914405627e-07,
    2.7987894062695733e-07,
    2.796467054545978e-07,
    2.794058026658262e-07,
    2.7915628142951916e-07,
    2.7889819104223787e-07,
    2.7863158092587913e-07,
    2.783565006253326e-07,
    2.780729998061431e-07,
    2.7778112825217553e-07,
    2.774809358632748e-07,
    2.771724726529429e-07,
    2.768557887460079e-07,
    2.7653093437630164e-07,
    2.761979598843407e-07,
    2.7585691571500943e-07,
    2.7550785241524626e-07,
    2.7515082063173616e-07,
    2.7478587110860544e-07,
    2.7441305468511746e-07,
    2.7403242229337994e-07,
    2.7364402495604963e-07,
    2.732479137840403e-07,
    2.728441399742425e-07,
    2.724327548072375e-07,
    2.7201380964502555e-07,
    2.715873559287502e-07,
    2.711534451764336e-07,
    2.707121289807094e-07,
    2.702634590065685e-07,
    2.69807486989102e-07,
    2.69344264731253e-07,
    2.688738441015731e-07,
    2.683962770319813e-07,
    2.679116155155327e-07,
    2.6741991160418414e-07,
    2.6692121740657415e-07,
    2.664155850858015e-07,
    2.659030668572122e-07,
    2.6538371498619065e-07,
    2.648575817859563e-07,
    2.643247196153646e-07,
    2.6378518087671827e-07,
    2.63239018013576e-07,
    2.6268628350857414e-07,
    2.621270298812508e-07,
    2.615613096858769e-07,
    2.6098917550928955e-07,
    2.604106799687378e-07,
    2.5982587570972794e-07,
    2.59234815403879e-07,
    2.586375517467833e-07,
    2.5803413745587103e-07,
    2.5742462526828427e-07,
    2.568090679387558e-07,
    2.5618751823749297e-07,
    2.5556002894807184e-07,
    2.549266528653311e-07,
    2.542874427932824e-07,
    2.536424515430155e-07,
    2.5299173193062025e-07,
    2.5233533677510907e-07,
    2.516733188963492e-07,
    2.5100573111300075e-07,
    2.503326262404606e-07,
    2.496540570888153e-07,
    2.489700764608003e-07,
    2.48280737149765e-07,
    2.475860919376458e-07,
    2.468861935929477e-07,
    2.4618109486872943e-07,
    2.454708485006018e-07,
    2.4475550720472483e-07,
    2.4403512367582196e-07,
    2.433097505851937e-07,
    2.4257944057874307e-07,
    2.418442462750087e-07,
    2.411042202632021e-07,
    2.4035941510125655e-07,
    2.396098833138811e-07,
    2.3885567739062385e-07,
    2.38096849783942e-07,
    2.373334529072788e-07,
    2.3656553913315387e-07,
    2.357931607912521e-07,
    2.3501637016652883e-07,
    2.3423521949731955e-07,
    2.3344976097345795e-07,
    2.3266004673440285e-07,
    2.3186612886737217e-07,
    2.310680594054855e-07,
    2.3026589032591647e-07,
    2.2945967354805128e-07,
    2.2864946093165726e-07,
    2.278353042750578e-07,
    2.2701725531331984e-07,
    2.2619536571644278e-07,
    2.253696870875655e-07,
    2.2454027096117206e-07,
    2.2370716880131446e-07,
    2.2287043199983783e-07,
    2.2203011187461802e-07,
    2.2118625966780654e-07,
    2.203389265440857e-07,
    2.1948816358892996e-07,
    2.186340218068779e-07,
    2.1777655211981455e-07,
    2.1691580536525883e-07,
    2.160518322946642e-07,
    2.1518468357172547e-07,
    2.1431440977069564e-07,
    2.134410613747114e-07,
    2.125646887741305e-07,
    2.1168534226487223e-07,
    2.1080307204677415e-07,
    2.0991792822195428e-07,
    2.0902996079318315e-07,
    2.0813921966226272e-07,
    2.0724575462842236e-07,
    2.0634961538671358e-07,
    2.054508515264236e-07,
    2.045495125294931e-07,
    2.03645647768945e-07,
    2.0273930650732136e-07,
    2.0183053789513342e-07,
    2.009193909693177e-07,
    2.0000591465170215e-07,
    1.9909015774748456e-07,
    1.9817216894371886e-07,
    1.9725199680780813e-07,
    1.9632968978601515e-07,
    1.954052962019725e-07,
    1.9447886425521324e-07,
    1.935504420197043e-07,
    1.9262007744238803e-07,
    1.9168781834174179e-07,
    1.9075371240634193e-07,
    1.8981780719343572e-07,
    1.8888015012752946e-07,
    1.8794078849898232e-07,
    1.8699976946260946e-07,
    1.8605714003629797e-07,
    1.8511294709963338e-07,
    1.8416723739253058e-07,
    1.8322005751388286e-07,
    1.8227145392021684e-07,
    1.813214729243533e-07,
    1.803701606940869e-07,
    1.7941756325087155e-07,
    1.7846372646851408e-07,
    1.7750869607188262e-07,
    1.765525176356227e-07,
    1.755952365828813e-07,
    1.74636898184046e-07,
    1.7367754755549347e-07,
    1.7271722965834337e-07,
    1.717559892972289e-07,
    1.707938711190761e-07,
    1.6983091961188821e-07,
    1.6886717910354688e-07,
    1.6790269376062475e-07,
    1.669375075871989e-07,
    1.6597166442368662e-07,
    1.65005207945684e-07,
    1.640381816628162e-07,
    1.6307062891759915e-07,
    1.6210259288431434e-07,
    1.6113411656788913e-07,
    1.6016524280278824e-07,
    1.591960142519227e-07,
    1.5822647340555816e-07,
    1.572566625802422e-07,
    1.5628662391774044e-07,
    1.5531639938398249e-07,
    1.543460307680144e-07,
    1.5337555968097195e-07,
    1.5240502755505194e-07,
    1.514344756425042e-07,
    1.5046394501463038e-07,
    1.4949347656079185e-07,
    1.4852311098742904e-07,
    1.4755288881709487e-07,
    1.4658285038749404e-07,
    1.4561303585053335e-07,
    1.4464348517138859e-07,
    1.4367423812757466e-07,
    1.427053343080284e-07,
    1.417368131122069e-07,
    1.4076871374918897e-07,
    1.398010752367912e-07,
    1.3883393640069803e-07,
    1.3786733587359553e-07,
    1.369013120943183e-07,
    1.359359033070121e-07,
    1.3497114756029914e-07,
    1.3400708270645732e-07,
    1.3304374640061754e-07,
    1.3208117609995484e-07,
    1.3111940906290657e-07,
    1.3015848234839484e-07,
    1.2919843281505544e-07,
    1.2823929712048647e-07,
    1.2728111172050075e-07,
    1.2632391286838843e-07,
    1.2536773661419567e-07,
    1.244126188040118e-07,
    1.234585950792629e-07,
    1.2250570087602246e-07,
    1.2155397142432865e-07,
    1.206034417475118e-07,
    1.1965414666153513e-07,
    1.1870612077434692e-07,
    1.1775939848523626e-07,
    1.168140139842097e-07,
    1.158700012513711e-07,
    1.1492739405631176e-07,
    1.1398622595751592e-07,
    1.130465303017767e-07,
    1.1210834022361366e-07,
    1.1117168864471547e-07,
    1.1023660827338032e-07,
    1.0930313160397176e-07,
    1.0837129091638584e-07,
    1.0744111827553089e-07,
    1.0651264553080907e-07,
    1.0558590431561983e-07,
    1.0466092604686587e-07,
    1.0373774192447038e-07,
    1.0281638293090797e-07,
    1.0189687983074556e-07,
    1.0097926317019098e-07,
    1.0006356327665223e-07,
    9.914981025831198e-08,
    9.823803400370453e-08,
    9.73282641813097e-08,
    9.642053023915645e-08,
    9.551486140443329e-08,
    9.461128668310874e-08,
    9.370983485957019e-08,
    9.281053449626083e-08,
    9.191341393333612e-08,
    9.101850128832907e-08,
    9.0125824455822e-08,
    8.923541110712997e-08,
    8.834728868999889e-08,
    8.746148442830496e-08,
    8.657802532177284e-08,
    8.569693814570103e-08,
    8.481824945069543e-08,
    8.394198556241256e-08,
    8.306817258131967e-08,
    8.219683638245468e-08,
    8.132800261520387e-08,
    8.046169670308846e-08,
    7.959794384355855e-08,
    7.873676900779564e-08,
    7.78781969405338e-08,
    7.702225215987907e-08,
    7.616895895714591e-08,
    7.531834139670529e-08,
    7.447042331583641e-08,
    7.362522832458952e-08,
    7.278277980566578e-08,
    7.194310091429492e-08,
    7.110621457813457e-08,
    7.027214349717172e-08,
    6.944091014363405e-08,
    6.861253676191484e-08,
    6.778704536850846e-08,
    6.696445775194552e-08,
    6.614479547275188e-08,
    6.532807986340678e-08,
    6.451433202831257e-08,
    6.370357284377627e-08,
    6.289582295800287e-08,
    6.20911027910882e-08,
    6.12894325350335e-08,
    6.04908321537619e-08,
    5.969532138314371e-08,
    5.890291973103505e-08,
    5.811364647732712e-08,
    5.732752067399515e-08,
    5.654456114516941e-08,
    5.5764786487206695e-08,
    5.498821506877182e-08,
    5.4214865030931485e-08,
    5.344475428725806e-08,
    5.2677900523934934e-08,
    5.1914321199881125e-08,
    5.1154033546877925e-08,
    5.0397054569704793e-08,
    4.9643401046287335e-08,
    4.889308952785533e-08,
    4.814613633910195e-08,
    4.740255757836183e-08,
    4.6662369117791154e-08,
    4.592558660355699e-08,
    4.519222545603817e-08,
    4.446230087003578e-08,
    4.3735827814988e-08,
    4.3012821035193864e-08,
    4.22932950500527e-08,
    4.1577264154301815e-08,
    4.086474241827007e-08,
    4.015574368813942e-08,
    3.9450281586212e-08,
    3.874836951118403e-08,
    3.805002063843705e-08,
    3.735524792032581e-08,
    3.666406408648248e-08,
    3.597648164412859e-08,
    3.5292512878391576e-08,
    3.461216985262962e-08,
    3.3935464408771365e-08,
    3.32624081676537e-08,
    3.259301252937524e-08,
    3.1927288673656544e-08,
    3.126524756020643e-08,
    3.060689992909378e-08,
    2.995225630113679e-08,
    2.9301326978288055e-08,
    2.8654122044035713e-08,
    2.8010651363811808e-08,
    0.0,
];
