### bps.init.mk -- Initialisation pour les modules `make'.

# Author: Michael Grünewald
# Date: Ven 10 fév 2006 10:40:49 GMT
# Cookie: SYNOPSIS TARGET VARIABLE EN DOCUMENTATION

# $Id: bps.init.mk 150 2009-09-05 17:13:32Z michi $

# BSD Owl Scripts (https://bitbucket.org/michipili/bsdowl)
# This file is part of BSD Owl Scripts
#
# Copyright © 2005–2014 Michael Grünewald
#
# This file must be used under the terms of the CeCILL-B.
# This source file is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at
# http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt


### SYNOPSIS

# .include "bps.init.mk"


### DESCRIPTION

# Rend des services dans le domaine de l'initialisation.
#
# Définit des pseudo-commandes CP, MV INSTALL, INSTALL_DIR,
# SED_INPLACE, etc.;
#
# Définit une valeur pour PACKAGEDIR sur la base de la valeur de
# PACKAGE, si cette dernière a une valeur.
#
# Définit des pseudo-commandes WARN, INFO, MESG, FAIL utilisées pour
# le diagnostique.
#
# Définit `all' comme cible implicite.
#
# Demande le traitement des fichiers "bps.own.mk" et "bps.clean.mk"
#  et "Makefile.inc".
#
# Demande le traitement du fichier MAKEINITRC si cette variable est
# définie et que l'utilisateur courant n'est pas l'utilisateur
# root. Ceci permet d'utiliser le même Makefile pour installer des
# programmes `localement', et `globalement' avec la commande `sudo'.
#
# Définit la liste _MAKE_USERTARGET des cibles ``interface utilisateur''
# (all, clean, etc.). Voici la liste des ces cibles et les actions
# qu'elles doivent entreprendre:
#
#    * obj: créer l'arborescence nécessaire sous `objdir', le cas échéant
#    * configure: traite le code source pour l'adapter à
#       l'environnement courant;
#    * depend: traite le code source pour déterminer automatiquement
#       les dépendances entre certaines modules;
#    * build: prépare le programme;
#    * doc: prépare la documentation;
#    * all: configure, depend, build, doc;
#    * install: installer le programme et la documentation;
#    * clean: nettoie les fichiers produits lors de la préparation du
#       programme et de la documentation (y compris le programme et la
#       documentation eux-mêmes);
#    * distclean: comme clean, et nettoie les fichiers produits par
#       les étapes configure et depend.
#
#  Dans certains cas, il faut interpréter très librement le terme
#  `programme' utilisé ci-dessus.

#
# Description des variables
#

# MAKEINITRC
#
#   Fichier d'initialisation pour l'utilisateur.
#
#   Lorsque la variable 'MAKEINITRC' est définie et a comme valeur le nom d'un
#   fichier, ce fichier est lu par make pendant l'évaluation de ce module.

# CP RM INSTALL INSTALL_DIR AWK SED SED_INPLACE ECHO.
#
#   Pseudo commandes.

# PACKAGE PACKAGEDIR
#
#   Nom de l'application préparée.
#
#   La variable PACKAGE peut être définie par le client. Lorsque
#   c'est le cas la Collection de Makefiles en tient compte dans
#   certains endroits, notamment pour donner des noms de répertoires
#   censés être appropriés. C'est en fait la variable PACKAGEDIR qui
#   joue ce rôle, on s'en sert par exemple pour définir
#   SHAREDIR=/share${PACKAGEDIR}, etc.
#
#   SeeAlso: bps.own.mk bps.files.mk


### IMPLÉMENTATION

.if !target(__<bps.init.mk>__)
__<bps.init.mk>__:

.if exists(bps.config.mk)
.include "bps.config.mk"
.endif

### INSTALLATION DE BPS

# Ces déclarations ne tiennent pas compte de tous les paramètres
# pouvant être passés au script `configure'.

_BPS_PACKAGEDIR?= /bps
_BPS_PREFIX?= /usr/local
_BPS_DATADIR?= ${_BPS_PREFIX}/share${_BPS_PACKAGEDIR}
_BPS_DOCDIR?= ${_BPS_PREFIX}/share/doc${_BPS_PACKAGEDIR}
_BPS_LIBEXECDIR?= ${_BPS_PREFIX}/libexec${_BPS_PACKAGEDIR}
_BPS_TEXMFDIR?= ${_BPS_PREFIX}/share/texmf

_BPS_SYSTEMOWN?= root
_BPS_SYSTEMGRP?= wheel

_BPS_COMPRESS?= gzip xz

### PSEUDO COMMANDES (BOOTSTRAP)

ID?= id
.if !defined(UID)
UID!= ${ID} -u
.endif

.if !defined(USER)
USER!= ${ID} -n -u
.endif

.if !defined(GROUP)
GROUP!= ${ID} -n -g
.endif

### DOSSIER D'INSTALLATION

DESTDIR?=
PREFIX?= /usr/local

### FICHIER DE CONFIGURATION

MAKEINITRC?= Makefile.inc

.if exists(${.CURDIR}/${MAKEINITRC})
.include "${.CURDIR}/${MAKEINITRC}"
.endif

.if defined(PROJECTBASE) && !empty(PROJECTBASE)
.if ${PROJECTBASE} != ${.CURDIR}
.if exists(${PROJECTBASE}/${MAKEINITRC})
.include "${PROJECTBASE}/${MAKEINITRC}"
.endif
.endif
.endif


## PSEUDO COMMANDES

ENVTOOL?=		env			# Le nom ENV
                                                #  appartient à sh(1)
CP?=			cp
RM?=			rm
MV?=			mv
LN?=			ln
LN_S?=			ln -s
MKDIR?=			mkdir
MKDIR_P?=		.././install-sh -c -d
TAR?=			tar
INSTALL?=		/usr/bin/install -c
INSTALL_DIR?=		/usr/bin/install -c -d
AWK?=			nawk
GREP?=			/usr/bin/grep
SED?=			/usr/bin/sed
SED_INPLACE?=		${SED} -i .bk
TOUCH?=			touch
ECHO?=			echo
INFO?=			@echo '===>'
WARN?=			@echo 'Warning:'
FAIL?=			@echo 'Failure:'
MESG?=			@echo
NOP?=			@: do nada
SU?=			su

### VARIABLES

CLEANFILES?=
CLEANDIRS?=
DISTCLEANFILES?=
DISTCLEANDIRS?=
REALCLEANFILES?=
REALCLEANDIRS?=
COOKIEPREFIX?= .cookie.

## CIBLE IMPLICTE (all)

.MAIN:			all


## PACKAGEDIR

.if !defined(PACKAGE)&&defined(PROJECT)&&!empty(PROJECT)
PACKAGE = ${PROJECT}
.endif

.if defined(PACKAGE)&&!empty(PACKAGE)
PACKAGEDIR?=	/${PACKAGE}
.endif

## _MAKE_USERTARGET

_MAKE_USERTARGET?=
_MAKE_ALLSUBTARGET?=

.include "bps.objdir.mk"
.include "bps.autoconf.mk"
.include "bps.credentials.mk"

_MAKE_USERTARGET+= configure depend build doc all install
_MAKE_USERTARGET+= clean distclean realclean
_MAKE_ALLSUBTARGET+= configure depend build doc


#
# Héritage de certaines variables
#

# Les valeurs des variables DESTDIR, PREFIX et PACKAGE sont
# exportées.

.if empty(.MAKEFLAGS:MPREFIX=*)&&defined(PREFIX)
.MAKEFLAGS: PREFIX='${PREFIX}'
.endif

.if empty(.MAKEFLAGS:MDESTDIR=*)&&defined(DESTDIR)
.MAKEFLAGS: DESTDIR='${DESTDIR}'
.endif

.if empty(.MAKEFLAGS:MPACKAGE=*)&&defined(PACKAGE)
.MAKEFLAGS: PACKAGE='${PACKAGE}'
.endif

.endif # !target(__<bps.init.mk>__)

### End of file `bps.init.mk'
