# bladeRF Library (libbladeRF) #
This is the source for the library which interacts with the bladeRF device.

It is meant to be used as a simple and intuitive way to think about not just the bladeRF device itself, but most any radio hardware.  Fundamental operations such as setting the tuning frequency, manipulating switches on the board for different paths, and changing the different transmit and receive gains are all parts of a radio system which need to be exposed at a library level.

Functionality provided by this library includes:
- Opening/closing devices and querying information about them
- Tuning to various frequencies
- Configuring the sample rate
- Configuring the bandwidth and gain of the RF chain
- Configuring RF gains
- Transmitting and receiving complex baseband samples
- Updating the device's firmware and FPGA
- Low-level access to on-board devices, for testing and debugging

For more information, please generate and view the doxygen documentation. From your host/build directory, run:
```
cmake -DBUILD_DOCUMENTATION=ON ../
make libbladeRF-doxygen
```
The HTML documentation will be placed in **\<build dir\>/libraries/libbladerf/doc/doxygen/html**.  The **index.html** file is the "main" documentation page.

Please see the [CHANGELOG](CHANGELOG) file for a summary of changes across libbladeRF versions.

## Build Variables ##

Below is a list of useful and project-specific CMake options. Please see the CMake [variable list] in CMake's documentation for
more information.

| Option                                            | Description
| ------------------------------------------------- |:------------------------------------------------------------------------------------------------------------------|
| -DBUILD_LIBBLADERF_DOCUMENTATION=\<ON/OFF\>       | Builds API documentation using Doxygen.  Default: equal to BUILD_DOCUMENTATION                                    |
| -DENABLE_BACKEND_LIBUSB=\<ON/OFF\>                | Enables libusb backend in libbladeRF. Default: ON                                                                 |
| -DENABLE_BACKEND_USB=\<ON/OFF\>                   | Enables USB backends in libbladeRF.  Default: ON                                                                  |
| -DENABLE_BACKEND_LINUX_DRIVER=\<ON/OFF\>          | Enables Linux driver in libbladeRF. Default: OFF                                                                  |
| -DENABLE_BACKEND_DUMMY=\<ON/OFF\>                 | Enables dummy backend support in libbladeRF.  Only useful for some developers.  Default: OFF                      |
| -DENABLE_LIBBLADERF_LOGGING=\<ON/OFF\>            | Enable log messages in libbladeRF.  Default: ON                                                                   |
| -DENABLE_LIBBLADERF_SYNC_LOG_VERBOSE=\<ON/OFF\>   | Enable log_verbose() calls in the sync interface's data path. Note that this may harm performance. Default: OFF   |
| -DENABLE_LOCK_CHECKS=\<ON/OFF\>                   | Enable checks for lock acquistion failures (e.g., deadlock). Default: OFF                                         |
| -DLIBUSB_DETACH_KERNEL_DRIVER=\<ON/OFF\>          | Enable calls to libusb_detach_kernel_driver(). Not supported in Windows. Default: ON                              |
| -DLIBUSB_PATH=\</path/to/libusb\>                 | Path to libusb files. (This is generally only needed for Windows users who downloaded binary distributions.)      |
