/*
 * Decompiled with CFR 0.152.
 */
package com.ryanharter.auto.value.gson.factory;

import autovaluegson.factory.shaded.com.google.auto.common.GeneratedAnnotations;
import autovaluegson.factory.shaded.com.google.auto.common.MoreElements;
import autovaluegson.factory.shaded.com.google.auto.common.Visibility;
import autovaluegson.factory.shaded.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.ryanharter.auto.value.gson.AutoValueGsonExtension;
import com.ryanharter.auto.value.gson.GsonTypeAdapterFactory;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class AutoValueGsonAdapterFactoryProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of(AutoValue.class.getName(), GsonTypeAdapterFactory.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> adapterFactories = roundEnv.getElementsAnnotatedWith(GsonTypeAdapterFactory.class);
        if (adapterFactories.isEmpty()) {
            return false;
        }
        Set<? extends Element> autoValueElements = roundEnv.getElementsAnnotatedWith(AutoValue.class);
        List elements = autoValueElements.stream().map(e -> (TypeElement)e).filter(e -> AutoValueGsonExtension.isApplicable((TypeElement)e, (Messager)this.processingEnv.getMessager())).sorted((o1, o2) -> {
            String o1Name = AutoValueGsonAdapterFactoryProcessor.classNameOf(o1, ".");
            String o2Name = AutoValueGsonAdapterFactoryProcessor.classNameOf(o2, ".");
            return o1Name.compareTo(o2Name);
        }).collect(Collectors.toList());
        if (elements.isEmpty()) {
            Element reportableElement = adapterFactories.iterator().next();
            if (!autoValueElements.isEmpty()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write TypeAdapterFactory: Cannot generate class for this @GsonTypeAdapterFactory-annotated element because while @AutoValue-annotated elements were found on the compilation classpath, none of them contain a requisite public static TypeAdapter-returning signature method to opt in to being included in @GsonTypeAdapterFactory-generated factories. See the auto-value-gson README for more information on declaring these.", reportableElement);
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write TypeAdapterFactory: Cannot generate class for this @GsonTypeAdapterFactory-annotated element because no @AutoValue-annotated elements were found on the compilation classpath.", reportableElement);
            }
            return false;
        }
        for (Element element : adapterFactories) {
            TypeElement type;
            if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.error(element, "Must be abstract!", new Object[0]);
            }
            if (!this.implementsTypeAdapterFactory(type = (TypeElement)element)) {
                this.error(element, "Must implement TypeAdapterFactory!", new Object[0]);
            }
            String adapterName = AutoValueGsonAdapterFactoryProcessor.classNameOf(type, "_");
            String qualifiedName = AutoValueGsonAdapterFactoryProcessor.classNameOf(type, ".");
            PackageElement packageElement = AutoValueGsonAdapterFactoryProcessor.packageElementOf(type);
            String packageName = packageElement.getQualifiedName().toString();
            List<TypeElement> applicableElements = elements.stream().filter(e -> {
                Visibility typeVisibility = Visibility.ofElement(e);
                switch (typeVisibility) {
                    case PRIVATE: {
                        return false;
                    }
                    case DEFAULT: 
                    case PROTECTED: {
                        if (MoreElements.getPackage(e).equals(packageElement)) break;
                        return false;
                    }
                }
                ExecutableElement adapterMethod = this.getTypeAdapterMethod((TypeElement)e);
                if (adapterMethod == null) {
                    return false;
                }
                Visibility methodVisibility = Visibility.ofElement(adapterMethod);
                switch (methodVisibility) {
                    case PRIVATE: {
                        return false;
                    }
                    case DEFAULT: 
                    case PROTECTED: {
                        if (MoreElements.getPackage(adapterMethod).equals(packageElement)) break;
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
            TypeSpec typeAdapterFactory = this.createTypeAdapterFactory(type, applicableElements, packageName, adapterName, qualifiedName);
            JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)typeAdapterFactory).build();
            try {
                file.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e2) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write TypeAdapterFactory: " + e2.getLocalizedMessage(), element);
            }
        }
        return false;
    }

    private static AnnotationSpec createGeneratedAnnotationSpec(TypeElement generatedAnnotationTypeElement) {
        return AnnotationSpec.builder((ClassName)ClassName.get((TypeElement)generatedAnnotationTypeElement)).addMember("value", "$S", new Object[]{AutoValueGsonAdapterFactoryProcessor.class.getName()}).addMember("comments", "$S", new Object[]{"https://github.com/rharter/auto-value-gson"}).build();
    }

    private TypeSpec createTypeAdapterFactory(TypeElement sourceElement, List<TypeElement> elements, String packageName, String adapterName, String qualifiedName) {
        TypeSpec.Builder factory = TypeSpec.classBuilder((ClassName)ClassName.get((String)packageName, (String)("AutoValueGson_" + adapterName), (String[])new String[0]));
        Optional<AnnotationSpec> generatedAnnotationSpec = GeneratedAnnotations.generatedAnnotation(this.processingEnv.getElementUtils(), this.processingEnv.getSourceVersion()).map(AutoValueGsonAdapterFactoryProcessor::createGeneratedAnnotationSpec);
        generatedAnnotationSpec.ifPresent(arg_0 -> ((TypeSpec.Builder)factory).addAnnotation(arg_0));
        factory.addOriginatingElement((Element)sourceElement);
        factory.addModifiers(new Modifier[]{Modifier.FINAL});
        factory.superclass((TypeName)ClassName.get((String)packageName, (String)qualifiedName, (String[])new String[0]));
        ParameterSpec gson = ParameterSpec.builder(Gson.class, (String)"gson", (Modifier[])new Modifier[0]).build();
        TypeVariableName t = TypeVariableName.get((String)"T");
        ParameterSpec type = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeToken.class), (TypeName[])new TypeName[]{t}), (String)"type", (Modifier[])new Modifier[0]).build();
        ParameterizedTypeName result = ParameterizedTypeName.get((ClassName)ClassName.get(TypeAdapter.class), (TypeName[])new TypeName[]{t});
        MethodSpec.Builder create = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(t).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build()).addParameters(ImmutableSet.of(gson, type)).returns((TypeName)result).addStatement("Class<?> rawType = $N.getRawType()", new Object[]{type});
        List properties = elements.stream().peek(arg_0 -> ((TypeSpec.Builder)factory).addOriginatingElement(arg_0)).map(e -> Pair.create(e, this.getTypeAdapterMethod((TypeElement)e))).filter(entry -> ((Pair)entry).second != null).collect(Collectors.toList());
        int elementsSize = properties.size();
        for (int i = 0; i < elementsSize; ++i) {
            Pair pair = (Pair)properties.get(i);
            Element element = (Element)pair.first;
            TypeName elementType = this.rawType(element);
            if (i == 0) {
                create.beginControlFlow("if ($T.class.isAssignableFrom(rawType))", new Object[]{elementType});
            } else {
                create.nextControlFlow("else if ($T.class.isAssignableFrom(rawType))", new Object[]{elementType});
            }
            ExecutableElement typeAdapterMethod = (ExecutableElement)pair.second;
            List<? extends VariableElement> params = typeAdapterMethod.getParameters();
            if (params == null || params.size() == 0) {
                create.addStatement("return (TypeAdapter<$T>) $T." + typeAdapterMethod.getSimpleName() + "()", new Object[]{t, elementType});
                continue;
            }
            if (params.size() == 1) {
                create.addStatement("return (TypeAdapter<$T>) $T." + typeAdapterMethod.getSimpleName() + "($N)", new Object[]{t, elementType, gson});
                continue;
            }
            create.addStatement("return (TypeAdapter<$T>) $T." + typeAdapterMethod.getSimpleName() + "($N, (($T) $N.getType()).getActualTypeArguments())", new Object[]{t, elementType, gson, ParameterizedType.class, type});
        }
        create.nextControlFlow("else", new Object[0]);
        create.addStatement("return null", new Object[0]);
        create.endControlFlow();
        factory.addMethod(create.build());
        return factory.build();
    }

    private TypeName rawType(Element element) {
        TypeName type = TypeName.get((TypeMirror)element.asType());
        if (type instanceof ParameterizedTypeName) {
            type = ((ParameterizedTypeName)type).rawType;
        }
        return type;
    }

    private ExecutableElement getTypeAdapterMethod(TypeElement element) {
        TypeName type = TypeName.get((TypeMirror)element.asType());
        ParameterizedTypeName typeAdapterType = ParameterizedTypeName.get((ClassName)ClassName.get(TypeAdapter.class), (TypeName[])new TypeName[]{type});
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (!method.getModifiers().contains((Object)Modifier.STATIC) || method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            TypeName returnType = TypeName.get((TypeMirror)method.getReturnType());
            if (returnType.equals((Object)typeAdapterType)) {
                return method;
            }
            if (!(returnType instanceof ParameterizedTypeName)) continue;
            ParameterizedTypeName paramReturnType = (ParameterizedTypeName)returnType;
            TypeName argument = (TypeName)paramReturnType.typeArguments.get(0);
            if (!(type instanceof ParameterizedTypeName)) continue;
            ParameterizedTypeName pTypeName = (ParameterizedTypeName)type;
            if (!pTypeName.rawType.equals((Object)argument)) continue;
            return method;
        }
        return null;
    }

    private void error(Element element, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private boolean implementsTypeAdapterFactory(TypeElement type) {
        TypeMirror typeAdapterFactoryType = this.elementUtils.getTypeElement(TypeAdapterFactory.class.getCanonicalName()).asType();
        TypeMirror typeMirror = type.asType();
        if (!type.getInterfaces().isEmpty() || typeMirror.getKind() != TypeKind.NONE) {
            while (typeMirror.getKind() != TypeKind.NONE) {
                if (this.searchInterfacesAncestry(typeMirror, typeAdapterFactoryType)) {
                    return true;
                }
                type = (TypeElement)this.typeUtils.asElement(typeMirror);
                typeMirror = type.getSuperclass();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean searchInterfacesAncestry(TypeMirror rootIface, TypeMirror target) {
        TypeElement rootIfaceElement = (TypeElement)this.typeUtils.asElement(rootIface);
        for (TypeMirror typeMirror : rootIfaceElement.getInterfaces()) {
            void var5_5;
            TypeElement ifaceElement = (TypeElement)this.typeUtils.asElement(rootIface);
            while (var5_5.getKind() != TypeKind.NONE) {
                if (this.typeUtils.isSameType((TypeMirror)var5_5, target)) {
                    return true;
                }
                if (this.searchInterfacesAncestry((TypeMirror)var5_5, target)) {
                    return true;
                }
                TypeMirror typeMirror2 = ifaceElement.getSuperclass();
            }
        }
        return false;
    }

    private static String classNameOf(TypeElement type, String delimiter) {
        StringBuilder name = new StringBuilder(type.getSimpleName().toString());
        while (type.getEnclosingElement() instanceof TypeElement) {
            type = (TypeElement)type.getEnclosingElement();
            name.insert(0, type.getSimpleName() + delimiter);
        }
        return name.toString();
    }

    private static PackageElement packageElementOf(TypeElement type) {
        return MoreElements.getPackage(type);
    }

    private static class Pair<F, S> {
        private final F first;
        private final S second;

        private Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        static <F, S> Pair<F, S> create(F first, S second) {
            return new Pair<F, S>(first, second);
        }
    }
}

