/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Optional;

@BugPattern(summary="Duration.get() only works with SECONDS or NANOS.", explanation="`Duration.get(TemporalUnit)` only works when passed `ChronoUnit.SECONDS` or `ChronoUnit.NANOS`. All other values are guaranteed to throw a `UnsupportedTemporalTypeException`. In general, you should avoid `duration.get(ChronoUnit)`. Instead, please use `duration.toNanos()`, `Durations.toMicros(duration)`, `duration.toMillis()`, `duration.getSeconds()`, `duration.toMinutes()`, `duration.toHours()`, or `duration.toDays()`.", severity=BugPattern.SeverityLevel.ERROR)
public final class DurationGetTemporalUnit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<ChronoUnit> INVALID_TEMPORAL_UNITS = ImmutableSet.copyOf(EnumSet.complementOf(EnumSet.of(ChronoUnit.SECONDS, ChronoUnit.NANOS)));
    private static final ImmutableMap<ChronoUnit, String> SUGGESTIONS = ImmutableMap.builder().put((Object)ChronoUnit.DAYS, (Object)".toDays()").put((Object)ChronoUnit.HOURS, (Object)".toHours()").put((Object)ChronoUnit.MINUTES, (Object)".toMinutes()").put((Object)ChronoUnit.MILLIS, (Object)".toMillis()").buildOrThrow();
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onExactClass("java.time.Duration").named("get").withParameters("java.time.temporal.TemporalUnit", new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Optional<ChronoUnit> invalidUnit;
        if (MATCHER.matches((Tree)tree, state) && (invalidUnit = DurationGetTemporalUnit.getInvalidChronoUnit((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), INVALID_TEMPORAL_UNITS)).isPresent()) {
            if (SUGGESTIONS.containsKey((Object)invalidUnit.get())) {
                SuggestedFix.Builder builder = SuggestedFix.builder();
                builder.replace((Tree)tree, state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)) + (String)SUGGESTIONS.get((Object)invalidUnit.get()));
                return this.describeMatch(tree, (Fix)builder.build());
            }
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    static Optional<ChronoUnit> getInvalidChronoUnit(ExpressionTree tree, Iterable<ChronoUnit> invalidUnits) {
        Optional<String> constant = DurationGetTemporalUnit.getEnumName(tree);
        if (constant.isPresent()) {
            for (ChronoUnit invalidTemporalUnit : invalidUnits) {
                if (!constant.get().equals(invalidTemporalUnit.name())) continue;
                return Optional.of(invalidTemporalUnit);
            }
        }
        return Optional.empty();
    }

    private static Optional<String> getEnumName(ExpressionTree temporalUnit) {
        if (temporalUnit instanceof IdentifierTree) {
            return Optional.of(((IdentifierTree)temporalUnit).getName().toString());
        }
        if (temporalUnit instanceof MemberSelectTree) {
            return Optional.of(((MemberSelectTree)temporalUnit).getIdentifier().toString());
        }
        return Optional.empty();
    }
}

