/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.errorprone.BugPattern;
import com.google.errorprone.SuppressionHelper;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Scanner
extends TreePathScanner<Void, VisitorState> {
    private Set<String> suppressions = new HashSet<String>();
    private Set<Class<? extends Annotation>> customSuppressions = new HashSet<Class<? extends Annotation>>();
    private boolean inGeneratedCode = false;
    private SuppressionHelper suppressionHelper;

    private void initSuppressionHelper(VisitorState state) {
        if (this.suppressionHelper == null) {
            this.suppressionHelper = new SuppressionHelper(this.getCustomSuppressionAnnotations(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(TreePath path, VisitorState state) {
        SuppressionHelper.SuppressionInfo prevSuppressionInfo = this.updateSuppressions(path.getLeaf(), state);
        try {
            Void void_ = (Void)super.scan(path, state);
            return void_;
        }
        finally {
            this.suppressions = prevSuppressionInfo.suppressWarningsStrings;
            this.customSuppressions = prevSuppressionInfo.customSuppressions;
            this.inGeneratedCode = prevSuppressionInfo.inGeneratedCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(Tree tree, VisitorState state) {
        if (tree == null) {
            return null;
        }
        SuppressionHelper.SuppressionInfo prevSuppressionInfo = this.updateSuppressions(tree, state);
        try {
            Void void_ = (Void)super.scan(tree, state);
            return void_;
        }
        finally {
            this.suppressions = prevSuppressionInfo.suppressWarningsStrings;
            this.customSuppressions = prevSuppressionInfo.customSuppressions;
            this.inGeneratedCode = prevSuppressionInfo.inGeneratedCode;
        }
    }

    private SuppressionHelper.SuppressionInfo updateSuppressions(Tree tree, VisitorState state) {
        SuppressionHelper.SuppressionInfo prevSuppressionInfo = new SuppressionHelper.SuppressionInfo(this.suppressions, this.customSuppressions, this.inGeneratedCode);
        this.initSuppressionHelper(state);
        Symbol sym = ASTHelpers.getDeclaredSymbol(tree);
        if (sym != null) {
            SuppressionHelper.SuppressionInfo newSuppressions = this.suppressionHelper.extendSuppressionSets(sym, state.getSymtab().suppressWarningsType, this.suppressions, this.customSuppressions, this.inGeneratedCode, state);
            if (newSuppressions.suppressWarningsStrings != null) {
                this.suppressions = newSuppressions.suppressWarningsStrings;
            }
            if (newSuppressions.customSuppressions != null) {
                this.customSuppressions = newSuppressions.customSuppressions;
            }
            this.inGeneratedCode = newSuppressions.inGeneratedCode;
        }
        return prevSuppressionInfo;
    }

    protected boolean isSuppressed(Suppressible suppressible, VisitorState state) {
        this.initSuppressionHelper(state);
        return SuppressionHelper.isSuppressed(suppressible, this.suppressions, this.customSuppressions, this.severityMap().get(suppressible.canonicalName()), this.inGeneratedCode, state.errorProneOptions().disableWarningsInGeneratedCode());
    }

    protected Set<Class<? extends Annotation>> getCustomSuppressionAnnotations() {
        return Collections.emptySet();
    }

    protected void reportMatch(Description description, VisitorState state) {
        if (description == null || description == Description.NO_MATCH) {
            return;
        }
        state.reportMatch(description);
    }

    protected void handleError(Suppressible s, Throwable t) {
    }

    public Map<String, BugPattern.SeverityLevel> severityMap() {
        return Collections.emptyMap();
    }
}

