/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import javax.lang.model.element.ElementKind;

@BugPattern(name="TypeParameterQualifier", summary="Type parameter used as type qualifier", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class TypeParameterQualifier
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        Symbol baseSym = ASTHelpers.getSymbol((Tree)tree.getExpression());
        if (baseSym == null || baseSym.getKind() != ElementKind.TYPE_PARAMETER) {
            return Description.NO_MATCH;
        }
        TreeMaker make = TreeMaker.instance(state.context).forToplevel((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit());
        JCTree.JCExpression qual = make.QualIdent(ASTHelpers.getSymbol((Tree)tree));
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)qual.toString()));
    }
}

