/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MockitoCast", summary="A bug in Mockito will cause this test to fail at runtime with a ClassCastException", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class MockitoCast
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String MOCKITO_CLASS = "org.mockito.Mockito";
    private static final String UI_FIELD_ANNOTATION = "com.google.gwt.uibinder.client.UiField";
    private static final String MOCK_ANNOTATION = "org.mockito.Mock";
    private static final ImmutableSet<String> BAD_ANSWER_STRATEGIES = ImmutableSet.of((Object)"RETURNS_SMART_NULLS", (Object)"RETURNS_MOCKS", (Object)"RETURNS_DEEP_STUBS");
    private static final Matcher<ExpressionTree> WHEN_MATCHER = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("when");

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        Symbol mockitoSym = state.getSymbolFromString(MOCKITO_CLASS);
        if (mockitoSym == null) {
            return Description.NO_MATCH;
        }
        LinkedHashSet<Symbol> badAnswers = new LinkedHashSet<Symbol>();
        for (Symbol member : mockitoSym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (member.getKind() != ElementKind.FIELD || !BAD_ANSWER_STRATEGIES.contains((Object)member.getSimpleName().toString())) continue;
            badAnswers.add(member);
        }
        Set<Symbol.VarSymbol> mockVariables = MockInitializationScanner.scan(state, badAnswers);
        new WhenNeedsCastScanner(mockVariables, state).scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    static class MockAnswerStrategyScanner
    extends TreeScanner<Boolean, Void> {
        private final VisitorState state;
        private final Set<Symbol.VarSymbol> badMocks;

        static boolean scan(Tree tree, VisitorState state, Set<Symbol.VarSymbol> badMocks) {
            return (Boolean)MoreObjects.firstNonNull((Object)tree.accept(new MockAnswerStrategyScanner(state, badMocks), null), (Object)false);
        }

        public MockAnswerStrategyScanner(VisitorState state, Set<Symbol.VarSymbol> badMocks) {
            this.state = state;
            this.badMocks = badMocks;
        }

        @Override
        public Boolean scan(Tree tree, Void aVoid) {
            Symbol sym = ASTHelpers.getSymbol((Tree)tree);
            if (sym instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSym = (Symbol.VarSymbol)sym;
                if (this.badMocks.contains(ASTHelpers.getSymbol((Tree)tree))) {
                    return true;
                }
                if (ASTHelpers.hasAnnotation((Symbol)sym, (String)MockitoCast.MOCK_ANNOTATION, (VisitorState)this.state) && !MockAnswerStrategyScanner.answerHandlesGenerics(varSym, this.state)) {
                    return true;
                }
                if (ASTHelpers.hasAnnotation((Symbol)varSym, (String)MockitoCast.UI_FIELD_ANNOTATION, (VisitorState)this.state)) {
                    return true;
                }
            }
            return (Boolean)super.scan(tree, aVoid);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return (Boolean)MoreObjects.firstNonNull((Object)r1, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)r2, (Object)false) != false;
        }

        static boolean answerHandlesGenerics(Symbol.VarSymbol varSym, VisitorState state) {
            Attribute.Compound attribute = varSym.attribute(state.getSymbolFromString(MockitoCast.MOCK_ANNOTATION));
            String answer = null;
            for (Map.Entry<Symbol.MethodSymbol, Attribute> e : attribute.getElementValues().entrySet()) {
                if (!((Name)e.getKey().getSimpleName()).contentEquals("answer")) continue;
                answer = e.getValue().getValue().toString();
                break;
            }
            return !BAD_ANSWER_STRATEGIES.contains(answer);
        }
    }

    class WhenNeedsCastScanner
    extends TreePathScanner<Void, Void> {
        final Set<Symbol.VarSymbol> badMocks;
        final VisitorState state;

        WhenNeedsCastScanner(Set<Symbol.VarSymbol> badMocks, VisitorState state) {
            this.badMocks = badMocks;
            this.state = state;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            Description description = this.matchMethodInvocation(node, this.state.withPath(this.getCurrentPath()));
            if (description != Description.NO_MATCH) {
                this.state.reportMatch(description);
            }
            return (Void)super.visitMethodInvocation(node, null);
        }

        public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
            if (!WHEN_MATCHER.matches((Tree)tree, state)) {
                return Description.NO_MATCH;
            }
            if (tree.getArguments().size() != 1) {
                return Description.NO_MATCH;
            }
            ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
            if (!(arg instanceof JCTree.JCMethodInvocation)) {
                return Description.NO_MATCH;
            }
            JCTree.JCMethodInvocation call = (JCTree.JCMethodInvocation)arg;
            Types types = state.getTypes();
            if (call.meth.type == null) {
                return Description.NO_MATCH;
            }
            Type instantiatedReturnType = types.erasure(call.meth.type.getReturnType());
            if (instantiatedReturnType == null) {
                return Description.NO_MATCH;
            }
            Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)call);
            if (methodSym == null) {
                return Description.NO_MATCH;
            }
            if (methodSym.type == null) {
                return Description.NO_MATCH;
            }
            Type uninstantiatedReturnType = types.erasure(methodSym.type.getReturnType());
            if (uninstantiatedReturnType == null) {
                return Description.NO_MATCH;
            }
            if (types.isSameType(instantiatedReturnType, uninstantiatedReturnType)) {
                return Description.NO_MATCH;
            }
            if (!MockAnswerStrategyScanner.scan(call.getMethodSelect(), state, this.badMocks)) {
                return Description.NO_MATCH;
            }
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            String qual = uninstantiatedReturnType.tsym.getTypeParameters().isEmpty() ? SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (Symbol)uninstantiatedReturnType.tsym) : "Object";
            fixBuilder.prefixWith((Tree)arg, String.format("(%s) ", qual));
            return MockitoCast.this.describeMatch(tree, (Fix)fixBuilder.build());
        }
    }

    static class MockInitializationScanner
    extends TreeScanner<Void, Void> {
        private final Set<Symbol.VarSymbol> mockVariables = new LinkedHashSet<Symbol.VarSymbol>();
        private final Set<Symbol> badAnswers;

        static Set<Symbol.VarSymbol> scan(VisitorState state, Set<Symbol> badAnswers) {
            MockInitializationScanner scanner = new MockInitializationScanner(badAnswers);
            state.getPath().getCompilationUnit().accept(scanner, null);
            return scanner.mockVariables;
        }

        public MockInitializationScanner(Set<Symbol> badAnswers) {
            this.badAnswers = badAnswers;
        }

        @Override
        public Void visitVariable(VariableTree node, Void aVoid) {
            this.recordInitialization(node, node.getInitializer());
            return (Void)super.visitVariable(node, aVoid);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void aVoid) {
            this.recordInitialization(node.getVariable(), node.getExpression());
            return (Void)super.visitAssignment(node, aVoid);
        }

        private void recordInitialization(Tree varTree, ExpressionTree initializer) {
            if (initializer == null) {
                return;
            }
            Symbol sym = ASTHelpers.getSymbol((Tree)varTree);
            if (!(sym instanceof Symbol.VarSymbol)) {
                return;
            }
            Boolean initializedWithBadAnswer = initializer.accept(new TreeScanner<Boolean, Void>(){

                @Override
                public Boolean scan(Tree tree, Void unused) {
                    if (badAnswers.contains(ASTHelpers.getSymbol((Tree)tree))) {
                        return true;
                    }
                    return (Boolean)super.scan(tree, null);
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    return (Boolean)MoreObjects.firstNonNull((Object)r1, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)r2, (Object)false) != false;
                }
            }, null);
            if (((Boolean)MoreObjects.firstNonNull((Object)initializedWithBadAnswer, (Object)false)).booleanValue()) {
                this.mockVariables.add((Symbol.VarSymbol)sym);
            }
        }
    }
}

