/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.ElementScanner9;
import javax.lang.model.util.Elements;

public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Elements eltUtils;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean processingOver, boolean errorRaised, Set<? extends Element> rootElements, ProcessingEnvironment processingEnv) {
        this.processingOver = processingOver;
        this.errorRaised = errorRaised;
        this.rootElements = rootElements;
        this.processingEnv = processingEnv;
        this.eltUtils = processingEnv.getElementUtils();
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        this.throwIfNotAnnotation(a);
        Set result = Collections.emptySet();
        AnnotationSetScanner scanner = new AnnotationSetScanner(result);
        for (Element element : this.rootElements) {
            result = (Set)((ElementScanner6)scanner).scan(element, a);
        }
        return result;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWithAny(TypeElement ... annotations) {
        LinkedHashSet<TypeElement> annotationSet = new LinkedHashSet<TypeElement>(annotations.length);
        for (TypeElement typeElement : annotations) {
            this.throwIfNotAnnotation(typeElement);
            annotationSet.add(typeElement);
        }
        Set result = Collections.emptySet();
        AnnotationSetMultiScanner scanner = new AnnotationSetMultiScanner(result);
        for (Element element : this.rootElements) {
            result = (Set)((ElementScanner6)scanner).scan(element, annotationSet);
        }
        return result;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        this.throwIfNotAnnotation(a);
        String name = a.getCanonicalName();
        if (name == null) {
            return Collections.emptySet();
        }
        TypeElement annotationType = this.eltUtils.getTypeElement(name);
        if (annotationType == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(annotationType);
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWithAny(Set<Class<? extends Annotation>> annotations) {
        ArrayList<TypeElement> annotationsAsElements = new ArrayList<TypeElement>(annotations.size());
        for (Class<? extends Annotation> annotation : annotations) {
            this.throwIfNotAnnotation(annotation);
            String name = annotation.getCanonicalName();
            if (name == null) continue;
            annotationsAsElements.add(this.eltUtils.getTypeElement(name));
        }
        return this.getElementsAnnotatedWithAny(annotationsAsElements.toArray(new TypeElement[0]));
    }

    private Element mirrorAsElement(AnnotationMirror annotationMirror) {
        return annotationMirror.getAnnotationType().asElement();
    }

    private void throwIfNotAnnotation(Class<? extends Annotation> a) {
        if (!a.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
    }

    private void throwIfNotAnnotation(TypeElement a) {
        if (a.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
    }

    private static abstract class ElementScanningIncludingTypeParameters<R, P>
    extends ElementScanner9<R, P> {
        protected ElementScanningIncludingTypeParameters(R defaultValue) {
            super(defaultValue);
        }

        @Override
        public R visitType(TypeElement e, P p) {
            this.scan(e.getTypeParameters(), p);
            return super.visitType(e, p);
        }

        @Override
        public R visitExecutable(ExecutableElement e, P p) {
            this.scan(e.getTypeParameters(), p);
            return super.visitExecutable(e, p);
        }
    }

    private class AnnotationSetMultiScanner
    extends ElementScanningIncludingTypeParameters<Set<Element>, Set<TypeElement>> {
        private Set<Element> annotatedElements;

        AnnotationSetMultiScanner(Set<Element> defaultSet) {
            super(defaultSet);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> scan(Element e, Set<TypeElement> annotations) {
            for (AnnotationMirror annotationMirror : JavacRoundEnvironment.this.eltUtils.getAllAnnotationMirrors(e)) {
                if (!annotations.contains(JavacRoundEnvironment.this.mirrorAsElement(annotationMirror))) continue;
                this.annotatedElements.add(e);
                break;
            }
            e.accept(this, annotations);
            return this.annotatedElements;
        }
    }

    private class AnnotationSetScanner
    extends ElementScanningIncludingTypeParameters<Set<Element>, TypeElement> {
        private Set<Element> annotatedElements;

        AnnotationSetScanner(Set<Element> defaultSet) {
            super(defaultSet);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> scan(Element e, TypeElement annotation) {
            for (AnnotationMirror annotationMirror : JavacRoundEnvironment.this.eltUtils.getAllAnnotationMirrors(e)) {
                if (!annotation.equals(JavacRoundEnvironment.this.mirrorAsElement(annotationMirror))) continue;
                this.annotatedElements.add(e);
                break;
            }
            e.accept(this, annotation);
            return this.annotatedElements;
        }
    }
}

