/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.list.ElementList;

public final class DoubleList
extends ElementList {
    private double[] list;

    public DoubleList() {
        this(-1L);
    }

    public DoubleList(long capacity) {
        this.list = new double[Array.initialCapacity(capacity)];
    }

    public DoubleList add(double element) {
        int s = this.size;
        double[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.size = s + 1;
        return this;
    }

    public DoubleList add(double ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        double[] lst = this.list;
        if (ns > lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.size = ns;
        return this;
    }

    public double get(int index) {
        return this.list[index];
    }

    public double[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public double[] finish() {
        double[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof DoubleList)) return false;
        DoubleList l = (DoubleList)obj;
        if (!Arrays.equals(this.list, 0, this.size, l.list, 0, l.size)) return false;
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

