/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryBiPredicate;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.MapType;

public final class XQSingletonMap
extends XQMap {
    private final Item k;
    private Value v;

    XQSingletonMap(Item key, Value value) {
        super(MapType.get(key.type, value.seqType()));
        this.k = key;
        this.v = value;
    }

    @Override
    public long structSize() {
        return 1L;
    }

    @Override
    public Value getOrNull(Item key) throws QueryException {
        return key.atomicEqual(this.k) ? this.v : null;
    }

    @Override
    public Value keys() {
        return this.k;
    }

    @Override
    public Item keyAt(int index) {
        return this.k;
    }

    @Override
    public Value valueAt(int index) {
        return this.v;
    }

    @Override
    public XQMap put(Item key, Value value) throws QueryException {
        return key.atomicEqual(this.k) ? new XQSingletonMap(this.k, value) : XQSingletonMap.empty().put(this.k, this.v).put(key, value);
    }

    @Override
    public XQMap putAt(int index, Value value) {
        return new XQSingletonMap(this.k, value);
    }

    @Override
    public XQMap remove(Item key) throws QueryException {
        return key.atomicEqual(this.k) ? XQSingletonMap.empty() : this;
    }

    @Override
    public void forEach(QueryBiConsumer<Item, Value> func) throws QueryException {
        func.accept(this.k, this.v);
    }

    @Override
    public boolean test(QueryBiPredicate<Item, Value> func) throws QueryException {
        return func.test(this.k, this.v);
    }

    @Override
    public Item shrink(QueryContext qc) throws QueryException {
        this.v = this.v.shrink(qc);
        this.type = MapType.get(this.k.type, this.v.seqType());
        return this;
    }
}

