/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.ft;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.ft.FTPos;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.util.Array;
import org.basex.util.hash.IntSet;
import org.basex.util.list.IntList;

public final class FTPosData {
    private FTPos[] pos = new FTPos[1];
    private Data dt;
    private int size;

    public FTPosData() {
    }

    public FTPosData(Data data) {
        this.dt = data;
    }

    public void add(Data data, int pre, FTMatches all) {
        if (this.dt == null) {
            this.dt = data;
        } else if (this.dt != data) {
            return;
        }
        IntSet set = new IntSet();
        for (FTMatch ftm : all) {
            for (FTStringMatch sm : ftm) {
                for (int s = sm.start; s <= sm.end; ++s) {
                    set.add(s);
                }
            }
        }
        IntList il = new IntList(set.keys()).sort();
        int c = this.find(pre);
        if (c < 0) {
            c = -c - 1;
            int sz = this.size;
            if (sz == this.pos.length) {
                this.pos = Arrays.copyOf(this.pos, Array.newCapacity(sz));
            }
            Array.insert(this.pos, c, 1, sz, null);
            this.pos[c] = new FTPos(pre, il);
            ++this.size;
        } else {
            this.pos[c].union(il);
        }
    }

    public FTPos get(Data data, int pre) {
        int p = this.find(pre);
        return p < 0 || this.dt != data ? null : this.pos[p];
    }

    public int size() {
        int c = 0;
        for (int i = 0; i < this.size; ++i) {
            c += this.pos[i].size();
        }
        return c;
    }

    private int find(int pre) {
        int l = 0;
        int h = this.size - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int c = this.pos[m].pre - pre;
            if (c == 0) {
                return m;
            }
            if (c < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return -l - 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FTPosData)) {
            return false;
        }
        FTPosData ft = (FTPosData)obj;
        if (this.size != ft.size) {
            return false;
        }
        for (int p = 0; p < this.size; ++p) {
            if (this.pos[p].pre == ft.pos[p].pre && this.pos[p].equals(ft.pos[p])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int p = 0; p < this.size; ++p) {
            if (!sb.isEmpty()) {
                sb.append('\n');
            }
            sb.append(this.pos[p]);
        }
        return sb.toString();
    }
}

