/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.jetty.io.IOResources;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class Descriptor {
    private static final Logger LOG = LoggerFactory.getLogger(Descriptor.class);
    protected Resource _xml;
    protected XmlParser.Node _root;
    protected String _dtd;

    public Descriptor(Resource resource) {
        this._xml = Objects.requireNonNull(resource, "Resource must not be null");
        if (this._xml.isDirectory()) {
            throw new IllegalArgumentException("Descriptor cannot be a directory");
        }
    }

    public void parse(XmlParser parser) throws Exception {
        if (this._root == null) {
            Objects.requireNonNull(parser);
            try (InputStream is = IOResources.asInputStream((Resource)this._xml);){
                this._root = parser.parse(is);
                this._dtd = parser.getDTD();
            }
            catch (IOException | SAXException e) {
                LOG.warn("Unable to parse {}", (Object)this._xml, (Object)e);
                throw e;
            }
        }
    }

    public String getURI() {
        return this._xml.getURI().toASCIIString();
    }

    public Resource getResource() {
        return this._xml;
    }

    public XmlParser.Node getRoot() {
        return this._root;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getURI() + ")";
    }
}

