/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.basex.core.BaseXException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOStream;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.validate.ErrorInfo;
import org.basex.query.func.validate.ValidateFn;
import org.basex.query.func.validate.Validation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.Reflect;
import org.basex.util.Resolver;
import org.basex.util.Strings;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidateXsd
extends ValidateFn {
    private static final String FACTORY = "http://www.w3.org/2001/XMLSchema";
    private static final String SAXON_VERSION_URI = "http://saxon.sf.net/feature/xsd-version";
    static final String[] IMPL = new String[]{"com.saxonica.ee.jaxp.SchemaFactoryImpl", "Saxon EE", "1.1", "org.apache.xerces.jaxp.validation.XMLSchema11Factory", "Xerces", "1.1", "org.apache.xerces.jaxp.validation.XMLSchemaFactory", "Xerces", "1.0", "", "Java", "1.0"};
    static final int OFFSET;
    private static final boolean SAXON;
    private static final boolean JAVA;

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.check(qc);
    }

    @Override
    public final ArrayList<ErrorInfo> errors(final QueryContext qc) throws QueryException {
        return this.validate(new Validation(){

            @Override
            void validate() throws IOException, SAXException, QueryException {
                Schema s;
                IO input = ValidateXsd.this.read(ValidateXsd.this.toNodeOrAtomItem(ValidateXsd.this.arg(0), false, qc), null);
                Item schema = ValidateXsd.this.toNodeOrAtomItem(ValidateXsd.this.arg(1), true, qc);
                HashMap options = ValidateXsd.this.toOptions(ValidateXsd.this.arg(2), qc);
                String url = schema == null ? "" : this.prepare(ValidateXsd.this.read(schema, null)).url();
                String caching = (String)options.remove("cache");
                boolean cache = Strings.isTrue(caching);
                Schema schema2 = s = cache ? ValidateFn.MAP.get(url) : null;
                if (s == null) {
                    SchemaFactory sf;
                    if (JAVA) {
                        sf = SchemaFactory.newInstance(ValidateXsd.FACTORY);
                    } else {
                        Class<?> clz = Reflect.find(IMPL[OFFSET]);
                        try {
                            sf = (SchemaFactory)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new BaseXException(ex);
                        }
                        if (SAXON) {
                            sf.setProperty(ValidateXsd.SAXON_VERSION_URI, IMPL[OFFSET + 2]);
                        }
                    }
                    sf.setErrorHandler(this);
                    LSResourceResolver ls = Resolver.resources(qc.context.options);
                    if (ls != null) {
                        sf.setResourceResolver(ls);
                    }
                    for (Map.Entry entry : options.entrySet()) {
                        sf.setFeature((String)entry.getKey(), Strings.isTrue((String)entry.getValue()));
                    }
                    Schema schema3 = s = url.isEmpty() ? sf.newSchema() : sf.newSchema(new URL(url));
                    if (cache) {
                        ValidateFn.MAP.put(url, s);
                    }
                }
                Validator v = s.newValidator();
                v.setErrorHandler(this);
                v.validate(input instanceof IOContent || input instanceof IOStream ? new StreamSource(input.inputStream()) : new StreamSource(input.url()));
            }
        });
    }

    static {
        int i = 0;
        int il = IMPL.length;
        while (i + 3 < il && Reflect.find(IMPL[i]) == null) {
            i += 3;
        }
        OFFSET = i;
        SAXON = i == 0;
        JAVA = i == 9;
    }
}

