#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 nie jest zainstalowany"},
    {TR_NO_PATCH_MESSAGE,
        "Twoja instalacja Cezara 3 nie ma zainstalowanej łatki 1.0.1.0."
        "Łatkę możesz pobrać z:\n."
        URL_PATCHES "\n"
        "Kontynuujesz na własne ryzyko."},
    {TR_MISSING_FONTS_TITLE, "Brakuje czcionek"},
    {TR_MISSING_FONTS_MESSAGE,
        "Twoja instalacja Cezara 3 wymaga dodatkowych czcionek."
        "Możesz je pobrać dla własnego języka z:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Edytor nie jest zainstalowany"},
    {TR_NO_EDITOR_MESSAGE,
        "Twoja instalacja Cezara 3 nie ma plików edytora"
        "Możesz je pobrać z:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Nieprawidłowy folder językowy"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Wybrany folder nie zawiera poprawnego pakietu językowego"
        "Proszę sprawdzić błędy w pliku log"},
    {TR_BUILD_ALL_TEMPLES, "Całość"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Anuluj"},
    {TR_BUTTON_RESET_DEFAULTS, "Ustaw domyślne"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Skróty klawiszowe"},
    {TR_CONFIG_LANGUAGE_LABEL, "Język:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(domyślny)"},
    {TR_CONFIG_DISPLAY_SCALE, "Skala wyświetlacza:"},
    {TR_CONFIG_CURSOR_SCALE, "Skala kursora:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Zmiany interfejsu użytkownika"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Poziom trudności"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Odgrywaj film wprowadzający"},
    {TR_CONFIG_SIDEBAR_INFO, "Dodatkowe informacje w panelu sterowania"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Płynne przewijanie"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Wyłącz przeciąganie mapy prawym przyciskiem"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Wyłącz przewijanie mapy na krawędzi okna"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Pokaż wybrany obszar przy oczyszczaniu terenu"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Pozwól na budowę kolejno każdej ze świątyń"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Pokaż zasięg przy budowie rezerwuarów, fontann i studni"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Pokaż rozmiar budowy przy przeciąganiu kursorem"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Podświetl legion przy najechaniu kursorem"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Włącz boczny panel wojskowy"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Napraw błąd z imigracją na najwyższym poziomie trudności"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Napraw 100-letnie duchy"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Napraw zmianę imperatora i czas przetrwania w konstruktorze miast"},
    {TR_HOTKEY_TITLE, "Augustus - konfiguracja skrótów klawiszowych"},
    {TR_HOTKEY_LABEL, "Skrót klawiszowy"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternatywny"},
    {TR_HOTKEY_HEADER_ARROWS, "Strzałki kierunkowe"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globalne skróty klawiszowe"},
    {TR_HOTKEY_HEADER_CITY, "Miejskie skróty klawiszowe"},
    {TR_HOTKEY_HEADER_ADVISORS, "Doradcy"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Widoki"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Miejskie miejsca skoku"},
    {TR_HOTKEY_HEADER_EDITOR, "Edytor"},
    {TR_HOTKEY_HEADER_BUILD, "Skróty klawiszowe budynków"},
    {TR_HOTKEY_ARROW_UP, "Góra"},
    {TR_HOTKEY_ARROW_DOWN, "Dół"},
    {TR_HOTKEY_ARROW_LEFT, "Lewo"},
    {TR_HOTKEY_ARROW_RIGHT, "Prawo"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Przełącz pełny ekran"},
    {TR_HOTKEY_CENTER_WINDOW, "Wycentruj okno"},
    {TR_HOTKEY_RESIZE_TO_640, "Zmień rozmiar okna do 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Zmień rozmiar okna do 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Zmień rozmiar okna do 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Zapisz zrzut ekranu"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Zapisz zrzut ekranu miasta"},
    {TR_HOTKEY_BUILD_CLONE, "Sklonuj budynek pod kursorem"},
    {TR_HOTKEY_LOAD_FILE, "Wczytaj plik"},
    {TR_HOTKEY_SAVE_FILE, "Zapisz plik"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Zwiększ prędkość gry"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Zmniejsz prędkość gry"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Pauza"},
    {TR_HOTKEY_CYCLE_LEGION, "Przełącz między legionami"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Obróć mapę w lewo"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Obróć mapę w prawo"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Doradca zatrudnienia"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Doradca legionów"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Doradca imperialny"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Doradca wyników"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Doradca handlowy"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Doradca populacji"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Doradca zdrowia"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Doradca edukacji"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Doradca rozrywki"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Doradca religijny"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Doradca finansowy"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Główny doradca"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Przełącz między widokami"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Pokaż widok wody"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Pokaż widok pożarów"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Pokaż widok zniszczenia"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Pokaż widok zbrodni"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Pokaż widok problemów"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Przejdź do punktu skoku 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Przejdź do punktu skoku 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Przejdź do punktu skoku 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Przejdź do punktu skoku 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Ustaw punkt skoku 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Ustaw punkt skoku 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Ustaw punkt skoku 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Ustaw punkt skoku 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Przełącz informacje o bitwach"},
    {TR_HOTKEY_EDIT_TITLE, "Wprowadź skrót"},
    {TR_BUILDING_ROADBLOCK, "Blokada drogi"},
    {TR_BUILDING_ROADBLOCK_DESC, "Blokada drogi zatrzymuje przechodniów bez celu."},
    {TR_HEADER_HOUSING, "Domy"},
    {TR_ADVISOR_HOUSING_ROOM, "W miejskich domach jest miejsce dla"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "Brak miejsca w miejskich domach."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Domy wymagające garnków"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Domy wymagające mebli"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Domy wymagające oliwy"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Domy wymagające wina"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Razem domów:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Dostępne zakwaterowanie:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Całkowite zakwaterowanie:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Populacja - domy"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Wykresy"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Bogactwo domów"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Procent populacji w willach i pałacach"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Procent populacji w namiotach i szałasach"},
    {TR_ADVISOR_AVERAGE_TAX, "Średni podatek na głowę"},
    {TR_ADVISOR_AVERAGE_AGE, "Średnia wieku populacji"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Procent populacji w sile roboczej"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Narodzin w zeszłym roku:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Śmierci w zeszłym roku:"},
    {TR_ADVISOR_TOTAL_POPULATION, "Razem mieszkańców"},
    { TR_CONFIG_TITLE, "Augustus - konfiguracja" },
    { TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Pokaż rozmiar budowy przy przeciąganiu budowy" },
    { TR_CONFIG_ROTATE_MANUALLY, "Obróć bramy i łuk triumfalny skrótem klawiszowym" },
    { TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Pokaż punkty docelowe" },
    { TR_CONFIG_ENABLE_ZOOM, "Włącz powiększanie/pomniejszanie (może być powolne, wymaga więcej pamięci)" },
    { TR_CONFIG_COMPLETE_RATING_COLUMNS, "Pokaż całe kolumny przy niskich poziomach wyników" },
    { TR_CONFIG_GRANDFESTIVAL, "Wielkie festiwale pozwalają na dodatkowe błogosławieństwo" },
    { TR_CONFIG_JEALOUS_GODS, "Wyłącz zazdrość bogów" },
    { TR_CONFIG_GLOBAL_LABOUR, "Włącz globalne zatrudnienie" },
    { TR_CONFIG_SCHOOL_WALKERS, "Wydłuż drogę uczniów szkół" },
    { TR_CONFIG_RETIRE_AT_60, "Zmień wiek emerytalny z 50 na 60" },
    { TR_CONFIG_FIXED_WORKERS, "Stały procent zatrudnionych - 38%" },
    { TR_CONFIG_EXTRA_FORTS, "Zezwól na budowę dodatkowych 4 fortów" },
    { TR_CONFIG_WOLVES_BLOCK, "Zablokuj budowę w pobliżu wilków" },
    { TR_CONFIG_DYNAMIC_GRANARIES, "Zablokuj niepołączenie drogi spichlerzy" },
    { TR_CONFIG_MORE_STOCKPILE, "Domy gromadzą więcej dóbr ze straganu" },
    { TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Kupujące panie ze straganu nie rozdają dóbr" },
    { TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Natychmiast niszcz budynki" },
    { TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Popychacze wozów ze zbierających spichlrzy mogą schodzić z dróg" },
    { TR_CONFIG_GRANARIES_GET_DOUBLE, "Podwój pojemność zbierająych popychaczy wozów ze spichlerzy" },
    { TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Setnicy z wież mogą schodzić z dróg" },
    { TR_CONFIG_FARMS_DELIVER_CLOSE, "Farmy i przystanie dostarczają żywność tylko do pobliskich spichlerzy" },
    { TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Jedzenie nie jest dostarczane do zbierających spichlerzy" },
    { TR_CONFIG_ALL_HOUSES_MERGE, "Wszystkie domy mogą się łączyć" },
    { TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Otwarty szlak handlowy liczy się jako nowy rodzaj wina" },
    { TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Losowo upadające glinianki i kopalnie żelaza zabierają zamiast tego trochę pieniędzy" },
    { TR_CONFIG_MULTIPLE_BARRACKS, "Zezwól na budowę wielu koszar" },
    { TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Hurtownie nie akceptują żadnych dóbr przy zbudowaniu" },
    { TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Domy nie zajmują ogrodów przy powiększaniu" },
    { TR_BUILDING_ROADBLOCK, "Blokada drogi" },
    { TR_BUILDING_ROADBLOCK_DESC, "Blokada drogi powstrzymuje wałęsających się mieszkańców." },
    { TR_BUILDING_ARCHITECT_GUILD, "Gildia inżynierów" },
    { TR_BUILDING_ARCHITECT_GUILD_DESC, "Inżynierowie niestrudzenie pracują, by zbudować monumenty ku chwale Rzymu." },
    { TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Nadaj epitet świątyni" },
    { TR_BUILDING_GRAND_TEMPLE_CERES, "Dom Ceres" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Dom Neptuna" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY, "Dom Merkurego" },
    { TR_BUILDING_GRAND_TEMPLE_MARS, "Dom Marsa" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS, "Dom Wenus" },
    { TR_BUILDING_PANTHEON, "Panteon" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Wielka świątynia Ceres" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Wielka świątynia Neptuna" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Wielka świątynia Merkurego" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Wielka świątynia Marsa" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Wielka świątynia Wenus" },
    { TR_BUILDING_PANTHEON_DESC, "Panteon" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Popychacze wozów z farm poruszają się o 50% szybciej." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Zwiększa zasięg fontann, studni i rezerwuarów. Zatrudnienie budowli wodnych zmniejszone o połowę. Statki handlowe poruszają się 25% szybciej." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Handlarze lądowi i morscy mają zwiększoną pojemność o 50%. Handlarze lądowi poruszają się o 25% szybciej" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Szkoli żołnierzy jak koszary. Zezwala na budowę dodatkowych czterech fortów" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Ogrody, świątynie i pomniki błyszczą dodatkowych pięknem, zwiększając atrakcyjność. Domy gromadzą więcej dóbr i wolniej dewoluują." },
    { TR_BUILDING_PANTHEON_BONUS_DESC, "Zapewnia dostęp do wszystkich bogów. Organizuje coroczne festiwale i redukuje żołd świątyń o 25%" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Kapłani zmniejszają konsumpcję żywności o 20%." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Świątynia wysyła woźniców do hipodromu." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Kapłani redukują konsumpcję mebli i garnków o 20%." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Świątynie generują żywność odwiedzając domy i wysyłają ją do punktu zaopatrzeniowego." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Wielka świątynia produkuje wino zależne od rozmiaru miasta z dostępem do Wenus. Kapłani zbierają i rozdają to wino." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Kapłani zbierają i rozdają oliwę i jeden typ żywności." },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Kapłani zwiększają pojemność domów o 5%. Wielka świątynia działa jak wypełniony rezerwuar." },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Kapłani redukują zużycie oliwy i wina o 20%." },
    { TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Kapłani redukują zużycie wszystkich dóbr o 10%." },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Kapłani zapewniają rozrywkę i zwiększają piękno domów, pozwalając ograniczyć potrzebę dodatkowych upiększeń." },
    { TR_BUILDING_PANTHEON_MODULE_1_DESC, "Wszystkie świątynie wysyłają swoich kapłanów do panteonu, szerząc wiarę w swoich bogów." },
    { TR_BUILDING_PANTHEON_MODULE_2_DESC, "Domy z dostępem do panteonu mogą rozwinąć się o dodatkowy krok." },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Świątynia Ceres Promitor" },
    { TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Świątynia Ceres Reparator" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Świątynia Neptunus Equester" },
    { TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Świątynia Neptunus Adiutor" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Świątynia Mercurius Fortunus" },
    { TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Świątynia Mercurius Abundantia" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Świątynia Mars Ultor" },
    { TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Świątynia Mars Quirinus" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Świątynia Venus Verticordia" },
    { TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Świątynia Venus Genetrix" },
    { TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima" },
    { TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna" },
    { TR_BUILDING_GRAND_TEMPLE_MENU, "Wielka świątynia" },
    { TR_BUILDING_WORK_CAMP, "Obóz pracy" },
    { TR_BUILDING_WORK_CAMP_DESC, "Pracownicy zbierają się tutaj, by dostarczać materiałów do konstrukcji monumentów." },
    { TR_REQUIRED_RESOURCES, "Surowce potrzebne do ukończenia obecnej fazy:" },
    { TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Budowa wielkiej świątyni wymaga materiałów zgromadzonych w magazynie, pracowników z obozu pracy i inżynierów z obozu inżynierów." },
    { TR_CONSTRUCTION_PHASE, "Faza konstrukcji:" },
    { TR_ADD_MODULE, "Poświęcić świątynię?" },
    { TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epitet nadany." },
    { TR_BUILDING_CERES_TEMPLE_QUOTE, "Pierwsza w skiby lemieszem kraje krzywym ziemię\nCeres i pierwsza zbożem darzy ludzkie plemię,\nPierwsza nadaje prawa. Jej to wszystko dary,\n Ja w śpiewie czcić, jej składać powinnam ofiary.\n-Owidiusz, Przemiany, Księga V" },
    { TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "I gniew morza ustaje. Neptun trójząb złożył,\nBystre wiatry uciszył i wody ukorzył.\nWoła Trytona — Tryton, wyższy nad bałwany\nPrzypływa; grzbiet ma siwy muszlami nadziany.\nPan morza w brzmiącą konchę dąć mu każe silnie\n-Owidiusz, Przemiany, Ksiegą I" },
    { TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Można ci bowiem zabierać i woły i paśne bydlęta,\nŁupem pozyskać trójnogi i płowogrzywiaste rumaki,\nŻycie atoli człowieka zaborem napowrót nie wróci,\nAni też łupem, jak tylko uciecze przez zębów zaporę.\nMatka mi bowiem Thetyda o srebrnych nóżkach mówiła,\n-Homer, Iliada, księga IX" },
    { TR_BUILDING_MARS_TEMPLE_QUOTE, "Wtedy Mars, władny w boju, wlał ogień i siły,\nW Latynów serca, które wnet żywiej zabiły,\nZaś popłoch i strach zgubny rzucił w Teukrów rzędy.\nZyskawszy pole bitwy, wróg kupi się wszędy\nZa sprawą boga wojny.\n-Wirgliusz, Eneida, Księga IX" },
    { TR_BUILDING_VENUS_TEMPLE_QUOTE, "Wtedy niebian zjednawszy Wenus przymileniem,\nI Jowisza pieszczonem objąwszy ramieniem:\nOjcze, który me prośby wypełniałeś zawsze\n - Rzekła - dziś okaż dla mnie serce najłaskawsze\n-Owidiusz, Przemiany" },
    { TR_BUILDING_PANTHEON_QUOTE, "Tymczasem dom potężny Olimpu się budzi.\nZebranie zwoła niebian ojciec i król ludzi.\nDo gwieździstej siedziby, skąd cała kraina\nWidna, obóz Dardanów i ludy Latyna.,\nZasiędą przy otwartych bramach, on zaś zacznie.\n-Wirgiliusz, Eneida, Księga X" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)" },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Pracownicy konstruują podium, które wyniesie świątynie i zapewni trwałe fundamenty pozwalające znieść upływ czasu." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Rzemieślnicy tworzą portico, w którym znajdzie się świątynny ołtarz." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Inżynierowie tworzą cella, wnętrze świątyni które będzie domem do świętych obrazów." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Rozpoczęły się prace nad świątynnym praecinctum, gdzie wyznawcy będą się zbierać do rytuałów." },
    { TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Prace nad świątynią są prawie gotowe, kapłani zbierają się do konsekracji świątyni." },
    { TR_BUILDING_MENU_TREES, "Drzwi" },
    { TR_BUILDING_MENU_PATHS, "Ścieżki" },
    { TR_BUILDING_MENU_PARKS, "Parki" },
    { TR_BUILDING_SMALL_POND, "Mały staw" },
    { TR_BUILDING_LARGE_POND, "Duży staw" },
    { TR_BUILDING_PINE_TREE, "Sosna" },
    { TR_BUILDING_FIR_TREE, "Jodła" },
    { TR_BUILDING_OAK_TREE, "Dąb" },
    { TR_BUILDING_ELM_TREE, "Wiąz" },
    { TR_BUILDING_FIG_TREE, "Figowiec" },
    { TR_BUILDING_PLUM_TREE, "Śliwa" },
    { TR_BUILDING_PALM_TREE, "Palma" },
    { TR_BUILDING_DATE_TREE, "Daktyl" },
    { TR_BUILDING_PINE_PATH, "Ścieżka z sosanmi" },
    { TR_BUILDING_FIR_PATH, "Ścieżka z jodłami" },
    { TR_BUILDING_OAK_PATH, "Ścieżka z dębami" },
    { TR_BUILDING_ELM_PATH, "Ścieżka z więzami" },
    { TR_BUILDING_FIG_PATH, "Ścieżka z figami" },
    { TR_BUILDING_PLUM_PATH, "Ścieżka ze śliwami" },
    { TR_BUILDING_PALM_PATH, "Ścieżka z palmami" },
    { TR_BUILDING_DATE_PATH, "Ścieżka z daktylami" },
    { TR_BUILDING_BLUE_PAVILION, "Niebieski pawilon" },
    { TR_BUILDING_RED_PAVILION, "Czerwony pawilon" },
    { TR_BUILDING_ORANGE_PAVILION, "Pomarańczowy pawilon" },
    { TR_BUILDING_YELLOW_PAVILION, "Żółty pawilon" },
    { TR_BUILDING_GREEN_PAVILION, "Zielony pawilon" },
    { TR_BUILDING_SMALL_STATUE_ALT, "Posąg bogini" },
    { TR_BUILDING_SMALL_STATUE_ALT_B, "Posąg senatora" },
    { TR_BUILDING_OBELISK, "Obelisk" },
    { TR_BUILDING_POND_DESC, "Staw napełniony jest wodą z miejskich rezerwuarów i zapewnia wodą dla roślin i zwierząt, a także miejsce relaksu dla mieszkańców." },
    { TR_BUILDING_WINDOW_POND, "Staw" },
    { TR_BUILDING_OBELISK_DESC, "Wspaniały monument, wzniesiony przez starożytnego króla nilu. Egipcjanie z niego nie korzystali." },
    { TR_ADVISOR_FINANCE_LEVIES, "Żołd budynków" },
    { TR_CONFIRM_DELETE_MONUMENT, "Zniszczyć ten monument" },
    { TR_SELECT_EPITHET_PROMPT_HEADER, "Wybierz epitet do nadania" },
    { TR_SELECT_EPITHET_PROMPT_TEXT, "Nadanie epitetu trwale poświęci tę światynię temu aspektowi boga, nadając kapłanom boską moc." },
    { TR_BUILDING_INFO_MONTHLY_LEVY, "/miesiąc" },
    { TR_BUILDING_MESS_HALL, "Punkt zaopatrzenia" },
    { TR_BUILDING_MESS_HALL_DESC, "Punkt zaopatrzeniowy zabiera jedzenie ze spichlerzy by zapewniż pożywienie żołnierzom w miejskich fortach. Brak żywności spowolni rekrutację i osłabi morale." },
    { TR_BUILDING_MESS_HALL_FULFILLMENT, "Stan zaopatrzenia w zeszłym miesiącu:" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Żołnierze są: " },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Dobrze odżywieni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Odżywieni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Głodni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Bardzo głodni" },
    { TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Umierają z głodu" },
    { TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Zróżnicowana dieta znacznie poprawia morale." },
    { TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Pożywna i wielce zróżnicowana dieta ma wspaniały efekt na morale." },
    { TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Nie masz żołnierzy do nakarmienia." },
    { TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Zaopatrzenia starczy na miesięcy:" },
    { TR_BUILDING_BARRACKS_FOOD_WARNING, "Braki w żywności w punkcie zaopatrzeniowym spowalniają rekrutację." },
    { TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Krytyczne braki w pożywieni w punkcie zaopatrzeniowym wielce spowalniają rekrutację." },
    { TR_BUILDING_LEGION_FOOD_WARNING_1, "Niedawne braki żywności osłabiły morale" },
    { TR_BUILDING_LEGION_FOOD_WARNING_2, "Niedawne braki żywności wielce osłabiły morale" },
    { TR_BUILDING_LEGION_STARVING, "Brak żywności" },
    { TR_ADVISOR_LEGION_FOOD_SATISFIED, "Twoi żołnierze mają jedzenie którego potrzebują." },
    { TR_ADVISOR_LEGION_FOOD_NEEDED, "Twoi żołnierze potrzebują więcej żywności." },
    { TR_ADVISOR_LEGION_FOOD_CRITICAL, "Twoi żołnierze umierają z głodu!" },
    { TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Miesiące zaopatrzenia w żywność:" },
    { TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Żołnierze są głodni" },
    { TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Twój punkt zaopatrzeniowy krytycznie potrzebuje żywności. Zapewnij, aby miał dostęp do pełnego spichlerza." },
    { TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Twoje miasto straciło punkt zaopatrzeniowy i twoi żołnierze głodują. Natychmiast zbuduj nowy." },
    { TR_MARKET_SPECIAL_ORDERS_HEADER, "Dobra do zebrania" },
    { TR_WARNING_NO_MESS_HALL, "Wpierw zbuduj punkt zaopatrzeniowy dla żołnierzy." },
    { TR_WARNING_MAX_GRAND_TEMPLES, "Można postawić tylko dwie wielkie świątynie." },
    { TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Wielka świątynia ukończona" },
    { TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Kapłani i wyznawcy tłumnie gromadzą się do nowej wielkiej świątyni na ryty poświęcenia. Mieszkańcy są w podziwie majestatu twojej pracy, a wybrane bóstwo obdarza cię swoją łaską." },
    { TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Błogosławieństwo Merkurego" },
    { TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Uradowany twoim oddaniem, Merkury zapewnił twoim rzemieślnikom materiały do produkcji dóbr." },
    { TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Brygadzista" },
    { TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Tragarz" },
    { TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architekt" },
    { TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Kwartermistrz" },
    { TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Sługa obozowy" },
    { TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Wielka świątynia organizuje kapłanów Ceres by doręczali żywność i oliwę głodnym mieszkańcom." },
    { TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Wielka świątynia pozwala kapłanom Wenus dostarczać święte wino." },
    { TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Wielka świątynia organizuje kapłanów Marsa by dostaczali żywność do punktu zaopatrzeniowego." },
    { TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Świątynia Ceres" },
    { TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Świątynia Neptuna" },
    { TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Świątynia Merkurego" },
    { TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Świątynia Marsa" },
    { TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Świątynia Wenus" },
    { TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Kapłan" },
        // Transcription of mission_exact4.wav
    { TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Zrobię co mogę by uspokoić tych barbarzyńców. Jestem pewny, że przestaną atakować miasto kiedy zamienię z nimi słowo.\"" },
    { TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Coroczny festiwal" },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Wierni zbierają się do świętowania Cereliów, ku chwale Ceres. Rolnicy składają ofiary, licząc na obfite zbiory w nadchodzących latach."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Dziś rozpoczynają się obchody Neptunaliów, ku chwale Neptuna. Wierni budują szałasy z gałęzi i radują się, schowani przed gorącem śłońca środku lata."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Kupcy i handlarze tłumnie zbierają się do świętowania Merkuraliów. Statki i magazyny pokrapiane są świętą wodą, licząć na boską ochronę Merkurego."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Obywatele zbierają się na świętowanie Ekwirii, szukając łaski Marsa. Tętęt kopyt i odgłosy rydwanów przepełniają otoczenie, gdy wierni ściagają się ku chwale swojego boga."},
    { TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Wierni zbierają się na weneralia, dzień poświęcony Wenus. Obywatele szukają jej błogosławieństwa w sprawach sercowych." },
    { TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Usuń przeczytane wiadomości" },
    { TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Wyłącz ten budynek." },
    { TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Włącz ten budynek." },
    { TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Zezwól paniom ze straganu na kupowanie tutaj" },
    { TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Zezwól karawanom na handel tutaj" },
    { TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Zezwól statkom handlowym na handel tutaj" },
    { TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Zarządzanie miastem" },
    { TR_BUILDING_LIGHTHOUSE, "Latarnia" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fundamenty)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestał)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Wieża)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Korona)" },
    { TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Inżynierowie stawiają solidne fundamenty, zdolne utrzymać wagę wielkiej wieży z kamienia." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Kamieniarze konstruują pedestał, który wzniesie ogień latarni wysoko ponad horyzont." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "Wieża latarni wzrasta każdego dnia, podczas gdy kamieniarze ostrożnie praktykują swoją rzemiosło." },
    { TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Inżynierowie wykańczają latarnię. Niedługo będzie świecić wiele mil, zapewniając statkom drogę do domu." },
    { TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Konstrukcja latarni wymaga materiałów zgromadzonych w magazynie, pracowników z obozu pracy i inżynierów z gildii inżynierów." },
    { TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Statki rybackie poruszają się o 10% szybciej. Sztormy morskie trwają o połowę krócej." },
    { TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumenty" },
    { TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Latarnia, potężna wieża z kamienia wznosi się nad horyzontem. Niech jej blask prowadzi statki do domu aż do końca czasów." },
    { TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Panteon ukończony. It stands unrivaled as a monument to the awesome power of the gods and people of Rome." },
    { TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument ukończony" },
    { TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Błogosławieństwo Neptuna" },
    { TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Nagradzają pobożność twego miasta, Neptun zapewnia bezpieczną podróż handlarzom przez dwanaście miesięcy, podczas których będziesz mógł sprzedawać towary za połowę więcej." },
    { TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Błogosławieństwo Wenus" },
    { TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Uradowana twoim oddanie, Venus nagradza twoich mieszkańców zdrowiem, szczęściem i młodością, zwiększając liczbę pracujących mieszkańców." },
    { TR_BUILDING_MENU_STATUES, "Posągi" },
    { TR_BUILDING_MENU_GOV_RES, "Domy guberantora" },
    { TR_OVERLAY_ROADS, "Drogi" },
    { TR_NO_EXTRA_ASSETS_TITLE, "Nie można znaleźć folderu z modami" },
    { TR_NO_EXTRA_ASSETS_MESSAGE,
        "Twoja instalacja Cezara 3 nie posiada odpowiednio zainstalowanego folderu z modami. "
        "Nowe obiekty mogą nie wyświetlać się prawidłowo.\n"
        "Zapewnij aby folder '/assets' istniał w katalogu w którym jest zainstalowany Cezar 3. " },
    { TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Latarnia musi być zbudowana blisko wody" },
    { TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Ten dom ma dostęp do wszystkich bogów z panteonu." },
    { TR_BUILDING_LEGION_FOOD_BONUS, "Liczne jedzenie wzmaga morale" },
    { TR_BUILDING_LEGION_FOOD_STATUS, "Status jedzenia" },
    { TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Zezwól kwartermistrzowi na zbieranie stąd żywności" },
    { TR_WARNING_RESOURCES_NOT_AVAILABLE, "Nie możesz pozyskać niezbędnych materiałów" },
    { TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Ukońcczone wielkie świątynie dają +8 do kultury" },
    { TR_BUTTON_BACK_TO_MAIN_MENU, "Wróć na główne menu" },
    { TR_LABEL_PAUSE_MENU, "Pauza" },
    { TR_OVERLAY_LEVY, "Żołd" },
    { TR_TOOLTIP_OVERLAY_LEVY, " denarów płaconych miesięcznie jako żołd." },
    { TR_MAP_EDITOR_OPTIONS, "Ustawienia scenariusza" },
    { TR_BUTTON_GO_TO_SITE, "Idź do lokacji" },
    { TR_RETURN_ALL_TO_FORT, "Całość" },
    { TR_OPTION_MENU_COST, "Będzie kosztować" },
    { TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Nędzne mieszkania i slumsy uniemożliwiają imigrację " },
    { TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Wysyłanie jedzenie ze spichlerza"},
    { TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Jesteś pewien?" },
    { TR_ADVISOR_IN_STORAGE, "przechowywane" },
    { TR_ADVISOR_FROM_GRANARIES, "ze spichlerzy" },
    { TR_ADVISOR_KEEP_STOCKPILING, "Nadal zbieraj surowiec" },
    { TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Maksymalny poziom dobrobytu dla tego poziomu mieszkanie jest" },
    { TR_ADVISOR_OPEN_TO_IMPORT, "Otwórz drogę handlową na import" },
    { TR_ADVISOR_OPEN_TO_EXPORT, "Otwórz drogę handlową na eksport" },
    { TR_ADVISOR_TRADE_MAX, "Maks" },
    { TR_ADVISOR_TRADE_NO_LIMIT, "maks" },
    { TR_ADVISOR_TRADE_IMPORTABLE, "Importowalne" },
    { TR_ADVISOR_TRADE_EXPORTABLE, "Eksportowalne" },
    { TR_ADVISOR_TRADE_NO_BUYERS, "Nie ma kupców dla tego surowca" },
    { TR_ADVISOR_TRADE_NO_SELLERS, "Nie ma sprzedających dla tego surowca" },
    { TR_ADVISOR_TRADE_NOT_IMPORTING, "Nie importuje" },
    { TR_ADVISOR_TRADE_NOT_EXPORTING, "Nie eksportuje" },
    { TR_BUILDING_ARENA, "Arena" },
    { TR_BUILDING_CARAVANSERAI, "Caravanserai" },
    { TR_BUILDING_CARAVANSERAI_DESC, "Merchant caravans shelter here to rest and feed their animals. Land trade disruptions last half as long." },
    { TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fundamenty)" },
    { TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Inżynierowie kładą fundamenty dla schronu dla handlarzy." },
    { TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Polityka handlu lądowego" },
    { TR_BUILDING_CARAVANSERAI_NO_POLICY, "Brak polityki handlu lądowego." },
    { TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Wybierz politykę handlu lądowego dla Twojego miasta. Możesz zmienić na inną politykę w każdym czasie." },
    { TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    { TR_BUILDING_CARAVANSERAI_POLICY_1, "Polityka lądowego sprzedawcy: Eksport lądowy zarabia 20% więcej, ale import lądowy jest o 10% droższy." },
    { TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    { TR_BUILDING_CARAVANSERAI_POLICY_2, "Polityka lądowego kupcy: Import lądowy kosztuje 20% mniej, ale eksport lądowy zarabia o 10% mniej." },
    { TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    { TR_BUILDING_CARAVANSERAI_POLICY_3, "Polityka lądowa ilościowa: Karawany handlowe przewożą 4 towary więcej, ale poruszają się o 10% wolniej." },
    { TR_BUILDING_COLONNADE, "Kolonnada" },
    { TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    { TR_BUILDING_COLOSSEUM_PHASE_2, "(Fundamenty" },
    { TR_BUILDING_COLOSSEUM_PHASE_3, "(Arkady}" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galeria)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Pracownicy kopią podziemne hypogeum - tunele i maszyny, z których pojawią się wielkie spektakle." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Mury Koloseum nabierają kształtu, gdy kładzione są rzędy miejsc siedzących zarówno dla plebsu, jak i cesarzy." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Pełne wdzięku łuki wznoszą się ku niebu, utrzymując potężne Koloseum." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Gdy Koloseum sięga ku niebu, jego ściany są pokryte błyszczącym marmurem i posągami." },
    {TR_BUILDING_DECORATIVE_COLUMN, "Marmurowa kolumna" },
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Miasta z otwartym handlem morskim:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Nie ma otwartego handlu morskiego" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Fontanna z delfinem" },
    {TR_BUILDING_GARDEN_PATH, "Ścieżka ogrodowa" },
    {TR_BUILDING_GARDEN_WALL, "Zapętlona ściana ogrodowa" },
    {TR_BUILDING_GRAND_GARDEN, "Wielki ogród" },
    {TR_BUILDING_HEDGE_DARK, "Zielenisty krzew" },
    {TR_BUILDING_HEDGE_LIGHT, "Naświetlony krzew" },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Tor)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fundamenty)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Trybuny)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fasada)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "To ogromne miejsce jest skrupulatnie badane i przygotowywane dla projektu na bezprecedensową skalę." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Wokół toru budowane są dojścia i konstrukcje wsporcze." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Masoni rzeźbią kamienne siedzenia dla dziesiątek tysięcy widzów." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Rzemieślnicy tworzą coś więcej niż zwykły tor wyścigowy, jest to  pomnik godny bogów i ludu Rzymu." },
    {TR_BUILDING_HORSE_STATUE, "Pomnik konny" },
    {TR_BUILDING_INFO_TOURISM, "(podróżnicy)" },
    {TR_BUILDING_LARARIUM, "Lararium" },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Duże Mauzoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Wypolerowane marmurowe ściany i posągi tej wspaniałej budowli odzwierciedlają wielkie czyny patrycjuszy, którzy zasłużyli na przywilej spoczynku tutaj ." },
    {TR_BUILDING_LEGION_STATUE, "Pomnik legionu" },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Ta biblioteka już działa. Rozwój lokalny pozwolił twoim obywatelom na rozbudowę budynku, dostarczając dodatkowe zwoje i kąciki do czytania." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Polityka handlu morskiego" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Brak polityki handlu morskiego." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Wybierz politykę handlu morskiego dla Twojego miasta. Możesz zmienić na inną politykę w każdym czasie." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Polityka morskiego sprzedawcy: Eksport morski zarabia 20% więcej, ale import morski jest o 10% droższy." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Polityka morskiego kupcy: Import morski kosztuje 20% mniej, ale eksport morski zarabia o 10% mniej." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Polityka morska ilościowa: Statki handlowe przewożą 4 towary więcej, ale poruszają się o 10% wolniej." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Ten pomnik ma wszystkie materiały potrzebne do tej fazy.Pracownicy czekają na wykwalifikowanego architekta z gildii architektów, który będzie nadzorować dalszą budowę." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Budowa pomnika wymaga materiałów przechowywanych w magazynie, robotników z obozu pracy i architektów z cechu architektów ." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Budowa wstrzymana." },
    {TR_BUILDING_NYMPHAEUM, "Nymphaeum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Ta wielka świątynia poświęcona jest nimfom wodnym - pomniejszym bóstwom wiosny, rzeki i morza. Obiecuje piękno i dostatek okolicznej ziemi oraz boską łaskę dla miasta." },
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Ta szkoła działa. Rozwój lokalny pozwolił twoim mieszkańcom na rozbudowę budynku, zapewniając miejsce dla większej liczby dzieci."},
    {TR_BUILDING_SMALL_MAUSOLEUM, "Małe Mauzoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Ten budynek jest miejscem spoczynku minionych pokoleń dumnych rodzin z Twojego miasta i jest źródłem zazdrości wielu nadal żyjących." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Budowa tej świątyni będzie wymagała materiałów przechowywanych w magazynie, robotników z obozu pracy i architektów z gildii architektów ." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Budowa)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Masoni i inżynierowie budują tą świętą budowlę z lśniącego marmuru." },
    {TR_BUILDING_TAVERN, "Tawerna" },
    {TR_BUILDING_TAVERN_DESC_1, "Ta tawerna nie ma pracowników, więc nie może się otworzyć." },
    {TR_BUILDING_TAVERN_DESC_2, "Ta tawerna nie ma wina, więc nie może się otworzyć." },
    {TR_BUILDING_TAVERN_DESC_3, "Ta tawerna zapewnia rozrywkę tak długo, aż otrzymuje dostawy wina. Dostawy mięsa zwiększyłyby efektywność lokalu." },
    {TR_BUILDING_TAVERN_DESC_4, "Obfite wino i zapach pieczonego mięsa przyciągają do tej tawerny żywy tłum, do hazardu, muzyki i radości." },
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Ten teatr działa. Rozwój lokalny pozwolił twoim mieszkańcom na rozbudowę budynku, zapewniając więcej miejsc dla widowni." },
    {TR_BUILDING_WATCHTOWER, "Wieża wartownicza"},
    {TR_BUILDING_WATCHTOWER_DESC, "Łucznicy na krenelażach tej wieży czujnie obserwują, szukając najeźdźców, podczas gdy strażnicy patrolują ulice poniżej." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Mieszkańcy zostali podniesieni na duchu przez ostatnie wydarzenie." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Mieszkańcy utracili ducha przez ostatnie wydarzenie." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Mieszkańcy nienawidzę Twoję imię."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Mieszkańcy są wobec Ciebie bardzo wściekli." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Mieszkańcy są wobec Ciebie wściekli." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Mieszkańcy są wobec Ciebie bardzo niezadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Mieszkańcy są wobec Ciebie niezadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Mieszkańcy są na Ciebie zdnenerwowani." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Mieszkańcy są wobec Ciebie obojętni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Mieszkańcy są wobec Ciebie zadwoloeni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Mieszkańcy są wobec Ciebie bardzo zadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Mieszkańcy są wobec Ciebie niezwykle zadowoleni." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Mieszkańcy kochaję Ciebie." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Mieszkańcy idolizują Ciebie jako bóstwo." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Mieszkańcy są niezadowoleni wysokimi podatkami." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Mieszkańcy są niezadowoleni niskimi płacami." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Mieszkańcy są niezadowoleni z powodu braku miejsc pracy." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Mieszkańcy są przygnębieni niskim stanem ich domostwa." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Mieszkańcy doceniliby więcej rozrywki." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Mieszkańcy doceniliby urozmaiconą dietę." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Mieszkańcy doceniliby większą pożądalność terenu." },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Wstrzymaj budowlę" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "wznów budowlę" },
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Instrukcje dla Caravanserai"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Inauguracyjne rozgrwyki w Twoim koloseum się rozpoczęły. Po Twoim rozkazie, ten monument będzie konsekrowany krwią walecznych!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Inauguracyjne rozgrwyki" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Hipodrom jest ukończony. Twoi obywatele z niecierpliwością czekają na Twój rozkaz na rozpoczęcie wyścigów! " },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Wyścigi się rozpoczynają" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Woda ze zbiorników Twojego miasta powoli wypełnia Koloseum. Stolarze zaczynają składać realistyczne miniaturowe statki wojenne, podczas gdy gladiatorzy trenują do walki na wodzie. Wkrótce rozpoczną się Igrzyska Morskie!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Koloseum stało się sztucznym jeziorem, gdzie gladiatorzy odtwarzają wielkie rzymskie zwycięstwa na morzu. Krew i woda mieszają się, podczas gdy tłum krzyczy z aprobatą. Naumachia - igrzyska morskie - rozpoczęły się!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Rozpoczyna się długi proces czyszczenia Koloseum, jest ono opróżniane i przygotowywane do normalnego użytku. Twoi obywatele będą mówić o tym wielkim wodnym spektaklu przez wiele lat." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "W Twoim mieście zaczynają pojawiać się dziwne ładunki, gdyż handlarze z najdalszych zakątków ziemi dostarczają przerażające bestie do klatek pod Kolosem. Wkrótce makabryczny spektakl będzie zachwycać Twoich obywateli." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Skazani przestępcy i gladiatorzy poszukujący ostatecznej chwały stają w obliczu śmierci w postaci zębów i pazurów. Igrzyska ze zwierzętami rozpoczęły się z hukiem trąbek!"},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Ostatnie z dzikich bestii leżą zabite w piaskach Koloseum, a ich krew zmieszała się z krwią skazańców. Igrzyska ze zwierzętami dobiegły końca." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Nowy rok powitamy wspaniałą grą ku czci bogów. W zamian prosimy o szczęście, pomyślność i błogosławieństwa w sprawach handlowych." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Igrzyska rozpoczynają się o wschodzie słońca na Kalendach Ianuriusza. Kapłani składają ofiary ze zwierząt, podczas gdy gladiatorzy opasują swoje ramiona, aby umrzeć, szukając łaski bogów." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Wróżby sugerują, że bogowie byli bardzo zadowoleni z naszych wspaniałych gier oraz z okazanych im ofiar i czci. Możemy spodziewać się bardzo dochodowego roku!" },
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Wszystkie oczy będą skierowane na Twoje miasto, gdy Igrzyska Olimpijskie przyciągają podróżników, zawodników i rzymskich dostojników z całego świata. Zajmie nie mniej niż cały rok, aby dokończyć wszystkie możliwe przygotowania." },
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Nadszedł ten dzień. Zapala się święty płomień, a ulice Twojego miasta są opuszczone, gdyż obywatele pakują się do wielkiego hipodromu. Niech rozpoczną się igrzyska!" },
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "Święty płomień gaśnie, a podróżnicy i obywatele udają się do domów w znużonym uniesieniu. Masz wieczną chwałę za pomyślne prowadzenie tego starożytnego święta śmiertelnej siły i honoru." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Wraz z ogłoszeniem Igrzysk Rzymskich ludzie z najdalszych zakątków gromadzą się w Twoim mieście, a wielu ma nadzieję na wygranie nadchodzących konkursów. Zajmie nie mniej niż cały rok, aby dokończyć wszystkie możliwe przygotowania ." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Rozpoczyna się uroczysta procesja, a wraz z nią igrzyska rzymskie. Niech sam Jowisz wybierze mistrzów wyścigów, walk zapaśniczych i innych zawodów wytrzymałości i zwinności. Koloseum jest wypełnione po brzegi obywatelami oczekującymi na igrzyska i zwyczajowe prezenty w postaci pszenicy i oliwy z oliwek. Niech rozpoczną się igrzyska!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Kończy się ostatni dzień Igrzysk Rzymskich. Przepełniony ekscytacją i z pełnymi brzuchami, każdy obywatel zasmakował wielkości rzymskiego życia. Chwała bogom, chwała zwycięzcom i chwała gubernatorowi!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Wielkie Igrzyska"},
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Łupienie w mieście!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Magazyn lub spichlerz został splądrowany przez wściekłych obywateli, a towary zostały skradzione! Niskie zadowolenie mieszkańców zwiększa prawdopodobieństwo wystąpienia takich incydentów ."},
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Spichlerz został złupiony!" },
    {TR_CITY_WARNING_SECESSION, "Plebejusze odmawiają pracy!" },
    {TR_CITY_WARNING_THEFT, "Fundusze zostały ukradzione z forum bądź senatu!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Magazyn został złupiony!" },
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Pozwól handlarzom eksportować jedzenie ze spichlerzy"},
    {TR_CONFIG_ARE_YOU_SURE, "Zresetować do domyślnych?"},
    {TR_CONFIG_AUDIO, "Opcje dzwięku"},
    {TR_CONFIG_CITY_SOUNDS, "Włącz dzwięki miasta"},
    {TR_CONFIG_DIFFICULTY, "Poziom trudności:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Maksymalna liczba wielkich świątyń:" },
    {TR_CONFIG_INFINITE, "Bez limitu" },
    {TR_CONFIG_USE_COLOR_CURSORS, "Użyj kolorowych kursorów" },
    {TR_CONFIG_VIDEO_SOUND, "Włącz dźwięk filmów" },
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Wyłącz przewijanie mapy na krawędzi okna"},
    {TR_CONFIG_EFFECTS, "Włącz efekty dzwiękowe"},
    {TR_CONFIG_ENABLE_AUDIO, "Włącz dźwięk"},
    {TR_CONFIG_FULLSCREEN, "Pełny ekran"},
    {TR_CONFIG_GAME_SPEED, "Prędkość gry:"},
    {TR_CONFIG_GODS_EFFECTS, "Włącz błogosławieństwa i klątwy bogów"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Wyłącz nieskończone pojawianie się wilków"},
    {TR_CONFIG_HEADER_GENERAL, "Ustawienia ogólne"},
    {TR_CONFIG_MUSIC, "Włącz muzykę"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Wędrujący piesi nie omijają zakrętu"},
    {TR_CONFIG_SCROLL_SPEED, "Prędkość skrolowania:"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Wyświetl maksymalną możliwą do osiągnięcia ocenę dobrobytu przy aktualnej zabudowie "},
    {TR_CONFIG_SPEECH, "Włącz mowę"},
    {TR_CONFIG_VIDEO, "Opcje wideo"},
    {TR_CONFIG_VOLUME, "Głośność"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Rozdzielność w oknie:"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Stracisz wszystkie spersonalizowane konfiguracje."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Stracisz wszystkie spersonalizowane skróty klawiszowe."},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE,
        "Twój system nie ma wystarczająco pamięci graficznej by zezwolić na zoom.\n"
        "Zoom nie został włączony."},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "Zoom nie mógł zostać włączony"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Instrukcje dla docku"},
    {TR_FIGURE_TYPE_BARKEEP, "Barman" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Dostawca tawerny " },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Kolektor Caravanserai" },
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Dostawca Caravanserai" },
    {TR_FIGURE_TYPE_LOOTER, "Szabrownik" },
    {TR_FIGURE_TYPE_ROBBER, "Złodziej" },
    {TR_FIGURE_TYPE_TOURIST,  "Podróźnik"},
    {TR_FIGURE_TYPE_WATCHMAN, "Strażnik" },
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Ta kombinacja klawiszowa już jest wyznaczona dla tej czynności:"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Klawisz już użyty"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotuj budynek"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Poprzednia rotacja budynku" },
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Doradca mieszkalnictwa"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Pokaż nakładkę względną"},
    {TR_MARKET_NOT_TRADING, "Nie handluje"},
    {TR_MARKET_TRADING, "Handluje"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instrukcje dla messy"},
    {TR_OPTION_MENU_APPLY, "Zastosuj" },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_OVERLAY_SENTIMENT, "Nastrój" },
    {TR_OVERLAY_TAVERN, "Tawerna" },
    {TR_RESOURCE_FISH, "Ryby" },
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Niezgodna wersja stanu gry"},
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "Zapisana gra, którą próbujesz załadować, jest zapisana w nowszej wersji Augustusa. \nUaktualnij Augustusa do najnowszej wersji." },
    {TR_SELECT_GAMES_HEADER, "Igrzyska" },
    {TR_SELECT_GAMES_TEXT, "Igrzyska odbędą się w Koloseum, kosztować to będzie Twoje osobiste fundusze i zasoby Twojego miasta ." },
    {TR_SIDEBAR_EXTRA_INVASIONS, "Inwazje" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Inwazja w toku" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Brak Inwazji" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Bliska Inwazja" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Zbliżający się wrogowie" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Dalecy wrogowie" },
    {TR_SIDEBAR_EXTRA_GODS, "Bogowie" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Zobacz Wszystko" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Mała jednostka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Średnia jednostka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Duża jednostka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Spełnij prośbę"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Gromadź"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Przestań gromadzić"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instrukcje dla tawerny"},
    {TR_TEMPLE_DISTRIBUTING, "Dystrybuje"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Nie dystrybuje"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instrukcje dla świątyni"},
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informacje o igrzyskach" },
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Idź do wykresu populacji" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Odwiedź doradcę mieszkalnictwa" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Wybierz politykę handlu lądowego"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Caravanserai jest potrzebne by ustalić politykę handlu lądowego"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Wybierz politykę handlu morskiego"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Latarnia morska jest potrzebna by ustalić politykę handlu morskiego"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Przełączaj dostęp prefektów i inżynierów" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Przełączaj dostęp kapłanów" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Przełączaj dostęp pracowników targowisk" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Przełączaj dostęp pracownikom rozrywki" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Przełączaj dostęp pracownikom edukacji" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Przełączaj dostęp pracownikom zdrowia" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Przełączaj dostęp celnikom" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Przełączaj dostęp poszukiwaczy pracowników" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Przełączaj dostęp misjonarzom" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Przełączaj dostęp strażnikom" },
    {TR_TOOLTIP_HOLD_GAME, "Urządź igrzyska"},
    {TR_TOOLTIP_NO_GAME, "Nie urządzaj igrzysk"},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "To mieszkanie nie ma dostępu do areny czy koloseum." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "To mieszkanie ma dostęp do areny z jednym widowiskiem." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "To mieszkanie ma dostęp do areny z dwoma widowiskami." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "To mieszkanie ma dostęp do koloseum z jednym widowiskiem." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "To mieszkanie ma dostęp do koloseum z dwoma widowiskami." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Czeka na pchacza wozu" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Budynek wyłączony" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Nie ma surowców" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Nie ma dostępu do wody" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Pracownicy strajkują" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Ten dom nie ma dostępu do tawerny lub jego zapasy jego tawerny wyschły od wina." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Żaden barman nie przechodził przez jakiś czas. Ten dom wkrótce straci dostęp do swojej tawerny." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Ten dom minął barman z tawerny z winem." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Ten dom minął barman z tawerny z winem i mięsem." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Ten dom przeszedł niedawno przez barmana z tawerny z winem." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Ten dom przeszedł niedawno przez barmana z tawerny z winem i mięsem. Niech rozpocznie się zabawa!" },
    {TR_WARNING_NEARBY_WOLF, "Nie można budować kiedy wilki są w pobliżu" },
    {TR_WARNING_VARIANT_TOGGLE, "Naciśnij klawisz rotacji, aby przełączać się między wariantami tego budynku"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Areny" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Wszyscy" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Urządź igrzyska" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Miesiące aż kolejne igrzyska mogą się odbyć: " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Wielkie igrzyska były niedawno urządzone." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsoruj wielkie igrzyska w swoim Koloseum, kosztem osobistych funduszy i zasobów Twojego miasta." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Igrzyska" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Trwają przygotowania do Wielkich Igrzysk." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Wielkie igrzyska są urządzane! Twoje miasto jest przepełnione podróźnikami i radowaniem." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nikt" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Miesiące do Igrzysk Morskich:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Igrzyska morskie trwają. Plusk wody, skrzypienie belek i okrzyki bojowe gladiatorów potęgują ryk tłumu." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Miesiące do Igrzysk Zwierząt:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Igrzyska są w toku. Ramię w ramię, tłum krzyczy, gdy dzikie bestie tropią ich ludzką ofiarę." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Miesiące do igrzysk Kalends:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Igrzyska Kalendów trwają.Zapach ofiar ze zwierząt i kadzideł pokonuje nawet ostrą krew i pot na arenie." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Miesiące do igrzysk olimpijskich:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Igrzyska Olimpijskie trwają.Święty ogień płonie dzień i noc, gdy sportowcy walczą o nieśmiertelną chwałę." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Miesiące do Igrzysk Rzymskich:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Trwają Igrzyska Rzymskie.Każdy uczestnik rozlewa krew, pot i łzy, aby udowodnić, że jest najlepszym Rzymianinem." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tawerny" },
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Trybut/oprocentowanie"},
    {TR_WINDOW_ADVISOR_TOURISM, "Rozmaite"},
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Na tej arenie nie ma ani lwów, ani gladiatorów i nie zapewnia ona zbyt wiele rozrywki." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Na tej arenie odbywają się gladiatorzy i polowania na zwierzęta, ku uciesze mieszkańców." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Regularne pokazy gladiatorów zapewniają rozrywkę tłumowi, ale lwy podniosłyby poziom widowiska." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Głodne bestie grasują po arenie w poszukiwaniu zdobyczy, ale brak wyszkolonych gladiatorów sprawia, że na krótkie pokazy." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Na tej arenie nie ma ani lwów, ani gladiatorów i nie zapewnia ona zbyt wiele rozrywki." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Wielkie igrzyska będą kontynuowane przez" }, // ...XX Days, 
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Ten posąg wyglądałby jeszcze wspanialej z działającą fontanną.Zapewnij mu dostęp do wody." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Ten plac budowy pomnika nie ma dostępu do drogi i nie może przyjmować materiałów. Połącz drogę z jednym ze środkowych kafelków."},
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Ta mała świątynia poświęcona jest duchom przodków ludu rzymskiego. Można tu składać małe ofiary i modlitwy."},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Zbyt wiele budynków tego typu - podróżni omijają to miejsce." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Dochód od podróżników w tym roku:"},
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Twój doradca handlowy nakazał wstrzymanie produkcji ryb."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Z powodu niskiego nastroju miasta plebejusze tego warsztatu ogłosili secesję i odmawiają pracy!" },
    {TR_WINDOW_FIGURE_TOURIST, "Ten podróźnik wydał: "},
    {TR_WINDOW_GAMES_COST, "Koszt:" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Za mało funduszy osobistych." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Za mało przechowywanych zasobów." },
    {TR_WINDOW_GAMES_NO_VENUE, "Scena nie zostało zbudowana lub nie ma pracowników." },
    {TR_WINDOW_GAMES_OPTION_1, "Urządź Igrzyska Morskie" },
    {TR_WINDOW_GAMES_OPTION_2, "Urządź Igrzyska Zwierzęce" },
    {TR_WINDOW_GAMES_OPTION_3, "Urządź Kalendy Januariusza" },
    {TR_WINDOW_GAMES_OPTION_4, "Urządź Igrszyska Olimpijskie" },
    {TR_WINDOW_GAMES_OPTION_5, "Urządź Igrzyska Rzymskie" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Koloseum zostanie zalane, aby odtworzyć wielką bitwę morską. Szybkość poruszania się twoich żołnierzy i ich siła w odległych bitwach zostanie zwiększona na następny rok." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Koloseum będzie miejscem makabrycznych polowań na zwierzęta i egzekucji dzikich bestii, zachwycając plebejskie masy. Przestępczość, zamieszki i bunty zostaną stłumione na następny rok. Gladiatorzy pomogą obronić miasto przed kolejną inwazją." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Koloseum będzie gospodarzem igrzysk ku czci bogów pierwszego dnia przyszłego roku, błagając o szczęście i dobrobyt. W przyszłym roku kwoty handlowe zostaną podwojone." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "Hipodrom będzie gospodarzem igrzysk olimpijskich. Twoje miasto będzie gościć rzesze odwiedzających, a jeśli Twoi sportowcy będą dobrze szanować Twoje miasto, zyskasz stały wzrost turystyki i przychylności." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Koloseum będzie gospodarzem Igrzysk Rzymskich, podczas których ludzie będą podróżować do Twojego miasta z całego imperium, aby rywalizować ze sobą. Taki wielki spektakl z pewnością przyniesie Tobię przychylność zarówno cesarza, jak i zwykłych ludzi na następny rok." },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(fundusze osobiste)" },
    {TR_CITY_MESSAGE_SQUALOR, "Nędza i slumsy stanowią problem." },
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Latarnik" },
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Budynek nie ma dostępu do rezerwuaru." },
    {TR_HOTKEY_COPY_SETTINGS, "Skopiuj ustawienia budynku" },
    {TR_HOTKEY_PASTE_SETTINGS, "Wklej ustawienia budynku" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararia w mieście" },
    {TR_WINDOW_RACE_BET_BUTTON, "Postaw na konia" },
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Wyścig w toku..." },
    {TR_WINDOW_RACE_BET_TITLE, "Postaw zakład na konia" },
    {TR_WINDOW_RACE_BET_AMOUNT, "Stawka" },
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Bet an amount of your personal funds on the chariot team of your choice, and double your stake if your horse wins. Your earnings will even be quadrupled during the Colosseum Games!" },
    {TR_WARNING_BET_VICTORY, "Twój koń wygrał wyścig w miejskim hipodromie." },
    {TR_WARNING_BET_DEFEAT, "Twój koń przegrał wyścig w miejskim hipodromie." },
    {TR_PERSONAL_SAVINGS, "Fundusze :" },
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Postaw na niebieskiego konia" },
    {TR_WINDOW_RACE_BET_RED_HORSE, "Postaw na czerwonego konia" },
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Postaw na białego konia" },
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Postaw na zielonego konia" },
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Bez pełnej obsady kapłanów, ta świątynia nie może przeprowadzać wszystkich świąt i rytuałów. Do czasu kiedy to się zmieni, nie możemy oczekiwać boskiego wsparcia." },
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Koloseum potrzebuje więcej pracowników, aby obywatele mogli w pełni cieszyć się z igrzysk w naszym mieście." },
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "Bez pełnej obsady pracowników, hipodrom nie może zapewnić spektakularnej rozrywki obywatelom miasta." },
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Bez wystarczającej liczby pracowników, latarnia nie może utrzymać ognia przez cały dzień. Statki mają problem by znaleźć doki naszego miasta."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Caravanserai nie ma wystarczającej liczby pracowników by obsłużyć wszystkie karawany."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Zadaszona ściana ogrodowa" },
    {TR_BUILDING_GARDEN_WALL_GATE, "Brama ogrodowa" },
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Ta niewielka brama kontroluje przepływ ludzi do ustronnych punktów miasta." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Pchacz wozu jest w drodze, aby odebrać towary z innego magazynu." },
    {TR_BUILDING_PALISADE, "Palisada" },
    {TR_BUILDING_PALISADE_DESC, "Ten ziemny wał, zakończony zaostrzonymi palami, zabezpieczy miasto przed najeźdźcami i dziki zwierzętami." },
    {TR_OVERLAY_MOTHBALL, "Wyłączone budynki" },
    {TR_OVERLAY_ENEMY, "Wrogowie" },
    {TR_BUILDING_TAVERN_DESC_5, "Obywatele uwielbiają odwiedzać to miejsce w wolnym czasie by porozmawiać nad posiłkiem i winem." },
    {TR_OVERLAY_WAREHOUSES, "Magazyny" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "Drużyna niebieska, ulubieńcy Neptuna. Najbardziej obiecujący młodzi rydwaniści, którzy chcą udowodnić swoją odwagę." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "Drużyna czerwona, sławna z najlepszego rydwanisty w historii Rzymu, byłego galernika, który uratował konsula Rzymu." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "Drużyna biała, założona przez byłych gladiatorów. Mają walkę w krwi i nawet teraz, jako wolni ludzie wciąż żyją dla wyzwania."},
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "Drużyna zielona, wywodząca się z Celeresów - straży przybocznej z czasów rzymskiej monarchii. Nawet teraz uważają się za najlepszych z najlepszych."},
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Wznów transport zasobów" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Świątynia zacznie zbierać żywność do punktu zaopatrzeniowego, gdy tylko ten zostanie zbudowany." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Wieża potrzebuje strażnika z koszar zanim będzie mogła bronić naszego miasta." },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Koloseum zbudowane! Niech rozpoczną się igrzyska!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Hipodrom zbudowany! Obywatele nie mogą doczekać się twojego rozkazu by rozpocząć wyścigi!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Wyścigi rozpoczęte" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Włącz bezpośrednie dostawy do magazynu" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Wyłącz dostawy do magazynu" },
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Wstrzymaj dostarczanie zasobów z magazynu" },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "Arena jest zamknięta. Ptaki zakładają gniazda w opuszczonych siedzeniach." },
    {TR_CONFIG_DIGIT_SEPARATOR, "Separate digits"},

};

void translation_polish(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
