%
% This file is part of AtomVM.
%
% Copyright 2018 Davide Bettio <davide@uninstall.it>
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%    http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%
% SPDX-License-Identifier: Apache-2.0 OR LGPL-2.1-or-later
%

-module(test_bif_badargument2).

-export([start/0, id/1, and2/2]).

start() ->
    not1(id(nil)) + and2(id(true), id(nil)) + or2(id(true), id(nil)) + xor2(id(false), id(nil)).

id(X) ->
    X.

not1(A) ->
    try not A of
        Result -> Result
    catch
        error:badarg -> -1;
        _:_ -> -2
    end.

and2(A, B) ->
    try A and B of
        Result -> Result
    catch
        error:badarg -> -4;
        _:_ -> -8
    end.

or2(A, B) ->
    try A or B of
        Result -> Result
    catch
        error:badarg -> -16;
        _:_ -> -32
    end.

xor2(A, B) ->
    try A xor B of
        Result -> Result
    catch
        error:badarg -> -64;
        _:_ -> -128
    end.
